% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/usage.R
\name{showMetrics}
\alias{showMetrics}
\title{Show Application Metrics}
\usage{
showMetrics(metricSeries, metricNames, appDir = getwd(),
  appName = NULL, account = NULL, server = NULL, from = NULL,
  until = NULL, interval = NULL)
}
\arguments{
\item{metricSeries}{Metric series to query. Refer to the
\href{http://docs.rstudio.com/shinyapps.io/metrics.html#ApplicationMetrics}{shinyapps.io documentation}
for available series.}

\item{metricNames}{Metric names in the series to query. Refer to the
\href{http://docs.rstudio.com/shinyapps.io/metrics.html#ApplicationMetrics}{shinyapps.io documentation}
for available metrics.}

\item{appDir}{Directory containing application. Defaults to
current working directory.}

\item{appName}{Name of application}

\item{account}{Account name. If a single account is registered on the
system then this parameter can be omitted.}

\item{server}{Server name. Required only if you use the same account name on
multiple servers.}

\item{from}{Date range starting timestamp (Unix timestamp or relative time
delta such as "2d" or "3w").}

\item{until}{Date range ending timestamp (Unix timestamp or relative time
delta such as "2d" or "3w").}

\item{interval}{Summarization interval. Data points at intervals less then this
will be grouped. (Relative time delta e.g. "120s" or "1h" or "30d").}
}
\description{
Show application metrics of a currently deployed application
}
\note{
This function only works for ShinyApps servers.
}
