% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_quality_assurance.R
\name{checkInstallationQualificationStatus}
\alias{checkInstallationQualificationStatus}
\title{Check Installation Qualification Status}
\usage{
checkInstallationQualificationStatus(showMessage = TRUE)
}
\arguments{
\item{showMessage}{A logical value indicating whether to display a message if the
installation qualification has not been completed. Default is \code{TRUE}.}
}
\value{
Invisibly returns \code{TRUE} if the installation qualification has been completed,
otherwise returns \code{FALSE}.
}
\description{
This function checks whether the installation qualification for the \code{rpact} package
has been completed. If not, it provides a message prompting the user to run the
\code{testPackage()} function to perform the qualification.
}
\details{
The installation qualification is a critical step in ensuring that the \code{rpact} package
is correctly installed and validated for use in GxP-relevant environments. This function
verifies the qualification status and informs the user if further action is required.
}
\examples{
\dontrun{
checkInstallationQualificationStatus()
}

}
\keyword{internal}
