% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_analysis_stage_results.R
\docType{class}
\name{StageResultsMeans}
\alias{StageResultsMeans}
\title{Stage Results of Means}
\description{
Class for stage results of means.
}
\details{
This object cannot be created directly; use \code{\link[=getStageResults]{getStageResults()}}
with suitable arguments to create the stage results of a dataset of means.
}
\section{Fields}{

\describe{
\item{\code{stages}}{The stage numbers of the trial. Is an integer vector of length \code{kMax}.}

\item{\code{testStatistics}}{The stage-wise test statistics. Is a numeric vector of length \code{kMax}.}

\item{\code{overallTestStatistics}}{The overall i.e. cumulated test statistics. Is a numeric vector of length \code{kMax}.}

\item{\code{pValues}}{The stage-wise p-values. Is a numeric vector of length \code{kMax}.}

\item{\code{overallPValues}}{The overall i.e. cumulated p-values. Is a numeric vector of length \code{kMax}.}

\item{\code{combInverseNormal}}{The stage-wise test statistics for the inverse normal test. Is a numeric vector of length \code{kMax}.}

\item{\code{combFisher}}{Test statistic for Fisher's combination test. H~0~}

\item{\code{effectSizes}}{The stage-wise effect sizes. Is a numeric vector of length \code{kMax}.}

\item{\code{testActions}}{The action drawn from test result.}

\item{\code{weightsFisher}}{The weights for Fisher's combination test. Is a numeric vector of length \code{kMax}.}

\item{\code{weightsFisher}}{The weights for inverse normal statistic.. Is a numeric vector of length \code{kMax}.}

\item{\code{normalApproximation}}{Logical. Describes if a normal approximation was used when calculating p-values.
Default for means is \code{FALSE} and \code{TRUE} for rates and hazard ratio.}

\item{\code{equalVariances}}{Logical. Describes if variances are assumed equal between groups.
Specified via \code{equalVariances} in \code{\link[=getStageResults]{getStageResults()}}, default is \code{TRUE}.}
}}


\keyword{internal}
