% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object_name_linters.R
\name{object_name_linter}
\alias{object_name_linter}
\title{Object name linter}
\usage{
object_name_linter(styles = c("snake_case", "symbols"))
}
\arguments{
\item{styles}{A subset of
\Sexpr[stage=render, results=rd]{lintr:::regexes_rd}. A name should
match at least one of these styles.}
}
\description{
Check that object names conform to a naming style.
The default naming styles are "snake_case" and "symbols".
}
\details{
Note when used in a package, in order to ignore objects imported
from other namespaces, this linter will attempt \code{\link[=getNamespaceExports]{getNamespaceExports()}}
whenever an \code{import(PKG)} or \code{importFrom(PKG, ...)} statement is found
in your NAMESPACE file. If \code{\link[=requireNamespace]{requireNamespace()}} fails (e.g., the package
is not yet installed), the linter won't be able to ignore some usages
that would otherwise be allowed.

Suppose, for example, you have \code{import(upstream)} in your NAMESPACE,
which makes available its exported S3 generic function
\code{a_really_quite_long_function_name} that you then extend in your package
by defining a corresponding method for your class \code{my_class}.
Then, if \code{upstream} is not installed when this linter runs, a lint
will be thrown on this object (even though you don't "own" its full name).

The best way to get lintr to work correctly is to install the package so
that it's available in the session where this linter is running.
}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=configurable_linters]{configurable}, \link[=consistency_linters]{consistency}, \link[=default_linters]{default}, \link[=executing_linters]{executing}, \link[=style_linters]{style}
}
