% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createOA.R
\name{createAddelKempN}
\alias{createAddelKempN}
\title{Create an orthogonal array using the Addelman-Kempthorne algorithm with
alternate strength with \code{2q^n} rows.}
\usage{
createAddelKempN(q, ncol, exponent, bRandom = TRUE)
}
\arguments{
\item{q}{the number of symbols in the array}

\item{ncol}{number of parameters or columns}

\item{exponent}{the exponent on q}

\item{bRandom}{should the array be randomized}
}
\value{
an orthogonal array
}
\description{
The \code{addelkempn} program produces
\code{OA( 2*q^n, k, q, 2 )},  \code{k <= 2(q^n - 1)/(q-1)-1}, for prime powers \code{q}.
\code{q} may be an odd prime power, or \code{q} may be 2 or 4.
}
\details{
From Owen: An orthogonal array \code{A} is a matrix of \code{n} rows, \code{k}
columns with every element being one of \code{q} symbols
\code{0,...,q-1}.  The array has strength \code{t} if, in every \code{n} by \code{t}
submatrix, the \code{q^t} possible distinct rows, all appear
the same number of times.  This number is the index
of the array, commonly denoted \code{lambda}.  Clearly,
\code{lambda*q^t=n}. The notation for such an array is \code{OA( n, k, q, t )}.
}
\examples{
A <- createAddelKempN(3, 4, 3, TRUE)
B <- createAddelKempN(3, 4, 4, TRUE)
}
\seealso{
Other methods to create orthogonal arrays [createBoseBush()],
[createBose()], [createBush()], [createAddelKemp()], [createAddelKemp3()],
[createBusht()], [createBoseBushl()]
}
