% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vignette.R
\name{start_vignette}
\alias{start_vignette}
\alias{end_vignette}
\title{Set mocking/capturing state for a vignette}
\usage{
start_vignette(dir, ...)

end_vignette()
}
\arguments{
\item{dir}{Root file path for the mocks for this vignette. A good idea is
to use the file name of the vignette itself.}

\item{...}{Optional arguments passed to \code{start_capturing()}}
}
\value{
Nothing; called for its side effect of starting/ending
response recording or mocking.
}
\description{
Use \code{start_vignette()} to either use previously recorded responses, if they
exist, or capture real responses for future use.
}
\details{
In a vignette or other R Markdown or Sweave document, place
\code{start_vignette()} in an R code block at the beginning,
before the first API request is made, and put
\code{end_vignette()} in a R code chunk at the end. You may
want to make those R code chunks have \code{echo=FALSE} in order to hide the fact
that you're calling them.

As in \code{\link[=with_mock_dir]{with_mock_dir()}}, the behavior changes based on the existence of the \code{dir} directory. The
first time you build the vignette, the directory won't exist yet, so it will
make real requests and record them inside of \code{dir}. On subsequent runs, the
mocks will be used. To record fresh responses from the server, delete the
\code{dir} directory, and the responses will be recorded again the next time the
vignette runs.

If you have additional setup code that you'd like available across all of
your package's vignettes, put it in \code{inst/httptest2/start-vignette.R} in your
package, and it will be called in \code{start_vignette()} before the mock/record
context is set. Similarly, teardown code can go in
\code{inst/httptest2/end-vignette.R}, evaluated in \code{end_vignette()} after mocking
is stopped.
}
\seealso{
\code{\link[=start_capturing]{start_capturing()}} for how requests are recorded; \code{\link[=use_mock_api]{use_mock_api()}}
for how previously recorded requests are loaded; \code{\link[=change_state]{change_state()}} for how to
handle recorded requests when the server state is changing;
\code{vignette("vignettes", package = "httptest2")} for an overview of all
}
