% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{highlight}
\alias{highlight}
\title{Set text highlight color}
\usage{
highlight(x, i = NULL, j = NULL, color = "yellow", part = "body", source = j)
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{i}{row selector, see section \emph{Row selection with the \code{i} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{j}{column selector, see section \emph{Column selection with the \code{j} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{color}{color to use as text highlighting color.
If a function, the function must return a character vector of colors.}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' can be used.}

\item{source}{if color is a function, source specifies the dataset column to be used
as an argument to \code{color}. This is only useful when j is colored with values contained in
other columns.}
}
\description{
Change the text highlight color of selected rows and
columns of a flextable. A function can be used instead of
fixed colors.

When \code{color} is a function, it is possible to color cells based on values
located in other columns; using hidden columns (those not used by
argument \code{colkeys}) is a common use case. The argument \code{source}
must be used to define the columns to be used for the color
definition, and the argument \code{j} must be used to define where to apply
the colors and only accepts values from \code{colkeys}.
}
\examples{
my_color_fun <- function(x) {
  out <- rep("yellow", length(x))
  out[x < quantile(x, .75)] <- "pink"
  out[x < quantile(x, .50)] <- "wheat"
  out[x < quantile(x, .25)] <- "gray90"
  out
}
ft <- flextable(head(mtcars, n = 10))
ft <- highlight(ft, j = "disp", i = ~ disp > 200, color = "yellow")
ft <- highlight(ft, j = ~ drat + wt + qsec, color = my_color_fun)
ft
}
\seealso{
Other sugar functions for table style: 
\code{\link{align}()},
\code{\link{bg}()},
\code{\link{bold}()},
\code{\link{color}()},
\code{\link{empty_blanks}()},
\code{\link{font}()},
\code{\link{fontsize}()},
\code{\link{italic}()},
\code{\link{keep_with_next}()},
\code{\link{line_spacing}()},
\code{\link{padding}()},
\code{\link{rotate}()},
\code{\link{style}()},
\code{\link{tab_settings}()},
\code{\link{valign}()}
}
\concept{sugar functions for table style}
