% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-all-identical.R
\name{chk_all_identical}
\alias{chk_all_identical}
\alias{vld_all_identical}
\title{Check All Identical}
\usage{
chk_all_identical(x, x_name = NULL)

vld_all_identical(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks all elements in x identical using

\code{length(x) < 2L || all(vapply(x, vld_identical, TRUE, y = x[[1]]))}

\strong{Pass}: \code{c(1, 1, 1)}, \code{list(1, 1)}

\strong{Fail}: \code{c(1, 1.0000001)}, \code{list(1, NA)}
}
\section{Functions}{
\itemize{
\item \code{vld_all_identical()}: Validate All Identical

}}
\examples{
# chk_all_identical
chk_all_identical(c(1, 1))
try(chk_all_identical(c(1, 1.1)))
# vld_all_identical
vld_all_identical(c(1, 1))
}
\seealso{
\code{\link[=length]{length()}}

\code{\link[=vld_identical]{vld_identical()}}

For more details about the use of this function,
please read the article
\code{vignette("chk-families")}.

Other equal_checkers: 
\code{\link{chk_all_equal}()},
\code{\link{chk_all_equivalent}()},
\code{\link{chk_equal}()},
\code{\link{chk_equivalent}()},
\code{\link{chk_identical}()}

Other all_checkers: 
\code{\link{chk_all}()},
\code{\link{chk_all_equal}()},
\code{\link{chk_all_equivalent}()}
}
\concept{all_checkers}
\concept{equal_checkers}
