% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{lizards}
\alias{lizards}
\title{Habitat preferences of lizards}
\format{
A data frame with 23 rows and 6 columns:
\itemize{
\item \code{grahami}. count of grahami lizards
\item \code{opalinus}. count of opalinus lizards
\item \code{height}. a factor with levels \verb{<5ft}, \verb{>=5ft}
\item \code{diameter}. a factor with levels \verb{<=2in}, \verb{>2in}
\item \code{light}. a factor with levels \code{sunny}, \code{shady}
\item \code{time}. a factor with levels \code{early}, \code{midday}, \code{late}
}

The variables \code{grahami} and \code{opalinus} are counts of two lizard
species at two different perch heights, two different perch
diameters, in sun and in shade, at three times of day.
}
\source{
McCullagh P, Nelder J A (1989) \emph{Generalized Linear
Models} (2nd Edition).  London: Chapman and Hall.

Originally from

\if{html}{\out{<div class="sourceCode">}}\preformatted{Schoener T W (1970) Nonsynchronous spatial overlap of lizards
in patchy habitats.  _Ecology_ *51*, 408-418.
}\if{html}{\out{</div>}}
}
\usage{
lizards
}
\description{
Habitat preferences of lizards
}
\seealso{
\code{\link[=brglm_fit]{brglm_fit()}}
}
\keyword{datasets}
