% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bold_specimens.R
\name{bold_specimens}
\alias{bold_specimens}
\title{Search BOLD for specimens.}
\usage{
bold_specimens(
  taxon = NULL,
  ids = NULL,
  bin = NULL,
  container = NULL,
  institutions = NULL,
  researchers = NULL,
  geo = NULL,
  response = FALSE,
  format = "tsv",
  cleanData = FALSE,
  ...
)
}
\arguments{
\item{taxon}{(character) One or more taxonomic name. Optional.}

\item{ids}{(character|integer|numeric) One or more IDs. Optional. IDs
include Sample IDs, Process IDs, Museum IDs and Field IDs.}

\item{bin}{(character) One or more Barcode Index Number URI. Optional.}

\item{container}{(character) One or more project codes or dataset codes.
Optional.}

\item{institutions}{(character) One or more institution's name. Optional.
Institutions are the Specimen Storing Site.}

\item{researchers}{(character) One or more researcher names. Optional.
Include collectors and specimen identifiers.}

\item{geo}{(character) One or more geographic sites.
Includes countries and province/states.}

\item{response}{(logical) Default : FALSE. If TRUE, returns the object from
the Curl call. Useful for debugging and getting more detailed info on the
API call.}

\item{format}{(character) One of xml, json, tsv (default). tsv format gives
back a data.frame object. xml gives back parsed XML as \code{xml_document}
object. 'json' (JavaScript Object Notation) and 'dwc' (Darwin Core Archive)
are supported in theory, but the JSON can be malformed, so we don't support
that here, and the DWC option actually returns TSV.}

\item{cleanData}{(logical) If \code{TRUE}, the cell values containing only duplicated values (ex : "COI-5P|COI-5P|COI-5P") will be reduce to one value ("COI-5P") and empty string will be change to NA. Default: \code{FALSE}}

\item{...}{Further args passed on to
\code{\link[crul:verb-GET]{crul::verb-GET}}, main purpose being curl
debugging}
}
\description{
Search BOLD for specimens.
}
\note{
If using the \code{taxon} parameter with another parameter, if the \code{taxon} isn't found in the public database, it will act as if no \code{taxon} was specified and try to return all the data for the other specified parameter. You can make sure that the \code{taxon} you're looking up has public records with \code{\link{bold_stats}}.
}
\examples{
\dontrun{
bold_specimens(taxon='Osmia')
bold_specimens(taxon='Osmia', format='xml')
bold_specimens(taxon='Osmia', response=TRUE)
res <- bold_specimens(taxon='Osmia', format='xml', response=TRUE)
res$url
res$status_code
res$response_headers

# More than 1 can be given for all search parameters
bold_specimens(taxon=c('Coelioxys','Osmia'))

## curl debugging
### These examples below take a long time, so you can set a timeout so that
### it stops by X sec
head(bold_specimens(taxon='Osmia', verbose = TRUE))
# head(bold_specimens(geo='Costa Rica', timeout_ms = 6))
}

}
\references{
http://v4.boldsystems.org/index.php/resources/api?type=webservices
}
