\name{sublong}
\alias{sublong}
\title{Align Long Sequence Reads to a Reference Genome via Seed-and-Vote}
\description{This function aligns DNA-seq reads, generated by long-read sequencing technologies such as Nanopore and PacBio sequencers, to a reference genome.}
\usage{
sublong(

    # basic input/output options
    index,
    readFiles,
    outputFiles,
    outputFormat = "BAM",
    nthreads = 1)
}
\arguments{
	\item{index}{ a character vector giving the basename of index files. Index files should be located in the current directory. The provided index should be a full index and also it should have only one block. See \code{buildindex} for index building options.}
	\item{readFiles}{ a character vector giving the names of input files that contain long sequence reads. FASTQ and gzipped FASTQ formats are both accepted.}
	\item{outputFiles}{ a character vector specifying the names of output files that contain read mapping results.}
	\item{outputFormat}{ a character string specifying the format of output files. \code{BAM} by default. Acceptable formats include \code{SAM} and \code{BAM}. }
	\item{nthreads}{ an integer giving the number of threads used for mapping. \code{1} by default. Note that when more than one thread is used, the order of reads might be changed in the output.}
}
\details{
\code{sublong} is designed for the mapping of long reads.
It performs full alignment of reads by performing seed-and-vote mapping followed by a bounded dynamic programming procedure.
\code{sublong} is able to map reads as long as millions of bases.

\code{sublong} is extremely fast.
It takes less than 10 minutes to complete the mapping of more than 100,000 long reads generated from Nanopore MinION ultra-long sequencing protocol.

The number of CIGAR operations (eg. insertion and deletion) reported for a long read may exceed the limit on the total number of operations allowed in a CIGAR string (up to 65,535 operations in a CIGAR string in BAM output and up to 99,900 operations in a CIGAR string in SAM output).
If this limited is exceeded, the read will be soft clipped.
}
\author{Yang Liao and Wei Shi}
\examples{
ref <- system.file("extdata","reference.fa",package="Rsubread")
buildindex(basename="./full_index",reference=ref,gappedIndex=FALSE, indexSplit=FALSE)
reads <- system.file("extdata","longreads.txt.gz",package="Rsubread")
sublong("./full_index",reads,"./Long_alignment.BAM",nthreads=4)
}
