% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveSingleCellExperiment.R
\name{saveSingleCellExperiment}
\alias{saveSingleCellExperiment}
\alias{stageObject,SingleCellExperiment-method}
\alias{saveObject,SingleCellExperiment-method}
\title{Save a SingleCellExperiment to disk}
\usage{
\S4method{saveObject}{SingleCellExperiment}(x, path, ...)
}
\arguments{
\item{x}{A \linkS4class{SingleCellExperiment} object or one of its subclasses.}

\item{path}{String containing the path to a directory in which to save \code{x}.}

\item{...}{Further arguments to pass to the RangedSummarizedExperiment method.}
}
\value{
\code{x} is saved into \code{path} and \code{NULL} is invisibly returned.
}
\description{
Save a \linkS4class{SingleCellExperiment} to its on-disk representation.
}
\examples{
# Mocking up an SCE:
mat <- matrix(rpois(10000, 10), ncol=10)
colnames(mat) <- letters[1:10]
rownames(mat) <- sprintf("GENE_\%i", seq_len(nrow(mat)))

se <- SingleCellExperiment(list(counts=mat))
se$stuff <- LETTERS[1:10]
se$blah <- runif(10)
reducedDims(se) <- list(
    PCA=matrix(rnorm(ncol(se)*10), ncol=10),
    TSNE=matrix(rnorm(ncol(se)*2), ncol=2)
)
altExps(se) <- list(spikes=SummarizedExperiment(list(counts=mat[1:2,])))

# Staging it: 
tmp <- tempfile()
saveObject(se, tmp)
list.files(tmp, recursive=TRUE)

}
\seealso{
\code{\link{readSingleCellExperiment}}, to read the SingleCellExperiment back into the R session.
}
\author{
Aaron Lun
}
