/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2004-2017 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://oss.oracle.com/licenses/CDDL+GPL-1.1
 * or LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package server.provider.wsdl_hello_lit_context.client;

import javax.xml.namespace.QName;
import junit.framework.*;
import testutil.ClientServerTestUtil;
import javax.xml.ws.*;
import javax.xml.ws.handler.MessageContext;
import java.util.Map;
import java.util.List;

/**
 *
 * @author Jitendra Kotamraju
 */
public class HelloLiteralTest extends TestCase {

    public HelloLiteralTest(String name) {
        super(name);
    }

    private Hello getStub(){
        Hello_Service service = new Hello_Service();
        return service.getHelloPort();
    }

    private Hello getMsgStub() {
        HelloMsg service = new HelloMsg();
        Hello hello =  service.getHelloMsgPort();
        return hello;
    }

    public void testVoid() {
        Hello stub = getStub();
        VoidType req = new VoidType();
        VoidType response = stub.voidTest(req);
        assertNotNull(response);
    }

    public void testMsgVoid() {
        Hello stub = getMsgStub();
        VoidType req = new VoidType();
        VoidType response = stub.voidTest(req);
        assertNotNull(response);
        if (!ClientServerTestUtil.useLocal()) {
            Map<String, List<String>> map = (Map<String, List<String>>)((BindingProvider)stub).getResponseContext().get(MessageContext.HTTP_RESPONSE_HEADERS);

            assertNotNull(map);
            assertEquals("bar", map.get("foo").get(0));
        }
    }

}
