---
title: "On the Way to CDI 4.0"
summary: Overview of changes coming to CDI 4.0
layout: post
author: matn
tag: Release
priority: 1
change_frequency: daily
---

As you probably know, work is well under way for projects aiming to land in Jakarta EE 10 space and CDI is no exception. In fact, the specification is close to being rounded up for its next major release hence it is the right time to summarize what is coming.

Here is a quick overview of impending changes; we’ll look into each of them separately:

* Introduction of CDI Lite
* Change of default empty `beans.xml` discovery mode
* Removal of long deprecated API bits
* Quality of life improvements

## Introduction of CDI Lite

The split of specification to CDI Full and CDI Lite is by far the biggest change coming in 4.0 and is therefore split into several parts.

### Little Bit of History

The [original proposal](http://www.cdi-spec.org/news/2020/03/09/CDI_for_the_future/) for CDI Lite was published in March 2020 and if you browse [the CDI mailing list](http://www.eclipse.org/lists/cdi-dev), you’ll see that there have been many threads on this topic since then. And those discussions, meetings and proposals have been fruitful because later on, precisely in May 2021, a [community vote](https://www.eclipse.org/lists/cdi-dev/msg00361.html) took place and decided that CDI Lite is about to happen. To this date, two projects are known to be working on a build-time CDI Lite implementation: Quarkus, through its ArC subproject, and OpenDI, which is based on top of Micronaut.

### What is and isn’t Lite

The specification was split into Lite and Full parts in a way that Lite defines a set of core features and Full then builds on top of it, expanding sets of rules and presenting additional features. This means that CDI Lite is simply a subset of CDI Full - you can use Lite APIs in a portable way in CDI Full environments and every CDI Full implementation has to also implement CDI Lite. That being said, CDI Full remains ‘runtime oriented’ as opposed to Lite implementations which are likely to focus on build-time environments even though the specification sets no limits in this regard.

Below is a list of CDI features that are now exclusive to CDI Full implementations:

* Decorators
* Interception bound via `@Interceptors` annotation
  * Interceptors bound via interceptor binding annotations work perfectly well in CDI Lite
* Specialization
* Passivation
* Conversation Scope
  * All other built-in scopes are present in CDI Lite
* Portable Extensions
  * These are replaced by a new extension API which is described in the following paragraph

It is important to reiterate that existing applications are all considered to use CDI Full and as such will continue working unimpeded.

### Introduction of Build Compatible Extensions

Portable Extensions are crucial for CDI extensibility but are also an ill fit for any build oriented framework. Therefore, an alternative extension SPI was proposed. This was covered in depth in a [previous blog post](http://www.cdi-spec.org/news/2020/09/15/CDI_Lite_extension/) and has undergone many iterations since. However, its purpose stays ultimately the same - to provide an alternative for Portable Extensions that will work in all environments.

### New Underlying Metamodel

One of the goals of CDI Lite was to shake off as much reflection as possible. Nonetheless, current metamodel (`AnnotatedType` and friends) is very reflection-heavy which is why CDI Lite comes with new metamodel abstraction. Note that CDI Full and Portable Extensions will still use the old metamodel whereas CDI Lite and Build Compatible Extensions will use the new metamodel.

This metamodel is currently housed inside CDI JAR but there has been some interest in using it from other Jakarta projects so it might end up being shipped as a separate artifact.

### Shipping CDI 4.0 JAR

One of the questions on many meetings was around how to ship CDI JAR now that there is Lite and Full combined. The answer to that is that there is no clear way of achieving that without breaking existing applications through package name changes. Therefore, as a compromise, CDI will stay a single JAR containing all the APIs.

## Change of Default Empty `beans.xml` Discovery Mode

One notable change coming to CDI is the [discovery mode of bean archives containing empty `beans.xml`](https://github.com/eclipse-ee4j/cdi/issues/500). These were formerly treated as explicit bean archives (i.e. having discovery mode `all`) but beginning with CDI 4.0, they will be considered as implicit bean archives (discovery mode `annotated`).

In other words, if a class in such an archive is to be recognized as a bean, it needs to have at least one bean defining annotation. It can be a breaking change which is why this change also comes with a backward compatible switch - all CDI Full products have to contain an option that switches the behavior to how it worked in the past. The option is of course a temporary measure to ease transition and applications are encouraged to adapt their bean archives accordingly in the long term.

For those interested in the history of this decision, there was a [community survey](https://www.eclipse.org/lists/cdi-dev/msg00353.html), posted via CDI mailing list, detailing the reasons and options with results visible [here](https://docs.google.com/forms/d/e/1FAIpQLSes003JAWpieL6Rp80Js-vhuMcTril_olbnL2TBY5pM5PvVdA/viewanalytics).

## Removal of Deprecated API Bits

CDI has been around for over a decade and as such has accumulated a bunch of deprecated APIs that were carried over and over into each subsequent version. A cleanup was already well overdue, so [here goes](https://github.com/eclipse-ee4j/cdi/issues/472)!

Note that the deprecated removed APIs all have a replacement. Therefore, no functionality is lost even though you might need to change your application accordingly. Below is a list of removals along with their suggested replacements.

* `@New` qualifier
  * Replaced by `@Dependent` beans since CDI 1.1
* `Bean#isNullable()` method
  * Related to the above
  * It is safe to just remove this method from any custom implementation of Bean<T> interface as it wasn’t used
* `BeanManager#fireEvent()` method
  * Deprecated since CDI 2.0; this method was insufficient ever since CDI introduced async events
  * Users should use `BeanManager.getEvent()` instead
* `BeanManager#createInjectionTarget(AnnotatedType)` method
  * Replaced by `BeanManager#getInjectionTargetFactory(AnnotatedType)` since CDI 1.1
* `BeforeBeanDiscovery#addAnnotatedType(AnnotatedType)` method
  * Replaced by `BeforeBeanDiscovery#addAnnotatedType(AnnotatedType, String)` since CDI 1.1
* Removed the notion of a mandatory configuration switch for all containers to support different understanding of missing `beans.xml` file
  * Refers to the [following specification sentence](https://jakarta.ee/specifications/cdi/3.0/jakarta-cdi-spec-3.0.html#bean_archive):
  * _For compatibility with Contexts and Dependency 1.0, products must contain an option to cause an archive to be ignored by the container when no beans.xml is present_.
  * The behavioral change exists since CDI 1.1

## Quality of Life Improvements

This chapter summarizes some of the minor changes and additions to the specification which won’t make or break your application but can, hopefully, make your life easier.

### Observable Container State Events

Up until now, the only way to know that a CDI container has started was to listen for an event with qualifier `@Initialized(ApplicationScoped.class)`. However, this event [isn’t a true container state event](https://github.com/eclipse-ee4j/cdi/issues/496); it is a context-related event. Not to mention that in build oriented stacks, contexts can be started prior to runtime making this event useless. Similarly, container shutdown only has `@BeforeDestroyed(ApplicationScoped.class)` which was the closest call but not quite on the mark.
Therefore, CDI 4.0 will fire an event with payload `jakarta.enterprise.event.Startup` and qualifier `@Any` during container startup. Users and integrators can declare observers in order to perform their early initialization tasks as soon as the CDI container is truly ready. Symmetrically, the container will fire an event with payload `jakarta.enterprise.event.Shutdown` and qualifier `@Any` during application shutdown.

Observers are encouraged to declare `@Priority` in a similar fashion that interceptors do - this enables ordering scheme in which, for example, integrator-defined observer methods for `Startup` event precede those defined by user application.

### Programmatic Lookup Improvements

One of the pitfalls of programmatic lookup is that there is no easy way to browse bean metadata. Besides, iterating over all bean candidates immediately creates bean instances of all `@Dependent` beans which isn’t ideal.

These were the main motivations behind [introduction of the `Handle<T>` interface](https://github.com/eclipse-ee4j/cdi/issues/521) - an abstraction representing a contextual reference handle and allowing browsing its `Bean<T>` metadata, retrieving contextual instance and destroying it if needed.

Handles can be grabbed directly from `Instance<T>` through several methods:

* `Handle<T> getHandle()`
* `Iterable<Handle<T>> handles()`
* `Stream<Handle<T>> handlesStream()`

### Using `@Priority` on Stereotypes

Another small change is that [CDI Stereotypes can now declare `@Priority`](https://github.com/eclipse-ee4j/cdi/issues/495); any bean declaring such stereotype will be considered enabled and have given priority. A bean can declare priority explicitly in order to override the value.

This is a nice shorthand for test scenarios which commonly need to declare enabled alternatives which mock or stub application behavior.

## Conclusion

CDI 4.0 specification is nearing its completion and this article should provide you with an overview of changes and how to prepare for them. While a Beta or CR release will hopefully happen shortly, there is always the option to go over to [CDI GH repository](https://github.com/eclipse-ee4j/cdi), check out the main branch and build it with a good old `mvn clean install`.

Last but not least, a compatible implementation for CDI Full will still be Weld which is now being worked on to stay on top of CDI API changes. As soon as CDI releases a Beta version, Weld will follow with its own release. So stay tuned if you want to try things out early!

