-- $Id$

-- assign a variable of a an array to a variable of an array with a different
-- direction (via a procedure)

-- Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.

package t is
	type b_arr is array(integer range <>) of bit;

	procedure assign(constant a : in b_arr; variable b : out b_arr);
end package t;

package body t is
	procedure assign(constant a : in b_arr; variable b : out b_arr) IS
	begin
		b := a;
	end;
end;

entity test_bench is
end entity test_bench;

use t.b_arr;
architecture test_bench_impl of test_bench is
	variable a : b_arr(0 to 1);
	variable b : b_arr(100 downto 99);
begin
	x : process
	begin
		a := "10";
		t.assign(a, b);
		assert b(100) = '1' report "error" severity failure;
		assert b(99) = '0' report "error" severity failure;
		assert false report "simulation finished" severity note;
		wait;
	end process;
end test_bench_impl;
