#!/usr/bin/env python3
# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# init_themes.py
#
# sauvegarde des modifications locales du design de l'appli web
# dans un thème si besoin (/usr/share/zephir/web/themes/theme_local)
#
###########################################################################
from configparser import ConfigParser
from os.path import isdir, isfile, join
from os import system, makedirs, unlink
import shutil, sys
img_path = "/usr/share/zephir/web/backup_images"
themes_path = "/usr/share/zephir/web/themes"

def read_md5(filename):
    f_md5 = open(filename)
    lines = f_md5.read()
    f_md5.close()
    md5_data = {}
    for line in lines.strip().split('\n'):
        value, fname = line.split()
        md5_data[fname[1:]] = value
    return md5_data

if isdir(img_path):
    # on est dans le cas ou la version précédente de l'application ne gére pas encore les thèmes

    # 1 - vérification des couleurs
    # couleurs originales (utilisé pour détecter si il faut créer automatiquement un thème personnalisé
    local_colors = {'maincol':'#edf7f9',
                   'menucol':'#beccec',
                   'groupcol':'#edf7f9',
                   'bgcol':'#fff1e0',
                   'tablecol':'#0a1d90',
                   'linkcol':'#a8501d',
                   'hovercol':'#a8501d'}

    # 2 - vérification du répertoire des images
    modifs = []
    if isfile(join(themes_path, 'original', 'default_images.md5')):
        # md5 des images fournies par défaut
        def_md5s = read_md5(join(themes_path, 'original', 'default_images.md5'))
        # md5 des fichiers présents actuellement
        res = system('cd %s;/usr/bin/md5sum -b * > %s' % (img_path, join(themes_path, 'images.md5')))
        if res == 0:
            md5s = read_md5(join(themes_path, 'images.md5'))
            # liste des fichiers modifiés
            for f_img, md5val in md5s.items():
                if def_md5s.get(f_img, '') != md5val:
                    # fichier modifié ou absent à l'origine
                    modifs.append(f_img)

    # 3 - création du nouveau thème avec les modifications détectées
    if local_colors != orig_colors:
        if not isdir(join(themes_path, 'theme_local')):
            makedirs(join(themes_path, 'theme_local'))
        colors_conf = ConfigParser()
        colors_conf.add_section('zephir_web')
        for colname, colvalue in local_colors.items():
            colors_conf.set('zephir_web', colname, colvalue)
        # enregistrement du fichier
        f_colors = open(join(themes_path, 'theme_local', 'colors.ini'), 'w')
        colors_conf.write(f_colors)
        f_colors.close()
    if modifs:
        if not isdir(join(themes_path, 'theme_local', 'images')):
            makedirs(join(themes_path, 'theme_local', 'images'))
        for img_name in modifs:
            if img_name.startswith('bandeauHeader') and img_name.endswith('.jpg'):
                # dans le cas de certaines images, on les convertit en png pour correspondre
                # au nouveau template
                try:
                    import Image
                    Image.open(join(img_path, img_name)).save(join(themes_path, 'theme_local', 'images', img_name.replace('.jpg', '.png')))
                except:
                    # si la conversion échoue, on copie l'image .jpg pour éviter de la perdre
                    shutil.copy(join(img_path, img_name), join(themes_path, 'theme_local', 'images', img_name))
            else:
                shutil.copy(join(img_path, img_name), join(themes_path, 'theme_local', 'images', img_name))
    # 4 - activation du thème local dans la configuration creole si nécessaire
    if modifs or (local_colors != orig_colors):
        if not creole_conf.has_section('zephir_web_theme'):
            creole_conf.add_section('zephir_web_theme')
        creole_conf.set('zephir_web_theme', 'val', "['theme_local']")
        creole_conf.set('zephir_web_theme', 'valdefault', "[]")
        creole_conf.set('zephir_web_theme', 'valprec', "[]")
        try:
            f_conf = open('/root/config.tmp', 'w')
            creole_conf.write(f_conf)
            f_conf.close()
            shutil.copy('/root/config.tmp', '/etc/eole/config.eol')
        except:
            sys.exit('Erreur rencontrée lors de la sauvegarde du thème utilisé')

    # 4 - nettoyage
    shutil.rmtree(img_path)
    unlink(join(themes_path, 'images.md5'))
