#!/usr/bin/env python
# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr 
#  
# import_modules.py
#  
# script d'insertion des données par défaut dans la base de données
# (types établissement et modules par défaut)
#       
###########################################################################

# insertion des types d'établissement
import getpass, os
from zephir.eolerpclib import xmlrpclib, EoleProxy
from zephir.config import *

login = raw_input("entrez un nom d'utilisateur zephir : ")
passwd = getpass.getpass("mot de passe pour %s : " % login)

z = EoleProxy('https://%s:%s@%s:%s' % (login, passwd, ADRESSE_ZEPHIR, PORT_ZEPHIR))

# création des modules
print "création des modules Eole..."

modules_actuel = z.modules.get_module()[1]
libelles = []
ids = {}
for module in modules_actuel:
    libelles.append(module['libelle'])
    ids[module['libelle']] = module['id']
 
for version, modules in liste_modules.items():
    for module in modules:
        if module in libelles:
            id_module = ids[module]
        else:
            res,id_module = z.modules.add_module(module,version)
            if res == 0:
                print("\nerreur de création du module %s : %s\n" % (module,id_module))
 
    # mise à jour des dictionnaires
    print("\n mise à jour du dictionnaire pour %s " % module)
    # installation du dictionnaire
    fichier = open("%s/dictionnaires/dico-%s" % (ROOT_DIR, module),"r")
    buffer_dico = fichier.read()
    fichier.close()
    res = z.uucp.install_module(int(id_module),xmlrpclib.base64.encodestring(buffer_dico))[0]
    if res == 0:
        print("erreur d'envoi du dictionnaire pour le module %s" % module)

print "\ninsertion des données terminée"
