#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import os
from zephir.backend.config import PATH_ZEPHIR, ROOT_DIR, DB_PASSWD
import psycopg2 as PgSQL


# on récupère la liste des modules triés par n° de module
cx = PgSQL.connect(database='zephir',user='zephir',password=DB_PASSWD)
db_cursor = cx.cursor()
db_cursor.execute("""select id,libelle from modules""")
res = db_cursor.fetchall()
db_cursor.close()

for module in res:
    # insertion des fichiers spécifiques au module
    # lecture du fichier de description
    if os.path.isfile(os.path.join(ROOT_DIR, 'dictionnaires',  'fichiers_%s' % module[1])):
        fic_desc = open(os.path.join(ROOT_DIR, 'dictionnaires',  'fichiers_%s' % module[1]))
        data = fic_desc.read().strip().split('\n')
        fic_desc.close()
        # copie effective du dictionnaire
        for fic in data:
            if fic.startswith('/'):
                basename = os.path.basename(fic)
                path = os.path.dirname(fic)
                print basename, " ", path
