#! /usr/bin/env python3
# -*- coding: UTF-8 -*-

###########################################################################
# Eole NG - 2010
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Ajout d'un partage LDAP
#
###########################################################################
import sys, getopt
from os.path import isdir
from scribe.eoleshare import Share

def main():
    # définition du message d'aide
    help_msg = """arguments:
         -n (--nom) nom du partage
         -g (--groupe) groupe auquel appartient le partage
         -c (--chemin) chemin du répertoire à partager sur le serveur
            optionnel : /home/workgroups/nom_du_partage par défaut
         -l (--lettre) lettre sur laquelle connecter le partage sous windows
            optionnel : choisi par windows par défaut
         -h (--help) (ce message)

     exemple : ./ajout_partage.py -n cd -g groupe_cd -c /mnt/cdrom -l J:
     """

    # récupération des arguments de la ligne de commande
    try:
        options, args = getopt.getopt(sys.argv[1:], 'n:g:c:l:h',
                                 ['nom=',
                                  'groupe=',
                                  'chemin=',
                                  'lettre=',
                                  'help'])
    except getopt.GetoptError:
        # on récupère les information de l'exception
        er_type, er_value, er_traceback = sys.exc_info()
        er_msg = str(er_value)
        # on prévient l'utilisateur que l'option nécessite un argument
        sys.exit("l'option -%s est inconnue ou nécessite un argument" % er_msg[er_msg.index('-')+1])

    name = None
    groupe = None
    path = None
    letter = None

    for (opt, val) in options:
        if (opt == '-n') or (opt == '--nom'):
            name = val

        elif (opt == '-g') or (opt == '--groupe'):
            groupe = val

        elif (opt == '-c') or (opt == '--chemin'):
            path = val

        elif (opt == '-l') or (opt == '--lettre'):
            letter = val

        elif (opt == '-h') or (opt == '--help'):
            sys.exit(help_msg)

    # vérification des arguments:
    # arguments obligatoires
    if name is None:
        sys.exit("\nerreur, nom de partage est obligatoire\n" + help_msg)
    if groupe is None:
        sys.exit("\nerreur, le groupe d'appartenance est obligatoire\n" + help_msg)
    # arguments optionnels
    if path is not None:
        # on vérifie l'existence du répertoire
        if not isdir(path):
            print("\nattention, le chemin spécifié n'a pas été trouvé !")

    # ajout du partage
    share = Share()
    share.ldap_admin.connect()
    share._add(name, groupe, _type='rw', filepath=path, drive=letter)
    share.ldap_admin.close()

if __name__ == '__main__':
    main()
