# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2010
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
    librairie de fonctions pour le parsing
"""

from os import system #, unlink
from lxml import etree
from zipfile import ZipFile, is_zipfile
from os.path import basename, isfile
from scribe.importation import log

def unzip_file(fichier):
    """
    décompression du fichier d'entrée si nécessaire
    """
    if is_zipfile(fichier):
        zfile = ZipFile(fichier).namelist()
        if len(zfile) != 1:
            err_msg = "Le fichier zip %s ne doit contenir qu'un seul élément" % basename(fichier)
            log.errorlog(err_msg)
            raise Exception(err_msg)
        log.debuglog("décompression du fichier %s" % basename(fichier))
        system('/usr/bin/unzip -o "%s" >/dev/null' % fichier)
        #FIXME: Structures.xml est lu 2 fois
        #unlink(fichier)
        fichier = zfile[0]
        if not isfile(fichier):
            err_msg = "Erreur de récupération du fichier décompressé %s" % fichier
            log.errorlog(err_msg)
            raise Exception(err_msg)
    return fichier

def parse_xml(xml_file, tag='addRequest', check=True):
    """
    initialisation du parseur XML
    """
    xml_file = unzip_file(xml_file)
    if check:
        test = system('/usr/bin/xmllint --noout "%s" 2>/dev/null' % xml_file)
        if test != 0:
            err_msg = "Le fichier %s n'est pas un fichier XML valide" % basename(xml_file)
            log.errorlog(err_msg)
            raise Exception(err_msg)
    return etree.iterparse(xml_file, events=('end',), tag=tag), xml_file
