#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# Copyright © 2015 Pôle de compétences EOLE <eole@ac-dijon.fr>
#
# License CeCILL:
#  * in french: http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
#  * in english http://www.cecill.info/licences/Licence_CeCILL_V2-en.html
##########################################################################
import sys
from pyeole.ihm import question_ouinon
from scribe.linker import _user_factory

def main():

    aide = "suppression_utilisateur.py <utilisateur1>[,utilisateur2,utilisateur3]\n"

    # récupération des arguments de la ligne de commande
    try:
        users = sys.argv[1]
    except:
        sys.exit("\n"+aide)

    if users == "-h":
        sys.exit("\n"+aide)

    liste_users = users.split(",")

    # faut il supprimer également son répertoire ?
    sup_rep = question_ouinon("Voulez-vous supprimer les répertoires personnels ?") == 'oui'
    msg = "Confirmez-vous la suppression des utilisateurs {0} ?"
    confirm = question_ouinon(msg.format(','.join(liste_users))) == 'oui'

    if not confirm:
        sys.exit("\nsuppression annulée\n")

    for user in liste_users:
        try:
            ldap_user = _user_factory(user.strip())
        except Exception as msg:
            print(msg)
            continue
        print("Suppression de l'utilisateur {0}".format(user))
        ldap_user._delete(user, remove_data=sup_rep)

# si on a appelé le programme directement : on exécute main
if __name__ == "__main__":
    main()
