#!/usr/bin/env python3
# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2009
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
script pour ajouter un élève sur Scribe
"""

import sys
import getopt
from scribe.eleves import Eleve
from scribe.errors import MissingUserCreateKey, LdapExistingUser

def main():
    """
    boucle principale
    """
    try:
        options, args = getopt.getopt(sys.argv[1:], 
            'u:c:n:m:p:f:x:d:o:D:q:P:sh',
            ['user=',
             'classe=',
             'niveau=',
             'mdp=',
             'prenom=',
             'fnom=',
             'sexe=',
             'date_naiss=',
             'numero=',
             'domain=',
             'quota=',
             'profil=',
             'shell',
             'help'])
    except getopt.GetoptError:
        er_type, er_value, er_traceback = sys.exc_info()
        er_msg = str(er_value)
        sys.exit("l'option -%s est inconnue ou nécessite un argument" % er_msg[er_msg.index('-')+1])

    eleve = {}
    for (opt, val) in options:
        # login de l'élève
        if (opt == '-u') or (opt == '--user'):
            eleve['login'] = val
        # classe
        elif (opt == '-c') or (opt == '--classe'):
            eleve['classe'] = val
        # niveau
        elif (opt == '-n') or (opt == '--niveau'):
            eleve['niveau'] = val
        # mot de passe
        elif (opt == '-m') or (opt == '--mdp'):
            eleve['password'] = val
        # prénom
        elif (opt == '-p') or (opt == '--prenom'):
            eleve['prenom'] = val
        # nom (de famille)
        elif (opt == '-f') or (opt == '--fnom'):
            eleve['nom'] = val
        # sexe 1/0
        elif (opt == '-x') or (opt == '--sexe'):
            eleve['civilite'] = val
        # date de naissance
        elif (opt == '-d') or (opt == '--date_naiss'):
            eleve['date'] = val
        # numero élève
        elif (opt == '-o') or (opt == '--numero'):
            eleve['numero'] = val
        # domaine
        elif (opt == '-D') or (opt == '--domain'):
            eleve['domaine'] = val
        # quota
        elif (opt == '-q') or (opt == '--quota'):
            eleve['quota'] = val
        # profil
        elif (opt == '-P') or (opt == '--profil'):
            eleve['profil'] = val
        # shell
        elif (opt == '-s') or (opt == '--shell'):
            eleve['shell'] = True

        # et... l'aide 
        elif (opt == '-h') or (opt == '--help'):
            sys.exit("""options :
                -u login eleve
                -c classe
                -m mot de passe
                -p prenom
                -f nom de famille
                -d date de naissance (jj/mm/aaaa)
                -o numero élève
                -x civilité (1=M., 2=Mme, 3=Mlle)
                [-n niveau]
                [-D domaine mail (restreint | internet)]
                [-q quota]
                [-P profil (1=local, 2=obligatoire-1, 3=obligatoire-2, 4=itinérant)]
                [-s activation du shell]
                -h (aide)
                """)

    ldapeleve = Eleve()
    try:
        ldapeleve.add_one(**eleve)
    except MissingUserCreateKey as msg:
        print("Erreur : Il manque un argument obligatoire (%s)" % msg)
        sys.exit(1)
    except LdapExistingUser:
        print("Erreur : Le login %(login)s n'est pas disponible" % eleve)
        sys.exit(1)
    except Exception as msg:
        print("Erreur : %s" % str(msg))
        sys.exit(1)

    print("L'utilisateur %(login)s (%(prenom)s %(nom)s) a été ajouté" % eleve)
    sys.exit(0)

if __name__ == "__main__":
    main()
