#!/usr/bin/env python3
# -*- coding: UTF-8 -*-

###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# change-classe.py -u eleve -c nouvelle_classe 
#
# Changement de classe pour un élève
#
###########################################################################

###################
# modules importés
###################
from scribe.backend import change_classe
import getopt
import sys
#import ldap
#import ldif
#from os import system
#from scribe.backend_conf import *
##from creole import parsedico

## message d'aide
def help():
    sys.exit("""   
    options :
	    -u (--uid)    : uid de l'élève
	    -c (--classe) : nouvelle classe de l'élève
	    -h (--help)   : affiche ce message

    Exemple : %s -u toto -c 3g6
    """%sys.argv[0])


def main():
    # gestion des options
    uid=""
    classe=""

    try:
	    options, args = getopt.getopt(sys.argv[1:],'u:c:h',
            ['uid=',
	         'classe=',
             'help'])
             
    except getopt.GetoptError:
        er_type, er_value, er_traceback = sys.exc_info()
        er_msg = str(er_value)
        sys.exit("l'option -%s est inconnue ou nécessite un argument" % er_msg[er_msg.index('-')+1])

    for (opt,val) in options:
        # uid
        if (opt == '-u') or (opt == '--uid'):
            uid = val
        # modele
        if (opt == '-c') or (opt == '--classe'):
            classe = val
        # et l'aide...
        elif (opt == '-h') or (opt == '--help'):
	    help()	   
    
    if uid == "" or classe == "":
        help()
    
    # FIXME exceptions !!!
    if change_classe(uid, classe):
        sys.exit("L'élève \"%s\" est maintenant inscrit en %s"%(uid,classe))
    
    sys.exit("Erreur lors de l'inscription de \"%s\" en %s"%(uid,classe))


if __name__ == "__main__":
    main()	    
