import pwd
from os.path import dirname, abspath, join, isdir, islink, realpath
from shutil import rmtree
from os import makedirs, stat
from glob import glob

import pathvnc
from scribe import login

TEST_DIR = dirname(abspath(__file__))
TMP_DIR = join(TEST_DIR, 'tmp')

def test_groupedir():
    grpdir = join(TMP_DIR, 'groupes')
    if isdir(TMP_DIR):
        rmtree(TMP_DIR)
    makedirs(TMP_DIR)
    try:
        info=pwd.getpwnam('eole')
    except:
        info=pwd.getpwnam('scribe')
    uid = info.pw_uid
    homedir = TMP_DIR
    shares = [{'name': 'test1', 'path': '/home/test1', 'drive': ''},
            {'name': 'test2', 'path': '/home/test2', 'drive': ''},
            {'name': 'test3', 'path': '/home/test3', 'drive': 'e:'}]
    login.gen_groupedir(uid, homedir, shares)
    dirnames = [join(grpdir, 'test2'), join(grpdir, 'test1')]
    assert glob(join(grpdir, '*')).sort() == dirnames.sort()
    assert stat(grpdir).st_mode == 16704
    assert stat(grpdir).st_uid == uid
    assert stat(grpdir).st_gid == 0
    for dirname in dirnames:
        assert islink(dirname)
    assert realpath(join(grpdir, 'test1')) == '/home/test1'
    assert realpath(join(grpdir, 'test2')) == '/home/test2'
