#-*-coding:utf-8-*-
"""
    Librairies d'exception propre au backend scribe
"""
class SystemExistingUser(Exception):
    message = "Un utilisateur système portant ce nom existe"

class LdapExistingValue(Exception):
    """
        raise dans le cas où une valeur existe déjà
    """
    pass

class LdapExistingGroup(LdapExistingValue):
    """
        pour les groupes
    """
    message = "L'annuaire contient un groupe portant ce nom"

class LdapExistingUser(LdapExistingValue):
    """
        pour les users
    """
    message = "L'annuaire contient un utilisateur portant ce nom"

class LdapExistingShare(LdapExistingValue):
    message = "L'annuaire contient un partage portant ce nom"

class NotEmptyNiveau(Exception):
    """
        niveau avec des classes associées
    """
    pass

class NotEmptyGroup(Exception):
    """
        le groupe n'est pas vide
    """
    pass

class MissingUserCreateKey(Exception):
    pass

class EmptyUserCreateKey(Exception):
    pass

class EmptyGroupCreateKey(Exception):
    pass

class NotIntValue(Exception):
    pass

class NiveauNotFound(Exception):
    pass

class BadLogin(Exception):
    pass

