#!/usr/bin/env python3
# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2013
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
script pour supprimer un groupe sur Scribe
"""

import sys
from scribe.eolegroup import Group
from scribe.eoleshare import Share

def main():
    rmdir = True
    try:
        # on affiche le message d'aide si besoin
        if sys.argv[1] in ["--help", "-h"]:
            print("""\n syntaxe : {0} groupe1,groupe2,...,groupeN
           {0} (mode interactif)\n""".format(sys.argv[0]))
            return
        # on regarde si un groupe est passé en ligne de commande
        groupes = sys.argv[1].split(',')
    except:
        # demande du groupe à supprimer
        groupes = []
        groupe = ""
        fin_liste = 0
        while fin_liste == 0:
            groupe = input("entrez un nom de groupe (rien pour terminer la liste) : ")
            if groupe != "":
                groupes.append(groupe)
            else:
                fin_liste = 1

        rep = "bidon"
        while rep.upper() not in ['O', 'N', '']:
            rep = input("Voulez-vous également supprimer les répertoires associés aux partages ? (O) : ")
        if rep.upper() in ['O', '']:
            rmdir = True
        else:
            rmdir = False

    # supression des groupes demandés
    errors = 0
    ldapgroup = Group()
    for groupe in groupes:
        try:
            ldapgroup.delete(groupe, rmdir=rmdir, sync=False)
        except Exception as msg:
            errors += 1
            print(msg)

    if errors == 0:
        Share().synchronize(True)
        sys.exit(0)
    else:
        sys.exit(1)

if __name__ == '__main__':
    main()
