# -*- coding: utf-8 -*-
"""AAF parsing entry point
"""
import time, sys
from os.path import join
from glob import glob
from . import delta
from .config import dbtype

from .ihm import print_time
from .miscutil import parse_xml_files
from .util import db

times = [time.time()]

def main(xml_path, close=True):
    """parsing main entry point
    the parsing type depends on the name of the xml file
    """
    # REM: parsing order is very important for database integrity validation
    aaftypes = [{'pattern': "_EtabEducNat_", 'function': "parse_delta_etab_educnat", 'type': 'etablissement'}]
    if dbtype == 'mongodb':
        aaftypes.extend([{'pattern': "_MatiereEducNat_", 'function': "parse_delta_subjects", 'type': 'matiere'},
                         {'pattern': "_PersRelEleve_", 'function': "parse_delta_responsables", 'type': 'responsable'},
                         {'pattern': "_Eleve_", 'function': "parse_delta_eleves", 'type': 'élève'}])
    else:
        aaftypes.extend([{'pattern': "_Eleve_", 'function': "parse_delta_eleves", 'type': 'élève'},
                         {'pattern': "_PersRelEleve_", 'function': "parse_delta_responsables", 'type': 'responsable'}])
    aaftypes.append({'pattern': "_PersEducNat_", 'function': "parse_delta_profs", 'type': 'administratif'})

    xml_files = glob(join(xml_path, "*.xml"))
    xml_files.sort()

    for xmlfile in aaftypes:
        parse_xml_files(xmlfile['pattern'], xmlfile['function'], xml_files, delta)
        print_time(xmlfile['type'], times)
    if close:
        db.close()

