/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.LastPositionFinder;
import com.icl.saxon.expr.LookaheadEnumerator;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.style.GroupActivation;
import com.icl.saxon.style.SAXONItem;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.XSLForEach;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.NodeImpl;
import java.util.Stack;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class SAXONGroup
extends XSLForEach {
    Expression groupBy = null;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.SELECT) {
                string = attributeCollection.getValue(n);
            } else if (n3 == standardNames.GROUP_BY) {
                string2 = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("select");
        } else {
            this.select = this.makeExpression(string);
        }
        if (string2 == null) {
            this.reportAbsence("group-by");
        } else {
            this.groupBy = this.makeExpression(string2);
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.select = this.handleSortKeys(this.select);
        NodeImpl nodeImpl = this;
        SAXONItem sAXONItem = null;
        while (nodeImpl != null) {
            if (nodeImpl instanceof SAXONItem) {
                sAXONItem = (SAXONItem)nodeImpl;
                break;
            }
            nodeImpl = nodeImpl.getNextInDocument(this);
        }
        if (sAXONItem == null) {
            this.compileError("saxon:group must have a nested saxon:item element");
        }
    }

    public void process(Context context) throws TransformerException {
        NodeEnumeration nodeEnumeration = this.select.enumerate(context, false);
        if (!(nodeEnumeration instanceof LastPositionFinder)) {
            nodeEnumeration = new LookaheadEnumerator(nodeEnumeration);
        }
        Context context2 = context.newContext();
        context2.setLastPositionFinder((LastPositionFinder)((Object)nodeEnumeration));
        GroupActivation groupActivation = new GroupActivation(this, this.groupBy, nodeEnumeration, context2);
        Stack stack = context2.getGroupActivationStack();
        stack.push(groupActivation);
        while (groupActivation.hasMoreElements()) {
            groupActivation.nextElement();
            this.processChildren(context2);
            context.setReturnValue(context2.getReturnValue());
        }
        stack.pop();
    }
}

