<?php
/*
# Copyright 2004, Revolution Linux Inc., Nicolas Dufresne and Francis Giraldeau
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/

    // To set the debug mode, please uncomment the
    // line containing  // $dbConnexion->debug = true;

	require_once '/usr/share/php/adodb/adodb.inc.php';
	require_once '/usr/share/php/adodb/adodb-errorpear.inc.php';
	require_once 'functions.php';

	/**
	* Create a new connection to the database if needed
	*
	* This function reads database configuration from configuration file
	* and create a connection.  It return NULL if connection is good, a
	* message if not.
	*
	* @param object A referenced var where to place the new connection
	*/
	function makeDBConnexion() {
		global $CONFIG;
		global $dbConnexion;
		
		// If connecxion is already active, nothing to do.
		if ($dbConnexion) return NULL;
		
		// Test if configuration exist
		if (!isset($CONFIG['db_user']))
			return getMessage('no_db_user');
		
		// Authorize empty password
		if (!isset($CONFIG['db_password'])){
			$CONFIG['db_password'] = "";
		}

		if (!isset($CONFIG['db_server']))
			return getMessage('no_db_server');

		if (!isset($CONFIG['db_name']))
			return getMessage('no_db_name');

		if (!isset($CONFIG['db_type']))
			$CONFIG['db_type'] = 'postgres7';
		
		// Connection to Database
		$dbConnexion = ADONewConnection($CONFIG['db_type']);
		$dbConnexion->PConnect($CONFIG['db_server'],$CONFIG['db_user'],$CONFIG['db_password'],$CONFIG['db_name']);
		if ($error = ADODB_Pear_Error())
			return getMessage('db_connexion_failed')." : ".$error->getUserInfo();
		$dbConnexion->SetFetchMode(ADODB_FETCH_ASSOC);

        // To enable DEBUG MODE for ADODB (Very usefull !)
        // Uncomment the following line
        // $dbConnexion->debug = true;
			
		return NULL;
	}
	
	/**
	* Do a select and return first entry, null if no entry
	*
	* Do a select and return first entry, null if no entry,
	* a string if an erro occured.
	*
	* @param string Sql query
	*/
	function singleResultSelect($query) {
		global $ADODB_Last_PEAR_Error;
		if (!eregi("^select ",$query))
			return getMessage('not_a_select');
		if ($error = makeDBConnexion()) return $error;
		global $dbConnexion;
		$recordSet = &$dbConnexion->Execute($query);

		if ($error = ADODB_Pear_Error()) {
			$ADODB_Last_PEAR_Error=false;
			return $error->getUserInfo();
		}
			
		if (!$recordSet)
			return NULL;

		return $recordSet->fields;
	}
	
	/**
	* Do a select and return all entries, null if no entry
	*
	* Do a select and return all entries, null if no entry
	*
	* @param string Sql query
	*/

	function select($query) {
		global $ADODB_Last_PEAR_Error;
		if (!eregi("^select ",$query))
			return getMessage('not_a_select');
		if ($error = makeDBConnexion()) return $error;
		global $dbConnexion;
		$recordSet = &$dbConnexion->Execute($query);

		if ($error = ADODB_Pear_Error()) {
			$ADODB_Last_PEAR_Error=false;
			return $error->getUserInfo();
		}
			
		if (!$recordSet)
			return NULL;
		
		while (!$recordSet->EOF) {
    		$result[] = $recordSet->fields;
    		$recordSet->MoveNext();
		}

		return $result;
	}

	/**
	* Do delete and return true if it work
	*
	* Do delete and return true if it work
	*	
	* @param string SQL query
	*/
	function delete($query) {
		global $ADODB_Last_PEAR_Error;
		if (!eregi("^delete ",$query))
			return getMessage('not_a_delete');

		if ($error = makeDBConnexion()) return $error;
		global $dbConnexion;
		
		$dbConnexion->Execute($query);

		if ($error = ADODB_Pear_Error()) {
			$ADODB_Last_PEAR_Error=false;
			return $error->getUserInfo();
		}

		return NULL;
	}

	/**
	* Do udpate and return true if it work
	*
	* Do udpate and return true if it work
	*	
	* @param string SQL query
	*/
	function write($query) {
		global $ADODB_Last_PEAR_Error;
		if (!eregi("^update ",$query) && !eregi("^insert ",$query))
			return getMessage('not_an_update');

		if ($error = makeDBConnexion()) return $error;
		global $dbConnexion;
		
		$dbConnexion->Execute($query);

		if ($error = ADODB_Pear_Error()) {
			$ADODB_Last_PEAR_Error=false;
			return $error->getUserInfo();
		}

		return NULL;
	}


	/**
	* Start transactions
	*
	* Begin transactions in smart transaction mode
	*/
	function startTrans(){
		if ($error = makeDBConnexion()) return $error;
		global $dbConnexion;
		$dbConnexion->StartTrans();
	}

	/**
	* Has Faild transaction
	*
	* Check if a the current transaction has failed. Return true id it does;
	*
	* @return bool Transaction as failed
	*/
	function hasFailedTrans() {
		if ($error = makeDBConnexion()) return $error;
		global $dbConnexion;
		return $dbConnexion->HasFailedTrans();
	}

	/**
	* Genrate failure in transaction
	*/
	function failTrans() {
		if ($error = makeDBConnexion()) return $error;
		global $dbConnexion;
		$dbConnexion->FailTrans();
	}
	
	/**
	* Complete Transaction
	*
	* End transactions in smart mode.
	*/
	function completeTrans(){
		if ($error = makeDBConnexion()) return $error;
		global $dbConnexion;
		$dbConnexion->CompleteTrans();
	}
	
	/**
	* Convert unix time to DBtime
	*
	* Convert unix time to DBtime
	*
	* @param string Time in second since 1970
	*/
	function UnixToDB($timeStamp) {
		if ($error = makeDBConnexion()) return NULL;
		global $dbConnexion;
		return $dbConnexion->DBTimeStamp($timeStamp);
	}
	/**
	* Convert DBtime to unix
	*
	* Convert DBtime to unix
	*
	* @param string Time from DB
	*/
	function DBToUnix($timeStamp) {
		if ($error = makeDBConnexion()) return NULL;
		global $dbConnexion;		
		return $dbConnexion->UnixTimeStamp($timeStamp);
	}
	
	
	/**
	* Quote String to avoid sql injection
	*
	* @param string 
	*/
	function qstr($string) {
		if ($error = makeDBConnexion()) return NULL;
		global $dbConnexion;		
		return $dbConnexion->qstr($string);
	}
	
?>
