/*
 *   logtool - a logfile parsing/monitoring/manipulation utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "includes.h"

/* a parsing function to do a string replacement (sorta like sed w/o the extended syntax)	*/

/* A function to do string replacement's (a bit like sed) */
char *lt_strep(char *input, size_t bufsize,  char *string, char *newstring)
{
        /* Set our local variables */
        int oldlen, newlen;
        char *p, *q;
        /*
         *  Make sure the input contains the string we want to replace
         * and if not, return the input "as-is"
         */
        if((p = strstr(input, string)) == NULL) {
              return input;
        }
        /* set the old/new length variables for the strings */
        oldlen = strlen(string);
        newlen = strlen(newstring);
        /* If the strings too big for buffer size, then quit now */
        if ((strlen(input) + newlen - oldlen + 1) > bufsize) {
                return NULL;
        }

        /*
         * Memmove and memcpy the string's around so's the new string
         * exists where the old one used to be.
         */
        memmove(q = p+newlen, p+oldlen, strlen(p+oldlen)+1);
        memcpy(p, newstring, newlen);
        /* return "input" with the replaced string */
        return input;
}

/* we make some decisions based on event.source and display accordingly	*/
int lt_do_parse_evtsrc() {
	char tmp[LSIZE];
	char *ptr;
	if(cf.sys_ng_host == TRUE && lt_match(event.source, "src@|kern@") != FALSE) {
		ptr = strstr(event.source, "@") + 1;
		strcpy(tmp, ptr);
		strcpy(event.source, tmp);
	}
		
	if(cf.hostfmt != HOST_DEFAULT && lt_match(event.source, ".*/[0-9].*") != FALSE) {
		switch(cf.hostfmt) {
			case NG_HOST_BOTH:
				/* do nothing, we've already got em both here	*/
				break;
			case NG_HOST_IP:
				/* we want just the IP, so...	*/
				ptr = strstr(event.source, "/");
				++ptr;
				strcpy(event.source, ptr);
				break;
			case NG_HOST_NAME:
				ptr = strstr(event.source, "/");
				ptr[0] = '\0';
				break;
			default:
				break;
		}
	}
	return 0;
}

void lt_set_lasts() {
	

	if(event.message[0] != '\0') {
		strcpy(event.lmessage, event.message);
	} else { 
		event.lmessage[0] = '\0';
	}

	if(event.program[0] != '\0') {
		strcpy(event.lprogram, event.program);
	} else {
		event.lprogram[0] = '\0';
	}

	if(event.source[0] != '\0') {
		strcpy(event.lsource, event.source);
	} else {
		event.lsource[0] = '\0';
	}
	
	if(event.raw[0] != '\0') {
		strcpy(event.lraw, event.raw);
	}

}
	

void lt_parse_multilog() {
	time_t ttime;
	char tmp[LSIZE], tmp2[LSIZE];	
	char *ptr;
	if(event.raw[0] == '@') {
		sscanf(event.raw, "%s", tmp);
		ttime = t64nfrac(tmp);
		strcpy(tmp2, ctime(&ttime));
		tmp2[strlen(tmp2) - 1] = '\0';
		ptr = strstr(tmp2, " ");
		++ptr;
		strcpy(tmp, ptr);
		ptr = strrchr(tmp, ' ');
		ptr[0] = '\0';
		
		/* we're gonna have to fix up event.raw for later processing	*/
		strcpy(tmp2, event.raw);
		ptr = strstr(tmp2, " ");
		++ptr;
		strcpy(event.raw, tmp);
		strcat(event.raw, " ");
		strcat(event.raw, cf.multilog_program);
		strcat(event.raw, ": ");
		strcat(event.raw, ptr);
		
	}
}


int lt_do_regexcheck() {
	int retval = TRUE;
	
	if(reg.include_check == TRUE && lt_match_re(event.raw, reg.include_reg) != TRUE) {
		retval = FALSE;
	}
	if(reg.exclude_check == TRUE && lt_match_re(event.raw, reg.exclude_reg) == TRUE) {
		retval = FALSE;
	}

	return (retval);
}

/* The function that parses the line.  It's pretty basic at this point,
 * but in the future, it will do a lot more to the data */
int lt_do_parse() {
		
	int retval = TRUE;
	
	/* if the event is just a \newline, skip it	*/
	if(strcmp(event.raw, "\n") == 0) {
		return FALSE;
	}

	lt_set_lasts();	
	sscanf(event.raw, "%s %s %s %s %s %[^\n]", 
			event.month, event.day, event.time, event.source, event.program, event.message);
	
	lt_do_parse_evtsrc();
	
	return (retval);	
}

void lt_set_event_color() {
	/* set color == red by default */
	if(cf.redbeep == 1 && cf.outfmt == OUTPUT_ANSI) {
		strcpy(event.pcolor, "\033!\033r");
	} else {
	        strcpy(event.pcolor, "\033r");
	}

	if(reg.yellow_check == TRUE && lt_match_re(event.raw, reg.yellow_reg) != 0) {
		strcpy(event.pcolor, "\033y");        /* yellow event color 	*/
		
	} else if(reg.brightyellow_check == TRUE && lt_match_re(event.raw, reg.brightyellow_reg) != 0) {
		strcpy(event.pcolor, "\033Y");		/* bright yellow event color	*/
		
        } else  if(reg.green_check == TRUE && lt_match_re(event.raw, reg.green_reg) != 0) {
                strcpy(event.pcolor, "\033g");         /* green event color 	*/
		
        } else  if(reg.brightgreen_check == TRUE && lt_match_re(event.raw, reg.brightgreen_reg) != 0) {
                strcpy(event.pcolor, "\033G");         /* bright green event color 	*/
		
        } else if(reg.blue_check == TRUE && lt_match_re(event.raw, reg.blue_reg) != 0) {
		strcpy(event.pcolor, "\033b");		/* blue event color	*/
        
	} else if(reg.brightblue_check == TRUE && lt_match_re(event.raw, reg.brightblue_reg) != 0) {
		strcpy(event.pcolor, "\033B");		/* blue event color	*/
		
	} else if(reg.cyan_check == TRUE && lt_match_re(event.raw, reg.cyan_reg) != 0) {
		strcpy(event.pcolor, "\033c");		/* cyan event color	*/
	
        } else if(reg.brightcyan_check == TRUE && lt_match_re(event.raw, reg.brightcyan_reg) != 0) {
		strcpy(event.pcolor, "\033C");	/* bright cyan event	*/
		
        } else if(reg.magenta_check == TRUE && lt_match_re(event.raw, reg.magenta_reg) != 0) {
		strcpy(event.pcolor, "\033m");	/* magenta	*/
        
	} else if(reg.brightmagenta_check == TRUE && lt_match_re(event.raw, reg.brightmagenta_reg) != 0) {
		strcpy(event.pcolor, "\033M");	/* magenta	*/
	
	} else if(reg.brightred_check == TRUE && lt_match_re(event.raw, reg.brightred_reg) != 0) {
		if(cf.redbeep == 1 && cf.outfmt == OUTPUT_ANSI) {
			strcpy(event.pcolor, "\033!\033R");	/* bright red	*/
		} else {
			strcpy(event.pcolor, "\033R");
		}

	} 
}
