/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quarter@users.sourceforge.net> */

#include "include/support.h"
#include "include/paritycommand.h"
#include "include/message.h"

class LWCommandBegin: public LWCommandSegment {

LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	(void) args;
	
	g_return_val_if_fail (argc == 0, NULL);
	
	if (context->instrPtr->prev != NULL) {
	
		LWPiece *piece = (LWPiece *) context->instrPtr->prev->data;
		g_return_val_if_fail (piece != NULL, NULL);

		LWSymbol *symbol = piece->getSymbol();
		g_return_val_if_fail (symbol != NULL, NULL);
		g_return_val_if_fail (TRUE == symbol->isCommand(), NULL);

		LWCommand *cmd = (LWCommand *) symbol;		
		
		//When loop back to the previous command
		if (TRUE == cmd->isLoop()) {
			context->instrPtr = context->instrPtr->prev;
			context->resume = TRUE;
		}
	}
	
	return NULL;
}

const gchar *getName ()
{
	return "begin";
}	

gchar *getHint ()
{
	return _("Open logical block");
}

gboolean matchNextCondition (LWCommand *cmd)
{
	(void) cmd;
	return TRUE;
}

gboolean matchWith (LWCommand *cmd)
{
	if (cmd == NULL)
		throw new LWMessage (LW_ERROR_UnmatchedBrace);
	
	if (g_ascii_strcasecmp (cmd->getName(), "end"))
		throw new LWMessage (LW_ERROR_UnmatchedBrace);
	
	match();
	
	return TRUE;
}

};

LWSymbol *new_LWCommandBegin()
{
	return new LWCommandBegin();
}
