package tests::SQLQueryTypeTest;

use base qw/Lire::Test::DlfAnalyserTestCase/;

use Lire::DlfAnalysers::SQLQueryType;
use File::Basename;

sub schemasdir {
    return dirname( __FILE__ ) . "/../..";
}

sub create_analyser {
    return new Lire::DlfAnalysers::SQLQueryType();
}

sub registration_file {
    return dirname( __FILE__ ) . "/../../querytype_init";
}

sub test_categorise {
    my $self = $_[0];

    my $analyser = $self->create_analyser();
    my $dlf = { 'query' => undef };
    $analyser->categorise( $dlf );
    $self->assert_null( $dlf->{'querytype'} );

    $dlf = { 'query' => '   select test from test'  };
    $analyser->categorise( $dlf );
    $self->assert_str_equals( 'SELECT', $dlf->{'querytype'} );

    $dlf = { 'query' => 'UPDATE test SET test=1'  };
    $analyser->categorise( $dlf );
    $self->assert_str_equals( 'UPDATE', $dlf->{'querytype'} );

    return;
}


1;
