# A Desktop Planetarium for KDE

Important Note: **Do not submit Pull Requests to Github**. KStars repository on Github is just a mirror. All PRs will be closed automatically. To send patches to KStars, please use KDE's [Phabricator](https://community.kde.org/Infrastructure/Phabricator) system.

KStars is free, open source, cross-platform Astronomy Software.

It provides an accurate graphical simulation of the night sky, from any location on Earth, at any date and time. The display includes up to 100 million stars, 13,000 deep-sky objects,all 8 planets, the Sun and Moon, and thousands of comets, asteroids, supernovae, and satellites. 

For students and teachers, it supports adjustable simulation speeds in order to view phenomena that happen over long timescales, the KStars Astrocalculator to predict conjunctions, and many common astronomical calculations. For the amateur astronomer, it provides an observation planner, a sky calendar tool, and an FOV editor to calculate field of view of equipment and display them. Find out interesting objects in the "What's up Tonight" tool, plot altitude vs. time graphs for any object, print high-quality sky charts, and gain access to lots of information and resources to help you explore the universe!

Included with KStars is Ekos astrophotography suite, a complete astrophotography solution that can control all INDI devices including numerous telescopes, CCDs, DSLRs, focusers, filters, and a lot more. Ekos supports highly accurate tracking using online and offline astrometry solver, autofocus and autoguiding capabilities, and capture of single or multiple images using the powerful built in sequence manager.

## Copyright

Copyright (c) 2001 - 2020 by The KStars Team:

KStars is Free Software, released under the GNU Public License. See COPYING for GPL license information.

## Downloads

KStars is available for Windows, MacOS, and Linux. You can download the latest version from [KStars official website](https://edu.kde.org/kstars).

On Linux, it is available for most Linux distributions.

Latest stable version is v3.3.8

## Important URLs and files.

* The [KStars homepage](https://edu.kde.org/kstars)
* KDE [KStars Git Repository](git://anongit.kde.org/kstars).You can obtain the latest version via git from:
* KStars [Web Chat](https://webchat.kde.org/#/room/#kstars:kde.org)

## KStars documentation

The KStars handbook can be found in your $(KDEDIR)/share/doc/HTML/<lang>/kstars/
directory.  You can also easily access it from the Help menu, or by pressing
the [F1] key, or by visiting https://docs.kde.org/?application=kstars

In addition, there are the following README files:

README:             This file; general information
README.planetmath:  Explanation of algorithms used to compute planet positions
README.customize:   Advanced customization options
README.images:      Copyright information for images used in KStars.
README.i18n:        Instructions for translators


## Credits
### The KStars Team

Main contributors:
   Jason Harris <kstars@30doradus.org>
   Jasem Mutlaq <mutlaqja@ikarustech.com>
   Akarsh Simha <akarsh.simha@kdemail.net>
   James Bowlin <bowlin@mindspring.com>
   Heiko Evermann <heiko@evermann.de>
   Thomas Kabelmann <tk78@gmx.de>
   Pablo de Vicente <pvicentea@wanadoo.es>
   Mark Hollomon <mhh@mindspring.com>
   Carsten Niehaus <cniehaus@kde.org>
   Médéric Boquien <mboquien@free.fr>
   Alexey Khudyakov <alexey.skladnoy@gmail.com>
   Jérôme Sonrier <jsid@emor3j.fr.eu.org>
   Harry de Valence <hdevalence@gmail.com>
   Victor Carbune <victor.carbune@kdemail.net>
   Rafał Kułaga <rl.kulaga@gmail.com>
   Samikshan Bairagya <samikshan@gmail.com>
   Rishab Arora <ra.rishab@gmail.com>
   Robert Lancaster <rlancaste@gmail.com>

### Data Sources:

 Most of the catalog data came from the Astronomical Data Center, run by
 NASA.  The website is:
 http://adc.gsfc.nasa.gov/

 NGC/IC data is compiled by Christian Dersch from OpenNGC database.
 https://github.com/mattiaverga/OpenNGC
 Check LICENSE_OpenNGC for license details (CC-BY-SA-4.0)

 Supernovae data is from the Open Supernova Catalog project at https://sne.space
 Please refer to the published paper here: http://adsabs.harvard.edu/abs/2016arXiv160501054G

 KStars links to the excellent image collections and HTML pages put together
 by the Students for the Exploration and Development of Space, at:
 http://www.seds.org

 KStars links to the online Digitized Sky Survey images, which you can
 query at:
 http://archive.stsci.edu/cgi-bin/dss_form

 KStars links to images from the HST Heritage project, and from HST
 press releases:
 http://heritage.stsci.edu
 http://oposite.stsci.edu/pubinfo/pr.html

 KStars links to images from the Advanced Observer Program at
 Kitt Peak National Observatory.  If you are interested in astrophotography,
 you might consider checking out their program:
 http://www.noao.edu/outreach/aop/

 Credits for each image used in the program are listed in README.images


# Acknowledgements

 KStars is a labor of love.  It started as a personal hobby of mine, but
 very soon after I first posted the code on Sourceforge, it started to
 attract other developers.  I am just completely impressed and gratified
 by my co-developers.  I couldn't ask for a more talented, friendly crew.
 It goes without saying that KStars would be nowhere near what it is today
 without their efforts.  Together, we've made something we can all be
 proud of.

 We used (primarily) two books as a guide in writing the algorithms used
 in KStars:
 + "Practical Astronomy With Your Calculator" by Peter Duffett-Smith
 + "Astronomical Algorithms" by Jean Meeus

 Thanks to the developers of Qt and KDE whose peerless API made KStars
 possible.  Thanks also to the tireless efforts of the KDE translation
 teams, who bring KStars to a global audience.

 Thanks to everyone at the KDevelop message boards and on irc.kde.org,
 for answering my frequent questions.

 Thanks also to the many users who have submitted bug reports or other
 feedback.


You're still reading this? :)
Well, that's about it.  I hope you enjoy KStars!

Jason Harris
kstars@30doradus.org

KStars Development Mailing list
kstars-devel@kde.org

Send us ideas and feedback!
