#***************************************************************************
# *   Copyright (C) 2003 by A Lynch                                  *
# *   aalynch@users.sourceforge.net                                        *
# *                                                                         *
# *   This program is free software; you can redistribute it and/or modify  *
# *   it under the terms of the GNU General Public License version 2 as published by  *
# *   the Free Software Foundation;                                         *
# *                                                                         *
# *   This program is distributed in the hope that it will be useful,       *
# *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
# *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
# *   GNU General Public License for more details.                          *
# *                                                                         *
# *   You should have received a copy of the GNU General Public License     *
# *   along with this program; if not, write to the                         *
# *   Free Software Foundation, Inc.,                                       *
# *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
# ***************************************************************************/

import os

from PyQt4 import QtGui, QtCore

import equation
from qt4gui import nodedebugger

from constants import *

import logging
l = logging.getLogger(__name__)

def getNextNodeId():
    id = 1
    while True:
        yield id 
        id += 1

class TreeItem:

    def __init__(self, row, column, node, parentItem=None):
        self.parentItem = parentItem
        self.node = node
        self.row = row
        self.column = column

class NodeModel(QtCore.QAbstractItemModel):
    def __init__(self, parent=None):
        QtCore.QAbstractItemModel.__init__(self, parent)
        self.treeItems = {}
        self.rootNode = None
    
    def createTreeIndex(self, row, column, node, parentItem=None):
        item = TreeItem(row, column, node, parentItem)
        self.treeItems[id(item)] = item
        index = self.createIndex(row, column, id(item))
        return index
            
    def setRootNode(self, rootNode):
        self.rootNode = rootNode        
    
    def index(self, row, column, parentModelIndex):
        index = None
        if not parentModelIndex.isValid() and column ==0 and row ==0:
            index = self.createTreeIndex(0, 0, self.rootNode)
        elif parentModelIndex.isValid():
            parentItem = self.treeItems[parentModelIndex.internalId()]
            parentNode = parentItem.node
            node = parentNode.nodes[row]
            index = self.createTreeIndex(row, column, node, parentItem)
        return index

    def parent(self, modelIndex):
        if modelIndex.isValid():
            item = self.treeItems[modelIndex.internalId()]
            parentItem = item.parentItem
            if not parentItem:
                return QtCore.QModelIndex()
            else:
                parentIndex = self.createIndex(parentItem.row, 0 , id(parentItem))
            return parentIndex
        else:
            return QtCore.QModelIndex()
            
    def rowCount(self, parentModelIndex):
        if not parentModelIndex.isValid():
            return 1
        else:
            item = self.treeItems[parentModelIndex.internalId()]
            node = item.node
            count = len(node.nodes)
            return count
            
    def columnCount(self, parentModelIndex):
        return 1
            
    def hasChildren(self, modelIndex):
        if not modelIndex.isValid():
            return True
        else:
            item = self.treeItems[modelIndex.internalId()]
            node = item.node
            if len(node.nodes) == 0:
                return False
            else:
                return True
                
    def data(self, modelIndex, role):
        if role == QtCore.Qt.DisplayRole:
            item = self.treeItems[modelIndex.internalId()]
            node = item.node
            value = QtCore.QString(str(node.getDebugString()))
            varValue = QtCore.QVariant(value)
            return varValue
        else:
            return QtCore.QVariant()
            
class NodeDebuggerImpl(QtGui.QWidget):
    def __init__(self, parent):
        QtGui.QWidget.__init__(self, parent)
        try:
            self.ui = nodedebugger.Ui_frmNodeDebugger()
            self.ui.setupUi(self)
        except:
            l.exception("creating node debugger")
            
    def setRootNode(self, node):
            nodeModel = NodeModel(self)
            nodeModel.setRootNode(node)
            self.ui.tvNode.setModel(nodeModel)
