#ifdef WIN32
/* Wu Yongwei's quick hacks for MinGW, referenced in 
http://osdir.com/ml/gnu.mingw.devel/2003-03/msg00070.html
 */
#include <windows.h>
#include <errno.h>
#define dlsym(D,F) (void*)GetProcAddress((HMODULE)D,F)
#define dlerror() (char*)GetLastError()
#define dlopen(P,G) (void*)LoadLibrary(P)
#define dlclose(D) FreeLibrary((HMODULE)D)
#else
#include <dlfcn.h>
#endif
#include <iostream>
#include <stdlib.h>
#include <cstdlib>

extern "C" {
#include "repl_load.h"
}

using namespace std;

static void* program;
static prepareFn do_prepare;
static pushIntFn do_pushInt;
static pushFloatFn do_pushFloat;
static pushStringFn do_pushString;
static callFn do_call;
static initFn do_init;
static arrayFn do_array;
static opFn do_op;
static opFn do_floatop;
static opFn do_unop;
static opFn do_floatunop;
static appendFn do_append;
static coerceFn do_str2int;
static coerceFn do_int2str;
static coerceFn do_str2real;
static coerceFn do_real2str;
static coerceFn do_str2chr;
static coerceFn do_chr2str;
static coerceFn do_int2real;
static coerceFn do_real2int;
static coerceFn do_bool2str;
static actionFn do_clearStack;

#define TEST(x) if (x==NULL) { cout << dlerror() << endl; exit(-1); }

void interp_load(const char* pathname)
{
    program = dlopen(pathname, RTLD_LAZY);
    if (program==NULL) {
	cout << dlerror() << endl;
	exit(-1);
    } else {
	// Look up the necessary function symbols.
	// We have to do this now, rather than compile time, because there
	// are symbols which aren't resolved until the Builtins library is
	// compiled. And we can't compile that until we have a compiler...
	// So this rather hacky solution lets us resolve just what we need.
	do_prepare = (prepareFn)(dlsym(program, "interp_prepare_call"));
	TEST(do_prepare);
	do_clearStack = (prepareFn)(dlsym(program, "interp_clear"));
	TEST(do_clearStack);
	do_pushInt = (pushIntFn)(dlsym(program, "interp_push_int"));
	TEST(do_pushInt);
	do_pushFloat = (pushFloatFn)(dlsym(program, "interp_push_float"));
	TEST(do_pushFloat);
	do_pushString = (pushStringFn)(dlsym(program, "interp_push_string"));
	TEST(do_pushString);
	do_call = (callFn)(dlsym(program, "interp_call"));
	TEST(do_call);
	do_init = (initFn)(dlsym(program, "interp_init"));
	TEST(do_init);
	do_array = (arrayFn)(dlsym(program, "interp_array"));
	TEST(do_array);
	do_op = (opFn)(dlsym(program, "interp_op"));
	TEST(do_op);
	do_floatop = (opFn)(dlsym(program, "interp_floatopfn"));
	TEST(do_floatop);
	do_unop = (opFn)(dlsym(program, "interp_unop"));
	TEST(do_unop);
	do_floatunop = (opFn)(dlsym(program, "interp_floatunop"));
	TEST(do_floatunop);
	do_append = (appendFn)(dlsym(program, "interp_append"));
	TEST(do_append);

	do_str2int = (coerceFn)(dlsym(program, "interp_str2int"));
	TEST(do_str2int);
	do_int2str = (coerceFn)(dlsym(program, "interp_int2str"));
	TEST(do_int2str);
	do_str2real = (coerceFn)(dlsym(program, "interp_str2real"));
	TEST(do_str2real);
	do_real2str = (coerceFn)(dlsym(program, "interp_real2str"));
	TEST(do_real2str);
	do_bool2str = (coerceFn)(dlsym(program, "interp_bool2str"));
	TEST(do_bool2str);
	do_str2chr = (coerceFn)(dlsym(program, "interp_str2chr"));
	TEST(do_str2chr);
	do_chr2str = (coerceFn)(dlsym(program, "interp_chr2str"));
	TEST(do_chr2str);
	do_int2real = (coerceFn)(dlsym(program, "interp_int2real"));
	TEST(do_int2real);
	do_real2int = (coerceFn)(dlsym(program, "interp_real2int"));
	TEST(do_real2int);
    }
}

void interp_init()
{
    do_init();
}

void interp_close()
{
    if (program!=NULL) {
	dlclose(program);
	do_prepare = NULL;
	do_pushInt = NULL;
	do_pushFloat = NULL;
	do_pushString = NULL;
	do_call = NULL;
	program = NULL;
    }
}

// Clear the stack
void interp_clear()
{
    do_clearStack();
}

void interp_prepare_call() 
{
    // Look up 'interp_prepare_call' in program.
    do_prepare();
}

void interp_push_int(int v)
{
    do_pushInt(v);
}

void interp_push_float(double v)
{
    do_pushFloat(v);
}

void interp_push_string(char* v)
{
    do_pushString(v);
}

// Call a function in the given vm, in the loaded program.
// FIXME: This has to deal with exceptions at some point! Probably putting
// try/catch VM instructions around it will work...
int interp_call(const char* function)
{
    return do_call(program, function);
}

void interp_array(int len)
{
    do_array(len);
}

void interp_op(int opid)
{
    do_op(opid);
}

void interp_floatop(int opid)
{
    do_floatop(opid);
}

void interp_unop(int opid)
{
    do_unop(opid);
}

void interp_floatunop(int opid)
{
    do_floatunop(opid);
}

void interp_append()
{
    do_append();
}

void interp_str2int()
{
    do_str2int();
}

void interp_int2str()
{
    do_int2str();
}

void interp_str2real()
{
    do_str2real();
}

void interp_real2str()
{
    do_real2str();
}

void interp_str2chr()
{
    do_str2chr();
}

void interp_chr2str()
{
    do_chr2str();
}

void interp_int2real()
{
    do_int2real();
}

void interp_real2int()
{
    do_real2int();
}

void interp_bool2str()
{
    do_bool2str();
}
