/*
 *   File name:	main.cpp
 *   Summary:	Main program for KDirStat
 *   License:	GPL - See file COPYING for details.
 *
 *   Author:	Stefan Hundhammer <kdirstat@gmx.de>
 *		Joshua Hodosh <kdirstat@grumpypenguin.org>
 *		Parts auto-generated by KDevelop
 *
 *   Updated:	2010-03-03
 */



#include "k4dirstat.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <KDE/KLocale>
#include <KDE/KUrl>

static const char description[] =
    I18N_NOOP("KDirStat - Directory statistics.\n"
		"\n"
		"Shows where all your disk space has gone\n"
		"and helps you clean it up.");

static const char version[] = "2.7.0";

int main(int argc, char **argv)
{
    KAboutData about("k4dirstat", 0, ki18n("k4dirstat"), version, ki18n(description),
		     KAboutData::License_GPL,
		     ki18n("(c) 1999-2008 Stefan Hundhammer, (c) 2010 Joshua Hodosh"),
		     KLocalizedString(), 0, "kdirstat@grumpypenguin.org");

    about.addAuthor( ki18n("Stefan Hundhammer"),
		      ki18n("\n"
				"If you have any comments or if you would simply like to tell\n"
				"your opinion about this program, please use \n"
				"\"Send Feedback Mail\" from the \"Help\" menu.\n"
				"\n"
				"Any feedback (even negative!) is appreciated." ),
		      "kdirstat@gmx.de",
		      "http://kdirstat.sourceforge.net/" );

    about.addAuthor( ki18n("Joshua Hodosh"), ki18n("Ported to KDE4"),
                     "kdirstat@grumpypenguin.org" );

    about.addCredit( ki18n("SequoiaView Team"),
		      ki18n( "for showing just how useful treemaps really can be." ),
		      0,	// e-mail
		      "http://www.win.tue.nl/sequoiaview" );

    about.addCredit( ki18n("Jarke J. van Wijk, Huub van de Wetering, Mark Bruls"),
		      ki18n( "for their papers about treemaps." ),
		      "vanwijk@win.tue.nl",
		      "http://www.win.tue.nl/~vanwijk/" );

    about.addCredit( ki18n("Ben Shneiderman"),
		      ki18n( "for his ingenious idea of treemaps -\n"
				 "a truly intuitive way of visualizing tree contents." ),
		      "",	// E-Mail
		      "http://www.cs.umd.edu/hcil/treemaps/" );

    KCmdLineArgs::init(argc, argv, &about);

    KCmdLineOptions options;
    options.add("+[Dir/URL]", ki18n( "Directory or URL to open" ));
    KCmdLineArgs::addCmdLineOptions(options);
    KApplication app;

    k4dirstat *kdirstat = new k4dirstat;

    // see if we are starting with session management
    if (app.isSessionRestored())
    {
        RESTORE(k4dirstat);
    }
    else
    {
        kdirstat->show();
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();      
        if (args->count() == 0)
        {
            kdirstat->fileAskOpenDir();
        }
        else
        {       
            // Process command line arguments as URLs or paths to scan

            KUrl url = args->url( 0 );
            // kdDebug() << "Opening " << url.url() << endl;
            kdirstat->openURL( url );
        }
        args->clear();
    }

    return app.exec();
}
