#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Anna Lea
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Samorost series:
# - Samorost 1
# - Samorost 2
# - Samorost 3
# send your bug reports to bugs@dotslashplay.it
###

script_version=20241202.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID_SAMOROST1='samorost-1'
GAME_NAME_SAMOROST1='Samorost 1'

GAME_ID_SAMOROST2='samorost-2'
GAME_NAME_SAMOROST2='Samorost 2'

GAME_ID_SAMOROST3='samorost-3'
GAME_NAME_SAMOROST3='Samorost 3'

ARCHIVE_BASE_SAMOROST1_0_NAME='setup_samorost_1_1.12_(47177).exe'
ARCHIVE_BASE_SAMOROST1_0_MD5='3cbc500a060c6654b312c0e0adb04601'
ARCHIVE_BASE_SAMOROST1_0_TYPE='innosetup'
ARCHIVE_BASE_SAMOROST1_0_SIZE='77000'
ARCHIVE_BASE_SAMOROST1_0_VERSION='1.1.12-gog47177'
ARCHIVE_BASE_SAMOROST1_0_URL='https://www.gog.com/game/samorost_1'

ARCHIVE_BASE_SAMOROST2_0_NAME='setup_samorost_2_2.34_(42685).exe'
ARCHIVE_BASE_SAMOROST2_0_MD5='282e6c0c807678e19d4d0987b1d7b62f'
ARCHIVE_BASE_SAMOROST2_0_TYPE='innosetup'
ARCHIVE_BASE_SAMOROST2_0_SIZE='130000'
ARCHIVE_BASE_SAMOROST2_0_VERSION='2.2.34-gog42685'
ARCHIVE_BASE_SAMOROST2_0_URL='https://www.gog.com/game/samorost2'

ARCHIVE_BASE_SAMOROST3_0_NAME='setup_samorost_3_1.467.0_(18751).exe'
ARCHIVE_BASE_SAMOROST3_0_MD5='0edc5e0c7a71c41826999bb8bd4b32b0'
ARCHIVE_BASE_SAMOROST3_0_TYPE='innosetup'
ARCHIVE_BASE_SAMOROST3_0_SIZE='1200000'
ARCHIVE_BASE_SAMOROST3_0_VERSION='3.1.467.0-gog18751'
ARCHIVE_BASE_SAMOROST3_0_URL='https://www.gog.com/game/samorost_3_cosmic_edition'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
adobe air
samorost1.exe
samorost2.exe
samorost3.exe'
CONTENT_GAME_DATA_FILES='
data
meta-inf'

WINE_PERSISTENT_DIRECTORIES_SAMOROST1='
users/${USER}/AppData/Roaming/amanitadesign.samorost1'
## "samorost3" despite the game being Samorost 2 is expected
WINE_PERSISTENT_DIRECTORIES_SAMOROST2='
users/${USER}/AppData/Roaming/amanitadesign.samorost3'
WINE_PERSISTENT_DIRECTORIES_SAMOROST3='
users/${USER}/AppData/Roaming/amanita-design.samorost3'

APP_MAIN_EXE_SAMOROST1='samorost1.exe'
APP_MAIN_EXE_SAMOROST2='samorost2.exe'
APP_MAIN_EXE_SAMOROST3='samorost3.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID_SAMOROST1="${GAME_ID_SAMOROST1}-data"
PKG_DATA_ID_SAMOROST2="${GAME_ID_SAMOROST2}-data"
PKG_DATA_ID_SAMOROST3="${GAME_ID_SAMOROST3}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
