.TH HISTRETCH 1 "11 November 2021" "Version 1.3"
.\"=====================================================================
.if n .ds MF Metafont
.if t .ds MF Metafont
.if t .ds TX \fRT\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X\fP
.if n .ds TX TeX
.ie t .ds OX \fIT\v'+0.25m'E\v'-0.25m'X\fP
.el .ds OX TeX
.\" BX definition must follow TX so BX can use TX
.if t .ds BX \fRB\s-2IB\s0\fP\*(TX
.if n .ds BX BibTeX
.\" LX definition must follow TX so LX can use TX
.if t .ds LX \fRL\\h'-0.36m'\\v'-0.15v'\s-2A\s0\\h'-0.15m'\\v'0.15v'\fP\*(TX
.if n .ds LX LaTeX
.if t .ds AX \fRA\\h'-0.1667m'\\v'0.20v'M\\v'-0.20v'\\h'-0.125m'S\fP\*(TX
.if n .ds AX AmSTeX
.if t .ds AY \fRA\\h'-0.1667m'\\v'0.20v'M\\v'-0.20v'\\h'-0.125m'S\fP\*(LX
.if n .ds AY AmSLaTeX
.if n .ds WB Web
.if t .ds WB W\s-2EB\s0
.\"=====================================================================
.SH NAME
histretch \- translating binary HINT files to ASCII files
.SH SYNOPSIS
.B histretch
.RI [ options ]
.RI [ file ]
.\"=====================================================================
.SH DESCRIPTION
Stretching converts a binary HINT file, usually with the extension 
.BR .hnt ,
into an  ASCII based HINT file, with the extension
.BR .hint .
.PP
The binary HINT file format - also called `short' format - is optimized
for displaying HINT files. It can be parsed equally well in forward
and backward direction to enable fast forward or backward navigation in the file.
.PP
The ASCII based HINT file format - also called `long' format - is optimized
for readability. It can be edited using a text editor. Hence it allows
simple modifications that would be difficult to achieve when using the binary
format. It is also convenient when debugging.
.PP
The binary HINT file format is designed for on-screen reading of documents. 
Using a HINT viewer to display a HINT file, its content will dynamically
adapt to the available display area. For complete information on the
HINT file format and programs to view HINT files, see
.BR  https://hint.userweb.mwn.de .
.\"=====================================================================
.SH OPTIONS
This version of 
.B histretch
understands the following command line options:
.TP
.B -a
Write auxiliar files to disk using the localized path names as explained in the
.B FILES
section below.

Use this option if you are stretching a HINT file that you later want
to shrink back to its binary format unless you know that you have
already all the auxiliary files contained in it. 
.TP
.BI -d \ bitmask
Sets HINT file debugging flags according to the 
.IR bitmask .
See the
.B --help
option for details.
.TP
.B -f
Force the replacement of existing auxiliary files. 
Use this option together with the
.B -g
or 
.B -a
option to make sure that already exiting auxiliary files are replaced by the
auxiliary files contained in the HINT file.

.BR WARNING :
This is a dangerous option especially together with the
.B -g
option. Never use it on a HINT file of unknown
origin. It will possibly replace any file on your machine you have
write access to.  If in doubt, don't use the
.B -f
option.
.TP
.B -g
Write auxiliar files to disk using the path names as stored in the HINT file.
This option is an alternative to the 
.B -a
option and takes precedence if given. 
If in doubt, don't use the
.B -g
option.
If you just want to stretch the HINT file, then edit it, and then shrink
it back to the binary format, you should use the 
.B -a
option. 

You may use this option if you are stretching a HINT file on the same machine and in
the same directory where you have created the HINT file. Then all files
will be copied to the location they came from in case they were deleted
in the meantime.

If you are stretching a HINT file on one machine and the file was created
on a different machine, 
.B histretch 
will try to copy an auxiliary file
into the same directory that was used when the HINT file was created, provided that 
you have the necessary writing rights. 
This is probably where you want the auxiliary file assuming that both machines have the
same directory structure.

.BR WARNING :
This is a dangerous option especially together with the
.B -f
option. Never use it on a HINT file of unknown
origin. It can possibly write (and replace) any file on your machine where you have
write access.
.TP
.B --help
Print help message and exit.
.TP
.B -l
Redirect standard error to a log file. The name of the log file is derived from
the name of the input file replacing the extension
.B .hnt
by the extension
.BR .log .
.TP
.BI -o \ name
Use
.I name
for the output file instead of deriving it from the name of the input file.
Append the extension
.B .hint
if the
.I name
does not already has that extension.
.TP
.B -u
Enable the use of UTF8 character codes. 
Without this option, the output file is a pure ASCII file, because character codes
outside the ASCII range are written using their numeric representation.
With this option, the file will always represent printable characters using their UTF8 
character codes. This might make the output file more readable if displayed 
using an UTF8 enabled program; but it might be less readable if displayed
by a program that does not handle UTF8 characters properly. See also the
.B -x
option.
.TP
.B --version
Print version information and exit.
.TP
.B -x
Enable the use of hexadecimal character codes.
Without this option, characters that are not represented using their
character codes are represented using a decimal representation of 
the character code. With this option a hexadecimal representation is used.
The range of character codes that have a numeric representation includes
the non printable characters (character codes smaller than 32)
and unless the 
.B -u
option is given, the character codes with a value of 127 and above.
.\"=====================================================================
.SH FILES
Binary HINT files must contain all resources necessary to display the file,
for example font and image files.  These files are called auxiliary files.
ASCII HINT files contain only the path names of these files.

When creating a binary HINT file from an ASCII HINT file, it is
necessary to find these files, read them, and include them in the binary output file.
When creating an ASCII HINT file from a binary HINT file, it is
convenient if these files can be extracted and written to the file system.
To avoid clobbering arbitrary directories with files when extracting auxiliary 
files, it is possible to map the path names as stored in the HINT file
to 
.B localized
path names before writing or reading auxiliar files.

When computing a localized path name from a given path name,
a distinction is made between global resources,
like fonts, that are referenced by an absolute path name, and local
resources, for example an image, that are referenced by a relative
path name. The directory that starts the localized path name of the former 
has the extension
.B .abs
and for the latter the extension
.BR .rel 
is used.
To keep auxiliary files in these subdirectories even if their path
contains links to a parent directory, parent links
.RB ` .. ' 
are replaced by
.RB ` __ '
links to subdirectories.

For example,
given an input file 
.BR paper.hint,
the global resources are stored in the
.B paper.abs
directory and local resources are stored in 
.BR paper.rel .
An absolute path like
.B /usr/share/fonts/
will then map to the localized path
.BR paper.abs/usr/share/fonts/ 
and a relative path like
.B ../image/img1.jpg
will then map to the localized path
.BR paper.rel/__/image/img1.jpg .
.\"=====================================================================
.SH NOTES
This manual page is not meant to be exhaustive.  The complete
documentation can be found in
.IR "HINT: The file format" .
This document is available as a book or in electronic form from the 
HINT project home page at 
.BR https://hint.userweb.mwn.de .
There you find additional software, most importantly viewers for HINT files,
and further information.
.\"=====================================================================
.SH AVAILABILITY
.B histretch
should compile on a large variety of machine architectures
and operating systems.
It is part of the \*(TX Live distribution.
.PP
.\"=====================================================================
.SH "SEE ALSO"
.BR hishrink (1),
.BR hitex (1),
.\"=====================================================================
.SH AUTHORS
Martin Ruckert
.\" vim: syntax=nroff
