.\"	$Id$
.TH VLNA 1 "March 30 2009"
.nh
.SH NAME
vlna \- adds tilde after each non-syllabic preposition
.SH USAGE
.B vlna
[\fIoptions\fP]
[\fIfilenames\fP]
.SH PREFACE
There exists a special Czech and Slovak typographical rule: you cannot
leave the non-syllabic preposition on the end of one line and continue
writting text on next line. For example, 
you cannot write down the text "v lese" (in a forest) like 
"v<new-line>lese". The program vlna adds the asciitilde
between such preposition and the next word and removes the space(s) in
this place.  It means, the program converts "v lese" to "v~lese". You
can use this program as a preporcessor before TeXing. Moreower, you
can set another sequence to store instead asciitilte (see the
\fB\-x\fP option).
.SH DESCRIPTION
The program
.B vlna
processes one or more files, searches the non-syllabic prepositions 
followed by space(s) in these files and converts this/these space(s) 
to asciitilde for each such occurrence.
.PP
In the processed file, the activity of the program can be blocked by
\fB%~-\fP sequence and the activity can be restored again by the 
\fB%~+\fP sequence. These sequences can include spaces, it means that
\fB% ~-\fP is a correct sequence too.
.PP
The rule to recognize a preposition follows:
The arbitrary number of opening parentheses can be written before the
preposition and before these (optional) parentheses must be the space,
tabelator or new-line. The preposition itself is one-letter word, the letters 
have to be from this set: {KkSsVvZzOoUuAI}. See the \fB\-v\fP option if you 
want to change this set of letters. From version 1.2, the TeX sequence 
can be written before preposition and before the brace. Example:
"<new-line>([V lese" is converted to "<new-line>([V~lese".
Another example: "\\uv{V lese}" is converted to "\\uv{V~lese}".
.PP
One or more blank-spaces have to be included after preposition 
before next word. The blank-space means space or tabelator. 
One <new-line> can be here too.
All these characters are removed and replaced by asciitilde (or by 
another string, see \fB\-x\fP option). If <new-line> is deleted, another 
<new-line> is created before preposition (and before optional parentheses)
in order to the number of lines is kept unchanged. 
Example: "... V<new-line><tabelator>lese" is converted to
"...<new-line>V~lese".
.PP
The program checks the consintence of TeX's math environments
(if \fB\-m\fP option isn't used). For example the "$...$$...$" sequence
(it means the display mode switch inside the text-math mode)
generates a warning. Empty line inside display mode generates 
a warning too and the program processes next text like 
in normal (non-math) mode. The existence of the "$" inside display mode
are accepted because the constructions like
$$..\\hbox{..$..$}..$$ are allowed and common.
.PP
The consistence of verbatim mode is checked on the end of the file.
If the file ends but the verbatim mode does not end the warning is printed.
This behavior can be switched off by \fB\-n\fP or \fB\-w\fP options.
.PP
The program suppresses the tilde changing after letters like prepositions 
but they are not prepositions because the \fB\\TeX\fP or \fB\\LaTeX\fP
sequence precedes. Example: "vlastnosti \\TeX u jsou" is not converted to
"vlastnosti \\TeX u~jsou", because this text is printed (after TeX 
processing) like "vlastnosti TeXu jsou". The letter "u" is a suffix here, 
no preposition.
.SH OPTIONS
The options are optional and can be written in arbitrarty order separated 
by space.
.TP
.B \-f
Filter. The [\fIfilenames\fP] are treated as follows:
.RS
.TP 4
.B vlna \-f \fIfilename1 filename2\fP
Input is \fIfilename1\fP, output is \fIfilename2\fP.
.TP 4
.B vlna \-f \fIfilename1\fP
Input is \fIfilename1\fP, output is \fIstdout\fP.
.TP 4
.B vlna \-f
Input is \fIstdin\fP, output is \fIstdout\fP.
.TP 4
\fBvlna\fP \fIfilename1\fP [\fIfilename2\fP [\fIfilename3\fP ...]]
If the \fB\-f\fP option is omitted then each file is processed
independently and it is re-written.
.RE
.TP
.B \-s
The silent mode. No messages, warnings, statistics are printed.
Only errors which terminates the program untimely are printed.
If this parameter is omitted then banner, warnings and statistics 
are printed to \fIstderr\fP.
.TP
.B \-r
Do not create the backups. The option \fB\-r\fP is irrelevant if
the \fB\-f\fP option is used. If the \fB\-f\fP and \fB\-r\fP options 
aren't used then each re-written file is stored with its original contents 
to a backup file (the name of backup file is the same as filename, only
the tilde is used instead of the last character). 
.TP
.B \-v \fIcharacters\fP
The set of characters treated as non-syllabic prepositions is declared
by this option. Default: \fB\-v\ KkSsVvZzOoUuAI\fP.
The space between \fB\-v\fP and \fIcharacters\fP is required.
.TP
.B \-x \fIcode\fP
The \fIcode\fP is a string written in hexadecimal notation
(even hexa digits is required). This string will be saved after prepositions 
instead asciitilde which is default.
The example: \fB\-x C2A0\fP two bytes are stored after each 
non-syllabic preposition, first byte has C2 code and second byte 
has A0 code. This example means that
NO-BREAK SPACE in UTF8 encoding will be used after prepositions.
Another example: \fB\-x 00A0\fP the NO-BREAK SPACE in UTF16 encoding.
Another example: \fB\-x 48454C4C4F\fP the string HELLO will be used.
The space between \fB\-x\fP and \fIcode\fP is required.
.TP
.B \-m
The math-modes (\fB$\fP...\fB$\fP and \fB$$\fP...\fB$$\fP) are ignored.
It means that non-syllabic prepositions is searched in math-mode too.
Default (without \fB\-m\fP option): no changes in math modes are done 
because (for example) "v" is variable in math-mode, no preposition.
.TP
.B \-n
The verbatim mode (\fB\\verb\fP\fI<char>\fP...\fI<char>\fP,
\fB\\begtt\fP...\fB\\endtt\fP) is ignored, it means the program can 
do a changes in verbatim environment. 
Default (without \fB\-n\fP option): no changes in verbatim mode are done.
.TP
.B \-l
The LaTeX mode. The following environments are treated as display mode:
\fB\\begin{display}\fP...\fB\\end{display}\fP and 
\fB\\begin{equation}\fP...\fB\\end{equation}\fP and the following 
environment is treated as verbatim mode:
\fB\\begin{verbatim}\fP...\fB\\end{verbatim}\fP.
.TP
.B \-w
The web mode (Knuth's web, no www:-). The following sequences are 
treated as verbatim:
\fB@<\fP, \fB@d\fP...\fB@*\fP, \fB@\fP\fIspace\fP or \fB@>|\fP.
It means program code is unchanged in *.w or *.web files, only 
web-comments are processed. 
.SH EXAMPLES
.TP
.B vlna \-m \-n \-s \-r \fIfile\fP
The program has a behavior similar to the old \fBvlnka\fP program.
.TP
.B vlna *.tex
All files with .tex suffix in current directory will be processed 
(and possibly changed). (The "*" is UNIX-shell feautre).
.TP
.B vlna \-f file > /dev/null
Only the consistence checking of math and verbatim modes is processed.
No changes are done.
.SH AUTHORS
Petr Olsak <olsak@math.feld.cvut.cz>. 
Man page (Czech original) and Makefile is created by Rulolf Cejka
