//========================================================================
//
// BuiltinFontTables.cc
//
// Copyright 2001-2003 Glyph & Cog, LLC
//
//========================================================================

#include <config.h>
#include <stdlib.h>
#include "FontEncodingTables.h"
#include "BuiltinFontTables.h"

static BuiltinFontWidth courierWidthsTab[] = {
  { "Ntilde",                            600, nullptr },
  { "rcaron",                            600, nullptr },
  { "kcommaaccent",                      600, nullptr },
  { "Ncommaaccent",                      600, nullptr },
  { "Zacute",                            600, nullptr },
  { "comma",                             600, nullptr },
  { "cedilla",                           600, nullptr },
  { "plusminus",                         600, nullptr },
  { "circumflex",                        600, nullptr },
  { "dotaccent",                         600, nullptr },
  { "edotaccent",                        600, nullptr },
  { "asciitilde",                        600, nullptr },
  { "colon",                             600, nullptr },
  { "onehalf",                           600, nullptr },
  { "dollar",                            600, nullptr },
  { "Lcaron",                            600, nullptr },
  { "ntilde",                            600, nullptr },
  { "Aogonek",                           600, nullptr },
  { "ncommaaccent",                      600, nullptr },
  { "minus",                             600, nullptr },
  { "Iogonek",                           600, nullptr },
  { "zacute",                            600, nullptr },
  { "yen",                               600, nullptr },
  { "space",                             600, nullptr },
  { "Omacron",                           600, nullptr },
  { "questiondown",                      600, nullptr },
  { "emdash",                            600, nullptr },
  { "Agrave",                            600, nullptr },
  { "three",                             600, nullptr },
  { "numbersign",                        600, nullptr },
  { "lcaron",                            600, nullptr },
  { "A",                                 600, nullptr },
  { "B",                                 600, nullptr },
  { "C",                                 600, nullptr },
  { "aogonek",                           600, nullptr },
  { "D",                                 600, nullptr },
  { "E",                                 600, nullptr },
  { "onequarter",                        600, nullptr },
  { "F",                                 600, nullptr },
  { "G",                                 600, nullptr },
  { "H",                                 600, nullptr },
  { "I",                                 600, nullptr },
  { "J",                                 600, nullptr },
  { "K",                                 600, nullptr },
  { "iogonek",                           600, nullptr },
  { "L",                                 600, nullptr },
  { "backslash",                         600, nullptr },
  { "periodcentered",                    600, nullptr },
  { "M",                                 600, nullptr },
  { "N",                                 600, nullptr },
  { "omacron",                           600, nullptr },
  { "Tcommaaccent",                      600, nullptr },
  { "O",                                 600, nullptr },
  { "P",                                 600, nullptr },
  { "Q",                                 600, nullptr },
  { "Uhungarumlaut",                     600, nullptr },
  { "R",                                 600, nullptr },
  { "Aacute",                            600, nullptr },
  { "caron",                             600, nullptr },
  { "S",                                 600, nullptr },
  { "T",                                 600, nullptr },
  { "U",                                 600, nullptr },
  { "agrave",                            600, nullptr },
  { "V",                                 600, nullptr },
  { "W",                                 600, nullptr },
  { "equal",                             600, nullptr },
  { "question",                          600, nullptr },
  { "X",                                 600, nullptr },
  { "Y",                                 600, nullptr },
  { "Z",                                 600, nullptr },
  { "four",                              600, nullptr },
  { "a",                                 600, nullptr },
  { "Gcommaaccent",                      600, nullptr },
  { "b",                                 600, nullptr },
  { "c",                                 600, nullptr },
  { "d",                                 600, nullptr },
  { "e",                                 600, nullptr },
  { "f",                                 600, nullptr },
  { "g",                                 600, nullptr },
  { "bullet",                            600, nullptr },
  { "h",                                 600, nullptr },
  { "i",                                 600, nullptr },
  { "Oslash",                            600, nullptr },
  { "dagger",                            600, nullptr },
  { "j",                                 600, nullptr },
  { "k",                                 600, nullptr },
  { "l",                                 600, nullptr },
  { "m",                                 600, nullptr },
  { "n",                                 600, nullptr },
  { "tcommaaccent",                      600, nullptr },
  { "o",                                 600, nullptr },
  { "ordfeminine",                       600, nullptr },
  { "ring",                              600, nullptr },
  { "p",                                 600, nullptr },
  { "q",                                 600, nullptr },
  { "uhungarumlaut",                     600, nullptr },
  { "r",                                 600, nullptr },
  { "twosuperior",                       600, nullptr },
  { "aacute",                            600, nullptr },
  { "s",                                 600, nullptr },
  { "OE",                                600, nullptr },
  { "t",                                 600, nullptr },
  { "divide",                            600, nullptr },
  { "u",                                 600, nullptr },
  { "Ccaron",                            600, nullptr },
  { "v",                                 600, nullptr },
  { "w",                                 600, nullptr },
  { "x",                                 600, nullptr },
  { "y",                                 600, nullptr },
  { "z",                                 600, nullptr },
  { "Gbreve",                            600, nullptr },
  { "commaaccent",                       600, nullptr },
  { "hungarumlaut",                      600, nullptr },
  { "Idotaccent",                        600, nullptr },
  { "Nacute",                            600, nullptr },
  { "quotedbl",                          600, nullptr },
  { "gcommaaccent",                      600, nullptr },
  { "mu",                                600, nullptr },
  { "greaterequal",                      600, nullptr },
  { "Scaron",                            600, nullptr },
  { "Lslash",                            600, nullptr },
  { "semicolon",                         600, nullptr },
  { "oslash",                            600, nullptr },
  { "lessequal",                         600, nullptr },
  { "lozenge",                           600, nullptr },
  { "parenright",                        600, nullptr },
  { "ccaron",                            600, nullptr },
  { "Ecircumflex",                       600, nullptr },
  { "gbreve",                            600, nullptr },
  { "trademark",                         600, nullptr },
  { "daggerdbl",                         600, nullptr },
  { "nacute",                            600, nullptr },
  { "macron",                            600, nullptr },
  { "Otilde",                            600, nullptr },
  { "Emacron",                           600, nullptr },
  { "ellipsis",                          600, nullptr },
  { "scaron",                            600, nullptr },
  { "AE",                                600, nullptr },
  { "Ucircumflex",                       600, nullptr },
  { "lslash",                            600, nullptr },
  { "quotedblleft",                      600, nullptr },
  { "hyphen",                            600, nullptr },
  { "guilsinglright",                    600, nullptr },
  { "quotesingle",                       600, nullptr },
  { "eight",                             600, nullptr },
  { "exclamdown",                        600, nullptr },
  { "endash",                            600, nullptr },
  { "oe",                                600, nullptr },
  { "Abreve",                            600, nullptr },
  { "Umacron",                           600, nullptr },
  { "ecircumflex",                       600, nullptr },
  { "Adieresis",                         600, nullptr },
  { "copyright",                         600, nullptr },
  { "Egrave",                            600, nullptr },
  { "slash",                             600, nullptr },
  { "Edieresis",                         600, nullptr },
  { "otilde",                            600, nullptr },
  { "Idieresis",                         600, nullptr },
  { "parenleft",                         600, nullptr },
  { "one",                               600, nullptr },
  { "emacron",                           600, nullptr },
  { "Odieresis",                         600, nullptr },
  { "ucircumflex",                       600, nullptr },
  { "bracketleft",                       600, nullptr },
  { "Ugrave",                            600, nullptr },
  { "quoteright",                        600, nullptr },
  { "Udieresis",                         600, nullptr },
  { "perthousand",                       600, nullptr },
  { "Ydieresis",                         600, nullptr },
  { "umacron",                           600, nullptr },
  { "abreve",                            600, nullptr },
  { "Eacute",                            600, nullptr },
  { "adieresis",                         600, nullptr },
  { "egrave",                            600, nullptr },
  { "edieresis",                         600, nullptr },
  { "idieresis",                         600, nullptr },
  { "Eth",                               600, nullptr },
  { "ae",                                600, nullptr },
  { "asterisk",                          600, nullptr },
  { "odieresis",                         600, nullptr },
  { "Uacute",                            600, nullptr },
  { "ugrave",                            600, nullptr },
  { "five",                              600, nullptr },
  { "nine",                              600, nullptr },
  { "udieresis",                         600, nullptr },
  { "Zcaron",                            600, nullptr },
  { "Scommaaccent",                      600, nullptr },
  { "threequarters",                     600, nullptr },
  { "guillemotright",                    600, nullptr },
  { "Ccedilla",                          600, nullptr },
  { "ydieresis",                         600, nullptr },
  { "tilde",                             600, nullptr },
  { "at",                                600, nullptr },
  { "eacute",                            600, nullptr },
  { "underscore",                        600, nullptr },
  { "Euro",                              600, nullptr },
  { "Dcroat",                            600, nullptr },
  { "zero",                              600, nullptr },
  { "multiply",                          600, nullptr },
  { "eth",                               600, nullptr },
  { "Scedilla",                          600, nullptr },
  { "Racute",                            600, nullptr },
  { "Ograve",                            600, nullptr },
  { "partialdiff",                       600, nullptr },
  { "uacute",                            600, nullptr },
  { "braceleft",                         600, nullptr },
  { "Thorn",                             600, nullptr },
  { "zcaron",                            600, nullptr },
  { "scommaaccent",                      600, nullptr },
  { "ccedilla",                          600, nullptr },
  { "Dcaron",                            600, nullptr },
  { "dcroat",                            600, nullptr },
  { "scedilla",                          600, nullptr },
  { "Oacute",                            600, nullptr },
  { "Ocircumflex",                       600, nullptr },
  { "ogonek",                            600, nullptr },
  { "ograve",                            600, nullptr },
  { "racute",                            600, nullptr },
  { "Tcaron",                            600, nullptr },
  { "Eogonek",                           600, nullptr },
  { "thorn",                             600, nullptr },
  { "degree",                            600, nullptr },
  { "registered",                        600, nullptr },
  { "radical",                           600, nullptr },
  { "Aring",                             600, nullptr },
  { "percent",                           600, nullptr },
  { "six",                               600, nullptr },
  { "paragraph",                         600, nullptr },
  { "dcaron",                            600, nullptr },
  { "Uogonek",                           600, nullptr },
  { "two",                               600, nullptr },
  { "summation",                         600, nullptr },
  { "Igrave",                            600, nullptr },
  { "Lacute",                            600, nullptr },
  { "ocircumflex",                       600, nullptr },
  { "oacute",                            600, nullptr },
  { "Uring",                             600, nullptr },
  { "Lcommaaccent",                      600, nullptr },
  { "tcaron",                            600, nullptr },
  { "eogonek",                           600, nullptr },
  { "Delta",                             600, nullptr },
  { "Ohungarumlaut",                     600, nullptr },
  { "asciicircum",                       600, nullptr },
  { "aring",                             600, nullptr },
  { "grave",                             600, nullptr },
  { "uogonek",                           600, nullptr },
  { "bracketright",                      600, nullptr },
  { "ampersand",                         600, nullptr },
  { "Iacute",                            600, nullptr },
  { "lacute",                            600, nullptr },
  { "igrave",                            600, nullptr },
  { "Ncaron",                            600, nullptr },
  { "plus",                              600, nullptr },
  { "uring",                             600, nullptr },
  { "quotesinglbase",                    600, nullptr },
  { "lcommaaccent",                      600, nullptr },
  { "Yacute",                            600, nullptr },
  { "ohungarumlaut",                     600, nullptr },
  { "threesuperior",                     600, nullptr },
  { "acute",                             600, nullptr },
  { "section",                           600, nullptr },
  { "dieresis",                          600, nullptr },
  { "quotedblbase",                      600, nullptr },
  { "iacute",                            600, nullptr },
  { "ncaron",                            600, nullptr },
  { "florin",                            600, nullptr },
  { "yacute",                            600, nullptr },
  { "Rcommaaccent",                      600, nullptr },
  { "fi",                                600, nullptr },
  { "fl",                                600, nullptr },
  { "Acircumflex",                       600, nullptr },
  { "Cacute",                            600, nullptr },
  { "Icircumflex",                       600, nullptr },
  { "guillemotleft",                     600, nullptr },
  { "germandbls",                        600, nullptr },
  { "seven",                             600, nullptr },
  { "Amacron",                           600, nullptr },
  { "Sacute",                            600, nullptr },
  { "ordmasculine",                      600, nullptr },
  { "dotlessi",                          600, nullptr },
  { "sterling",                          600, nullptr },
  { "notequal",                          600, nullptr },
  { "Imacron",                           600, nullptr },
  { "rcommaaccent",                      600, nullptr },
  { "Zdotaccent",                        600, nullptr },
  { "acircumflex",                       600, nullptr },
  { "cacute",                            600, nullptr },
  { "Ecaron",                            600, nullptr },
  { "braceright",                        600, nullptr },
  { "icircumflex",                       600, nullptr },
  { "quotedblright",                     600, nullptr },
  { "amacron",                           600, nullptr },
  { "sacute",                            600, nullptr },
  { "imacron",                           600, nullptr },
  { "cent",                              600, nullptr },
  { "currency",                          600, nullptr },
  { "logicalnot",                        600, nullptr },
  { "zdotaccent",                        600, nullptr },
  { "Atilde",                            600, nullptr },
  { "breve",                             600, nullptr },
  { "bar",                               600, nullptr },
  { "fraction",                          600, nullptr },
  { "less",                              600, nullptr },
  { "ecaron",                            600, nullptr },
  { "guilsinglleft",                     600, nullptr },
  { "exclam",                            600, nullptr },
  { "period",                            600, nullptr },
  { "Rcaron",                            600, nullptr },
  { "Kcommaaccent",                      600, nullptr },
  { "greater",                           600, nullptr },
  { "atilde",                            600, nullptr },
  { "brokenbar",                         600, nullptr },
  { "quoteleft",                         600, nullptr },
  { "Edotaccent",                        600, nullptr },
  { "onesuperior",                       600, nullptr }
};

static BuiltinFontWidth courierBoldWidthsTab[] = {
  { "Ntilde",                            600, nullptr },
  { "rcaron",                            600, nullptr },
  { "kcommaaccent",                      600, nullptr },
  { "Ncommaaccent",                      600, nullptr },
  { "Zacute",                            600, nullptr },
  { "comma",                             600, nullptr },
  { "cedilla",                           600, nullptr },
  { "plusminus",                         600, nullptr },
  { "circumflex",                        600, nullptr },
  { "dotaccent",                         600, nullptr },
  { "edotaccent",                        600, nullptr },
  { "asciitilde",                        600, nullptr },
  { "colon",                             600, nullptr },
  { "onehalf",                           600, nullptr },
  { "dollar",                            600, nullptr },
  { "Lcaron",                            600, nullptr },
  { "ntilde",                            600, nullptr },
  { "Aogonek",                           600, nullptr },
  { "ncommaaccent",                      600, nullptr },
  { "minus",                             600, nullptr },
  { "Iogonek",                           600, nullptr },
  { "zacute",                            600, nullptr },
  { "yen",                               600, nullptr },
  { "space",                             600, nullptr },
  { "Omacron",                           600, nullptr },
  { "questiondown",                      600, nullptr },
  { "emdash",                            600, nullptr },
  { "Agrave",                            600, nullptr },
  { "three",                             600, nullptr },
  { "numbersign",                        600, nullptr },
  { "lcaron",                            600, nullptr },
  { "A",                                 600, nullptr },
  { "B",                                 600, nullptr },
  { "C",                                 600, nullptr },
  { "aogonek",                           600, nullptr },
  { "D",                                 600, nullptr },
  { "E",                                 600, nullptr },
  { "onequarter",                        600, nullptr },
  { "F",                                 600, nullptr },
  { "G",                                 600, nullptr },
  { "H",                                 600, nullptr },
  { "I",                                 600, nullptr },
  { "J",                                 600, nullptr },
  { "K",                                 600, nullptr },
  { "iogonek",                           600, nullptr },
  { "backslash",                         600, nullptr },
  { "L",                                 600, nullptr },
  { "periodcentered",                    600, nullptr },
  { "M",                                 600, nullptr },
  { "N",                                 600, nullptr },
  { "omacron",                           600, nullptr },
  { "Tcommaaccent",                      600, nullptr },
  { "O",                                 600, nullptr },
  { "P",                                 600, nullptr },
  { "Q",                                 600, nullptr },
  { "Uhungarumlaut",                     600, nullptr },
  { "R",                                 600, nullptr },
  { "Aacute",                            600, nullptr },
  { "caron",                             600, nullptr },
  { "S",                                 600, nullptr },
  { "T",                                 600, nullptr },
  { "U",                                 600, nullptr },
  { "agrave",                            600, nullptr },
  { "V",                                 600, nullptr },
  { "W",                                 600, nullptr },
  { "X",                                 600, nullptr },
  { "question",                          600, nullptr },
  { "equal",                             600, nullptr },
  { "Y",                                 600, nullptr },
  { "Z",                                 600, nullptr },
  { "four",                              600, nullptr },
  { "a",                                 600, nullptr },
  { "Gcommaaccent",                      600, nullptr },
  { "b",                                 600, nullptr },
  { "c",                                 600, nullptr },
  { "d",                                 600, nullptr },
  { "e",                                 600, nullptr },
  { "f",                                 600, nullptr },
  { "g",                                 600, nullptr },
  { "bullet",                            600, nullptr },
  { "h",                                 600, nullptr },
  { "i",                                 600, nullptr },
  { "Oslash",                            600, nullptr },
  { "dagger",                            600, nullptr },
  { "j",                                 600, nullptr },
  { "k",                                 600, nullptr },
  { "l",                                 600, nullptr },
  { "m",                                 600, nullptr },
  { "n",                                 600, nullptr },
  { "tcommaaccent",                      600, nullptr },
  { "o",                                 600, nullptr },
  { "ordfeminine",                       600, nullptr },
  { "ring",                              600, nullptr },
  { "p",                                 600, nullptr },
  { "q",                                 600, nullptr },
  { "uhungarumlaut",                     600, nullptr },
  { "r",                                 600, nullptr },
  { "twosuperior",                       600, nullptr },
  { "aacute",                            600, nullptr },
  { "s",                                 600, nullptr },
  { "OE",                                600, nullptr },
  { "t",                                 600, nullptr },
  { "divide",                            600, nullptr },
  { "u",                                 600, nullptr },
  { "Ccaron",                            600, nullptr },
  { "v",                                 600, nullptr },
  { "w",                                 600, nullptr },
  { "x",                                 600, nullptr },
  { "y",                                 600, nullptr },
  { "z",                                 600, nullptr },
  { "Gbreve",                            600, nullptr },
  { "commaaccent",                       600, nullptr },
  { "hungarumlaut",                      600, nullptr },
  { "Idotaccent",                        600, nullptr },
  { "Nacute",                            600, nullptr },
  { "quotedbl",                          600, nullptr },
  { "gcommaaccent",                      600, nullptr },
  { "mu",                                600, nullptr },
  { "greaterequal",                      600, nullptr },
  { "Scaron",                            600, nullptr },
  { "Lslash",                            600, nullptr },
  { "semicolon",                         600, nullptr },
  { "oslash",                            600, nullptr },
  { "lessequal",                         600, nullptr },
  { "lozenge",                           600, nullptr },
  { "parenright",                        600, nullptr },
  { "ccaron",                            600, nullptr },
  { "Ecircumflex",                       600, nullptr },
  { "gbreve",                            600, nullptr },
  { "trademark",                         600, nullptr },
  { "daggerdbl",                         600, nullptr },
  { "nacute",                            600, nullptr },
  { "macron",                            600, nullptr },
  { "Otilde",                            600, nullptr },
  { "Emacron",                           600, nullptr },
  { "ellipsis",                          600, nullptr },
  { "scaron",                            600, nullptr },
  { "AE",                                600, nullptr },
  { "Ucircumflex",                       600, nullptr },
  { "lslash",                            600, nullptr },
  { "quotedblleft",                      600, nullptr },
  { "guilsinglright",                    600, nullptr },
  { "hyphen",                            600, nullptr },
  { "quotesingle",                       600, nullptr },
  { "eight",                             600, nullptr },
  { "exclamdown",                        600, nullptr },
  { "endash",                            600, nullptr },
  { "oe",                                600, nullptr },
  { "Abreve",                            600, nullptr },
  { "Umacron",                           600, nullptr },
  { "ecircumflex",                       600, nullptr },
  { "Adieresis",                         600, nullptr },
  { "copyright",                         600, nullptr },
  { "Egrave",                            600, nullptr },
  { "slash",                             600, nullptr },
  { "Edieresis",                         600, nullptr },
  { "otilde",                            600, nullptr },
  { "Idieresis",                         600, nullptr },
  { "parenleft",                         600, nullptr },
  { "one",                               600, nullptr },
  { "emacron",                           600, nullptr },
  { "Odieresis",                         600, nullptr },
  { "ucircumflex",                       600, nullptr },
  { "bracketleft",                       600, nullptr },
  { "Ugrave",                            600, nullptr },
  { "quoteright",                        600, nullptr },
  { "Udieresis",                         600, nullptr },
  { "perthousand",                       600, nullptr },
  { "Ydieresis",                         600, nullptr },
  { "umacron",                           600, nullptr },
  { "abreve",                            600, nullptr },
  { "Eacute",                            600, nullptr },
  { "adieresis",                         600, nullptr },
  { "egrave",                            600, nullptr },
  { "edieresis",                         600, nullptr },
  { "idieresis",                         600, nullptr },
  { "Eth",                               600, nullptr },
  { "ae",                                600, nullptr },
  { "asterisk",                          600, nullptr },
  { "odieresis",                         600, nullptr },
  { "Uacute",                            600, nullptr },
  { "ugrave",                            600, nullptr },
  { "nine",                              600, nullptr },
  { "five",                              600, nullptr },
  { "udieresis",                         600, nullptr },
  { "Zcaron",                            600, nullptr },
  { "Scommaaccent",                      600, nullptr },
  { "threequarters",                     600, nullptr },
  { "guillemotright",                    600, nullptr },
  { "Ccedilla",                          600, nullptr },
  { "ydieresis",                         600, nullptr },
  { "tilde",                             600, nullptr },
  { "at",                                600, nullptr },
  { "eacute",                            600, nullptr },
  { "underscore",                        600, nullptr },
  { "Euro",                              600, nullptr },
  { "Dcroat",                            600, nullptr },
  { "multiply",                          600, nullptr },
  { "zero",                              600, nullptr },
  { "eth",                               600, nullptr },
  { "Scedilla",                          600, nullptr },
  { "Ograve",                            600, nullptr },
  { "Racute",                            600, nullptr },
  { "partialdiff",                       600, nullptr },
  { "uacute",                            600, nullptr },
  { "braceleft",                         600, nullptr },
  { "Thorn",                             600, nullptr },
  { "zcaron",                            600, nullptr },
  { "scommaaccent",                      600, nullptr },
  { "ccedilla",                          600, nullptr },
  { "Dcaron",                            600, nullptr },
  { "dcroat",                            600, nullptr },
  { "Ocircumflex",                       600, nullptr },
  { "Oacute",                            600, nullptr },
  { "scedilla",                          600, nullptr },
  { "ogonek",                            600, nullptr },
  { "ograve",                            600, nullptr },
  { "racute",                            600, nullptr },
  { "Tcaron",                            600, nullptr },
  { "Eogonek",                           600, nullptr },
  { "thorn",                             600, nullptr },
  { "degree",                            600, nullptr },
  { "registered",                        600, nullptr },
  { "radical",                           600, nullptr },
  { "Aring",                             600, nullptr },
  { "percent",                           600, nullptr },
  { "six",                               600, nullptr },
  { "paragraph",                         600, nullptr },
  { "dcaron",                            600, nullptr },
  { "Uogonek",                           600, nullptr },
  { "two",                               600, nullptr },
  { "summation",                         600, nullptr },
  { "Igrave",                            600, nullptr },
  { "Lacute",                            600, nullptr },
  { "ocircumflex",                       600, nullptr },
  { "oacute",                            600, nullptr },
  { "Uring",                             600, nullptr },
  { "Lcommaaccent",                      600, nullptr },
  { "tcaron",                            600, nullptr },
  { "eogonek",                           600, nullptr },
  { "Delta",                             600, nullptr },
  { "Ohungarumlaut",                     600, nullptr },
  { "asciicircum",                       600, nullptr },
  { "aring",                             600, nullptr },
  { "grave",                             600, nullptr },
  { "uogonek",                           600, nullptr },
  { "bracketright",                      600, nullptr },
  { "Iacute",                            600, nullptr },
  { "ampersand",                         600, nullptr },
  { "igrave",                            600, nullptr },
  { "lacute",                            600, nullptr },
  { "Ncaron",                            600, nullptr },
  { "plus",                              600, nullptr },
  { "uring",                             600, nullptr },
  { "quotesinglbase",                    600, nullptr },
  { "lcommaaccent",                      600, nullptr },
  { "Yacute",                            600, nullptr },
  { "ohungarumlaut",                     600, nullptr },
  { "threesuperior",                     600, nullptr },
  { "acute",                             600, nullptr },
  { "section",                           600, nullptr },
  { "dieresis",                          600, nullptr },
  { "iacute",                            600, nullptr },
  { "quotedblbase",                      600, nullptr },
  { "ncaron",                            600, nullptr },
  { "florin",                            600, nullptr },
  { "yacute",                            600, nullptr },
  { "Rcommaaccent",                      600, nullptr },
  { "fi",                                600, nullptr },
  { "fl",                                600, nullptr },
  { "Acircumflex",                       600, nullptr },
  { "Cacute",                            600, nullptr },
  { "Icircumflex",                       600, nullptr },
  { "guillemotleft",                     600, nullptr },
  { "germandbls",                        600, nullptr },
  { "Amacron",                           600, nullptr },
  { "seven",                             600, nullptr },
  { "Sacute",                            600, nullptr },
  { "ordmasculine",                      600, nullptr },
  { "dotlessi",                          600, nullptr },
  { "sterling",                          600, nullptr },
  { "notequal",                          600, nullptr },
  { "Imacron",                           600, nullptr },
  { "rcommaaccent",                      600, nullptr },
  { "Zdotaccent",                        600, nullptr },
  { "acircumflex",                       600, nullptr },
  { "cacute",                            600, nullptr },
  { "Ecaron",                            600, nullptr },
  { "icircumflex",                       600, nullptr },
  { "braceright",                        600, nullptr },
  { "quotedblright",                     600, nullptr },
  { "amacron",                           600, nullptr },
  { "sacute",                            600, nullptr },
  { "imacron",                           600, nullptr },
  { "cent",                              600, nullptr },
  { "currency",                          600, nullptr },
  { "logicalnot",                        600, nullptr },
  { "zdotaccent",                        600, nullptr },
  { "Atilde",                            600, nullptr },
  { "breve",                             600, nullptr },
  { "bar",                               600, nullptr },
  { "fraction",                          600, nullptr },
  { "less",                              600, nullptr },
  { "ecaron",                            600, nullptr },
  { "guilsinglleft",                     600, nullptr },
  { "exclam",                            600, nullptr },
  { "period",                            600, nullptr },
  { "Rcaron",                            600, nullptr },
  { "Kcommaaccent",                      600, nullptr },
  { "greater",                           600, nullptr },
  { "atilde",                            600, nullptr },
  { "brokenbar",                         600, nullptr },
  { "quoteleft",                         600, nullptr },
  { "Edotaccent",                        600, nullptr },
  { "onesuperior",                       600, nullptr }
};

static BuiltinFontWidth courierBoldObliqueWidthsTab[] = {
  { "Ntilde",                            600, nullptr },
  { "rcaron",                            600, nullptr },
  { "kcommaaccent",                      600, nullptr },
  { "Ncommaaccent",                      600, nullptr },
  { "Zacute",                            600, nullptr },
  { "comma",                             600, nullptr },
  { "cedilla",                           600, nullptr },
  { "plusminus",                         600, nullptr },
  { "circumflex",                        600, nullptr },
  { "dotaccent",                         600, nullptr },
  { "edotaccent",                        600, nullptr },
  { "asciitilde",                        600, nullptr },
  { "colon",                             600, nullptr },
  { "onehalf",                           600, nullptr },
  { "dollar",                            600, nullptr },
  { "Lcaron",                            600, nullptr },
  { "ntilde",                            600, nullptr },
  { "Aogonek",                           600, nullptr },
  { "ncommaaccent",                      600, nullptr },
  { "minus",                             600, nullptr },
  { "Iogonek",                           600, nullptr },
  { "zacute",                            600, nullptr },
  { "yen",                               600, nullptr },
  { "space",                             600, nullptr },
  { "Omacron",                           600, nullptr },
  { "questiondown",                      600, nullptr },
  { "emdash",                            600, nullptr },
  { "Agrave",                            600, nullptr },
  { "three",                             600, nullptr },
  { "numbersign",                        600, nullptr },
  { "lcaron",                            600, nullptr },
  { "A",                                 600, nullptr },
  { "B",                                 600, nullptr },
  { "C",                                 600, nullptr },
  { "aogonek",                           600, nullptr },
  { "D",                                 600, nullptr },
  { "E",                                 600, nullptr },
  { "onequarter",                        600, nullptr },
  { "F",                                 600, nullptr },
  { "G",                                 600, nullptr },
  { "H",                                 600, nullptr },
  { "I",                                 600, nullptr },
  { "J",                                 600, nullptr },
  { "K",                                 600, nullptr },
  { "iogonek",                           600, nullptr },
  { "backslash",                         600, nullptr },
  { "L",                                 600, nullptr },
  { "periodcentered",                    600, nullptr },
  { "M",                                 600, nullptr },
  { "N",                                 600, nullptr },
  { "omacron",                           600, nullptr },
  { "Tcommaaccent",                      600, nullptr },
  { "O",                                 600, nullptr },
  { "P",                                 600, nullptr },
  { "Q",                                 600, nullptr },
  { "Uhungarumlaut",                     600, nullptr },
  { "R",                                 600, nullptr },
  { "Aacute",                            600, nullptr },
  { "caron",                             600, nullptr },
  { "S",                                 600, nullptr },
  { "T",                                 600, nullptr },
  { "U",                                 600, nullptr },
  { "agrave",                            600, nullptr },
  { "V",                                 600, nullptr },
  { "W",                                 600, nullptr },
  { "X",                                 600, nullptr },
  { "question",                          600, nullptr },
  { "equal",                             600, nullptr },
  { "Y",                                 600, nullptr },
  { "Z",                                 600, nullptr },
  { "four",                              600, nullptr },
  { "a",                                 600, nullptr },
  { "Gcommaaccent",                      600, nullptr },
  { "b",                                 600, nullptr },
  { "c",                                 600, nullptr },
  { "d",                                 600, nullptr },
  { "e",                                 600, nullptr },
  { "f",                                 600, nullptr },
  { "g",                                 600, nullptr },
  { "bullet",                            600, nullptr },
  { "h",                                 600, nullptr },
  { "i",                                 600, nullptr },
  { "Oslash",                            600, nullptr },
  { "dagger",                            600, nullptr },
  { "j",                                 600, nullptr },
  { "k",                                 600, nullptr },
  { "l",                                 600, nullptr },
  { "m",                                 600, nullptr },
  { "n",                                 600, nullptr },
  { "tcommaaccent",                      600, nullptr },
  { "o",                                 600, nullptr },
  { "ordfeminine",                       600, nullptr },
  { "ring",                              600, nullptr },
  { "p",                                 600, nullptr },
  { "q",                                 600, nullptr },
  { "uhungarumlaut",                     600, nullptr },
  { "r",                                 600, nullptr },
  { "twosuperior",                       600, nullptr },
  { "aacute",                            600, nullptr },
  { "s",                                 600, nullptr },
  { "OE",                                600, nullptr },
  { "t",                                 600, nullptr },
  { "divide",                            600, nullptr },
  { "u",                                 600, nullptr },
  { "Ccaron",                            600, nullptr },
  { "v",                                 600, nullptr },
  { "w",                                 600, nullptr },
  { "x",                                 600, nullptr },
  { "y",                                 600, nullptr },
  { "z",                                 600, nullptr },
  { "Gbreve",                            600, nullptr },
  { "commaaccent",                       600, nullptr },
  { "hungarumlaut",                      600, nullptr },
  { "Idotaccent",                        600, nullptr },
  { "Nacute",                            600, nullptr },
  { "quotedbl",                          600, nullptr },
  { "gcommaaccent",                      600, nullptr },
  { "mu",                                600, nullptr },
  { "greaterequal",                      600, nullptr },
  { "Scaron",                            600, nullptr },
  { "Lslash",                            600, nullptr },
  { "semicolon",                         600, nullptr },
  { "oslash",                            600, nullptr },
  { "lessequal",                         600, nullptr },
  { "lozenge",                           600, nullptr },
  { "parenright",                        600, nullptr },
  { "ccaron",                            600, nullptr },
  { "Ecircumflex",                       600, nullptr },
  { "gbreve",                            600, nullptr },
  { "trademark",                         600, nullptr },
  { "daggerdbl",                         600, nullptr },
  { "nacute",                            600, nullptr },
  { "macron",                            600, nullptr },
  { "Otilde",                            600, nullptr },
  { "Emacron",                           600, nullptr },
  { "ellipsis",                          600, nullptr },
  { "scaron",                            600, nullptr },
  { "AE",                                600, nullptr },
  { "Ucircumflex",                       600, nullptr },
  { "lslash",                            600, nullptr },
  { "quotedblleft",                      600, nullptr },
  { "guilsinglright",                    600, nullptr },
  { "hyphen",                            600, nullptr },
  { "quotesingle",                       600, nullptr },
  { "eight",                             600, nullptr },
  { "exclamdown",                        600, nullptr },
  { "endash",                            600, nullptr },
  { "oe",                                600, nullptr },
  { "Abreve",                            600, nullptr },
  { "Umacron",                           600, nullptr },
  { "ecircumflex",                       600, nullptr },
  { "Adieresis",                         600, nullptr },
  { "copyright",                         600, nullptr },
  { "Egrave",                            600, nullptr },
  { "slash",                             600, nullptr },
  { "Edieresis",                         600, nullptr },
  { "otilde",                            600, nullptr },
  { "Idieresis",                         600, nullptr },
  { "parenleft",                         600, nullptr },
  { "one",                               600, nullptr },
  { "emacron",                           600, nullptr },
  { "Odieresis",                         600, nullptr },
  { "ucircumflex",                       600, nullptr },
  { "bracketleft",                       600, nullptr },
  { "Ugrave",                            600, nullptr },
  { "quoteright",                        600, nullptr },
  { "Udieresis",                         600, nullptr },
  { "perthousand",                       600, nullptr },
  { "Ydieresis",                         600, nullptr },
  { "umacron",                           600, nullptr },
  { "abreve",                            600, nullptr },
  { "Eacute",                            600, nullptr },
  { "adieresis",                         600, nullptr },
  { "egrave",                            600, nullptr },
  { "edieresis",                         600, nullptr },
  { "idieresis",                         600, nullptr },
  { "Eth",                               600, nullptr },
  { "ae",                                600, nullptr },
  { "asterisk",                          600, nullptr },
  { "odieresis",                         600, nullptr },
  { "Uacute",                            600, nullptr },
  { "ugrave",                            600, nullptr },
  { "nine",                              600, nullptr },
  { "five",                              600, nullptr },
  { "udieresis",                         600, nullptr },
  { "Zcaron",                            600, nullptr },
  { "Scommaaccent",                      600, nullptr },
  { "threequarters",                     600, nullptr },
  { "guillemotright",                    600, nullptr },
  { "Ccedilla",                          600, nullptr },
  { "ydieresis",                         600, nullptr },
  { "tilde",                             600, nullptr },
  { "at",                                600, nullptr },
  { "eacute",                            600, nullptr },
  { "underscore",                        600, nullptr },
  { "Euro",                              600, nullptr },
  { "Dcroat",                            600, nullptr },
  { "multiply",                          600, nullptr },
  { "zero",                              600, nullptr },
  { "eth",                               600, nullptr },
  { "Scedilla",                          600, nullptr },
  { "Ograve",                            600, nullptr },
  { "Racute",                            600, nullptr },
  { "partialdiff",                       600, nullptr },
  { "uacute",                            600, nullptr },
  { "braceleft",                         600, nullptr },
  { "Thorn",                             600, nullptr },
  { "zcaron",                            600, nullptr },
  { "scommaaccent",                      600, nullptr },
  { "ccedilla",                          600, nullptr },
  { "Dcaron",                            600, nullptr },
  { "dcroat",                            600, nullptr },
  { "Ocircumflex",                       600, nullptr },
  { "Oacute",                            600, nullptr },
  { "scedilla",                          600, nullptr },
  { "ogonek",                            600, nullptr },
  { "ograve",                            600, nullptr },
  { "racute",                            600, nullptr },
  { "Tcaron",                            600, nullptr },
  { "Eogonek",                           600, nullptr },
  { "thorn",                             600, nullptr },
  { "degree",                            600, nullptr },
  { "registered",                        600, nullptr },
  { "radical",                           600, nullptr },
  { "Aring",                             600, nullptr },
  { "percent",                           600, nullptr },
  { "six",                               600, nullptr },
  { "paragraph",                         600, nullptr },
  { "dcaron",                            600, nullptr },
  { "Uogonek",                           600, nullptr },
  { "two",                               600, nullptr },
  { "summation",                         600, nullptr },
  { "Igrave",                            600, nullptr },
  { "Lacute",                            600, nullptr },
  { "ocircumflex",                       600, nullptr },
  { "oacute",                            600, nullptr },
  { "Uring",                             600, nullptr },
  { "Lcommaaccent",                      600, nullptr },
  { "tcaron",                            600, nullptr },
  { "eogonek",                           600, nullptr },
  { "Delta",                             600, nullptr },
  { "Ohungarumlaut",                     600, nullptr },
  { "asciicircum",                       600, nullptr },
  { "aring",                             600, nullptr },
  { "grave",                             600, nullptr },
  { "uogonek",                           600, nullptr },
  { "bracketright",                      600, nullptr },
  { "Iacute",                            600, nullptr },
  { "ampersand",                         600, nullptr },
  { "igrave",                            600, nullptr },
  { "lacute",                            600, nullptr },
  { "Ncaron",                            600, nullptr },
  { "plus",                              600, nullptr },
  { "uring",                             600, nullptr },
  { "quotesinglbase",                    600, nullptr },
  { "lcommaaccent",                      600, nullptr },
  { "Yacute",                            600, nullptr },
  { "ohungarumlaut",                     600, nullptr },
  { "threesuperior",                     600, nullptr },
  { "acute",                             600, nullptr },
  { "section",                           600, nullptr },
  { "dieresis",                          600, nullptr },
  { "iacute",                            600, nullptr },
  { "quotedblbase",                      600, nullptr },
  { "ncaron",                            600, nullptr },
  { "florin",                            600, nullptr },
  { "yacute",                            600, nullptr },
  { "Rcommaaccent",                      600, nullptr },
  { "fi",                                600, nullptr },
  { "fl",                                600, nullptr },
  { "Acircumflex",                       600, nullptr },
  { "Cacute",                            600, nullptr },
  { "Icircumflex",                       600, nullptr },
  { "guillemotleft",                     600, nullptr },
  { "germandbls",                        600, nullptr },
  { "Amacron",                           600, nullptr },
  { "seven",                             600, nullptr },
  { "Sacute",                            600, nullptr },
  { "ordmasculine",                      600, nullptr },
  { "dotlessi",                          600, nullptr },
  { "sterling",                          600, nullptr },
  { "notequal",                          600, nullptr },
  { "Imacron",                           600, nullptr },
  { "rcommaaccent",                      600, nullptr },
  { "Zdotaccent",                        600, nullptr },
  { "acircumflex",                       600, nullptr },
  { "cacute",                            600, nullptr },
  { "Ecaron",                            600, nullptr },
  { "icircumflex",                       600, nullptr },
  { "braceright",                        600, nullptr },
  { "quotedblright",                     600, nullptr },
  { "amacron",                           600, nullptr },
  { "sacute",                            600, nullptr },
  { "imacron",                           600, nullptr },
  { "cent",                              600, nullptr },
  { "currency",                          600, nullptr },
  { "logicalnot",                        600, nullptr },
  { "zdotaccent",                        600, nullptr },
  { "Atilde",                            600, nullptr },
  { "breve",                             600, nullptr },
  { "bar",                               600, nullptr },
  { "fraction",                          600, nullptr },
  { "less",                              600, nullptr },
  { "ecaron",                            600, nullptr },
  { "guilsinglleft",                     600, nullptr },
  { "exclam",                            600, nullptr },
  { "period",                            600, nullptr },
  { "Rcaron",                            600, nullptr },
  { "Kcommaaccent",                      600, nullptr },
  { "greater",                           600, nullptr },
  { "atilde",                            600, nullptr },
  { "brokenbar",                         600, nullptr },
  { "quoteleft",                         600, nullptr },
  { "Edotaccent",                        600, nullptr },
  { "onesuperior",                       600, nullptr }
};

static BuiltinFontWidth courierObliqueWidthsTab[] = {
  { "Ntilde",                            600, nullptr },
  { "rcaron",                            600, nullptr },
  { "kcommaaccent",                      600, nullptr },
  { "Ncommaaccent",                      600, nullptr },
  { "Zacute",                            600, nullptr },
  { "comma",                             600, nullptr },
  { "cedilla",                           600, nullptr },
  { "plusminus",                         600, nullptr },
  { "circumflex",                        600, nullptr },
  { "dotaccent",                         600, nullptr },
  { "edotaccent",                        600, nullptr },
  { "asciitilde",                        600, nullptr },
  { "colon",                             600, nullptr },
  { "onehalf",                           600, nullptr },
  { "dollar",                            600, nullptr },
  { "Lcaron",                            600, nullptr },
  { "ntilde",                            600, nullptr },
  { "Aogonek",                           600, nullptr },
  { "ncommaaccent",                      600, nullptr },
  { "minus",                             600, nullptr },
  { "Iogonek",                           600, nullptr },
  { "zacute",                            600, nullptr },
  { "yen",                               600, nullptr },
  { "space",                             600, nullptr },
  { "Omacron",                           600, nullptr },
  { "questiondown",                      600, nullptr },
  { "emdash",                            600, nullptr },
  { "Agrave",                            600, nullptr },
  { "three",                             600, nullptr },
  { "numbersign",                        600, nullptr },
  { "lcaron",                            600, nullptr },
  { "A",                                 600, nullptr },
  { "B",                                 600, nullptr },
  { "C",                                 600, nullptr },
  { "aogonek",                           600, nullptr },
  { "D",                                 600, nullptr },
  { "E",                                 600, nullptr },
  { "onequarter",                        600, nullptr },
  { "F",                                 600, nullptr },
  { "G",                                 600, nullptr },
  { "H",                                 600, nullptr },
  { "I",                                 600, nullptr },
  { "J",                                 600, nullptr },
  { "K",                                 600, nullptr },
  { "iogonek",                           600, nullptr },
  { "backslash",                         600, nullptr },
  { "L",                                 600, nullptr },
  { "periodcentered",                    600, nullptr },
  { "M",                                 600, nullptr },
  { "N",                                 600, nullptr },
  { "omacron",                           600, nullptr },
  { "Tcommaaccent",                      600, nullptr },
  { "O",                                 600, nullptr },
  { "P",                                 600, nullptr },
  { "Q",                                 600, nullptr },
  { "Uhungarumlaut",                     600, nullptr },
  { "R",                                 600, nullptr },
  { "Aacute",                            600, nullptr },
  { "caron",                             600, nullptr },
  { "S",                                 600, nullptr },
  { "T",                                 600, nullptr },
  { "U",                                 600, nullptr },
  { "agrave",                            600, nullptr },
  { "V",                                 600, nullptr },
  { "W",                                 600, nullptr },
  { "X",                                 600, nullptr },
  { "question",                          600, nullptr },
  { "equal",                             600, nullptr },
  { "Y",                                 600, nullptr },
  { "Z",                                 600, nullptr },
  { "four",                              600, nullptr },
  { "a",                                 600, nullptr },
  { "Gcommaaccent",                      600, nullptr },
  { "b",                                 600, nullptr },
  { "c",                                 600, nullptr },
  { "d",                                 600, nullptr },
  { "e",                                 600, nullptr },
  { "f",                                 600, nullptr },
  { "g",                                 600, nullptr },
  { "bullet",                            600, nullptr },
  { "h",                                 600, nullptr },
  { "i",                                 600, nullptr },
  { "Oslash",                            600, nullptr },
  { "dagger",                            600, nullptr },
  { "j",                                 600, nullptr },
  { "k",                                 600, nullptr },
  { "l",                                 600, nullptr },
  { "m",                                 600, nullptr },
  { "n",                                 600, nullptr },
  { "tcommaaccent",                      600, nullptr },
  { "o",                                 600, nullptr },
  { "ordfeminine",                       600, nullptr },
  { "ring",                              600, nullptr },
  { "p",                                 600, nullptr },
  { "q",                                 600, nullptr },
  { "uhungarumlaut",                     600, nullptr },
  { "r",                                 600, nullptr },
  { "twosuperior",                       600, nullptr },
  { "aacute",                            600, nullptr },
  { "s",                                 600, nullptr },
  { "OE",                                600, nullptr },
  { "t",                                 600, nullptr },
  { "divide",                            600, nullptr },
  { "u",                                 600, nullptr },
  { "Ccaron",                            600, nullptr },
  { "v",                                 600, nullptr },
  { "w",                                 600, nullptr },
  { "x",                                 600, nullptr },
  { "y",                                 600, nullptr },
  { "z",                                 600, nullptr },
  { "Gbreve",                            600, nullptr },
  { "commaaccent",                       600, nullptr },
  { "hungarumlaut",                      600, nullptr },
  { "Idotaccent",                        600, nullptr },
  { "Nacute",                            600, nullptr },
  { "quotedbl",                          600, nullptr },
  { "gcommaaccent",                      600, nullptr },
  { "mu",                                600, nullptr },
  { "greaterequal",                      600, nullptr },
  { "Scaron",                            600, nullptr },
  { "Lslash",                            600, nullptr },
  { "semicolon",                         600, nullptr },
  { "oslash",                            600, nullptr },
  { "lessequal",                         600, nullptr },
  { "lozenge",                           600, nullptr },
  { "parenright",                        600, nullptr },
  { "ccaron",                            600, nullptr },
  { "Ecircumflex",                       600, nullptr },
  { "gbreve",                            600, nullptr },
  { "trademark",                         600, nullptr },
  { "daggerdbl",                         600, nullptr },
  { "nacute",                            600, nullptr },
  { "macron",                            600, nullptr },
  { "Otilde",                            600, nullptr },
  { "Emacron",                           600, nullptr },
  { "ellipsis",                          600, nullptr },
  { "scaron",                            600, nullptr },
  { "AE",                                600, nullptr },
  { "Ucircumflex",                       600, nullptr },
  { "lslash",                            600, nullptr },
  { "quotedblleft",                      600, nullptr },
  { "guilsinglright",                    600, nullptr },
  { "hyphen",                            600, nullptr },
  { "quotesingle",                       600, nullptr },
  { "eight",                             600, nullptr },
  { "exclamdown",                        600, nullptr },
  { "endash",                            600, nullptr },
  { "oe",                                600, nullptr },
  { "Abreve",                            600, nullptr },
  { "Umacron",                           600, nullptr },
  { "ecircumflex",                       600, nullptr },
  { "Adieresis",                         600, nullptr },
  { "copyright",                         600, nullptr },
  { "Egrave",                            600, nullptr },
  { "slash",                             600, nullptr },
  { "Edieresis",                         600, nullptr },
  { "otilde",                            600, nullptr },
  { "Idieresis",                         600, nullptr },
  { "parenleft",                         600, nullptr },
  { "one",                               600, nullptr },
  { "emacron",                           600, nullptr },
  { "Odieresis",                         600, nullptr },
  { "ucircumflex",                       600, nullptr },
  { "bracketleft",                       600, nullptr },
  { "Ugrave",                            600, nullptr },
  { "quoteright",                        600, nullptr },
  { "Udieresis",                         600, nullptr },
  { "perthousand",                       600, nullptr },
  { "Ydieresis",                         600, nullptr },
  { "umacron",                           600, nullptr },
  { "abreve",                            600, nullptr },
  { "Eacute",                            600, nullptr },
  { "adieresis",                         600, nullptr },
  { "egrave",                            600, nullptr },
  { "edieresis",                         600, nullptr },
  { "idieresis",                         600, nullptr },
  { "Eth",                               600, nullptr },
  { "ae",                                600, nullptr },
  { "asterisk",                          600, nullptr },
  { "odieresis",                         600, nullptr },
  { "Uacute",                            600, nullptr },
  { "ugrave",                            600, nullptr },
  { "nine",                              600, nullptr },
  { "five",                              600, nullptr },
  { "udieresis",                         600, nullptr },
  { "Zcaron",                            600, nullptr },
  { "Scommaaccent",                      600, nullptr },
  { "threequarters",                     600, nullptr },
  { "guillemotright",                    600, nullptr },
  { "Ccedilla",                          600, nullptr },
  { "ydieresis",                         600, nullptr },
  { "tilde",                             600, nullptr },
  { "at",                                600, nullptr },
  { "eacute",                            600, nullptr },
  { "underscore",                        600, nullptr },
  { "Euro",                              600, nullptr },
  { "Dcroat",                            600, nullptr },
  { "multiply",                          600, nullptr },
  { "zero",                              600, nullptr },
  { "eth",                               600, nullptr },
  { "Scedilla",                          600, nullptr },
  { "Ograve",                            600, nullptr },
  { "Racute",                            600, nullptr },
  { "partialdiff",                       600, nullptr },
  { "uacute",                            600, nullptr },
  { "braceleft",                         600, nullptr },
  { "Thorn",                             600, nullptr },
  { "zcaron",                            600, nullptr },
  { "scommaaccent",                      600, nullptr },
  { "ccedilla",                          600, nullptr },
  { "Dcaron",                            600, nullptr },
  { "dcroat",                            600, nullptr },
  { "Ocircumflex",                       600, nullptr },
  { "Oacute",                            600, nullptr },
  { "scedilla",                          600, nullptr },
  { "ogonek",                            600, nullptr },
  { "ograve",                            600, nullptr },
  { "racute",                            600, nullptr },
  { "Tcaron",                            600, nullptr },
  { "Eogonek",                           600, nullptr },
  { "thorn",                             600, nullptr },
  { "degree",                            600, nullptr },
  { "registered",                        600, nullptr },
  { "radical",                           600, nullptr },
  { "Aring",                             600, nullptr },
  { "percent",                           600, nullptr },
  { "six",                               600, nullptr },
  { "paragraph",                         600, nullptr },
  { "dcaron",                            600, nullptr },
  { "Uogonek",                           600, nullptr },
  { "two",                               600, nullptr },
  { "summation",                         600, nullptr },
  { "Igrave",                            600, nullptr },
  { "Lacute",                            600, nullptr },
  { "ocircumflex",                       600, nullptr },
  { "oacute",                            600, nullptr },
  { "Uring",                             600, nullptr },
  { "Lcommaaccent",                      600, nullptr },
  { "tcaron",                            600, nullptr },
  { "eogonek",                           600, nullptr },
  { "Delta",                             600, nullptr },
  { "Ohungarumlaut",                     600, nullptr },
  { "asciicircum",                       600, nullptr },
  { "aring",                             600, nullptr },
  { "grave",                             600, nullptr },
  { "uogonek",                           600, nullptr },
  { "bracketright",                      600, nullptr },
  { "Iacute",                            600, nullptr },
  { "ampersand",                         600, nullptr },
  { "igrave",                            600, nullptr },
  { "lacute",                            600, nullptr },
  { "Ncaron",                            600, nullptr },
  { "plus",                              600, nullptr },
  { "uring",                             600, nullptr },
  { "quotesinglbase",                    600, nullptr },
  { "lcommaaccent",                      600, nullptr },
  { "Yacute",                            600, nullptr },
  { "ohungarumlaut",                     600, nullptr },
  { "threesuperior",                     600, nullptr },
  { "acute",                             600, nullptr },
  { "section",                           600, nullptr },
  { "dieresis",                          600, nullptr },
  { "iacute",                            600, nullptr },
  { "quotedblbase",                      600, nullptr },
  { "ncaron",                            600, nullptr },
  { "florin",                            600, nullptr },
  { "yacute",                            600, nullptr },
  { "Rcommaaccent",                      600, nullptr },
  { "fi",                                600, nullptr },
  { "fl",                                600, nullptr },
  { "Acircumflex",                       600, nullptr },
  { "Cacute",                            600, nullptr },
  { "Icircumflex",                       600, nullptr },
  { "guillemotleft",                     600, nullptr },
  { "germandbls",                        600, nullptr },
  { "Amacron",                           600, nullptr },
  { "seven",                             600, nullptr },
  { "Sacute",                            600, nullptr },
  { "ordmasculine",                      600, nullptr },
  { "dotlessi",                          600, nullptr },
  { "sterling",                          600, nullptr },
  { "notequal",                          600, nullptr },
  { "Imacron",                           600, nullptr },
  { "rcommaaccent",                      600, nullptr },
  { "Zdotaccent",                        600, nullptr },
  { "acircumflex",                       600, nullptr },
  { "cacute",                            600, nullptr },
  { "Ecaron",                            600, nullptr },
  { "icircumflex",                       600, nullptr },
  { "braceright",                        600, nullptr },
  { "quotedblright",                     600, nullptr },
  { "amacron",                           600, nullptr },
  { "sacute",                            600, nullptr },
  { "imacron",                           600, nullptr },
  { "cent",                              600, nullptr },
  { "currency",                          600, nullptr },
  { "logicalnot",                        600, nullptr },
  { "zdotaccent",                        600, nullptr },
  { "Atilde",                            600, nullptr },
  { "breve",                             600, nullptr },
  { "bar",                               600, nullptr },
  { "fraction",                          600, nullptr },
  { "less",                              600, nullptr },
  { "ecaron",                            600, nullptr },
  { "guilsinglleft",                     600, nullptr },
  { "exclam",                            600, nullptr },
  { "period",                            600, nullptr },
  { "Rcaron",                            600, nullptr },
  { "Kcommaaccent",                      600, nullptr },
  { "greater",                           600, nullptr },
  { "atilde",                            600, nullptr },
  { "brokenbar",                         600, nullptr },
  { "quoteleft",                         600, nullptr },
  { "Edotaccent",                        600, nullptr },
  { "onesuperior",                       600, nullptr }
};

static BuiltinFontWidth helveticaWidthsTab[] = {
  { "Ntilde",                            722, nullptr },
  { "rcaron",                            333, nullptr },
  { "kcommaaccent",                      500, nullptr },
  { "Ncommaaccent",                      722, nullptr },
  { "Zacute",                            611, nullptr },
  { "comma",                             278, nullptr },
  { "cedilla",                           333, nullptr },
  { "plusminus",                         584, nullptr },
  { "circumflex",                        333, nullptr },
  { "dotaccent",                         333, nullptr },
  { "edotaccent",                        556, nullptr },
  { "asciitilde",                        584, nullptr },
  { "colon",                             278, nullptr },
  { "onehalf",                           834, nullptr },
  { "dollar",                            556, nullptr },
  { "Lcaron",                            556, nullptr },
  { "ntilde",                            556, nullptr },
  { "Aogonek",                           667, nullptr },
  { "ncommaaccent",                      556, nullptr },
  { "minus",                             584, nullptr },
  { "Iogonek",                           278, nullptr },
  { "zacute",                            500, nullptr },
  { "yen",                               556, nullptr },
  { "space",                             278, nullptr },
  { "Omacron",                           778, nullptr },
  { "questiondown",                      611, nullptr },
  { "emdash",                           1000, nullptr },
  { "Agrave",                            667, nullptr },
  { "three",                             556, nullptr },
  { "numbersign",                        556, nullptr },
  { "lcaron",                            299, nullptr },
  { "A",                                 667, nullptr },
  { "B",                                 667, nullptr },
  { "C",                                 722, nullptr },
  { "aogonek",                           556, nullptr },
  { "D",                                 722, nullptr },
  { "E",                                 667, nullptr },
  { "onequarter",                        834, nullptr },
  { "F",                                 611, nullptr },
  { "G",                                 778, nullptr },
  { "H",                                 722, nullptr },
  { "I",                                 278, nullptr },
  { "J",                                 500, nullptr },
  { "K",                                 667, nullptr },
  { "iogonek",                           222, nullptr },
  { "backslash",                         278, nullptr },
  { "L",                                 556, nullptr },
  { "periodcentered",                    278, nullptr },
  { "M",                                 833, nullptr },
  { "N",                                 722, nullptr },
  { "omacron",                           556, nullptr },
  { "Tcommaaccent",                      611, nullptr },
  { "O",                                 778, nullptr },
  { "P",                                 667, nullptr },
  { "Q",                                 778, nullptr },
  { "Uhungarumlaut",                     722, nullptr },
  { "R",                                 722, nullptr },
  { "Aacute",                            667, nullptr },
  { "caron",                             333, nullptr },
  { "S",                                 667, nullptr },
  { "T",                                 611, nullptr },
  { "U",                                 722, nullptr },
  { "agrave",                            556, nullptr },
  { "V",                                 667, nullptr },
  { "W",                                 944, nullptr },
  { "X",                                 667, nullptr },
  { "question",                          556, nullptr },
  { "equal",                             584, nullptr },
  { "Y",                                 667, nullptr },
  { "Z",                                 611, nullptr },
  { "four",                              556, nullptr },
  { "a",                                 556, nullptr },
  { "Gcommaaccent",                      778, nullptr },
  { "b",                                 556, nullptr },
  { "c",                                 500, nullptr },
  { "d",                                 556, nullptr },
  { "e",                                 556, nullptr },
  { "f",                                 278, nullptr },
  { "g",                                 556, nullptr },
  { "bullet",                            350, nullptr },
  { "h",                                 556, nullptr },
  { "i",                                 222, nullptr },
  { "Oslash",                            778, nullptr },
  { "dagger",                            556, nullptr },
  { "j",                                 222, nullptr },
  { "k",                                 500, nullptr },
  { "l",                                 222, nullptr },
  { "m",                                 833, nullptr },
  { "n",                                 556, nullptr },
  { "tcommaaccent",                      278, nullptr },
  { "o",                                 556, nullptr },
  { "ordfeminine",                       370, nullptr },
  { "ring",                              333, nullptr },
  { "p",                                 556, nullptr },
  { "q",                                 556, nullptr },
  { "uhungarumlaut",                     556, nullptr },
  { "r",                                 333, nullptr },
  { "twosuperior",                       333, nullptr },
  { "aacute",                            556, nullptr },
  { "s",                                 500, nullptr },
  { "OE",                               1000, nullptr },
  { "t",                                 278, nullptr },
  { "divide",                            584, nullptr },
  { "u",                                 556, nullptr },
  { "Ccaron",                            722, nullptr },
  { "v",                                 500, nullptr },
  { "w",                                 722, nullptr },
  { "x",                                 500, nullptr },
  { "y",                                 500, nullptr },
  { "z",                                 500, nullptr },
  { "Gbreve",                            778, nullptr },
  { "commaaccent",                       250, nullptr },
  { "hungarumlaut",                      333, nullptr },
  { "Idotaccent",                        278, nullptr },
  { "Nacute",                            722, nullptr },
  { "quotedbl",                          355, nullptr },
  { "gcommaaccent",                      556, nullptr },
  { "mu",                                556, nullptr },
  { "greaterequal",                      549, nullptr },
  { "Scaron",                            667, nullptr },
  { "Lslash",                            556, nullptr },
  { "semicolon",                         278, nullptr },
  { "oslash",                            611, nullptr },
  { "lessequal",                         549, nullptr },
  { "lozenge",                           471, nullptr },
  { "parenright",                        333, nullptr },
  { "ccaron",                            500, nullptr },
  { "Ecircumflex",                       667, nullptr },
  { "gbreve",                            556, nullptr },
  { "trademark",                        1000, nullptr },
  { "daggerdbl",                         556, nullptr },
  { "nacute",                            556, nullptr },
  { "macron",                            333, nullptr },
  { "Otilde",                            778, nullptr },
  { "Emacron",                           667, nullptr },
  { "ellipsis",                         1000, nullptr },
  { "scaron",                            500, nullptr },
  { "AE",                               1000, nullptr },
  { "Ucircumflex",                       722, nullptr },
  { "lslash",                            222, nullptr },
  { "quotedblleft",                      333, nullptr },
  { "guilsinglright",                    333, nullptr },
  { "hyphen",                            333, nullptr },
  { "quotesingle",                       191, nullptr },
  { "eight",                             556, nullptr },
  { "exclamdown",                        333, nullptr },
  { "endash",                            556, nullptr },
  { "oe",                                944, nullptr },
  { "Abreve",                            667, nullptr },
  { "Umacron",                           722, nullptr },
  { "ecircumflex",                       556, nullptr },
  { "Adieresis",                         667, nullptr },
  { "copyright",                         737, nullptr },
  { "Egrave",                            667, nullptr },
  { "slash",                             278, nullptr },
  { "Edieresis",                         667, nullptr },
  { "otilde",                            556, nullptr },
  { "Idieresis",                         278, nullptr },
  { "parenleft",                         333, nullptr },
  { "one",                               556, nullptr },
  { "emacron",                           556, nullptr },
  { "Odieresis",                         778, nullptr },
  { "ucircumflex",                       556, nullptr },
  { "bracketleft",                       278, nullptr },
  { "Ugrave",                            722, nullptr },
  { "quoteright",                        222, nullptr },
  { "Udieresis",                         722, nullptr },
  { "perthousand",                      1000, nullptr },
  { "Ydieresis",                         667, nullptr },
  { "umacron",                           556, nullptr },
  { "abreve",                            556, nullptr },
  { "Eacute",                            667, nullptr },
  { "adieresis",                         556, nullptr },
  { "egrave",                            556, nullptr },
  { "edieresis",                         556, nullptr },
  { "idieresis",                         278, nullptr },
  { "Eth",                               722, nullptr },
  { "ae",                                889, nullptr },
  { "asterisk",                          389, nullptr },
  { "odieresis",                         556, nullptr },
  { "Uacute",                            722, nullptr },
  { "ugrave",                            556, nullptr },
  { "nine",                              556, nullptr },
  { "five",                              556, nullptr },
  { "udieresis",                         556, nullptr },
  { "Zcaron",                            611, nullptr },
  { "Scommaaccent",                      667, nullptr },
  { "threequarters",                     834, nullptr },
  { "guillemotright",                    556, nullptr },
  { "Ccedilla",                          722, nullptr },
  { "ydieresis",                         500, nullptr },
  { "tilde",                             333, nullptr },
  { "at",                               1015, nullptr },
  { "eacute",                            556, nullptr },
  { "underscore",                        556, nullptr },
  { "Euro",                              556, nullptr },
  { "Dcroat",                            722, nullptr },
  { "multiply",                          584, nullptr },
  { "zero",                              556, nullptr },
  { "eth",                               556, nullptr },
  { "Scedilla",                          667, nullptr },
  { "Ograve",                            778, nullptr },
  { "Racute",                            722, nullptr },
  { "partialdiff",                       476, nullptr },
  { "uacute",                            556, nullptr },
  { "braceleft",                         334, nullptr },
  { "Thorn",                             667, nullptr },
  { "zcaron",                            500, nullptr },
  { "scommaaccent",                      500, nullptr },
  { "ccedilla",                          500, nullptr },
  { "Dcaron",                            722, nullptr },
  { "dcroat",                            556, nullptr },
  { "Ocircumflex",                       778, nullptr },
  { "Oacute",                            778, nullptr },
  { "scedilla",                          500, nullptr },
  { "ogonek",                            333, nullptr },
  { "ograve",                            556, nullptr },
  { "racute",                            333, nullptr },
  { "Tcaron",                            611, nullptr },
  { "Eogonek",                           667, nullptr },
  { "thorn",                             556, nullptr },
  { "degree",                            400, nullptr },
  { "registered",                        737, nullptr },
  { "radical",                           453, nullptr },
  { "Aring",                             667, nullptr },
  { "percent",                           889, nullptr },
  { "six",                               556, nullptr },
  { "paragraph",                         537, nullptr },
  { "dcaron",                            643, nullptr },
  { "Uogonek",                           722, nullptr },
  { "two",                               556, nullptr },
  { "summation",                         600, nullptr },
  { "Igrave",                            278, nullptr },
  { "Lacute",                            556, nullptr },
  { "ocircumflex",                       556, nullptr },
  { "oacute",                            556, nullptr },
  { "Uring",                             722, nullptr },
  { "Lcommaaccent",                      556, nullptr },
  { "tcaron",                            317, nullptr },
  { "eogonek",                           556, nullptr },
  { "Delta",                             612, nullptr },
  { "Ohungarumlaut",                     778, nullptr },
  { "asciicircum",                       469, nullptr },
  { "aring",                             556, nullptr },
  { "grave",                             333, nullptr },
  { "uogonek",                           556, nullptr },
  { "bracketright",                      278, nullptr },
  { "Iacute",                            278, nullptr },
  { "ampersand",                         667, nullptr },
  { "igrave",                            278, nullptr },
  { "lacute",                            222, nullptr },
  { "Ncaron",                            722, nullptr },
  { "plus",                              584, nullptr },
  { "uring",                             556, nullptr },
  { "quotesinglbase",                    222, nullptr },
  { "lcommaaccent",                      222, nullptr },
  { "Yacute",                            667, nullptr },
  { "ohungarumlaut",                     556, nullptr },
  { "threesuperior",                     333, nullptr },
  { "acute",                             333, nullptr },
  { "section",                           556, nullptr },
  { "dieresis",                          333, nullptr },
  { "iacute",                            278, nullptr },
  { "quotedblbase",                      333, nullptr },
  { "ncaron",                            556, nullptr },
  { "florin",                            556, nullptr },
  { "yacute",                            500, nullptr },
  { "Rcommaaccent",                      722, nullptr },
  { "fi",                                500, nullptr },
  { "fl",                                500, nullptr },
  { "Acircumflex",                       667, nullptr },
  { "Cacute",                            722, nullptr },
  { "Icircumflex",                       278, nullptr },
  { "guillemotleft",                     556, nullptr },
  { "germandbls",                        611, nullptr },
  { "Amacron",                           667, nullptr },
  { "seven",                             556, nullptr },
  { "Sacute",                            667, nullptr },
  { "ordmasculine",                      365, nullptr },
  { "dotlessi",                          278, nullptr },
  { "sterling",                          556, nullptr },
  { "notequal",                          549, nullptr },
  { "Imacron",                           278, nullptr },
  { "rcommaaccent",                      333, nullptr },
  { "Zdotaccent",                        611, nullptr },
  { "acircumflex",                       556, nullptr },
  { "cacute",                            500, nullptr },
  { "Ecaron",                            667, nullptr },
  { "icircumflex",                       278, nullptr },
  { "braceright",                        334, nullptr },
  { "quotedblright",                     333, nullptr },
  { "amacron",                           556, nullptr },
  { "sacute",                            500, nullptr },
  { "imacron",                           278, nullptr },
  { "cent",                              556, nullptr },
  { "currency",                          556, nullptr },
  { "logicalnot",                        584, nullptr },
  { "zdotaccent",                        500, nullptr },
  { "Atilde",                            667, nullptr },
  { "breve",                             333, nullptr },
  { "bar",                               260, nullptr },
  { "fraction",                          167, nullptr },
  { "less",                              584, nullptr },
  { "ecaron",                            556, nullptr },
  { "guilsinglleft",                     333, nullptr },
  { "exclam",                            278, nullptr },
  { "period",                            278, nullptr },
  { "Rcaron",                            722, nullptr },
  { "Kcommaaccent",                      667, nullptr },
  { "greater",                           584, nullptr },
  { "atilde",                            556, nullptr },
  { "brokenbar",                         260, nullptr },
  { "quoteleft",                         222, nullptr },
  { "Edotaccent",                        667, nullptr },
  { "onesuperior",                       333, nullptr }
};

static BuiltinFontWidth helveticaBoldWidthsTab[] = {
  { "Ntilde",                            722, nullptr },
  { "rcaron",                            389, nullptr },
  { "kcommaaccent",                      556, nullptr },
  { "Ncommaaccent",                      722, nullptr },
  { "Zacute",                            611, nullptr },
  { "comma",                             278, nullptr },
  { "cedilla",                           333, nullptr },
  { "plusminus",                         584, nullptr },
  { "circumflex",                        333, nullptr },
  { "dotaccent",                         333, nullptr },
  { "edotaccent",                        556, nullptr },
  { "asciitilde",                        584, nullptr },
  { "colon",                             333, nullptr },
  { "onehalf",                           834, nullptr },
  { "dollar",                            556, nullptr },
  { "Lcaron",                            611, nullptr },
  { "ntilde",                            611, nullptr },
  { "Aogonek",                           722, nullptr },
  { "ncommaaccent",                      611, nullptr },
  { "minus",                             584, nullptr },
  { "Iogonek",                           278, nullptr },
  { "zacute",                            500, nullptr },
  { "yen",                               556, nullptr },
  { "space",                             278, nullptr },
  { "Omacron",                           778, nullptr },
  { "questiondown",                      611, nullptr },
  { "emdash",                           1000, nullptr },
  { "Agrave",                            722, nullptr },
  { "three",                             556, nullptr },
  { "numbersign",                        556, nullptr },
  { "lcaron",                            400, nullptr },
  { "A",                                 722, nullptr },
  { "B",                                 722, nullptr },
  { "C",                                 722, nullptr },
  { "aogonek",                           556, nullptr },
  { "D",                                 722, nullptr },
  { "E",                                 667, nullptr },
  { "onequarter",                        834, nullptr },
  { "F",                                 611, nullptr },
  { "G",                                 778, nullptr },
  { "H",                                 722, nullptr },
  { "I",                                 278, nullptr },
  { "J",                                 556, nullptr },
  { "K",                                 722, nullptr },
  { "iogonek",                           278, nullptr },
  { "backslash",                         278, nullptr },
  { "L",                                 611, nullptr },
  { "periodcentered",                    278, nullptr },
  { "M",                                 833, nullptr },
  { "N",                                 722, nullptr },
  { "omacron",                           611, nullptr },
  { "Tcommaaccent",                      611, nullptr },
  { "O",                                 778, nullptr },
  { "P",                                 667, nullptr },
  { "Q",                                 778, nullptr },
  { "Uhungarumlaut",                     722, nullptr },
  { "R",                                 722, nullptr },
  { "Aacute",                            722, nullptr },
  { "caron",                             333, nullptr },
  { "S",                                 667, nullptr },
  { "T",                                 611, nullptr },
  { "U",                                 722, nullptr },
  { "agrave",                            556, nullptr },
  { "V",                                 667, nullptr },
  { "W",                                 944, nullptr },
  { "X",                                 667, nullptr },
  { "question",                          611, nullptr },
  { "equal",                             584, nullptr },
  { "Y",                                 667, nullptr },
  { "Z",                                 611, nullptr },
  { "four",                              556, nullptr },
  { "a",                                 556, nullptr },
  { "Gcommaaccent",                      778, nullptr },
  { "b",                                 611, nullptr },
  { "c",                                 556, nullptr },
  { "d",                                 611, nullptr },
  { "e",                                 556, nullptr },
  { "f",                                 333, nullptr },
  { "g",                                 611, nullptr },
  { "bullet",                            350, nullptr },
  { "h",                                 611, nullptr },
  { "i",                                 278, nullptr },
  { "Oslash",                            778, nullptr },
  { "dagger",                            556, nullptr },
  { "j",                                 278, nullptr },
  { "k",                                 556, nullptr },
  { "l",                                 278, nullptr },
  { "m",                                 889, nullptr },
  { "n",                                 611, nullptr },
  { "tcommaaccent",                      333, nullptr },
  { "o",                                 611, nullptr },
  { "ordfeminine",                       370, nullptr },
  { "ring",                              333, nullptr },
  { "p",                                 611, nullptr },
  { "q",                                 611, nullptr },
  { "uhungarumlaut",                     611, nullptr },
  { "r",                                 389, nullptr },
  { "twosuperior",                       333, nullptr },
  { "aacute",                            556, nullptr },
  { "s",                                 556, nullptr },
  { "OE",                               1000, nullptr },
  { "t",                                 333, nullptr },
  { "divide",                            584, nullptr },
  { "u",                                 611, nullptr },
  { "Ccaron",                            722, nullptr },
  { "v",                                 556, nullptr },
  { "w",                                 778, nullptr },
  { "x",                                 556, nullptr },
  { "y",                                 556, nullptr },
  { "z",                                 500, nullptr },
  { "Gbreve",                            778, nullptr },
  { "commaaccent",                       250, nullptr },
  { "hungarumlaut",                      333, nullptr },
  { "Idotaccent",                        278, nullptr },
  { "Nacute",                            722, nullptr },
  { "quotedbl",                          474, nullptr },
  { "gcommaaccent",                      611, nullptr },
  { "mu",                                611, nullptr },
  { "greaterequal",                      549, nullptr },
  { "Scaron",                            667, nullptr },
  { "Lslash",                            611, nullptr },
  { "semicolon",                         333, nullptr },
  { "oslash",                            611, nullptr },
  { "lessequal",                         549, nullptr },
  { "lozenge",                           494, nullptr },
  { "parenright",                        333, nullptr },
  { "ccaron",                            556, nullptr },
  { "Ecircumflex",                       667, nullptr },
  { "gbreve",                            611, nullptr },
  { "trademark",                        1000, nullptr },
  { "daggerdbl",                         556, nullptr },
  { "nacute",                            611, nullptr },
  { "macron",                            333, nullptr },
  { "Otilde",                            778, nullptr },
  { "Emacron",                           667, nullptr },
  { "ellipsis",                         1000, nullptr },
  { "scaron",                            556, nullptr },
  { "AE",                               1000, nullptr },
  { "Ucircumflex",                       722, nullptr },
  { "lslash",                            278, nullptr },
  { "quotedblleft",                      500, nullptr },
  { "guilsinglright",                    333, nullptr },
  { "hyphen",                            333, nullptr },
  { "quotesingle",                       238, nullptr },
  { "eight",                             556, nullptr },
  { "exclamdown",                        333, nullptr },
  { "endash",                            556, nullptr },
  { "oe",                                944, nullptr },
  { "Abreve",                            722, nullptr },
  { "Umacron",                           722, nullptr },
  { "ecircumflex",                       556, nullptr },
  { "Adieresis",                         722, nullptr },
  { "copyright",                         737, nullptr },
  { "Egrave",                            667, nullptr },
  { "slash",                             278, nullptr },
  { "Edieresis",                         667, nullptr },
  { "otilde",                            611, nullptr },
  { "Idieresis",                         278, nullptr },
  { "parenleft",                         333, nullptr },
  { "one",                               556, nullptr },
  { "emacron",                           556, nullptr },
  { "Odieresis",                         778, nullptr },
  { "ucircumflex",                       611, nullptr },
  { "bracketleft",                       333, nullptr },
  { "Ugrave",                            722, nullptr },
  { "quoteright",                        278, nullptr },
  { "Udieresis",                         722, nullptr },
  { "perthousand",                      1000, nullptr },
  { "Ydieresis",                         667, nullptr },
  { "umacron",                           611, nullptr },
  { "abreve",                            556, nullptr },
  { "Eacute",                            667, nullptr },
  { "adieresis",                         556, nullptr },
  { "egrave",                            556, nullptr },
  { "edieresis",                         556, nullptr },
  { "idieresis",                         278, nullptr },
  { "Eth",                               722, nullptr },
  { "ae",                                889, nullptr },
  { "asterisk",                          389, nullptr },
  { "odieresis",                         611, nullptr },
  { "Uacute",                            722, nullptr },
  { "ugrave",                            611, nullptr },
  { "nine",                              556, nullptr },
  { "five",                              556, nullptr },
  { "udieresis",                         611, nullptr },
  { "Zcaron",                            611, nullptr },
  { "Scommaaccent",                      667, nullptr },
  { "threequarters",                     834, nullptr },
  { "guillemotright",                    556, nullptr },
  { "Ccedilla",                          722, nullptr },
  { "ydieresis",                         556, nullptr },
  { "tilde",                             333, nullptr },
  { "dbldaggerumlaut",                   556, nullptr },
  { "at",                                975, nullptr },
  { "eacute",                            556, nullptr },
  { "underscore",                        556, nullptr },
  { "Euro",                              556, nullptr },
  { "Dcroat",                            722, nullptr },
  { "multiply",                          584, nullptr },
  { "zero",                              556, nullptr },
  { "eth",                               611, nullptr },
  { "Scedilla",                          667, nullptr },
  { "Ograve",                            778, nullptr },
  { "Racute",                            722, nullptr },
  { "partialdiff",                       494, nullptr },
  { "uacute",                            611, nullptr },
  { "braceleft",                         389, nullptr },
  { "Thorn",                             667, nullptr },
  { "zcaron",                            500, nullptr },
  { "scommaaccent",                      556, nullptr },
  { "ccedilla",                          556, nullptr },
  { "Dcaron",                            722, nullptr },
  { "dcroat",                            611, nullptr },
  { "Ocircumflex",                       778, nullptr },
  { "Oacute",                            778, nullptr },
  { "scedilla",                          556, nullptr },
  { "ogonek",                            333, nullptr },
  { "ograve",                            611, nullptr },
  { "racute",                            389, nullptr },
  { "Tcaron",                            611, nullptr },
  { "Eogonek",                           667, nullptr },
  { "thorn",                             611, nullptr },
  { "degree",                            400, nullptr },
  { "registered",                        737, nullptr },
  { "radical",                           549, nullptr },
  { "Aring",                             722, nullptr },
  { "percent",                           889, nullptr },
  { "six",                               556, nullptr },
  { "paragraph",                         556, nullptr },
  { "dcaron",                            743, nullptr },
  { "Uogonek",                           722, nullptr },
  { "two",                               556, nullptr },
  { "summation",                         600, nullptr },
  { "Igrave",                            278, nullptr },
  { "Lacute",                            611, nullptr },
  { "ocircumflex",                       611, nullptr },
  { "oacute",                            611, nullptr },
  { "Uring",                             722, nullptr },
  { "Lcommaaccent",                      611, nullptr },
  { "tcaron",                            389, nullptr },
  { "eogonek",                           556, nullptr },
  { "Delta",                             612, nullptr },
  { "Ohungarumlaut",                     778, nullptr },
  { "asciicircum",                       584, nullptr },
  { "aring",                             556, nullptr },
  { "grave",                             333, nullptr },
  { "uogonek",                           611, nullptr },
  { "bracketright",                      333, nullptr },
  { "Iacute",                            278, nullptr },
  { "ampersand",                         722, nullptr },
  { "igrave",                            278, nullptr },
  { "lacute",                            278, nullptr },
  { "Ncaron",                            722, nullptr },
  { "plus",                              584, nullptr },
  { "uring",                             611, nullptr },
  { "quotesinglbase",                    278, nullptr },
  { "lcommaaccent",                      278, nullptr },
  { "Yacute",                            667, nullptr },
  { "ohungarumlaut",                     611, nullptr },
  { "threesuperior",                     333, nullptr },
  { "acute",                             333, nullptr },
  { "section",                           556, nullptr },
  { "dieresis",                          333, nullptr },
  { "iacute",                            278, nullptr },
  { "quotedblbase",                      500, nullptr },
  { "ncaron",                            611, nullptr },
  { "florin",                            556, nullptr },
  { "yacute",                            556, nullptr },
  { "Rcommaaccent",                      722, nullptr },
  { "fi",                                611, nullptr },
  { "fl",                                611, nullptr },
  { "Acircumflex",                       722, nullptr },
  { "Cacute",                            722, nullptr },
  { "Icircumflex",                       278, nullptr },
  { "guillemotleft",                     556, nullptr },
  { "germandbls",                        611, nullptr },
  { "Amacron",                           722, nullptr },
  { "seven",                             556, nullptr },
  { "Sacute",                            667, nullptr },
  { "ordmasculine",                      365, nullptr },
  { "dotlessi",                          278, nullptr },
  { "sterling",                          556, nullptr },
  { "notequal",                          549, nullptr },
  { "Imacron",                           278, nullptr },
  { "rcommaaccent",                      389, nullptr },
  { "Zdotaccent",                        611, nullptr },
  { "acircumflex",                       556, nullptr },
  { "cacute",                            556, nullptr },
  { "Ecaron",                            667, nullptr },
  { "icircumflex",                       278, nullptr },
  { "braceright",                        389, nullptr },
  { "quotedblright",                     500, nullptr },
  { "amacron",                           556, nullptr },
  { "sacute",                            556, nullptr },
  { "imacron",                           278, nullptr },
  { "cent",                              556, nullptr },
  { "currency",                          556, nullptr },
  { "logicalnot",                        584, nullptr },
  { "zdotaccent",                        500, nullptr },
  { "Atilde",                            722, nullptr },
  { "breve",                             333, nullptr },
  { "bar",                               280, nullptr },
  { "fraction",                          167, nullptr },
  { "less",                              584, nullptr },
  { "ecaron",                            556, nullptr },
  { "guilsinglleft",                     333, nullptr },
  { "exclam",                            333, nullptr },
  { "period",                            278, nullptr },
  { "Rcaron",                            722, nullptr },
  { "Kcommaaccent",                      722, nullptr },
  { "greater",                           584, nullptr },
  { "atilde",                            556, nullptr },
  { "brokenbar",                         280, nullptr },
  { "quoteleft",                         278, nullptr },
  { "Edotaccent",                        667, nullptr },
  { "onesuperior",                       333, nullptr }
};

static BuiltinFontWidth helveticaBoldObliqueWidthsTab[] = {
  { "Ntilde",                            722, nullptr },
  { "rcaron",                            389, nullptr },
  { "kcommaaccent",                      556, nullptr },
  { "Ncommaaccent",                      722, nullptr },
  { "Zacute",                            611, nullptr },
  { "comma",                             278, nullptr },
  { "cedilla",                           333, nullptr },
  { "plusminus",                         584, nullptr },
  { "circumflex",                        333, nullptr },
  { "dotaccent",                         333, nullptr },
  { "edotaccent",                        556, nullptr },
  { "asciitilde",                        584, nullptr },
  { "colon",                             333, nullptr },
  { "onehalf",                           834, nullptr },
  { "dollar",                            556, nullptr },
  { "Lcaron",                            611, nullptr },
  { "ntilde",                            611, nullptr },
  { "Aogonek",                           722, nullptr },
  { "ncommaaccent",                      611, nullptr },
  { "minus",                             584, nullptr },
  { "Iogonek",                           278, nullptr },
  { "zacute",                            500, nullptr },
  { "yen",                               556, nullptr },
  { "space",                             278, nullptr },
  { "Omacron",                           778, nullptr },
  { "questiondown",                      611, nullptr },
  { "emdash",                           1000, nullptr },
  { "Agrave",                            722, nullptr },
  { "three",                             556, nullptr },
  { "numbersign",                        556, nullptr },
  { "lcaron",                            400, nullptr },
  { "A",                                 722, nullptr },
  { "B",                                 722, nullptr },
  { "C",                                 722, nullptr },
  { "aogonek",                           556, nullptr },
  { "D",                                 722, nullptr },
  { "E",                                 667, nullptr },
  { "onequarter",                        834, nullptr },
  { "F",                                 611, nullptr },
  { "G",                                 778, nullptr },
  { "H",                                 722, nullptr },
  { "I",                                 278, nullptr },
  { "J",                                 556, nullptr },
  { "K",                                 722, nullptr },
  { "iogonek",                           278, nullptr },
  { "backslash",                         278, nullptr },
  { "L",                                 611, nullptr },
  { "periodcentered",                    278, nullptr },
  { "M",                                 833, nullptr },
  { "N",                                 722, nullptr },
  { "omacron",                           611, nullptr },
  { "Tcommaaccent",                      611, nullptr },
  { "O",                                 778, nullptr },
  { "P",                                 667, nullptr },
  { "Q",                                 778, nullptr },
  { "Uhungarumlaut",                     722, nullptr },
  { "R",                                 722, nullptr },
  { "Aacute",                            722, nullptr },
  { "caron",                             333, nullptr },
  { "S",                                 667, nullptr },
  { "T",                                 611, nullptr },
  { "U",                                 722, nullptr },
  { "agrave",                            556, nullptr },
  { "V",                                 667, nullptr },
  { "W",                                 944, nullptr },
  { "X",                                 667, nullptr },
  { "question",                          611, nullptr },
  { "equal",                             584, nullptr },
  { "Y",                                 667, nullptr },
  { "Z",                                 611, nullptr },
  { "four",                              556, nullptr },
  { "a",                                 556, nullptr },
  { "Gcommaaccent",                      778, nullptr },
  { "b",                                 611, nullptr },
  { "c",                                 556, nullptr },
  { "d",                                 611, nullptr },
  { "e",                                 556, nullptr },
  { "f",                                 333, nullptr },
  { "g",                                 611, nullptr },
  { "bullet",                            350, nullptr },
  { "h",                                 611, nullptr },
  { "i",                                 278, nullptr },
  { "Oslash",                            778, nullptr },
  { "dagger",                            556, nullptr },
  { "j",                                 278, nullptr },
  { "k",                                 556, nullptr },
  { "l",                                 278, nullptr },
  { "m",                                 889, nullptr },
  { "n",                                 611, nullptr },
  { "tcommaaccent",                      333, nullptr },
  { "o",                                 611, nullptr },
  { "ordfeminine",                       370, nullptr },
  { "ring",                              333, nullptr },
  { "p",                                 611, nullptr },
  { "q",                                 611, nullptr },
  { "uhungarumlaut",                     611, nullptr },
  { "r",                                 389, nullptr },
  { "twosuperior",                       333, nullptr },
  { "aacute",                            556, nullptr },
  { "s",                                 556, nullptr },
  { "OE",                               1000, nullptr },
  { "t",                                 333, nullptr },
  { "divide",                            584, nullptr },
  { "u",                                 611, nullptr },
  { "Ccaron",                            722, nullptr },
  { "v",                                 556, nullptr },
  { "w",                                 778, nullptr },
  { "x",                                 556, nullptr },
  { "y",                                 556, nullptr },
  { "z",                                 500, nullptr },
  { "Gbreve",                            778, nullptr },
  { "commaaccent",                       250, nullptr },
  { "hungarumlaut",                      333, nullptr },
  { "Idotaccent",                        278, nullptr },
  { "Nacute",                            722, nullptr },
  { "quotedbl",                          474, nullptr },
  { "gcommaaccent",                      611, nullptr },
  { "mu",                                611, nullptr },
  { "greaterequal",                      549, nullptr },
  { "Scaron",                            667, nullptr },
  { "Lslash",                            611, nullptr },
  { "semicolon",                         333, nullptr },
  { "oslash",                            611, nullptr },
  { "lessequal",                         549, nullptr },
  { "lozenge",                           494, nullptr },
  { "parenright",                        333, nullptr },
  { "ccaron",                            556, nullptr },
  { "Ecircumflex",                       667, nullptr },
  { "gbreve",                            611, nullptr },
  { "trademark",                        1000, nullptr },
  { "daggerdbl",                         556, nullptr },
  { "nacute",                            611, nullptr },
  { "macron",                            333, nullptr },
  { "Otilde",                            778, nullptr },
  { "Emacron",                           667, nullptr },
  { "ellipsis",                         1000, nullptr },
  { "scaron",                            556, nullptr },
  { "AE",                               1000, nullptr },
  { "Ucircumflex",                       722, nullptr },
  { "lslash",                            278, nullptr },
  { "quotedblleft",                      500, nullptr },
  { "guilsinglright",                    333, nullptr },
  { "hyphen",                            333, nullptr },
  { "quotesingle",                       238, nullptr },
  { "eight",                             556, nullptr },
  { "exclamdown",                        333, nullptr },
  { "endash",                            556, nullptr },
  { "oe",                                944, nullptr },
  { "Abreve",                            722, nullptr },
  { "Umacron",                           722, nullptr },
  { "ecircumflex",                       556, nullptr },
  { "Adieresis",                         722, nullptr },
  { "copyright",                         737, nullptr },
  { "Egrave",                            667, nullptr },
  { "slash",                             278, nullptr },
  { "Edieresis",                         667, nullptr },
  { "otilde",                            611, nullptr },
  { "Idieresis",                         278, nullptr },
  { "parenleft",                         333, nullptr },
  { "one",                               556, nullptr },
  { "emacron",                           556, nullptr },
  { "Odieresis",                         778, nullptr },
  { "ucircumflex",                       611, nullptr },
  { "bracketleft",                       333, nullptr },
  { "Ugrave",                            722, nullptr },
  { "quoteright",                        278, nullptr },
  { "Udieresis",                         722, nullptr },
  { "perthousand",                      1000, nullptr },
  { "Ydieresis",                         667, nullptr },
  { "umacron",                           611, nullptr },
  { "abreve",                            556, nullptr },
  { "Eacute",                            667, nullptr },
  { "adieresis",                         556, nullptr },
  { "egrave",                            556, nullptr },
  { "edieresis",                         556, nullptr },
  { "idieresis",                         278, nullptr },
  { "Eth",                               722, nullptr },
  { "ae",                                889, nullptr },
  { "asterisk",                          389, nullptr },
  { "odieresis",                         611, nullptr },
  { "Uacute",                            722, nullptr },
  { "ugrave",                            611, nullptr },
  { "nine",                              556, nullptr },
  { "five",                              556, nullptr },
  { "udieresis",                         611, nullptr },
  { "Zcaron",                            611, nullptr },
  { "Scommaaccent",                      667, nullptr },
  { "threequarters",                     834, nullptr },
  { "guillemotright",                    556, nullptr },
  { "Ccedilla",                          722, nullptr },
  { "ydieresis",                         556, nullptr },
  { "tilde",                             333, nullptr },
  { "at",                                975, nullptr },
  { "eacute",                            556, nullptr },
  { "underscore",                        556, nullptr },
  { "Euro",                              556, nullptr },
  { "Dcroat",                            722, nullptr },
  { "multiply",                          584, nullptr },
  { "zero",                              556, nullptr },
  { "eth",                               611, nullptr },
  { "Scedilla",                          667, nullptr },
  { "Ograve",                            778, nullptr },
  { "Racute",                            722, nullptr },
  { "partialdiff",                       494, nullptr },
  { "uacute",                            611, nullptr },
  { "braceleft",                         389, nullptr },
  { "Thorn",                             667, nullptr },
  { "zcaron",                            500, nullptr },
  { "scommaaccent",                      556, nullptr },
  { "ccedilla",                          556, nullptr },
  { "Dcaron",                            722, nullptr },
  { "dcroat",                            611, nullptr },
  { "Ocircumflex",                       778, nullptr },
  { "Oacute",                            778, nullptr },
  { "scedilla",                          556, nullptr },
  { "ogonek",                            333, nullptr },
  { "ograve",                            611, nullptr },
  { "racute",                            389, nullptr },
  { "Tcaron",                            611, nullptr },
  { "Eogonek",                           667, nullptr },
  { "thorn",                             611, nullptr },
  { "degree",                            400, nullptr },
  { "registered",                        737, nullptr },
  { "radical",                           549, nullptr },
  { "Aring",                             722, nullptr },
  { "percent",                           889, nullptr },
  { "six",                               556, nullptr },
  { "paragraph",                         556, nullptr },
  { "dcaron",                            743, nullptr },
  { "Uogonek",                           722, nullptr },
  { "two",                               556, nullptr },
  { "summation",                         600, nullptr },
  { "Igrave",                            278, nullptr },
  { "Lacute",                            611, nullptr },
  { "ocircumflex",                       611, nullptr },
  { "oacute",                            611, nullptr },
  { "Uring",                             722, nullptr },
  { "Lcommaaccent",                      611, nullptr },
  { "tcaron",                            389, nullptr },
  { "eogonek",                           556, nullptr },
  { "Delta",                             612, nullptr },
  { "Ohungarumlaut",                     778, nullptr },
  { "asciicircum",                       584, nullptr },
  { "aring",                             556, nullptr },
  { "grave",                             333, nullptr },
  { "uogonek",                           611, nullptr },
  { "bracketright",                      333, nullptr },
  { "Iacute",                            278, nullptr },
  { "ampersand",                         722, nullptr },
  { "igrave",                            278, nullptr },
  { "lacute",                            278, nullptr },
  { "Ncaron",                            722, nullptr },
  { "plus",                              584, nullptr },
  { "uring",                             611, nullptr },
  { "quotesinglbase",                    278, nullptr },
  { "lcommaaccent",                      278, nullptr },
  { "Yacute",                            667, nullptr },
  { "ohungarumlaut",                     611, nullptr },
  { "threesuperior",                     333, nullptr },
  { "acute",                             333, nullptr },
  { "section",                           556, nullptr },
  { "dieresis",                          333, nullptr },
  { "iacute",                            278, nullptr },
  { "quotedblbase",                      500, nullptr },
  { "ncaron",                            611, nullptr },
  { "florin",                            556, nullptr },
  { "yacute",                            556, nullptr },
  { "Rcommaaccent",                      722, nullptr },
  { "fi",                                611, nullptr },
  { "fl",                                611, nullptr },
  { "Acircumflex",                       722, nullptr },
  { "Cacute",                            722, nullptr },
  { "Icircumflex",                       278, nullptr },
  { "guillemotleft",                     556, nullptr },
  { "germandbls",                        611, nullptr },
  { "Amacron",                           722, nullptr },
  { "seven",                             556, nullptr },
  { "Sacute",                            667, nullptr },
  { "ordmasculine",                      365, nullptr },
  { "dotlessi",                          278, nullptr },
  { "sterling",                          556, nullptr },
  { "notequal",                          549, nullptr },
  { "Imacron",                           278, nullptr },
  { "rcommaaccent",                      389, nullptr },
  { "Zdotaccent",                        611, nullptr },
  { "acircumflex",                       556, nullptr },
  { "cacute",                            556, nullptr },
  { "Ecaron",                            667, nullptr },
  { "icircumflex",                       278, nullptr },
  { "braceright",                        389, nullptr },
  { "quotedblright",                     500, nullptr },
  { "amacron",                           556, nullptr },
  { "sacute",                            556, nullptr },
  { "imacron",                           278, nullptr },
  { "cent",                              556, nullptr },
  { "currency",                          556, nullptr },
  { "logicalnot",                        584, nullptr },
  { "zdotaccent",                        500, nullptr },
  { "Atilde",                            722, nullptr },
  { "breve",                             333, nullptr },
  { "bar",                               280, nullptr },
  { "fraction",                          167, nullptr },
  { "less",                              584, nullptr },
  { "ecaron",                            556, nullptr },
  { "guilsinglleft",                     333, nullptr },
  { "exclam",                            333, nullptr },
  { "period",                            278, nullptr },
  { "Rcaron",                            722, nullptr },
  { "Kcommaaccent",                      722, nullptr },
  { "greater",                           584, nullptr },
  { "atilde",                            556, nullptr },
  { "brokenbar",                         280, nullptr },
  { "quoteleft",                         278, nullptr },
  { "Edotaccent",                        667, nullptr },
  { "onesuperior",                       333, nullptr }
};

static BuiltinFontWidth helveticaObliqueWidthsTab[] = {
  { "Ntilde",                            722, nullptr },
  { "rcaron",                            333, nullptr },
  { "kcommaaccent",                      500, nullptr },
  { "Ncommaaccent",                      722, nullptr },
  { "Zacute",                            611, nullptr },
  { "comma",                             278, nullptr },
  { "cedilla",                           333, nullptr },
  { "plusminus",                         584, nullptr },
  { "circumflex",                        333, nullptr },
  { "dotaccent",                         333, nullptr },
  { "edotaccent",                        556, nullptr },
  { "asciitilde",                        584, nullptr },
  { "colon",                             278, nullptr },
  { "onehalf",                           834, nullptr },
  { "dollar",                            556, nullptr },
  { "Lcaron",                            556, nullptr },
  { "ntilde",                            556, nullptr },
  { "Aogonek",                           667, nullptr },
  { "ncommaaccent",                      556, nullptr },
  { "minus",                             584, nullptr },
  { "Iogonek",                           278, nullptr },
  { "zacute",                            500, nullptr },
  { "yen",                               556, nullptr },
  { "space",                             278, nullptr },
  { "Omacron",                           778, nullptr },
  { "questiondown",                      611, nullptr },
  { "emdash",                           1000, nullptr },
  { "Agrave",                            667, nullptr },
  { "three",                             556, nullptr },
  { "numbersign",                        556, nullptr },
  { "lcaron",                            299, nullptr },
  { "A",                                 667, nullptr },
  { "B",                                 667, nullptr },
  { "C",                                 722, nullptr },
  { "aogonek",                           556, nullptr },
  { "D",                                 722, nullptr },
  { "E",                                 667, nullptr },
  { "onequarter",                        834, nullptr },
  { "F",                                 611, nullptr },
  { "G",                                 778, nullptr },
  { "H",                                 722, nullptr },
  { "I",                                 278, nullptr },
  { "J",                                 500, nullptr },
  { "K",                                 667, nullptr },
  { "iogonek",                           222, nullptr },
  { "backslash",                         278, nullptr },
  { "L",                                 556, nullptr },
  { "periodcentered",                    278, nullptr },
  { "M",                                 833, nullptr },
  { "N",                                 722, nullptr },
  { "omacron",                           556, nullptr },
  { "Tcommaaccent",                      611, nullptr },
  { "O",                                 778, nullptr },
  { "P",                                 667, nullptr },
  { "Q",                                 778, nullptr },
  { "Uhungarumlaut",                     722, nullptr },
  { "R",                                 722, nullptr },
  { "Aacute",                            667, nullptr },
  { "caron",                             333, nullptr },
  { "S",                                 667, nullptr },
  { "T",                                 611, nullptr },
  { "U",                                 722, nullptr },
  { "agrave",                            556, nullptr },
  { "V",                                 667, nullptr },
  { "W",                                 944, nullptr },
  { "X",                                 667, nullptr },
  { "question",                          556, nullptr },
  { "equal",                             584, nullptr },
  { "Y",                                 667, nullptr },
  { "Z",                                 611, nullptr },
  { "four",                              556, nullptr },
  { "a",                                 556, nullptr },
  { "Gcommaaccent",                      778, nullptr },
  { "b",                                 556, nullptr },
  { "c",                                 500, nullptr },
  { "d",                                 556, nullptr },
  { "e",                                 556, nullptr },
  { "f",                                 278, nullptr },
  { "g",                                 556, nullptr },
  { "bullet",                            350, nullptr },
  { "h",                                 556, nullptr },
  { "i",                                 222, nullptr },
  { "Oslash",                            778, nullptr },
  { "dagger",                            556, nullptr },
  { "j",                                 222, nullptr },
  { "k",                                 500, nullptr },
  { "l",                                 222, nullptr },
  { "m",                                 833, nullptr },
  { "n",                                 556, nullptr },
  { "tcommaaccent",                      278, nullptr },
  { "o",                                 556, nullptr },
  { "ordfeminine",                       370, nullptr },
  { "ring",                              333, nullptr },
  { "p",                                 556, nullptr },
  { "q",                                 556, nullptr },
  { "uhungarumlaut",                     556, nullptr },
  { "r",                                 333, nullptr },
  { "twosuperior",                       333, nullptr },
  { "aacute",                            556, nullptr },
  { "s",                                 500, nullptr },
  { "OE",                               1000, nullptr },
  { "t",                                 278, nullptr },
  { "divide",                            584, nullptr },
  { "u",                                 556, nullptr },
  { "Ccaron",                            722, nullptr },
  { "v",                                 500, nullptr },
  { "w",                                 722, nullptr },
  { "x",                                 500, nullptr },
  { "y",                                 500, nullptr },
  { "z",                                 500, nullptr },
  { "Gbreve",                            778, nullptr },
  { "commaaccent",                       250, nullptr },
  { "hungarumlaut",                      333, nullptr },
  { "Idotaccent",                        278, nullptr },
  { "Nacute",                            722, nullptr },
  { "quotedbl",                          355, nullptr },
  { "gcommaaccent",                      556, nullptr },
  { "mu",                                556, nullptr },
  { "greaterequal",                      549, nullptr },
  { "Scaron",                            667, nullptr },
  { "Lslash",                            556, nullptr },
  { "semicolon",                         278, nullptr },
  { "oslash",                            611, nullptr },
  { "lessequal",                         549, nullptr },
  { "lozenge",                           471, nullptr },
  { "parenright",                        333, nullptr },
  { "ccaron",                            500, nullptr },
  { "Ecircumflex",                       667, nullptr },
  { "gbreve",                            556, nullptr },
  { "trademark",                        1000, nullptr },
  { "daggerdbl",                         556, nullptr },
  { "nacute",                            556, nullptr },
  { "macron",                            333, nullptr },
  { "Otilde",                            778, nullptr },
  { "Emacron",                           667, nullptr },
  { "ellipsis",                         1000, nullptr },
  { "scaron",                            500, nullptr },
  { "AE",                               1000, nullptr },
  { "Ucircumflex",                       722, nullptr },
  { "lslash",                            222, nullptr },
  { "quotedblleft",                      333, nullptr },
  { "guilsinglright",                    333, nullptr },
  { "hyphen",                            333, nullptr },
  { "quotesingle",                       191, nullptr },
  { "eight",                             556, nullptr },
  { "exclamdown",                        333, nullptr },
  { "endash",                            556, nullptr },
  { "oe",                                944, nullptr },
  { "Abreve",                            667, nullptr },
  { "Umacron",                           722, nullptr },
  { "ecircumflex",                       556, nullptr },
  { "Adieresis",                         667, nullptr },
  { "copyright",                         737, nullptr },
  { "Egrave",                            667, nullptr },
  { "slash",                             278, nullptr },
  { "Edieresis",                         667, nullptr },
  { "otilde",                            556, nullptr },
  { "Idieresis",                         278, nullptr },
  { "parenleft",                         333, nullptr },
  { "one",                               556, nullptr },
  { "emacron",                           556, nullptr },
  { "Odieresis",                         778, nullptr },
  { "ucircumflex",                       556, nullptr },
  { "bracketleft",                       278, nullptr },
  { "Ugrave",                            722, nullptr },
  { "quoteright",                        222, nullptr },
  { "Udieresis",                         722, nullptr },
  { "perthousand",                      1000, nullptr },
  { "Ydieresis",                         667, nullptr },
  { "umacron",                           556, nullptr },
  { "abreve",                            556, nullptr },
  { "Eacute",                            667, nullptr },
  { "adieresis",                         556, nullptr },
  { "egrave",                            556, nullptr },
  { "edieresis",                         556, nullptr },
  { "idieresis",                         278, nullptr },
  { "Eth",                               722, nullptr },
  { "ae",                                889, nullptr },
  { "asterisk",                          389, nullptr },
  { "odieresis",                         556, nullptr },
  { "Uacute",                            722, nullptr },
  { "ugrave",                            556, nullptr },
  { "nine",                              556, nullptr },
  { "five",                              556, nullptr },
  { "udieresis",                         556, nullptr },
  { "Zcaron",                            611, nullptr },
  { "Scommaaccent",                      667, nullptr },
  { "threequarters",                     834, nullptr },
  { "guillemotright",                    556, nullptr },
  { "Ccedilla",                          722, nullptr },
  { "ydieresis",                         500, nullptr },
  { "tilde",                             333, nullptr },
  { "at",                               1015, nullptr },
  { "eacute",                            556, nullptr },
  { "underscore",                        556, nullptr },
  { "Euro",                              556, nullptr },
  { "Dcroat",                            722, nullptr },
  { "multiply",                          584, nullptr },
  { "zero",                              556, nullptr },
  { "eth",                               556, nullptr },
  { "Scedilla",                          667, nullptr },
  { "Ograve",                            778, nullptr },
  { "Racute",                            722, nullptr },
  { "partialdiff",                       476, nullptr },
  { "uacute",                            556, nullptr },
  { "braceleft",                         334, nullptr },
  { "Thorn",                             667, nullptr },
  { "zcaron",                            500, nullptr },
  { "scommaaccent",                      500, nullptr },
  { "ccedilla",                          500, nullptr },
  { "Dcaron",                            722, nullptr },
  { "dcroat",                            556, nullptr },
  { "Ocircumflex",                       778, nullptr },
  { "Oacute",                            778, nullptr },
  { "scedilla",                          500, nullptr },
  { "ogonek",                            333, nullptr },
  { "ograve",                            556, nullptr },
  { "racute",                            333, nullptr },
  { "Tcaron",                            611, nullptr },
  { "Eogonek",                           667, nullptr },
  { "thorn",                             556, nullptr },
  { "degree",                            400, nullptr },
  { "registered",                        737, nullptr },
  { "radical",                           453, nullptr },
  { "Aring",                             667, nullptr },
  { "percent",                           889, nullptr },
  { "six",                               556, nullptr },
  { "paragraph",                         537, nullptr },
  { "dcaron",                            643, nullptr },
  { "Uogonek",                           722, nullptr },
  { "two",                               556, nullptr },
  { "summation",                         600, nullptr },
  { "Igrave",                            278, nullptr },
  { "Lacute",                            556, nullptr },
  { "ocircumflex",                       556, nullptr },
  { "oacute",                            556, nullptr },
  { "Uring",                             722, nullptr },
  { "Lcommaaccent",                      556, nullptr },
  { "tcaron",                            317, nullptr },
  { "eogonek",                           556, nullptr },
  { "Delta",                             612, nullptr },
  { "Ohungarumlaut",                     778, nullptr },
  { "asciicircum",                       469, nullptr },
  { "aring",                             556, nullptr },
  { "grave",                             333, nullptr },
  { "uogonek",                           556, nullptr },
  { "bracketright",                      278, nullptr },
  { "Iacute",                            278, nullptr },
  { "ampersand",                         667, nullptr },
  { "igrave",                            278, nullptr },
  { "lacute",                            222, nullptr },
  { "Ncaron",                            722, nullptr },
  { "plus",                              584, nullptr },
  { "uring",                             556, nullptr },
  { "quotesinglbase",                    222, nullptr },
  { "lcommaaccent",                      222, nullptr },
  { "Yacute",                            667, nullptr },
  { "ohungarumlaut",                     556, nullptr },
  { "threesuperior",                     333, nullptr },
  { "acute",                             333, nullptr },
  { "section",                           556, nullptr },
  { "dieresis",                          333, nullptr },
  { "iacute",                            278, nullptr },
  { "quotedblbase",                      333, nullptr },
  { "ncaron",                            556, nullptr },
  { "florin",                            556, nullptr },
  { "yacute",                            500, nullptr },
  { "Rcommaaccent",                      722, nullptr },
  { "fi",                                500, nullptr },
  { "fl",                                500, nullptr },
  { "Acircumflex",                       667, nullptr },
  { "Cacute",                            722, nullptr },
  { "Icircumflex",                       278, nullptr },
  { "guillemotleft",                     556, nullptr },
  { "germandbls",                        611, nullptr },
  { "Amacron",                           667, nullptr },
  { "seven",                             556, nullptr },
  { "Sacute",                            667, nullptr },
  { "ordmasculine",                      365, nullptr },
  { "dotlessi",                          278, nullptr },
  { "sterling",                          556, nullptr },
  { "notequal",                          549, nullptr },
  { "Imacron",                           278, nullptr },
  { "rcommaaccent",                      333, nullptr },
  { "Zdotaccent",                        611, nullptr },
  { "acircumflex",                       556, nullptr },
  { "cacute",                            500, nullptr },
  { "Ecaron",                            667, nullptr },
  { "icircumflex",                       278, nullptr },
  { "braceright",                        334, nullptr },
  { "quotedblright",                     333, nullptr },
  { "amacron",                           556, nullptr },
  { "sacute",                            500, nullptr },
  { "imacron",                           278, nullptr },
  { "cent",                              556, nullptr },
  { "currency",                          556, nullptr },
  { "logicalnot",                        584, nullptr },
  { "zdotaccent",                        500, nullptr },
  { "Atilde",                            667, nullptr },
  { "breve",                             333, nullptr },
  { "bar",                               260, nullptr },
  { "fraction",                          167, nullptr },
  { "less",                              584, nullptr },
  { "ecaron",                            556, nullptr },
  { "guilsinglleft",                     333, nullptr },
  { "exclam",                            278, nullptr },
  { "period",                            278, nullptr },
  { "Rcaron",                            722, nullptr },
  { "Kcommaaccent",                      667, nullptr },
  { "greater",                           584, nullptr },
  { "atilde",                            556, nullptr },
  { "brokenbar",                         260, nullptr },
  { "quoteleft",                         222, nullptr },
  { "Edotaccent",                        667, nullptr },
  { "onesuperior",                       333, nullptr }
};

static BuiltinFontWidth symbolWidthsTab[] = {
  { "bracketleftex",                     384, nullptr },
  { "alpha",                             631, nullptr },
  { "union",                             768, nullptr },
  { "infinity",                          713, nullptr },
  { "comma",                             250, nullptr },
  { "copyrightsans",                     790, nullptr },
  { "plusminus",                         549, nullptr },
  { "arrowup",                           603, nullptr },
  { "apple",                             790, nullptr },
  { "parenleftbt",                       384, nullptr },
  { "notelement",                        713, nullptr },
  { "colon",                             278, nullptr },
  { "beta",                              549, nullptr },
  { "braceleftbt",                       494, nullptr },
  { "Lambda",                            686, nullptr },
  { "Phi",                               763, nullptr },
  { "minus",                             549, nullptr },
  { "space",                             250, nullptr },
  { "Sigma",                             592, nullptr },
  { "approxequal",                       549, nullptr },
  { "minute",                            247, nullptr },
  { "circleplus",                        768, nullptr },
  { "Omicron",                           722, nullptr },
  { "three",                             500, nullptr },
  { "numbersign",                        500, nullptr },
  { "lambda",                            549, nullptr },
  { "phi",                               521, nullptr },
  { "aleph",                             823, nullptr },
  { "Tau",                               611, nullptr },
  { "spade",                             753, nullptr },
  { "logicaland",                        603, nullptr },
  { "sigma",                             603, nullptr },
  { "propersuperset",                    713, nullptr },
  { "omicron",                           549, nullptr },
  { "question",                          444, nullptr },
  { "equal",                             549, nullptr },
  { "Epsilon",                           611, nullptr },
  { "emptyset",                          823, nullptr },
  { "diamond",                           753, nullptr },
  { "four",                              500, nullptr },
  { "Mu",                                889, nullptr },
  { "parenlefttp",                       384, nullptr },
  { "club",                              753, nullptr },
  { "bullet",                            460, nullptr },
  { "Omega",                             768, nullptr },
  { "tau",                               439, nullptr },
  { "Upsilon",                           690, nullptr },
  { "bracelefttp",                       494, nullptr },
  { "heart",                             753, nullptr },
  { "divide",                            549, nullptr },
  { "epsilon",                           439, nullptr },
  { "logicalor",                         603, nullptr },
  { "parenleftex",                       384, nullptr },
  { "greaterequal",                      549, nullptr },
  { "mu",                                576, nullptr },
  { "Nu",                                722, nullptr },
  { "therefore",                         863, nullptr },
  { "notsubset",                         713, nullptr },
  { "omega",                             686, nullptr },
  { "semicolon",                         278, nullptr },
  { "element",                           713, nullptr },
  { "upsilon",                           576, nullptr },
  { "existential",                       549, nullptr },
  { "integralbt",                        686, nullptr },
  { "lessequal",                         549, nullptr },
  { "phi1",                              603, nullptr },
  { "lozenge",                           494, nullptr },
  { "trademarkserif",                    890, nullptr },
  { "parenright",                        333, nullptr },
  { "reflexsuperset",                    713, nullptr },
  { "sigma1",                            439, nullptr },
  { "nu",                                521, nullptr },
  { "Gamma",                             603, nullptr },
  { "angleright",                        329, nullptr },
  { "ellipsis",                         1000, nullptr },
  { "Rho",                               556, nullptr },
  { "parenrightbt",                      384, nullptr },
  { "radicalex",                         500, nullptr },
  { "eight",                             500, nullptr },
  { "angleleft",                         329, nullptr },
  { "arrowdbldown",                      603, nullptr },
  { "congruent",                         549, nullptr },
  { "Theta",                             741, nullptr },
  { "intersection",                      768, nullptr },
  { "Pi",                                768, nullptr },
  { "slash",                             278, nullptr },
  { "registerserif",                     790, nullptr },
  { "parenleft",                         333, nullptr },
  { "one",                               500, nullptr },
  { "gamma",                             411, nullptr },
  { "bracketleft",                       333, nullptr },
  { "rho",                               549, nullptr },
  { "circlemultiply",                    768, nullptr },
  { "Chi",                               722, nullptr },
  { "theta",                             521, nullptr },
  { "pi",                                549, nullptr },
  { "integraltp",                        686, nullptr },
  { "Eta",                               722, nullptr },
  { "product",                           823, nullptr },
  { "nine",                              500, nullptr },
  { "five",                              500, nullptr },
  { "propersubset",                      713, nullptr },
  { "bracketrightbt",                    384, nullptr },
  { "trademarksans",                     786, nullptr },
  { "dotmath",                           250, nullptr },
  { "integralex",                        686, nullptr },
  { "chi",                               549, nullptr },
  { "parenrighttp",                      384, nullptr },
  { "eta",                               603, nullptr },
  { "underscore",                        500, nullptr },
  { "Euro",                              750, nullptr },
  { "multiply",                          549, nullptr },
  { "zero",                              500, nullptr },
  { "partialdiff",                       494, nullptr },
  { "angle",                             768, nullptr },
  { "arrowdblleft",                      987, nullptr },
  { "braceleft",                         480, nullptr },
  { "parenrightex",                      384, nullptr },
  { "Rfraktur",                          795, nullptr },
  { "Zeta",                              611, nullptr },
  { "braceex",                           494, nullptr },
  { "arrowdblup",                        603, nullptr },
  { "arrowdown",                         603, nullptr },
  { "Ifraktur",                          686, nullptr },
  { "degree",                            400, nullptr },
  { "Iota",                              333, nullptr },
  { "perpendicular",                     658, nullptr },
  { "radical",                           549, nullptr },
  { "asteriskmath",                      500, nullptr },
  { "percent",                           833, nullptr },
  { "zeta",                              494, nullptr },
  { "six",                               500, nullptr },
  { "two",                               500, nullptr },
  { "weierstrass",                       987, nullptr },
  { "summation",                         713, nullptr },
  { "bracketrighttp",                    384, nullptr },
  { "carriagereturn",                    658, nullptr },
  { "suchthat",                          439, nullptr },
  { "arrowvertex",                       603, nullptr },
  { "Delta",                             612, nullptr },
  { "iota",                              329, nullptr },
  { "arrowhorizex",                     1000, nullptr },
  { "bracketrightex",                    384, nullptr },
  { "bracketright",                      333, nullptr },
  { "ampersand",                         778, nullptr },
  { "plus",                              549, nullptr },
  { "proportional",                      713, nullptr },
  { "delta",                             494, nullptr },
  { "copyrightserif",                    790, nullptr },
  { "bracerightmid",                     494, nullptr },
  { "arrowleft",                         987, nullptr },
  { "second",                            411, nullptr },
  { "arrowdblboth",                     1042, nullptr },
  { "florin",                            500, nullptr },
  { "Psi",                               795, nullptr },
  { "bracerightbt",                      494, nullptr },
  { "bracketleftbt",                     384, nullptr },
  { "seven",                             500, nullptr },
  { "braceleftmid",                      494, nullptr },
  { "notequal",                          549, nullptr },
  { "psi",                               686, nullptr },
  { "equivalence",                       549, nullptr },
  { "universal",                         713, nullptr },
  { "arrowdblright",                     987, nullptr },
  { "braceright",                        480, nullptr },
  { "reflexsubset",                      713, nullptr },
  { "Xi",                                645, nullptr },
  { "theta1",                            631, nullptr },
  { "logicalnot",                        713, nullptr },
  { "Kappa",                             722, nullptr },
  { "similar",                           549, nullptr },
  { "bar",                               200, nullptr },
  { "fraction",                          167, nullptr },
  { "less",                              549, nullptr },
  { "registersans",                      790, nullptr },
  { "omega1",                            713, nullptr },
  { "exclam",                            333, nullptr },
  { "Upsilon1",                          620, nullptr },
  { "bracerighttp",                      494, nullptr },
  { "xi",                                493, nullptr },
  { "period",                            250, nullptr },
  { "Alpha",                             722, nullptr },
  { "arrowright",                        987, nullptr },
  { "greater",                           549, nullptr },
  { "bracketlefttp",                     384, nullptr },
  { "kappa",                             549, nullptr },
  { "gradient",                          713, nullptr },
  { "integral",                          274, nullptr },
  { "arrowboth",                        1042, nullptr },
  { "Beta",                              667, nullptr }
};

static BuiltinFontWidth timesBoldWidthsTab[] = {
  { "Ntilde",                            722, nullptr },
  { "rcaron",                            444, nullptr },
  { "kcommaaccent",                      556, nullptr },
  { "Ncommaaccent",                      722, nullptr },
  { "Zacute",                            667, nullptr },
  { "comma",                             250, nullptr },
  { "cedilla",                           333, nullptr },
  { "plusminus",                         570, nullptr },
  { "circumflex",                        333, nullptr },
  { "dotaccent",                         333, nullptr },
  { "edotaccent",                        444, nullptr },
  { "asciitilde",                        520, nullptr },
  { "colon",                             333, nullptr },
  { "onehalf",                           750, nullptr },
  { "dollar",                            500, nullptr },
  { "Lcaron",                            667, nullptr },
  { "ntilde",                            556, nullptr },
  { "Aogonek",                           722, nullptr },
  { "ncommaaccent",                      556, nullptr },
  { "minus",                             570, nullptr },
  { "Iogonek",                           389, nullptr },
  { "zacute",                            444, nullptr },
  { "yen",                               500, nullptr },
  { "space",                             250, nullptr },
  { "Omacron",                           778, nullptr },
  { "questiondown",                      500, nullptr },
  { "emdash",                           1000, nullptr },
  { "Agrave",                            722, nullptr },
  { "three",                             500, nullptr },
  { "numbersign",                        500, nullptr },
  { "lcaron",                            394, nullptr },
  { "A",                                 722, nullptr },
  { "B",                                 667, nullptr },
  { "C",                                 722, nullptr },
  { "aogonek",                           500, nullptr },
  { "D",                                 722, nullptr },
  { "E",                                 667, nullptr },
  { "onequarter",                        750, nullptr },
  { "F",                                 611, nullptr },
  { "G",                                 778, nullptr },
  { "H",                                 778, nullptr },
  { "I",                                 389, nullptr },
  { "J",                                 500, nullptr },
  { "K",                                 778, nullptr },
  { "iogonek",                           278, nullptr },
  { "backslash",                         278, nullptr },
  { "L",                                 667, nullptr },
  { "periodcentered",                    250, nullptr },
  { "M",                                 944, nullptr },
  { "N",                                 722, nullptr },
  { "omacron",                           500, nullptr },
  { "Tcommaaccent",                      667, nullptr },
  { "O",                                 778, nullptr },
  { "P",                                 611, nullptr },
  { "Q",                                 778, nullptr },
  { "Uhungarumlaut",                     722, nullptr },
  { "R",                                 722, nullptr },
  { "Aacute",                            722, nullptr },
  { "caron",                             333, nullptr },
  { "S",                                 556, nullptr },
  { "T",                                 667, nullptr },
  { "U",                                 722, nullptr },
  { "agrave",                            500, nullptr },
  { "V",                                 722, nullptr },
  { "W",                                1000, nullptr },
  { "X",                                 722, nullptr },
  { "question",                          500, nullptr },
  { "equal",                             570, nullptr },
  { "Y",                                 722, nullptr },
  { "Z",                                 667, nullptr },
  { "four",                              500, nullptr },
  { "a",                                 500, nullptr },
  { "Gcommaaccent",                      778, nullptr },
  { "b",                                 556, nullptr },
  { "c",                                 444, nullptr },
  { "d",                                 556, nullptr },
  { "e",                                 444, nullptr },
  { "f",                                 333, nullptr },
  { "g",                                 500, nullptr },
  { "bullet",                            350, nullptr },
  { "h",                                 556, nullptr },
  { "i",                                 278, nullptr },
  { "Oslash",                            778, nullptr },
  { "dagger",                            500, nullptr },
  { "j",                                 333, nullptr },
  { "k",                                 556, nullptr },
  { "l",                                 278, nullptr },
  { "m",                                 833, nullptr },
  { "n",                                 556, nullptr },
  { "tcommaaccent",                      333, nullptr },
  { "o",                                 500, nullptr },
  { "ordfeminine",                       300, nullptr },
  { "ring",                              333, nullptr },
  { "p",                                 556, nullptr },
  { "q",                                 556, nullptr },
  { "uhungarumlaut",                     556, nullptr },
  { "r",                                 444, nullptr },
  { "twosuperior",                       300, nullptr },
  { "aacute",                            500, nullptr },
  { "s",                                 389, nullptr },
  { "OE",                               1000, nullptr },
  { "t",                                 333, nullptr },
  { "divide",                            570, nullptr },
  { "u",                                 556, nullptr },
  { "Ccaron",                            722, nullptr },
  { "v",                                 500, nullptr },
  { "w",                                 722, nullptr },
  { "x",                                 500, nullptr },
  { "y",                                 500, nullptr },
  { "z",                                 444, nullptr },
  { "Gbreve",                            778, nullptr },
  { "commaaccent",                       250, nullptr },
  { "hungarumlaut",                      333, nullptr },
  { "Idotaccent",                        389, nullptr },
  { "Nacute",                            722, nullptr },
  { "quotedbl",                          555, nullptr },
  { "gcommaaccent",                      500, nullptr },
  { "mu",                                556, nullptr },
  { "greaterequal",                      549, nullptr },
  { "Scaron",                            556, nullptr },
  { "Lslash",                            667, nullptr },
  { "semicolon",                         333, nullptr },
  { "oslash",                            500, nullptr },
  { "lessequal",                         549, nullptr },
  { "lozenge",                           494, nullptr },
  { "parenright",                        333, nullptr },
  { "ccaron",                            444, nullptr },
  { "Ecircumflex",                       667, nullptr },
  { "gbreve",                            500, nullptr },
  { "trademark",                        1000, nullptr },
  { "daggerdbl",                         500, nullptr },
  { "nacute",                            556, nullptr },
  { "macron",                            333, nullptr },
  { "Otilde",                            778, nullptr },
  { "Emacron",                           667, nullptr },
  { "ellipsis",                         1000, nullptr },
  { "scaron",                            389, nullptr },
  { "AE",                               1000, nullptr },
  { "Ucircumflex",                       722, nullptr },
  { "lslash",                            278, nullptr },
  { "quotedblleft",                      500, nullptr },
  { "guilsinglright",                    333, nullptr },
  { "hyphen",                            333, nullptr },
  { "quotesingle",                       278, nullptr },
  { "eight",                             500, nullptr },
  { "exclamdown",                        333, nullptr },
  { "endash",                            500, nullptr },
  { "oe",                                722, nullptr },
  { "Abreve",                            722, nullptr },
  { "Umacron",                           722, nullptr },
  { "ecircumflex",                       444, nullptr },
  { "Adieresis",                         722, nullptr },
  { "copyright",                         747, nullptr },
  { "Egrave",                            667, nullptr },
  { "slash",                             278, nullptr },
  { "Edieresis",                         667, nullptr },
  { "otilde",                            500, nullptr },
  { "Idieresis",                         389, nullptr },
  { "parenleft",                         333, nullptr },
  { "one",                               500, nullptr },
  { "emacron",                           444, nullptr },
  { "Odieresis",                         778, nullptr },
  { "ucircumflex",                       556, nullptr },
  { "bracketleft",                       333, nullptr },
  { "Ugrave",                            722, nullptr },
  { "quoteright",                        333, nullptr },
  { "Udieresis",                         722, nullptr },
  { "perthousand",                      1000, nullptr },
  { "Ydieresis",                         722, nullptr },
  { "umacron",                           556, nullptr },
  { "abreve",                            500, nullptr },
  { "Eacute",                            667, nullptr },
  { "adieresis",                         500, nullptr },
  { "egrave",                            444, nullptr },
  { "edieresis",                         444, nullptr },
  { "idieresis",                         278, nullptr },
  { "Eth",                               722, nullptr },
  { "ae",                                722, nullptr },
  { "asterisk",                          500, nullptr },
  { "odieresis",                         500, nullptr },
  { "Uacute",                            722, nullptr },
  { "ugrave",                            556, nullptr },
  { "nine",                              500, nullptr },
  { "five",                              500, nullptr },
  { "udieresis",                         556, nullptr },
  { "Zcaron",                            667, nullptr },
  { "Scommaaccent",                      556, nullptr },
  { "threequarters",                     750, nullptr },
  { "guillemotright",                    500, nullptr },
  { "Ccedilla",                          722, nullptr },
  { "ydieresis",                         500, nullptr },
  { "tilde",                             333, nullptr },
  { "at",                                930, nullptr },
  { "eacute",                            444, nullptr },
  { "underscore",                        500, nullptr },
  { "Euro",                              500, nullptr },
  { "Dcroat",                            722, nullptr },
  { "multiply",                          570, nullptr },
  { "zero",                              500, nullptr },
  { "eth",                               500, nullptr },
  { "Scedilla",                          556, nullptr },
  { "Ograve",                            778, nullptr },
  { "Racute",                            722, nullptr },
  { "partialdiff",                       494, nullptr },
  { "uacute",                            556, nullptr },
  { "braceleft",                         394, nullptr },
  { "Thorn",                             611, nullptr },
  { "zcaron",                            444, nullptr },
  { "scommaaccent",                      389, nullptr },
  { "ccedilla",                          444, nullptr },
  { "Dcaron",                            722, nullptr },
  { "dcroat",                            556, nullptr },
  { "Ocircumflex",                       778, nullptr },
  { "Oacute",                            778, nullptr },
  { "scedilla",                          389, nullptr },
  { "ogonek",                            333, nullptr },
  { "ograve",                            500, nullptr },
  { "racute",                            444, nullptr },
  { "Tcaron",                            667, nullptr },
  { "Eogonek",                           667, nullptr },
  { "thorn",                             556, nullptr },
  { "degree",                            400, nullptr },
  { "registered",                        747, nullptr },
  { "radical",                           549, nullptr },
  { "Aring",                             722, nullptr },
  { "percent",                          1000, nullptr },
  { "six",                               500, nullptr },
  { "paragraph",                         540, nullptr },
  { "dcaron",                            672, nullptr },
  { "Uogonek",                           722, nullptr },
  { "two",                               500, nullptr },
  { "summation",                         600, nullptr },
  { "Igrave",                            389, nullptr },
  { "Lacute",                            667, nullptr },
  { "ocircumflex",                       500, nullptr },
  { "oacute",                            500, nullptr },
  { "Uring",                             722, nullptr },
  { "Lcommaaccent",                      667, nullptr },
  { "tcaron",                            416, nullptr },
  { "eogonek",                           444, nullptr },
  { "Delta",                             612, nullptr },
  { "Ohungarumlaut",                     778, nullptr },
  { "asciicircum",                       581, nullptr },
  { "aring",                             500, nullptr },
  { "grave",                             333, nullptr },
  { "uogonek",                           556, nullptr },
  { "bracketright",                      333, nullptr },
  { "Iacute",                            389, nullptr },
  { "ampersand",                         833, nullptr },
  { "igrave",                            278, nullptr },
  { "lacute",                            278, nullptr },
  { "Ncaron",                            722, nullptr },
  { "plus",                              570, nullptr },
  { "uring",                             556, nullptr },
  { "quotesinglbase",                    333, nullptr },
  { "lcommaaccent",                      278, nullptr },
  { "Yacute",                            722, nullptr },
  { "ohungarumlaut",                     500, nullptr },
  { "threesuperior",                     300, nullptr },
  { "acute",                             333, nullptr },
  { "section",                           500, nullptr },
  { "dieresis",                          333, nullptr },
  { "iacute",                            278, nullptr },
  { "quotedblbase",                      500, nullptr },
  { "ncaron",                            556, nullptr },
  { "florin",                            500, nullptr },
  { "yacute",                            500, nullptr },
  { "Rcommaaccent",                      722, nullptr },
  { "fi",                                556, nullptr },
  { "fl",                                556, nullptr },
  { "Acircumflex",                       722, nullptr },
  { "Cacute",                            722, nullptr },
  { "Icircumflex",                       389, nullptr },
  { "guillemotleft",                     500, nullptr },
  { "germandbls",                        556, nullptr },
  { "Amacron",                           722, nullptr },
  { "seven",                             500, nullptr },
  { "Sacute",                            556, nullptr },
  { "ordmasculine",                      330, nullptr },
  { "dotlessi",                          278, nullptr },
  { "sterling",                          500, nullptr },
  { "notequal",                          549, nullptr },
  { "Imacron",                           389, nullptr },
  { "rcommaaccent",                      444, nullptr },
  { "Zdotaccent",                        667, nullptr },
  { "acircumflex",                       500, nullptr },
  { "cacute",                            444, nullptr },
  { "Ecaron",                            667, nullptr },
  { "icircumflex",                       278, nullptr },
  { "braceright",                        394, nullptr },
  { "quotedblright",                     500, nullptr },
  { "amacron",                           500, nullptr },
  { "sacute",                            389, nullptr },
  { "imacron",                           278, nullptr },
  { "cent",                              500, nullptr },
  { "currency",                          500, nullptr },
  { "logicalnot",                        570, nullptr },
  { "zdotaccent",                        444, nullptr },
  { "Atilde",                            722, nullptr },
  { "breve",                             333, nullptr },
  { "bar",                               220, nullptr },
  { "fraction",                          167, nullptr },
  { "less",                              570, nullptr },
  { "ecaron",                            444, nullptr },
  { "guilsinglleft",                     333, nullptr },
  { "exclam",                            333, nullptr },
  { "period",                            250, nullptr },
  { "Rcaron",                            722, nullptr },
  { "Kcommaaccent",                      778, nullptr },
  { "greater",                           570, nullptr },
  { "atilde",                            500, nullptr },
  { "brokenbar",                         220, nullptr },
  { "quoteleft",                         333, nullptr },
  { "Edotaccent",                        667, nullptr },
  { "onesuperior",                       300, nullptr }
};

static BuiltinFontWidth timesBoldItalicWidthsTab[] = {
  { "Ntilde",                            722, nullptr },
  { "rcaron",                            389, nullptr },
  { "kcommaaccent",                      500, nullptr },
  { "Ncommaaccent",                      722, nullptr },
  { "Zacute",                            611, nullptr },
  { "comma",                             250, nullptr },
  { "cedilla",                           333, nullptr },
  { "plusminus",                         570, nullptr },
  { "circumflex",                        333, nullptr },
  { "dotaccent",                         333, nullptr },
  { "edotaccent",                        444, nullptr },
  { "asciitilde",                        570, nullptr },
  { "colon",                             333, nullptr },
  { "onehalf",                           750, nullptr },
  { "dollar",                            500, nullptr },
  { "Lcaron",                            611, nullptr },
  { "ntilde",                            556, nullptr },
  { "Aogonek",                           667, nullptr },
  { "ncommaaccent",                      556, nullptr },
  { "minus",                             606, nullptr },
  { "Iogonek",                           389, nullptr },
  { "zacute",                            389, nullptr },
  { "yen",                               500, nullptr },
  { "space",                             250, nullptr },
  { "Omacron",                           722, nullptr },
  { "questiondown",                      500, nullptr },
  { "emdash",                           1000, nullptr },
  { "Agrave",                            667, nullptr },
  { "three",                             500, nullptr },
  { "numbersign",                        500, nullptr },
  { "lcaron",                            382, nullptr },
  { "A",                                 667, nullptr },
  { "B",                                 667, nullptr },
  { "C",                                 667, nullptr },
  { "aogonek",                           500, nullptr },
  { "D",                                 722, nullptr },
  { "E",                                 667, nullptr },
  { "onequarter",                        750, nullptr },
  { "F",                                 667, nullptr },
  { "G",                                 722, nullptr },
  { "H",                                 778, nullptr },
  { "I",                                 389, nullptr },
  { "J",                                 500, nullptr },
  { "K",                                 667, nullptr },
  { "iogonek",                           278, nullptr },
  { "backslash",                         278, nullptr },
  { "L",                                 611, nullptr },
  { "periodcentered",                    250, nullptr },
  { "M",                                 889, nullptr },
  { "N",                                 722, nullptr },
  { "omacron",                           500, nullptr },
  { "Tcommaaccent",                      611, nullptr },
  { "O",                                 722, nullptr },
  { "P",                                 611, nullptr },
  { "Q",                                 722, nullptr },
  { "Uhungarumlaut",                     722, nullptr },
  { "R",                                 667, nullptr },
  { "Aacute",                            667, nullptr },
  { "caron",                             333, nullptr },
  { "S",                                 556, nullptr },
  { "T",                                 611, nullptr },
  { "U",                                 722, nullptr },
  { "agrave",                            500, nullptr },
  { "V",                                 667, nullptr },
  { "W",                                 889, nullptr },
  { "X",                                 667, nullptr },
  { "question",                          500, nullptr },
  { "equal",                             570, nullptr },
  { "Y",                                 611, nullptr },
  { "Z",                                 611, nullptr },
  { "four",                              500, nullptr },
  { "a",                                 500, nullptr },
  { "Gcommaaccent",                      722, nullptr },
  { "b",                                 500, nullptr },
  { "c",                                 444, nullptr },
  { "d",                                 500, nullptr },
  { "e",                                 444, nullptr },
  { "f",                                 333, nullptr },
  { "g",                                 500, nullptr },
  { "bullet",                            350, nullptr },
  { "h",                                 556, nullptr },
  { "i",                                 278, nullptr },
  { "Oslash",                            722, nullptr },
  { "dagger",                            500, nullptr },
  { "j",                                 278, nullptr },
  { "k",                                 500, nullptr },
  { "l",                                 278, nullptr },
  { "m",                                 778, nullptr },
  { "n",                                 556, nullptr },
  { "tcommaaccent",                      278, nullptr },
  { "o",                                 500, nullptr },
  { "ordfeminine",                       266, nullptr },
  { "ring",                              333, nullptr },
  { "p",                                 500, nullptr },
  { "q",                                 500, nullptr },
  { "uhungarumlaut",                     556, nullptr },
  { "r",                                 389, nullptr },
  { "twosuperior",                       300, nullptr },
  { "aacute",                            500, nullptr },
  { "s",                                 389, nullptr },
  { "OE",                                944, nullptr },
  { "t",                                 278, nullptr },
  { "divide",                            570, nullptr },
  { "u",                                 556, nullptr },
  { "Ccaron",                            667, nullptr },
  { "v",                                 444, nullptr },
  { "w",                                 667, nullptr },
  { "x",                                 500, nullptr },
  { "y",                                 444, nullptr },
  { "z",                                 389, nullptr },
  { "Gbreve",                            722, nullptr },
  { "commaaccent",                       250, nullptr },
  { "hungarumlaut",                      333, nullptr },
  { "Idotaccent",                        389, nullptr },
  { "Nacute",                            722, nullptr },
  { "quotedbl",                          555, nullptr },
  { "gcommaaccent",                      500, nullptr },
  { "mu",                                576, nullptr },
  { "greaterequal",                      549, nullptr },
  { "Scaron",                            556, nullptr },
  { "Lslash",                            611, nullptr },
  { "semicolon",                         333, nullptr },
  { "oslash",                            500, nullptr },
  { "lessequal",                         549, nullptr },
  { "lozenge",                           494, nullptr },
  { "parenright",                        333, nullptr },
  { "ccaron",                            444, nullptr },
  { "Ecircumflex",                       667, nullptr },
  { "gbreve",                            500, nullptr },
  { "trademark",                        1000, nullptr },
  { "daggerdbl",                         500, nullptr },
  { "nacute",                            556, nullptr },
  { "macron",                            333, nullptr },
  { "Otilde",                            722, nullptr },
  { "Emacron",                           667, nullptr },
  { "ellipsis",                         1000, nullptr },
  { "scaron",                            389, nullptr },
  { "AE",                                944, nullptr },
  { "Ucircumflex",                       722, nullptr },
  { "lslash",                            278, nullptr },
  { "quotedblleft",                      500, nullptr },
  { "guilsinglright",                    333, nullptr },
  { "hyphen",                            333, nullptr },
  { "quotesingle",                       278, nullptr },
  { "eight",                             500, nullptr },
  { "exclamdown",                        389, nullptr },
  { "endash",                            500, nullptr },
  { "oe",                                722, nullptr },
  { "Abreve",                            667, nullptr },
  { "Umacron",                           722, nullptr },
  { "ecircumflex",                       444, nullptr },
  { "Adieresis",                         667, nullptr },
  { "copyright",                         747, nullptr },
  { "Egrave",                            667, nullptr },
  { "slash",                             278, nullptr },
  { "Edieresis",                         667, nullptr },
  { "otilde",                            500, nullptr },
  { "Idieresis",                         389, nullptr },
  { "parenleft",                         333, nullptr },
  { "one",                               500, nullptr },
  { "emacron",                           444, nullptr },
  { "Odieresis",                         722, nullptr },
  { "ucircumflex",                       556, nullptr },
  { "bracketleft",                       333, nullptr },
  { "Ugrave",                            722, nullptr },
  { "quoteright",                        333, nullptr },
  { "Udieresis",                         722, nullptr },
  { "perthousand",                      1000, nullptr },
  { "Ydieresis",                         611, nullptr },
  { "umacron",                           556, nullptr },
  { "abreve",                            500, nullptr },
  { "Eacute",                            667, nullptr },
  { "adieresis",                         500, nullptr },
  { "egrave",                            444, nullptr },
  { "edieresis",                         444, nullptr },
  { "idieresis",                         278, nullptr },
  { "Eth",                               722, nullptr },
  { "ae",                                722, nullptr },
  { "asterisk",                          500, nullptr },
  { "odieresis",                         500, nullptr },
  { "Uacute",                            722, nullptr },
  { "ugrave",                            556, nullptr },
  { "nine",                              500, nullptr },
  { "five",                              500, nullptr },
  { "udieresis",                         556, nullptr },
  { "Zcaron",                            611, nullptr },
  { "Scommaaccent",                      556, nullptr },
  { "threequarters",                     750, nullptr },
  { "guillemotright",                    500, nullptr },
  { "Ccedilla",                          667, nullptr },
  { "ydieresis",                         444, nullptr },
  { "tilde",                             333, nullptr },
  { "at",                                832, nullptr },
  { "eacute",                            444, nullptr },
  { "underscore",                        500, nullptr },
  { "Euro",                              500, nullptr },
  { "Dcroat",                            722, nullptr },
  { "multiply",                          570, nullptr },
  { "zero",                              500, nullptr },
  { "eth",                               500, nullptr },
  { "Scedilla",                          556, nullptr },
  { "Ograve",                            722, nullptr },
  { "Racute",                            667, nullptr },
  { "partialdiff",                       494, nullptr },
  { "uacute",                            556, nullptr },
  { "braceleft",                         348, nullptr },
  { "Thorn",                             611, nullptr },
  { "zcaron",                            389, nullptr },
  { "scommaaccent",                      389, nullptr },
  { "ccedilla",                          444, nullptr },
  { "Dcaron",                            722, nullptr },
  { "dcroat",                            500, nullptr },
  { "Ocircumflex",                       722, nullptr },
  { "Oacute",                            722, nullptr },
  { "scedilla",                          389, nullptr },
  { "ogonek",                            333, nullptr },
  { "ograve",                            500, nullptr },
  { "racute",                            389, nullptr },
  { "Tcaron",                            611, nullptr },
  { "Eogonek",                           667, nullptr },
  { "thorn",                             500, nullptr },
  { "degree",                            400, nullptr },
  { "registered",                        747, nullptr },
  { "radical",                           549, nullptr },
  { "Aring",                             667, nullptr },
  { "percent",                           833, nullptr },
  { "six",                               500, nullptr },
  { "paragraph",                         500, nullptr },
  { "dcaron",                            608, nullptr },
  { "Uogonek",                           722, nullptr },
  { "two",                               500, nullptr },
  { "summation",                         600, nullptr },
  { "Igrave",                            389, nullptr },
  { "Lacute",                            611, nullptr },
  { "ocircumflex",                       500, nullptr },
  { "oacute",                            500, nullptr },
  { "Uring",                             722, nullptr },
  { "Lcommaaccent",                      611, nullptr },
  { "tcaron",                            366, nullptr },
  { "eogonek",                           444, nullptr },
  { "Delta",                             612, nullptr },
  { "Ohungarumlaut",                     722, nullptr },
  { "asciicircum",                       570, nullptr },
  { "aring",                             500, nullptr },
  { "grave",                             333, nullptr },
  { "uogonek",                           556, nullptr },
  { "bracketright",                      333, nullptr },
  { "Iacute",                            389, nullptr },
  { "ampersand",                         778, nullptr },
  { "igrave",                            278, nullptr },
  { "lacute",                            278, nullptr },
  { "Ncaron",                            722, nullptr },
  { "plus",                              570, nullptr },
  { "uring",                             556, nullptr },
  { "quotesinglbase",                    333, nullptr },
  { "lcommaaccent",                      278, nullptr },
  { "Yacute",                            611, nullptr },
  { "ohungarumlaut",                     500, nullptr },
  { "threesuperior",                     300, nullptr },
  { "acute",                             333, nullptr },
  { "section",                           500, nullptr },
  { "dieresis",                          333, nullptr },
  { "iacute",                            278, nullptr },
  { "quotedblbase",                      500, nullptr },
  { "ncaron",                            556, nullptr },
  { "florin",                            500, nullptr },
  { "yacute",                            444, nullptr },
  { "Rcommaaccent",                      667, nullptr },
  { "fi",                                556, nullptr },
  { "fl",                                556, nullptr },
  { "Acircumflex",                       667, nullptr },
  { "Cacute",                            667, nullptr },
  { "Icircumflex",                       389, nullptr },
  { "guillemotleft",                     500, nullptr },
  { "germandbls",                        500, nullptr },
  { "Amacron",                           667, nullptr },
  { "seven",                             500, nullptr },
  { "Sacute",                            556, nullptr },
  { "ordmasculine",                      300, nullptr },
  { "dotlessi",                          278, nullptr },
  { "sterling",                          500, nullptr },
  { "notequal",                          549, nullptr },
  { "Imacron",                           389, nullptr },
  { "rcommaaccent",                      389, nullptr },
  { "Zdotaccent",                        611, nullptr },
  { "acircumflex",                       500, nullptr },
  { "cacute",                            444, nullptr },
  { "Ecaron",                            667, nullptr },
  { "icircumflex",                       278, nullptr },
  { "braceright",                        348, nullptr },
  { "quotedblright",                     500, nullptr },
  { "amacron",                           500, nullptr },
  { "sacute",                            389, nullptr },
  { "imacron",                           278, nullptr },
  { "cent",                              500, nullptr },
  { "currency",                          500, nullptr },
  { "logicalnot",                        606, nullptr },
  { "zdotaccent",                        389, nullptr },
  { "Atilde",                            667, nullptr },
  { "breve",                             333, nullptr },
  { "bar",                               220, nullptr },
  { "fraction",                          167, nullptr },
  { "less",                              570, nullptr },
  { "ecaron",                            444, nullptr },
  { "guilsinglleft",                     333, nullptr },
  { "exclam",                            389, nullptr },
  { "period",                            250, nullptr },
  { "Rcaron",                            667, nullptr },
  { "Kcommaaccent",                      667, nullptr },
  { "greater",                           570, nullptr },
  { "atilde",                            500, nullptr },
  { "brokenbar",                         220, nullptr },
  { "quoteleft",                         333, nullptr },
  { "Edotaccent",                        667, nullptr },
  { "onesuperior",                       300, nullptr }
};

static BuiltinFontWidth timesItalicWidthsTab[] = {
  { "Ntilde",                            667, nullptr },
  { "rcaron",                            389, nullptr },
  { "kcommaaccent",                      444, nullptr },
  { "Ncommaaccent",                      667, nullptr },
  { "Zacute",                            556, nullptr },
  { "comma",                             250, nullptr },
  { "cedilla",                           333, nullptr },
  { "plusminus",                         675, nullptr },
  { "circumflex",                        333, nullptr },
  { "dotaccent",                         333, nullptr },
  { "edotaccent",                        444, nullptr },
  { "asciitilde",                        541, nullptr },
  { "colon",                             333, nullptr },
  { "onehalf",                           750, nullptr },
  { "dollar",                            500, nullptr },
  { "Lcaron",                            611, nullptr },
  { "ntilde",                            500, nullptr },
  { "Aogonek",                           611, nullptr },
  { "ncommaaccent",                      500, nullptr },
  { "minus",                             675, nullptr },
  { "Iogonek",                           333, nullptr },
  { "zacute",                            389, nullptr },
  { "yen",                               500, nullptr },
  { "space",                             250, nullptr },
  { "Omacron",                           722, nullptr },
  { "questiondown",                      500, nullptr },
  { "emdash",                            889, nullptr },
  { "Agrave",                            611, nullptr },
  { "three",                             500, nullptr },
  { "numbersign",                        500, nullptr },
  { "lcaron",                            300, nullptr },
  { "A",                                 611, nullptr },
  { "B",                                 611, nullptr },
  { "C",                                 667, nullptr },
  { "aogonek",                           500, nullptr },
  { "D",                                 722, nullptr },
  { "E",                                 611, nullptr },
  { "onequarter",                        750, nullptr },
  { "F",                                 611, nullptr },
  { "G",                                 722, nullptr },
  { "H",                                 722, nullptr },
  { "I",                                 333, nullptr },
  { "J",                                 444, nullptr },
  { "K",                                 667, nullptr },
  { "iogonek",                           278, nullptr },
  { "backslash",                         278, nullptr },
  { "L",                                 556, nullptr },
  { "periodcentered",                    250, nullptr },
  { "M",                                 833, nullptr },
  { "N",                                 667, nullptr },
  { "omacron",                           500, nullptr },
  { "Tcommaaccent",                      556, nullptr },
  { "O",                                 722, nullptr },
  { "P",                                 611, nullptr },
  { "Q",                                 722, nullptr },
  { "Uhungarumlaut",                     722, nullptr },
  { "R",                                 611, nullptr },
  { "Aacute",                            611, nullptr },
  { "caron",                             333, nullptr },
  { "S",                                 500, nullptr },
  { "T",                                 556, nullptr },
  { "U",                                 722, nullptr },
  { "agrave",                            500, nullptr },
  { "V",                                 611, nullptr },
  { "W",                                 833, nullptr },
  { "X",                                 611, nullptr },
  { "question",                          500, nullptr },
  { "equal",                             675, nullptr },
  { "Y",                                 556, nullptr },
  { "Z",                                 556, nullptr },
  { "four",                              500, nullptr },
  { "a",                                 500, nullptr },
  { "Gcommaaccent",                      722, nullptr },
  { "b",                                 500, nullptr },
  { "c",                                 444, nullptr },
  { "d",                                 500, nullptr },
  { "e",                                 444, nullptr },
  { "f",                                 278, nullptr },
  { "g",                                 500, nullptr },
  { "bullet",                            350, nullptr },
  { "h",                                 500, nullptr },
  { "i",                                 278, nullptr },
  { "Oslash",                            722, nullptr },
  { "dagger",                            500, nullptr },
  { "j",                                 278, nullptr },
  { "k",                                 444, nullptr },
  { "l",                                 278, nullptr },
  { "m",                                 722, nullptr },
  { "n",                                 500, nullptr },
  { "tcommaaccent",                      278, nullptr },
  { "o",                                 500, nullptr },
  { "ordfeminine",                       276, nullptr },
  { "ring",                              333, nullptr },
  { "p",                                 500, nullptr },
  { "q",                                 500, nullptr },
  { "uhungarumlaut",                     500, nullptr },
  { "r",                                 389, nullptr },
  { "twosuperior",                       300, nullptr },
  { "aacute",                            500, nullptr },
  { "s",                                 389, nullptr },
  { "OE",                                944, nullptr },
  { "t",                                 278, nullptr },
  { "divide",                            675, nullptr },
  { "u",                                 500, nullptr },
  { "Ccaron",                            667, nullptr },
  { "v",                                 444, nullptr },
  { "w",                                 667, nullptr },
  { "x",                                 444, nullptr },
  { "y",                                 444, nullptr },
  { "z",                                 389, nullptr },
  { "Gbreve",                            722, nullptr },
  { "commaaccent",                       250, nullptr },
  { "hungarumlaut",                      333, nullptr },
  { "Idotaccent",                        333, nullptr },
  { "Nacute",                            667, nullptr },
  { "quotedbl",                          420, nullptr },
  { "gcommaaccent",                      500, nullptr },
  { "mu",                                500, nullptr },
  { "greaterequal",                      549, nullptr },
  { "Scaron",                            500, nullptr },
  { "Lslash",                            556, nullptr },
  { "semicolon",                         333, nullptr },
  { "oslash",                            500, nullptr },
  { "lessequal",                         549, nullptr },
  { "lozenge",                           471, nullptr },
  { "parenright",                        333, nullptr },
  { "ccaron",                            444, nullptr },
  { "Ecircumflex",                       611, nullptr },
  { "gbreve",                            500, nullptr },
  { "trademark",                         980, nullptr },
  { "daggerdbl",                         500, nullptr },
  { "nacute",                            500, nullptr },
  { "macron",                            333, nullptr },
  { "Otilde",                            722, nullptr },
  { "Emacron",                           611, nullptr },
  { "ellipsis",                          889, nullptr },
  { "scaron",                            389, nullptr },
  { "AE",                                889, nullptr },
  { "Ucircumflex",                       722, nullptr },
  { "lslash",                            278, nullptr },
  { "quotedblleft",                      556, nullptr },
  { "guilsinglright",                    333, nullptr },
  { "hyphen",                            333, nullptr },
  { "quotesingle",                       214, nullptr },
  { "eight",                             500, nullptr },
  { "exclamdown",                        389, nullptr },
  { "endash",                            500, nullptr },
  { "oe",                                667, nullptr },
  { "Abreve",                            611, nullptr },
  { "Umacron",                           722, nullptr },
  { "ecircumflex",                       444, nullptr },
  { "Adieresis",                         611, nullptr },
  { "copyright",                         760, nullptr },
  { "Egrave",                            611, nullptr },
  { "slash",                             278, nullptr },
  { "Edieresis",                         611, nullptr },
  { "otilde",                            500, nullptr },
  { "Idieresis",                         333, nullptr },
  { "parenleft",                         333, nullptr },
  { "one",                               500, nullptr },
  { "emacron",                           444, nullptr },
  { "Odieresis",                         722, nullptr },
  { "ucircumflex",                       500, nullptr },
  { "bracketleft",                       389, nullptr },
  { "Ugrave",                            722, nullptr },
  { "quoteright",                        333, nullptr },
  { "Udieresis",                         722, nullptr },
  { "perthousand",                      1000, nullptr },
  { "Ydieresis",                         556, nullptr },
  { "umacron",                           500, nullptr },
  { "abreve",                            500, nullptr },
  { "Eacute",                            611, nullptr },
  { "adieresis",                         500, nullptr },
  { "egrave",                            444, nullptr },
  { "edieresis",                         444, nullptr },
  { "idieresis",                         278, nullptr },
  { "Eth",                               722, nullptr },
  { "ae",                                667, nullptr },
  { "asterisk",                          500, nullptr },
  { "odieresis",                         500, nullptr },
  { "Uacute",                            722, nullptr },
  { "ugrave",                            500, nullptr },
  { "nine",                              500, nullptr },
  { "five",                              500, nullptr },
  { "udieresis",                         500, nullptr },
  { "Zcaron",                            556, nullptr },
  { "Scommaaccent",                      500, nullptr },
  { "threequarters",                     750, nullptr },
  { "guillemotright",                    500, nullptr },
  { "Ccedilla",                          667, nullptr },
  { "ydieresis",                         444, nullptr },
  { "tilde",                             333, nullptr },
  { "at",                                920, nullptr },
  { "eacute",                            444, nullptr },
  { "underscore",                        500, nullptr },
  { "Euro",                              500, nullptr },
  { "Dcroat",                            722, nullptr },
  { "multiply",                          675, nullptr },
  { "zero",                              500, nullptr },
  { "eth",                               500, nullptr },
  { "Scedilla",                          500, nullptr },
  { "Ograve",                            722, nullptr },
  { "Racute",                            611, nullptr },
  { "partialdiff",                       476, nullptr },
  { "uacute",                            500, nullptr },
  { "braceleft",                         400, nullptr },
  { "Thorn",                             611, nullptr },
  { "zcaron",                            389, nullptr },
  { "scommaaccent",                      389, nullptr },
  { "ccedilla",                          444, nullptr },
  { "Dcaron",                            722, nullptr },
  { "dcroat",                            500, nullptr },
  { "Ocircumflex",                       722, nullptr },
  { "Oacute",                            722, nullptr },
  { "scedilla",                          389, nullptr },
  { "ogonek",                            333, nullptr },
  { "ograve",                            500, nullptr },
  { "racute",                            389, nullptr },
  { "Tcaron",                            556, nullptr },
  { "Eogonek",                           611, nullptr },
  { "thorn",                             500, nullptr },
  { "degree",                            400, nullptr },
  { "registered",                        760, nullptr },
  { "radical",                           453, nullptr },
  { "Aring",                             611, nullptr },
  { "percent",                           833, nullptr },
  { "six",                               500, nullptr },
  { "paragraph",                         523, nullptr },
  { "dcaron",                            544, nullptr },
  { "Uogonek",                           722, nullptr },
  { "two",                               500, nullptr },
  { "summation",                         600, nullptr },
  { "Igrave",                            333, nullptr },
  { "Lacute",                            556, nullptr },
  { "ocircumflex",                       500, nullptr },
  { "oacute",                            500, nullptr },
  { "Uring",                             722, nullptr },
  { "Lcommaaccent",                      556, nullptr },
  { "tcaron",                            300, nullptr },
  { "eogonek",                           444, nullptr },
  { "Delta",                             612, nullptr },
  { "Ohungarumlaut",                     722, nullptr },
  { "asciicircum",                       422, nullptr },
  { "aring",                             500, nullptr },
  { "grave",                             333, nullptr },
  { "uogonek",                           500, nullptr },
  { "bracketright",                      389, nullptr },
  { "Iacute",                            333, nullptr },
  { "ampersand",                         778, nullptr },
  { "igrave",                            278, nullptr },
  { "lacute",                            278, nullptr },
  { "Ncaron",                            667, nullptr },
  { "plus",                              675, nullptr },
  { "uring",                             500, nullptr },
  { "quotesinglbase",                    333, nullptr },
  { "lcommaaccent",                      278, nullptr },
  { "Yacute",                            556, nullptr },
  { "ohungarumlaut",                     500, nullptr },
  { "threesuperior",                     300, nullptr },
  { "acute",                             333, nullptr },
  { "section",                           500, nullptr },
  { "dieresis",                          333, nullptr },
  { "iacute",                            278, nullptr },
  { "quotedblbase",                      556, nullptr },
  { "ncaron",                            500, nullptr },
  { "florin",                            500, nullptr },
  { "yacute",                            444, nullptr },
  { "Rcommaaccent",                      611, nullptr },
  { "fi",                                500, nullptr },
  { "fl",                                500, nullptr },
  { "Acircumflex",                       611, nullptr },
  { "Cacute",                            667, nullptr },
  { "Icircumflex",                       333, nullptr },
  { "guillemotleft",                     500, nullptr },
  { "germandbls",                        500, nullptr },
  { "Amacron",                           611, nullptr },
  { "seven",                             500, nullptr },
  { "Sacute",                            500, nullptr },
  { "ordmasculine",                      310, nullptr },
  { "dotlessi",                          278, nullptr },
  { "sterling",                          500, nullptr },
  { "notequal",                          549, nullptr },
  { "Imacron",                           333, nullptr },
  { "rcommaaccent",                      389, nullptr },
  { "Zdotaccent",                        556, nullptr },
  { "acircumflex",                       500, nullptr },
  { "cacute",                            444, nullptr },
  { "Ecaron",                            611, nullptr },
  { "icircumflex",                       278, nullptr },
  { "braceright",                        400, nullptr },
  { "quotedblright",                     556, nullptr },
  { "amacron",                           500, nullptr },
  { "sacute",                            389, nullptr },
  { "imacron",                           278, nullptr },
  { "cent",                              500, nullptr },
  { "currency",                          500, nullptr },
  { "logicalnot",                        675, nullptr },
  { "zdotaccent",                        389, nullptr },
  { "Atilde",                            611, nullptr },
  { "breve",                             333, nullptr },
  { "bar",                               275, nullptr },
  { "fraction",                          167, nullptr },
  { "less",                              675, nullptr },
  { "ecaron",                            444, nullptr },
  { "guilsinglleft",                     333, nullptr },
  { "exclam",                            333, nullptr },
  { "period",                            250, nullptr },
  { "Rcaron",                            611, nullptr },
  { "Kcommaaccent",                      667, nullptr },
  { "greater",                           675, nullptr },
  { "atilde",                            500, nullptr },
  { "brokenbar",                         275, nullptr },
  { "quoteleft",                         333, nullptr },
  { "Edotaccent",                        611, nullptr },
  { "onesuperior",                       300, nullptr }
};

static BuiltinFontWidth timesRomanWidthsTab[] = {
  { "Ntilde",                            722, nullptr },
  { "rcaron",                            333, nullptr },
  { "kcommaaccent",                      500, nullptr },
  { "Ncommaaccent",                      722, nullptr },
  { "Zacute",                            611, nullptr },
  { "comma",                             250, nullptr },
  { "cedilla",                           333, nullptr },
  { "plusminus",                         564, nullptr },
  { "circumflex",                        333, nullptr },
  { "dotaccent",                         333, nullptr },
  { "edotaccent",                        444, nullptr },
  { "asciitilde",                        541, nullptr },
  { "colon",                             278, nullptr },
  { "onehalf",                           750, nullptr },
  { "dollar",                            500, nullptr },
  { "Lcaron",                            611, nullptr },
  { "ntilde",                            500, nullptr },
  { "Aogonek",                           722, nullptr },
  { "ncommaaccent",                      500, nullptr },
  { "minus",                             564, nullptr },
  { "Iogonek",                           333, nullptr },
  { "zacute",                            444, nullptr },
  { "yen",                               500, nullptr },
  { "space",                             250, nullptr },
  { "Omacron",                           722, nullptr },
  { "questiondown",                      444, nullptr },
  { "emdash",                           1000, nullptr },
  { "Agrave",                            722, nullptr },
  { "three",                             500, nullptr },
  { "numbersign",                        500, nullptr },
  { "lcaron",                            344, nullptr },
  { "A",                                 722, nullptr },
  { "B",                                 667, nullptr },
  { "C",                                 667, nullptr },
  { "aogonek",                           444, nullptr },
  { "D",                                 722, nullptr },
  { "E",                                 611, nullptr },
  { "onequarter",                        750, nullptr },
  { "F",                                 556, nullptr },
  { "G",                                 722, nullptr },
  { "H",                                 722, nullptr },
  { "I",                                 333, nullptr },
  { "J",                                 389, nullptr },
  { "K",                                 722, nullptr },
  { "iogonek",                           278, nullptr },
  { "backslash",                         278, nullptr },
  { "L",                                 611, nullptr },
  { "periodcentered",                    250, nullptr },
  { "M",                                 889, nullptr },
  { "N",                                 722, nullptr },
  { "omacron",                           500, nullptr },
  { "Tcommaaccent",                      611, nullptr },
  { "O",                                 722, nullptr },
  { "P",                                 556, nullptr },
  { "Q",                                 722, nullptr },
  { "Uhungarumlaut",                     722, nullptr },
  { "R",                                 667, nullptr },
  { "Aacute",                            722, nullptr },
  { "caron",                             333, nullptr },
  { "S",                                 556, nullptr },
  { "T",                                 611, nullptr },
  { "U",                                 722, nullptr },
  { "agrave",                            444, nullptr },
  { "V",                                 722, nullptr },
  { "W",                                 944, nullptr },
  { "X",                                 722, nullptr },
  { "question",                          444, nullptr },
  { "equal",                             564, nullptr },
  { "Y",                                 722, nullptr },
  { "Z",                                 611, nullptr },
  { "four",                              500, nullptr },
  { "a",                                 444, nullptr },
  { "Gcommaaccent",                      722, nullptr },
  { "b",                                 500, nullptr },
  { "c",                                 444, nullptr },
  { "d",                                 500, nullptr },
  { "e",                                 444, nullptr },
  { "f",                                 333, nullptr },
  { "g",                                 500, nullptr },
  { "bullet",                            350, nullptr },
  { "h",                                 500, nullptr },
  { "i",                                 278, nullptr },
  { "Oslash",                            722, nullptr },
  { "dagger",                            500, nullptr },
  { "j",                                 278, nullptr },
  { "k",                                 500, nullptr },
  { "l",                                 278, nullptr },
  { "m",                                 778, nullptr },
  { "n",                                 500, nullptr },
  { "tcommaaccent",                      278, nullptr },
  { "o",                                 500, nullptr },
  { "ordfeminine",                       276, nullptr },
  { "ring",                              333, nullptr },
  { "p",                                 500, nullptr },
  { "q",                                 500, nullptr },
  { "uhungarumlaut",                     500, nullptr },
  { "r",                                 333, nullptr },
  { "twosuperior",                       300, nullptr },
  { "aacute",                            444, nullptr },
  { "s",                                 389, nullptr },
  { "OE",                                889, nullptr },
  { "t",                                 278, nullptr },
  { "divide",                            564, nullptr },
  { "u",                                 500, nullptr },
  { "Ccaron",                            667, nullptr },
  { "v",                                 500, nullptr },
  { "w",                                 722, nullptr },
  { "x",                                 500, nullptr },
  { "y",                                 500, nullptr },
  { "z",                                 444, nullptr },
  { "Gbreve",                            722, nullptr },
  { "commaaccent",                       250, nullptr },
  { "hungarumlaut",                      333, nullptr },
  { "Idotaccent",                        333, nullptr },
  { "Nacute",                            722, nullptr },
  { "quotedbl",                          408, nullptr },
  { "gcommaaccent",                      500, nullptr },
  { "mu",                                500, nullptr },
  { "greaterequal",                      549, nullptr },
  { "Scaron",                            556, nullptr },
  { "Lslash",                            611, nullptr },
  { "semicolon",                         278, nullptr },
  { "oslash",                            500, nullptr },
  { "lessequal",                         549, nullptr },
  { "lozenge",                           471, nullptr },
  { "parenright",                        333, nullptr },
  { "ccaron",                            444, nullptr },
  { "Ecircumflex",                       611, nullptr },
  { "gbreve",                            500, nullptr },
  { "trademark",                         980, nullptr },
  { "daggerdbl",                         500, nullptr },
  { "nacute",                            500, nullptr },
  { "macron",                            333, nullptr },
  { "Otilde",                            722, nullptr },
  { "Emacron",                           611, nullptr },
  { "ellipsis",                         1000, nullptr },
  { "scaron",                            389, nullptr },
  { "AE",                                889, nullptr },
  { "Ucircumflex",                       722, nullptr },
  { "lslash",                            278, nullptr },
  { "quotedblleft",                      444, nullptr },
  { "guilsinglright",                    333, nullptr },
  { "hyphen",                            333, nullptr },
  { "quotesingle",                       180, nullptr },
  { "eight",                             500, nullptr },
  { "exclamdown",                        333, nullptr },
  { "endash",                            500, nullptr },
  { "oe",                                722, nullptr },
  { "Abreve",                            722, nullptr },
  { "Umacron",                           722, nullptr },
  { "ecircumflex",                       444, nullptr },
  { "Adieresis",                         722, nullptr },
  { "copyright",                         760, nullptr },
  { "Egrave",                            611, nullptr },
  { "slash",                             278, nullptr },
  { "Edieresis",                         611, nullptr },
  { "otilde",                            500, nullptr },
  { "Idieresis",                         333, nullptr },
  { "parenleft",                         333, nullptr },
  { "one",                               500, nullptr },
  { "emacron",                           444, nullptr },
  { "Odieresis",                         722, nullptr },
  { "ucircumflex",                       500, nullptr },
  { "bracketleft",                       333, nullptr },
  { "Ugrave",                            722, nullptr },
  { "quoteright",                        333, nullptr },
  { "Udieresis",                         722, nullptr },
  { "perthousand",                      1000, nullptr },
  { "Ydieresis",                         722, nullptr },
  { "umacron",                           500, nullptr },
  { "abreve",                            444, nullptr },
  { "Eacute",                            611, nullptr },
  { "adieresis",                         444, nullptr },
  { "egrave",                            444, nullptr },
  { "edieresis",                         444, nullptr },
  { "idieresis",                         278, nullptr },
  { "Eth",                               722, nullptr },
  { "ae",                                667, nullptr },
  { "asterisk",                          500, nullptr },
  { "odieresis",                         500, nullptr },
  { "Uacute",                            722, nullptr },
  { "ugrave",                            500, nullptr },
  { "nine",                              500, nullptr },
  { "five",                              500, nullptr },
  { "udieresis",                         500, nullptr },
  { "Zcaron",                            611, nullptr },
  { "Scommaaccent",                      556, nullptr },
  { "threequarters",                     750, nullptr },
  { "guillemotright",                    500, nullptr },
  { "Ccedilla",                          667, nullptr },
  { "ydieresis",                         500, nullptr },
  { "tilde",                             333, nullptr },
  { "at",                                921, nullptr },
  { "eacute",                            444, nullptr },
  { "underscore",                        500, nullptr },
  { "Euro",                              500, nullptr },
  { "Dcroat",                            722, nullptr },
  { "multiply",                          564, nullptr },
  { "zero",                              500, nullptr },
  { "eth",                               500, nullptr },
  { "Scedilla",                          556, nullptr },
  { "Ograve",                            722, nullptr },
  { "Racute",                            667, nullptr },
  { "partialdiff",                       476, nullptr },
  { "uacute",                            500, nullptr },
  { "braceleft",                         480, nullptr },
  { "Thorn",                             556, nullptr },
  { "zcaron",                            444, nullptr },
  { "scommaaccent",                      389, nullptr },
  { "ccedilla",                          444, nullptr },
  { "Dcaron",                            722, nullptr },
  { "dcroat",                            500, nullptr },
  { "Ocircumflex",                       722, nullptr },
  { "Oacute",                            722, nullptr },
  { "scedilla",                          389, nullptr },
  { "ogonek",                            333, nullptr },
  { "ograve",                            500, nullptr },
  { "racute",                            333, nullptr },
  { "Tcaron",                            611, nullptr },
  { "Eogonek",                           611, nullptr },
  { "thorn",                             500, nullptr },
  { "degree",                            400, nullptr },
  { "registered",                        760, nullptr },
  { "radical",                           453, nullptr },
  { "Aring",                             722, nullptr },
  { "percent",                           833, nullptr },
  { "six",                               500, nullptr },
  { "paragraph",                         453, nullptr },
  { "dcaron",                            588, nullptr },
  { "Uogonek",                           722, nullptr },
  { "two",                               500, nullptr },
  { "summation",                         600, nullptr },
  { "Igrave",                            333, nullptr },
  { "Lacute",                            611, nullptr },
  { "ocircumflex",                       500, nullptr },
  { "oacute",                            500, nullptr },
  { "Uring",                             722, nullptr },
  { "Lcommaaccent",                      611, nullptr },
  { "tcaron",                            326, nullptr },
  { "eogonek",                           444, nullptr },
  { "Delta",                             612, nullptr },
  { "Ohungarumlaut",                     722, nullptr },
  { "asciicircum",                       469, nullptr },
  { "aring",                             444, nullptr },
  { "grave",                             333, nullptr },
  { "uogonek",                           500, nullptr },
  { "bracketright",                      333, nullptr },
  { "Iacute",                            333, nullptr },
  { "ampersand",                         778, nullptr },
  { "igrave",                            278, nullptr },
  { "lacute",                            278, nullptr },
  { "Ncaron",                            722, nullptr },
  { "plus",                              564, nullptr },
  { "uring",                             500, nullptr },
  { "quotesinglbase",                    333, nullptr },
  { "lcommaaccent",                      278, nullptr },
  { "Yacute",                            722, nullptr },
  { "ohungarumlaut",                     500, nullptr },
  { "threesuperior",                     300, nullptr },
  { "acute",                             333, nullptr },
  { "section",                           500, nullptr },
  { "dieresis",                          333, nullptr },
  { "iacute",                            278, nullptr },
  { "quotedblbase",                      444, nullptr },
  { "ncaron",                            500, nullptr },
  { "florin",                            500, nullptr },
  { "yacute",                            500, nullptr },
  { "Rcommaaccent",                      667, nullptr },
  { "fi",                                556, nullptr },
  { "fl",                                556, nullptr },
  { "Acircumflex",                       722, nullptr },
  { "Cacute",                            667, nullptr },
  { "Icircumflex",                       333, nullptr },
  { "guillemotleft",                     500, nullptr },
  { "germandbls",                        500, nullptr },
  { "Amacron",                           722, nullptr },
  { "seven",                             500, nullptr },
  { "Sacute",                            556, nullptr },
  { "ordmasculine",                      310, nullptr },
  { "dotlessi",                          278, nullptr },
  { "sterling",                          500, nullptr },
  { "notequal",                          549, nullptr },
  { "Imacron",                           333, nullptr },
  { "rcommaaccent",                      333, nullptr },
  { "Zdotaccent",                        611, nullptr },
  { "acircumflex",                       444, nullptr },
  { "cacute",                            444, nullptr },
  { "Ecaron",                            611, nullptr },
  { "icircumflex",                       278, nullptr },
  { "braceright",                        480, nullptr },
  { "quotedblright",                     444, nullptr },
  { "amacron",                           444, nullptr },
  { "sacute",                            389, nullptr },
  { "imacron",                           278, nullptr },
  { "cent",                              500, nullptr },
  { "currency",                          500, nullptr },
  { "logicalnot",                        564, nullptr },
  { "zdotaccent",                        444, nullptr },
  { "Atilde",                            722, nullptr },
  { "breve",                             333, nullptr },
  { "bar",                               200, nullptr },
  { "fraction",                          167, nullptr },
  { "less",                              564, nullptr },
  { "ecaron",                            444, nullptr },
  { "guilsinglleft",                     333, nullptr },
  { "exclam",                            333, nullptr },
  { "period",                            250, nullptr },
  { "Rcaron",                            667, nullptr },
  { "Kcommaaccent",                      722, nullptr },
  { "greater",                           564, nullptr },
  { "atilde",                            444, nullptr },
  { "brokenbar",                         200, nullptr },
  { "quoteleft",                         333, nullptr },
  { "Edotaccent",                        611, nullptr },
  { "onesuperior",                       300, nullptr }
};

static BuiltinFontWidth zapfDingbatsWidthsTab[] = {
  { "a81",                               438, nullptr },
  { "a82",                               138, nullptr },
  { "a83",                               277, nullptr },
  { "a84",                               415, nullptr },
  { "a85",                               509, nullptr },
  { "a86",                               410, nullptr },
  { "a87",                               234, nullptr },
  { "a88",                               234, nullptr },
  { "a89",                               390, nullptr },
  { "a140",                              788, nullptr },
  { "a141",                              788, nullptr },
  { "a142",                              788, nullptr },
  { "a143",                              788, nullptr },
  { "a144",                              788, nullptr },
  { "a145",                              788, nullptr },
  { "a146",                              788, nullptr },
  { "a147",                              788, nullptr },
  { "a148",                              788, nullptr },
  { "a149",                              788, nullptr },
  { "a90",                               390, nullptr },
  { "a91",                               276, nullptr },
  { "a92",                               276, nullptr },
  { "space",                             278, nullptr },
  { "a93",                               317, nullptr },
  { "a94",                               317, nullptr },
  { "a95",                               334, nullptr },
  { "a96",                               334, nullptr },
  { "a97",                               392, nullptr },
  { "a98",                               392, nullptr },
  { "a99",                               668, nullptr },
  { "a150",                              788, nullptr },
  { "a151",                              788, nullptr },
  { "a152",                              788, nullptr },
  { "a153",                              788, nullptr },
  { "a154",                              788, nullptr },
  { "a155",                              788, nullptr },
  { "a156",                              788, nullptr },
  { "a157",                              788, nullptr },
  { "a158",                              788, nullptr },
  { "a159",                              788, nullptr },
  { "a160",                              894, nullptr },
  { "a161",                              838, nullptr },
  { "a162",                              924, nullptr },
  { "a163",                             1016, nullptr },
  { "a164",                              458, nullptr },
  { "a165",                              924, nullptr },
  { "a166",                              918, nullptr },
  { "a167",                              927, nullptr },
  { "a168",                              928, nullptr },
  { "a169",                              928, nullptr },
  { "a170",                              834, nullptr },
  { "a171",                              873, nullptr },
  { "a172",                              828, nullptr },
  { "a173",                              924, nullptr },
  { "a174",                              917, nullptr },
  { "a175",                              930, nullptr },
  { "a176",                              931, nullptr },
  { "a177",                              463, nullptr },
  { "a178",                              883, nullptr },
  { "a179",                              836, nullptr },
  { "a180",                              867, nullptr },
  { "a181",                              696, nullptr },
  { "a182",                              874, nullptr },
  { "a183",                              760, nullptr },
  { "a184",                              946, nullptr },
  { "a185",                              865, nullptr },
  { "a186",                              967, nullptr },
  { "a187",                              831, nullptr },
  { "a188",                              873, nullptr },
  { "a189",                              927, nullptr },
  { "a1",                                974, nullptr },
  { "a2",                                961, nullptr },
  { "a3",                                980, nullptr },
  { "a4",                                719, nullptr },
  { "a5",                                789, nullptr },
  { "a6",                                494, nullptr },
  { "a7",                                552, nullptr },
  { "a8",                                537, nullptr },
  { "a9",                                577, nullptr },
  { "a190",                              970, nullptr },
  { "a191",                              918, nullptr },
  { "a192",                              748, nullptr },
  { "a193",                              836, nullptr },
  { "a194",                              771, nullptr },
  { "a195",                              888, nullptr },
  { "a196",                              748, nullptr },
  { "a197",                              771, nullptr },
  { "a198",                              888, nullptr },
  { "a199",                              867, nullptr },
  { "a10",                               692, nullptr },
  { "a11",                               960, nullptr },
  { "a12",                               939, nullptr },
  { "a13",                               549, nullptr },
  { "a14",                               855, nullptr },
  { "a15",                               911, nullptr },
  { "a16",                               933, nullptr },
  { "a17",                               945, nullptr },
  { "a18",                               974, nullptr },
  { "a19",                               755, nullptr },
  { "a20",                               846, nullptr },
  { "a21",                               762, nullptr },
  { "a22",                               761, nullptr },
  { "a23",                               571, nullptr },
  { "a24",                               677, nullptr },
  { "a25",                               763, nullptr },
  { "a26",                               760, nullptr },
  { "a27",                               759, nullptr },
  { "a28",                               754, nullptr },
  { "a29",                               786, nullptr },
  { "a30",                               788, nullptr },
  { "a31",                               788, nullptr },
  { "a32",                               790, nullptr },
  { "a33",                               793, nullptr },
  { "a34",                               794, nullptr },
  { "a35",                               816, nullptr },
  { "a36",                               823, nullptr },
  { "a37",                               789, nullptr },
  { "a38",                               841, nullptr },
  { "a39",                               823, nullptr },
  { "a40",                               833, nullptr },
  { "a41",                               816, nullptr },
  { "a42",                               831, nullptr },
  { "a43",                               923, nullptr },
  { "a44",                               744, nullptr },
  { "a45",                               723, nullptr },
  { "a46",                               749, nullptr },
  { "a47",                               790, nullptr },
  { "a48",                               792, nullptr },
  { "a49",                               695, nullptr },
  { "a100",                              668, nullptr },
  { "a101",                              732, nullptr },
  { "a102",                              544, nullptr },
  { "a103",                              544, nullptr },
  { "a104",                              910, nullptr },
  { "a105",                              911, nullptr },
  { "a106",                              667, nullptr },
  { "a107",                              760, nullptr },
  { "a108",                              760, nullptr },
  { "a109",                              626, nullptr },
  { "a50",                               776, nullptr },
  { "a51",                               768, nullptr },
  { "a52",                               792, nullptr },
  { "a53",                               759, nullptr },
  { "a54",                               707, nullptr },
  { "a55",                               708, nullptr },
  { "a56",                               682, nullptr },
  { "a57",                               701, nullptr },
  { "a58",                               826, nullptr },
  { "a59",                               815, nullptr },
  { "a110",                              694, nullptr },
  { "a111",                              595, nullptr },
  { "a112",                              776, nullptr },
  { "a117",                              690, nullptr },
  { "a118",                              791, nullptr },
  { "a119",                              790, nullptr },
  { "a60",                               789, nullptr },
  { "a61",                               789, nullptr },
  { "a62",                               707, nullptr },
  { "a63",                               687, nullptr },
  { "a64",                               696, nullptr },
  { "a65",                               689, nullptr },
  { "a66",                               786, nullptr },
  { "a67",                               787, nullptr },
  { "a68",                               713, nullptr },
  { "a69",                               791, nullptr },
  { "a200",                              696, nullptr },
  { "a201",                              874, nullptr },
  { "a120",                              788, nullptr },
  { "a121",                              788, nullptr },
  { "a202",                              974, nullptr },
  { "a122",                              788, nullptr },
  { "a203",                              762, nullptr },
  { "a123",                              788, nullptr },
  { "a204",                              759, nullptr },
  { "a124",                              788, nullptr },
  { "a205",                              509, nullptr },
  { "a125",                              788, nullptr },
  { "a206",                              410, nullptr },
  { "a126",                              788, nullptr },
  { "a127",                              788, nullptr },
  { "a128",                              788, nullptr },
  { "a129",                              788, nullptr },
  { "a70",                               785, nullptr },
  { "a71",                               791, nullptr },
  { "a72",                               873, nullptr },
  { "a73",                               761, nullptr },
  { "a74",                               762, nullptr },
  { "a75",                               759, nullptr },
  { "a76",                               892, nullptr },
  { "a77",                               892, nullptr },
  { "a78",                               788, nullptr },
  { "a79",                               784, nullptr },
  { "a130",                              788, nullptr },
  { "a131",                              788, nullptr },
  { "a132",                              788, nullptr },
  { "a133",                              788, nullptr },
  { "a134",                              788, nullptr },
  { "a135",                              788, nullptr },
  { "a136",                              788, nullptr },
  { "a137",                              788, nullptr },
  { "a138",                              788, nullptr },
  { "a139",                              788, nullptr }
};

BuiltinFont builtinFonts[] = {
  { "Courier",               standardEncoding,            629, -157, { -23, -250,  715,  805}, nullptr },
  { "Courier-Bold",          standardEncoding,            629, -157, {-113, -250,  749,  801}, nullptr },
  { "Courier-BoldOblique",   standardEncoding,            629, -157, { -57, -250,  869,  801}, nullptr },
  { "Courier-Oblique",       standardEncoding,            629, -157, { -27, -250,  849,  805}, nullptr },
  { "Helvetica",             standardEncoding,            718, -207, {-166, -225, 1000,  931}, nullptr },
  { "Helvetica-Bold",        standardEncoding,            718, -207, {-170, -228, 1003,  962}, nullptr },
  { "Helvetica-BoldOblique", standardEncoding,            718, -207, {-174, -228, 1114,  962}, nullptr },
  { "Helvetica-Oblique",     standardEncoding,            718, -207, {-170, -225, 1116,  931}, nullptr },
  { "Symbol",                symbolEncoding,             1010, -293, {-180, -293, 1090, 1010}, nullptr },
  { "Times-Bold",            standardEncoding,            683, -217, {-168, -218, 1000,  935}, nullptr },
  { "Times-BoldItalic",      standardEncoding,            683, -217, {-200, -218,  996,  921}, nullptr },
  { "Times-Italic",          standardEncoding,            683, -217, {-169, -217, 1010,  883}, nullptr },
  { "Times-Roman",           standardEncoding,            683, -217, {-168, -218, 1000,  898}, nullptr },
  { "ZapfDingbats",          zapfDingbatsEncoding,        820, -143, {  -1, -143,  981,  820}, nullptr }
};

BuiltinFont *builtinFontSubst[] = {
  &builtinFonts[0],
  &builtinFonts[3],
  &builtinFonts[1],
  &builtinFonts[2],
  &builtinFonts[4],
  &builtinFonts[7],
  &builtinFonts[5],
  &builtinFonts[6],
  &builtinFonts[12],
  &builtinFonts[11],
  &builtinFonts[9],
  &builtinFonts[10]
};

void initBuiltinFontTables() {
  builtinFonts[0].widths = new BuiltinFontWidths(courierWidthsTab, 315);
  builtinFonts[1].widths = new BuiltinFontWidths(courierBoldWidthsTab, 315);
  builtinFonts[2].widths = new BuiltinFontWidths(courierBoldObliqueWidthsTab, 315);
  builtinFonts[3].widths = new BuiltinFontWidths(courierObliqueWidthsTab, 315);
  builtinFonts[4].widths = new BuiltinFontWidths(helveticaWidthsTab, 315);
  builtinFonts[5].widths = new BuiltinFontWidths(helveticaBoldWidthsTab, 316);
  builtinFonts[6].widths = new BuiltinFontWidths(helveticaBoldObliqueWidthsTab, 315);
  builtinFonts[7].widths = new BuiltinFontWidths(helveticaObliqueWidthsTab, 315);
  builtinFonts[8].widths = new BuiltinFontWidths(symbolWidthsTab, 190);
  builtinFonts[9].widths = new BuiltinFontWidths(timesBoldWidthsTab, 315);
  builtinFonts[10].widths = new BuiltinFontWidths(timesBoldItalicWidthsTab, 315);
  builtinFonts[11].widths = new BuiltinFontWidths(timesItalicWidthsTab, 315);
  builtinFonts[12].widths = new BuiltinFontWidths(timesRomanWidthsTab, 315);
  builtinFonts[13].widths = new BuiltinFontWidths(zapfDingbatsWidthsTab, 202);
}

void freeBuiltinFontTables() {
  int i;

  for (i = 0; i < 14; ++i) {
    delete builtinFonts[i].widths;
  }
}
