// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{ffi, BaselinePosition, LayoutManager};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkGridLayout")]
    pub struct GridLayout(Object<ffi::GtkGridLayout, ffi::GtkGridLayoutClass>) @extends LayoutManager;

    match fn {
        type_ => || ffi::gtk_grid_layout_get_type(),
    }
}

impl GridLayout {
    #[doc(alias = "gtk_grid_layout_new")]
    pub fn new() -> GridLayout {
        assert_initialized_main_thread!();
        unsafe { LayoutManager::from_glib_full(ffi::gtk_grid_layout_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`GridLayout`] objects.
    ///
    /// This method returns an instance of [`GridLayoutBuilder`](crate::builders::GridLayoutBuilder) which can be used to create [`GridLayout`] objects.
    pub fn builder() -> GridLayoutBuilder {
        GridLayoutBuilder::new()
    }

    #[doc(alias = "gtk_grid_layout_get_baseline_row")]
    #[doc(alias = "get_baseline_row")]
    #[doc(alias = "baseline-row")]
    pub fn baseline_row(&self) -> i32 {
        unsafe { ffi::gtk_grid_layout_get_baseline_row(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_grid_layout_get_column_homogeneous")]
    #[doc(alias = "get_column_homogeneous")]
    #[doc(alias = "column-homogeneous")]
    pub fn is_column_homogeneous(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_grid_layout_get_column_homogeneous(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_grid_layout_get_column_spacing")]
    #[doc(alias = "get_column_spacing")]
    #[doc(alias = "column-spacing")]
    pub fn column_spacing(&self) -> u32 {
        unsafe { ffi::gtk_grid_layout_get_column_spacing(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_grid_layout_get_row_baseline_position")]
    #[doc(alias = "get_row_baseline_position")]
    pub fn row_baseline_position(&self, row: i32) -> BaselinePosition {
        unsafe {
            from_glib(ffi::gtk_grid_layout_get_row_baseline_position(
                self.to_glib_none().0,
                row,
            ))
        }
    }

    #[doc(alias = "gtk_grid_layout_get_row_homogeneous")]
    #[doc(alias = "get_row_homogeneous")]
    #[doc(alias = "row-homogeneous")]
    pub fn is_row_homogeneous(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_grid_layout_get_row_homogeneous(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_grid_layout_get_row_spacing")]
    #[doc(alias = "get_row_spacing")]
    #[doc(alias = "row-spacing")]
    pub fn row_spacing(&self) -> u32 {
        unsafe { ffi::gtk_grid_layout_get_row_spacing(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_grid_layout_set_baseline_row")]
    #[doc(alias = "baseline-row")]
    pub fn set_baseline_row(&self, row: i32) {
        unsafe {
            ffi::gtk_grid_layout_set_baseline_row(self.to_glib_none().0, row);
        }
    }

    #[doc(alias = "gtk_grid_layout_set_column_homogeneous")]
    #[doc(alias = "column-homogeneous")]
    pub fn set_column_homogeneous(&self, homogeneous: bool) {
        unsafe {
            ffi::gtk_grid_layout_set_column_homogeneous(
                self.to_glib_none().0,
                homogeneous.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_grid_layout_set_column_spacing")]
    #[doc(alias = "column-spacing")]
    pub fn set_column_spacing(&self, spacing: u32) {
        unsafe {
            ffi::gtk_grid_layout_set_column_spacing(self.to_glib_none().0, spacing);
        }
    }

    #[doc(alias = "gtk_grid_layout_set_row_baseline_position")]
    pub fn set_row_baseline_position(&self, row: i32, pos: BaselinePosition) {
        unsafe {
            ffi::gtk_grid_layout_set_row_baseline_position(
                self.to_glib_none().0,
                row,
                pos.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_grid_layout_set_row_homogeneous")]
    #[doc(alias = "row-homogeneous")]
    pub fn set_row_homogeneous(&self, homogeneous: bool) {
        unsafe {
            ffi::gtk_grid_layout_set_row_homogeneous(
                self.to_glib_none().0,
                homogeneous.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_grid_layout_set_row_spacing")]
    #[doc(alias = "row-spacing")]
    pub fn set_row_spacing(&self, spacing: u32) {
        unsafe {
            ffi::gtk_grid_layout_set_row_spacing(self.to_glib_none().0, spacing);
        }
    }

    #[doc(alias = "baseline-row")]
    pub fn connect_baseline_row_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_baseline_row_trampoline<F: Fn(&GridLayout) + 'static>(
            this: *mut ffi::GtkGridLayout,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::baseline-row".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_baseline_row_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "column-homogeneous")]
    pub fn connect_column_homogeneous_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_column_homogeneous_trampoline<F: Fn(&GridLayout) + 'static>(
            this: *mut ffi::GtkGridLayout,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::column-homogeneous".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_column_homogeneous_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "column-spacing")]
    pub fn connect_column_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_column_spacing_trampoline<F: Fn(&GridLayout) + 'static>(
            this: *mut ffi::GtkGridLayout,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::column-spacing".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_column_spacing_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "row-homogeneous")]
    pub fn connect_row_homogeneous_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_row_homogeneous_trampoline<F: Fn(&GridLayout) + 'static>(
            this: *mut ffi::GtkGridLayout,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::row-homogeneous".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_row_homogeneous_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "row-spacing")]
    pub fn connect_row_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_row_spacing_trampoline<F: Fn(&GridLayout) + 'static>(
            this: *mut ffi::GtkGridLayout,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::row-spacing".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_row_spacing_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for GridLayout {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`GridLayout`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct GridLayoutBuilder {
    builder: glib::object::ObjectBuilder<'static, GridLayout>,
}

impl GridLayoutBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn baseline_row(self, baseline_row: i32) -> Self {
        Self {
            builder: self.builder.property("baseline-row", baseline_row),
        }
    }

    pub fn column_homogeneous(self, column_homogeneous: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("column-homogeneous", column_homogeneous),
        }
    }

    pub fn column_spacing(self, column_spacing: i32) -> Self {
        Self {
            builder: self.builder.property("column-spacing", column_spacing),
        }
    }

    pub fn row_homogeneous(self, row_homogeneous: bool) -> Self {
        Self {
            builder: self.builder.property("row-homogeneous", row_homogeneous),
        }
    }

    pub fn row_spacing(self, row_spacing: i32) -> Self {
        Self {
            builder: self.builder.property("row-spacing", row_spacing),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`GridLayout`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> GridLayout {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}
