// Generated by re2java
// re2java $INPUT -o $OUTPUT

class Parser {
    private String yyinput;
    private int yycursor;
    private int yymarker;
    private int number;

    private void add_digit(int base, int offset) throws ArithmeticException {
        number = Math.addExact(
            Math.multiplyExact(number, base),
            yyinput.charAt(yycursor - 1) - offset);
    }

    public int parse(String str) throws ArithmeticException, IllegalArgumentException {
        yyinput = str;
        yycursor = 0;
        number = 0;

        try {
            
{
    char yych = 0;
    int yystate = 0;
    yyl: while (true) {
        switch (yystate) {
            case 0:
                yych = yyinput.charAt(yycursor);
                yycursor += 1;
                switch (yych) {
                    case 0x30:
                        yystate = 2;
                        continue yyl;
                    case 0x31:
                    case 0x32:
                    case 0x33:
                    case 0x34:
                    case 0x35:
                    case 0x36:
                    case 0x37:
                    case 0x38:
                    case 0x39:
                        yystate = 4;
                        continue yyl;
                    default:
                        yystate = 1;
                        continue yyl;
                }
            case 1:
                { throw new IllegalArgumentException("not a number"); }
            case 2:
                yymarker = yycursor;
                yych = yyinput.charAt(yycursor);
                switch (yych) {
                    case 0x42:
                    case 0x62:
                        yycursor += 1;
                        yystate = 5;
                        continue yyl;
                    case 0x58:
                    case 0x78:
                        yycursor += 1;
                        yystate = 7;
                        continue yyl;
                    default:
                        yystate = 3;
                        continue yyl;
                }
            case 3:
                { return parse_oct(); }
            case 4:
                yycursor -= 1;
                { return parse_dec(); }
            case 5:
                yych = yyinput.charAt(yycursor);
                switch (yych) {
                    case 0x30:
                    case 0x31:
                        yycursor += 1;
                        yystate = 8;
                        continue yyl;
                    default:
                        yystate = 6;
                        continue yyl;
                }
            case 6:
                yycursor = yymarker;
                yystate = 3;
                continue yyl;
            case 7:
                yych = yyinput.charAt(yycursor);
                switch (yych) {
                    case 0x30:
                    case 0x31:
                    case 0x32:
                    case 0x33:
                    case 0x34:
                    case 0x35:
                    case 0x36:
                    case 0x37:
                    case 0x38:
                    case 0x39:
                    case 0x41:
                    case 0x42:
                    case 0x43:
                    case 0x44:
                    case 0x45:
                    case 0x46:
                    case 0x61:
                    case 0x62:
                    case 0x63:
                    case 0x64:
                    case 0x65:
                    case 0x66:
                        yycursor += 1;
                        yystate = 9;
                        continue yyl;
                    default:
                        yystate = 6;
                        continue yyl;
                }
            case 8:
                yycursor -= 1;
                { return parse_bin(); }
            case 9:
                yycursor -= 1;
                { return parse_hex(); }
            default:
                throw new IllegalStateException("internal lexer error");
        }
    }
}

        } catch (Exception e) {
            return -1;
        }
    }

    private int parse_bin() throws ArithmeticException, IllegalArgumentException {
        
{
    char yych = 0;
    int yystate = 0;
    yyl: while (true) {
        switch (yystate) {
            case 0:
                yych = yyinput.charAt(yycursor);
                yycursor += 1;
                switch (yych) {
                    case 0x00:
                        yystate = 1;
                        continue yyl;
                    case 0x30:
                    case 0x31:
                        yystate = 3;
                        continue yyl;
                    default:
                        yystate = 2;
                        continue yyl;
                }
            case 1:
                { return number; }
            case 2:
                { throw new IllegalArgumentException("ill-formed binary number"); }
            case 3:
                { add_digit(2, 48); return parse_bin(); }
            default:
                throw new IllegalStateException("internal lexer error");
        }
    }
}

    }

    private int parse_oct() throws ArithmeticException, IllegalArgumentException {
        
{
    char yych = 0;
    int yystate = 0;
    yyl: while (true) {
        switch (yystate) {
            case 0:
                yych = yyinput.charAt(yycursor);
                yycursor += 1;
                switch (yych) {
                    case 0x00:
                        yystate = 1;
                        continue yyl;
                    case 0x30:
                    case 0x31:
                    case 0x32:
                    case 0x33:
                    case 0x34:
                    case 0x35:
                    case 0x36:
                    case 0x37:
                        yystate = 3;
                        continue yyl;
                    default:
                        yystate = 2;
                        continue yyl;
                }
            case 1:
                { return number; }
            case 2:
                { throw new IllegalArgumentException("ill-formed octal number"); }
            case 3:
                { add_digit(8, 48); return parse_oct(); }
            default:
                throw new IllegalStateException("internal lexer error");
        }
    }
}

    }

    private int parse_dec() throws ArithmeticException, IllegalArgumentException {
        
{
    char yych = 0;
    int yystate = 0;
    yyl: while (true) {
        switch (yystate) {
            case 0:
                yych = yyinput.charAt(yycursor);
                yycursor += 1;
                switch (yych) {
                    case 0x00:
                        yystate = 1;
                        continue yyl;
                    case 0x30:
                    case 0x31:
                    case 0x32:
                    case 0x33:
                    case 0x34:
                    case 0x35:
                    case 0x36:
                    case 0x37:
                    case 0x38:
                    case 0x39:
                        yystate = 3;
                        continue yyl;
                    default:
                        yystate = 2;
                        continue yyl;
                }
            case 1:
                { return number; }
            case 2:
                { throw new IllegalArgumentException("ill-formed decimal number"); }
            case 3:
                { add_digit(10, 48); return parse_dec(); }
            default:
                throw new IllegalStateException("internal lexer error");
        }
    }
}

    }

    private int parse_hex() throws ArithmeticException, IllegalArgumentException {
        
{
    char yych = 0;
    int yystate = 0;
    yyl: while (true) {
        switch (yystate) {
            case 0:
                yych = yyinput.charAt(yycursor);
                yycursor += 1;
                switch (yych) {
                    case 0x00:
                        yystate = 1;
                        continue yyl;
                    case 0x30:
                    case 0x31:
                    case 0x32:
                    case 0x33:
                    case 0x34:
                    case 0x35:
                    case 0x36:
                    case 0x37:
                    case 0x38:
                    case 0x39:
                        yystate = 3;
                        continue yyl;
                    case 0x41:
                    case 0x42:
                    case 0x43:
                    case 0x44:
                    case 0x45:
                    case 0x46:
                        yystate = 4;
                        continue yyl;
                    case 0x61:
                    case 0x62:
                    case 0x63:
                    case 0x64:
                    case 0x65:
                    case 0x66:
                        yystate = 5;
                        continue yyl;
                    default:
                        yystate = 2;
                        continue yyl;
                }
            case 1:
                { return number; }
            case 2:
                { throw new IllegalArgumentException("ill-formed hexadecimal number"); }
            case 3:
                { add_digit(16, 48); return parse_hex(); }
            case 4:
                { add_digit(16, 55); return parse_hex(); }
            case 5:
                { add_digit(16, 87); return parse_hex(); }
            default:
                throw new IllegalStateException("internal lexer error");
        }
    }
}

    }

    public static void main(String []args) {
        Parser parser = new Parser();
        assert parser.parse("1234567890\0") == 1234567890;
        assert parser.parse("0b1101\0") == 0b1101;
        assert parser.parse("0x007Fe\0") == 0x7fe;
        assert parser.parse("0644\0") == 0644;
        assert parser.parse("9999999999\0") == -1;
        assert parser.parse("123??\0") == -1;
    }
};
