/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_SW_INC_UNOPRNMS_HXX
#define INCLUDED_SW_INC_UNOPRNMS_HXX

#include <sal/config.h>

#define UNO_NAME_FOLLOW_STYLE "FollowStyle"
#define UNO_NAME_LINK_STYLE "LinkStyle"
#define UNO_NAME_IS_PHYSICAL "IsPhysical"
#define UNO_NAME_IS_AUTO_UPDATE "IsAutoUpdate"
#define UNO_NAME_DISPLAY_NAME "DisplayName"
#define UNO_NAME_PARA_GRAPHIC "ParaBackGraphic"
#define UNO_NAME_PARA_GRAPHIC_URL "ParaBackGraphicURL"
#define UNO_NAME_PARA_GRAPHIC_FILTER "ParaBackGraphicFilter"
#define UNO_NAME_HEADER_GRAPHIC "HeaderBackGraphic"
#define UNO_NAME_HEADER_GRAPHIC_URL "HeaderBackGraphicURL"
#define UNO_NAME_HEADER_GRAPHIC_FILTER "HeaderBackGraphicFilter"
#define UNO_NAME_FOOTER_GRAPHIC "FooterBackGraphic"
#define UNO_NAME_FOOTER_GRAPHIC_URL "FooterBackGraphicURL"
#define UNO_NAME_FOOTER_GRAPHIC_FILTER "FooterBackGraphicFilter"
#define UNO_NAME_BACK_GRAPHIC_URL "BackGraphicURL"
#define UNO_NAME_BACK_GRAPHIC "BackGraphic"
#define UNO_NAME_BACK_GRAPHIC_FILTER "BackGraphicFilter"
#define UNO_NAME_BACK_GRAPHIC_LOCATION "BackGraphicLocation"
#define UNO_NAME_GRAPHIC_FILTER "GraphicFilter"
#define UNO_NAME_GRAPHIC_SIZE "GraphicSize"
#define UNO_NAME_GRAPHIC_BITMAP "GraphicBitmap"
#define UNO_NAME_GRAPHIC_URL "GraphicURL"
#define UNO_NAME_BULLET_ID "BulletId"
#define UNO_NAME_BULLET_CHAR "BulletChar"
#define UNO_NAME_BULLET_REL_SIZE "BulletRelSize"
#define UNO_NAME_BULLET_FONT "BulletFont"
#define UNO_NAME_BULLET_FONT_NAME "BulletFontName"
#define UNO_NAME_BULLET_COLOR "BulletColor"
#define UNO_NAME_PARA_GRAPHIC_LOCATION "ParaBackGraphicLocation"
#define UNO_NAME_HEADER_GRAPHIC_LOCATION "HeaderBackGraphicLocation"
#define UNO_NAME_FOOTER_GRAPHIC_LOCATION "FooterBackGraphicLocation"
#define UNO_NAME_PARA_LEFT_MARGIN "ParaLeftMargin"
#define UNO_NAME_PARA_RIGHT_MARGIN "ParaRightMargin"
#define UNO_NAME_PARA_LEFT_MARGIN_RELATIVE "ParaLeftMarginRelative"
#define UNO_NAME_PARA_RIGHT_MARGIN_RELATIVE "ParaRightMarginRelative"
#define UNO_NAME_PARA_IS_AUTO_FIRST_LINE_INDENT "ParaIsAutoFirstLineIndent"
#define UNO_NAME_PARA_FIRST_LINE_INDENT "ParaFirstLineIndent"
#define UNO_NAME_PARA_FIRST_LINE_INDENT_RELATIVE "ParaFirstLineIndentRelative"
#define UNO_NAME_PARA_IS_HYPHENATION "ParaIsHyphenation"
#define UNO_NAME_PARA_HYPHENATION_MAX_LEADING_CHARS "ParaHyphenationMaxLeadingChars"
#define UNO_NAME_PARA_HYPHENATION_MAX_TRAILING_CHARS "ParaHyphenationMaxTrailingChars"
#define UNO_NAME_PARA_HYPHENATION_MAX_HYPHENS "ParaHyphenationMaxHyphens"
#define UNO_NAME_PARA_HYPHENATION_NO_CAPS "ParaHyphenationNoCaps"
#define UNO_NAME_LEFT_MARGIN "LeftMargin"
#define UNO_NAME_RIGHT_MARGIN "RightMargin"
#define UNO_NAME_GUTTER_MARGIN "GutterMargin"
#define UNO_NAME_HEADER_LEFT_MARGIN "HeaderLeftMargin"
#define UNO_NAME_HEADER_RIGHT_MARGIN "HeaderRightMargin"
#define UNO_NAME_FOOTER_LEFT_MARGIN "FooterLeftMargin"
#define UNO_NAME_FOOTER_RIGHT_MARGIN "FooterRightMargin"
#define UNO_NAME_TEXT_RANGE "TextRange"
#define UNO_NAME_TEXT_BOX "TextBox"
#define UNO_NAME_NAME "Name"
#define UNO_NAME_CHAR_STYLE_NAME "CharStyleName"
#define UNO_NAME_ANCHOR_CHAR_STYLE_NAME "AnchorCharStyleName"
#define UNO_NAME_SUFFIX "Suffix"
#define UNO_NAME_PREFIX "Prefix"
#define UNO_NAME_LIST_FORMAT "ListFormat"
#define UNO_NAME_PARENT_NUMBERING "ParentNumbering"
#define UNO_NAME_CHAR_FONT_NAME "CharFontName"
#define UNO_NAME_CHAR_FONT_STYLE_NAME "CharFontStyleName"
#define UNO_NAME_CHAR_FONT_FAMILY "CharFontFamily"
#define UNO_NAME_CHAR_FONT_CHAR_SET "CharFontCharSet"
#define UNO_NAME_CHAR_FONT_PITCH "CharFontPitch"
#define UNO_NAME_CHAR_LOCALE "CharLocale"
#define UNO_NAME_CHAR_FONT_NAME_ASIAN "CharFontNameAsian"
#define UNO_NAME_CHAR_FONT_STYLE_NAME_ASIAN "CharFontStyleNameAsian"
#define UNO_NAME_CHAR_FONT_FAMILY_ASIAN "CharFontFamilyAsian"
#define UNO_NAME_CHAR_FONT_CHAR_SET_ASIAN "CharFontCharSetAsian"
#define UNO_NAME_CHAR_FONT_PITCH_ASIAN "CharFontPitchAsian"
#define UNO_NAME_CHAR_POSTURE_ASIAN "CharPostureAsian"
#define UNO_NAME_CHAR_WEIGHT_ASIAN "CharWeightAsian"
#define UNO_NAME_CHAR_HEIGHT_ASIAN "CharHeightAsian"
#define UNO_NAME_CHAR_LOCALE_ASIAN "CharLocaleAsian"
#define UNO_NAME_CHAR_FONT_NAME_COMPLEX "CharFontNameComplex"
#define UNO_NAME_CHAR_FONT_STYLE_NAME_COMPLEX "CharFontStyleNameComplex"
#define UNO_NAME_CHAR_FONT_FAMILY_COMPLEX "CharFontFamilyComplex"
#define UNO_NAME_CHAR_FONT_CHAR_SET_COMPLEX "CharFontCharSetComplex"
#define UNO_NAME_CHAR_FONT_PITCH_COMPLEX "CharFontPitchComplex"
#define UNO_NAME_CHAR_POSTURE_COMPLEX "CharPostureComplex"
#define UNO_NAME_CHAR_WEIGHT_COMPLEX "CharWeightComplex"
#define UNO_NAME_CHAR_HEIGHT_COMPLEX "CharHeightComplex"
#define UNO_NAME_CHAR_LOCALE_COMPLEX "CharLocaleComplex"
#define UNO_NAME_CHAR_AUTO_KERNING "CharAutoKerning"
#define UNO_NAME_CHAR_UNDERLINE_COLOR "CharUnderlineColor"
#define UNO_NAME_CHAR_UNDERLINE_HAS_COLOR "CharUnderlineHasColor"
#define UNO_NAME_CHAR_ESCAPEMENT "CharEscapement"
#define UNO_NAME_CHAR_CASE_MAP "CharCaseMap"
#define UNO_NAME_CHAR_STRIKEOUT "CharStrikeout"
#define UNO_NAME_CHAR_CROSSED_OUT "CharCrossedOut"
#define UNO_NAME_CHAR_NO_HYPHENATION "CharNoHyphenation"
#define UNO_NAME_CHAR_AUTO_ESCAPEMENT "CharAutoEscapement"
#define UNO_NAME_CHAR_PROP_HEIGHT "CharPropHeight"
#define UNO_NAME_CHAR_DIFF_HEIGHT "CharDiffHeight"
#define UNO_NAME_CHAR_PROP_HEIGHT_ASIAN "CharPropHeightAsian"
#define UNO_NAME_CHAR_DIFF_HEIGHT_ASIAN "CharDiffHeightAsian"
#define UNO_NAME_CHAR_PROP_HEIGHT_COMPLEX "CharPropHeightComplex"
#define UNO_NAME_CHAR_DIFF_HEIGHT_COMPLEX "CharDiffHeightComplex"
#define UNO_NAME_CHAR_ESCAPEMENT_HEIGHT "CharEscapementHeight"
#define UNO_NAME_CHAR_TRANSPARENCE "CharTransparence"
#define UNO_NAME_HIDE_TAB_LEADER_AND_PAGE_NUMBERS "HideTabLeaderAndPageNumber"
#define UNO_NAME_TAB_IN_TOC "TabInTOC"
#define UNO_NAME_TOC_BOOKMARK "TOCBookmark"
#define UNO_NAME_TOC_NEWLINE "TOCNewLine"
#define UNO_NAME_TOC_PARAGRAPH_OUTLINE_LEVEL "TOCParagraphOutlineLevel"

#define UNO_NAME_CHAR_FLASH "CharFlash"
#define UNO_NAME_CHAR_KERNING "CharKerning"
#define UNO_NAME_CHAR_BACK_COLOR "CharBackColor"
#define UNO_NAME_CHAR_BACK_TRANSPARENT "CharBackTransparent"
#define UNO_NAME_CHAR_COMBINE_IS_ON "CharCombineIsOn"
#define UNO_NAME_CHAR_COMBINE_PREFIX "CharCombinePrefix"
#define UNO_NAME_CHAR_COMBINE_SUFFIX "CharCombineSuffix"
#define UNO_NAME_CHAR_EMPHASIS "CharEmphasis"
#define UNO_NAME_PARA_LINE_SPACING "ParaLineSpacing"
#define UNO_NAME_PARA_TOP_MARGIN "ParaTopMargin"
#define UNO_NAME_PARA_BOTTOM_MARGIN "ParaBottomMargin"
#define UNO_NAME_PARA_TOP_MARGIN_RELATIVE "ParaTopMarginRelative"
#define UNO_NAME_PARA_BOTTOM_MARGIN_RELATIVE "ParaBottomMarginRelative"
#define UNO_NAME_PARA_EXPAND_SINGLE_WORD "ParaExpandSingleWord"
#define UNO_NAME_END_NOTICE "EndNotice"
#define UNO_NAME_BEGIN_NOTICE "BeginNotice"
#define UNO_NAME_FRAME_STYLE_NAME "FrameStyleName"
#define UNO_NAME_NUMBERING_STYLE_NAME "NumberingStyleName"
#define UNO_NAME_NUMBERING_START_VALUE "NumberingStartValue"
#define UNO_NAME_NUMBERING_IS_NUMBER "NumberingIsNumber"
#define UNO_NAME_COUNT_LINES_IN_FRAMES "CountLinesInFrames"
#define UNO_NAME_DDE_COMMAND_TYPE "DDECommandType"
#define UNO_NAME_DDE_COMMAND_FILE "DDECommandFile"
#define UNO_NAME_DDE_COMMAND_ELEMENT "DDECommandElement"
#define UNO_NAME_IS_AUTOMATIC_UPDATE "IsAutomaticUpdate"
#define UNO_NAME_DISTANCE "Distance"
#define UNO_NAME_DROP_CAP_FORMAT "DropCapFormat"
#define UNO_NAME_DROP_CAP_WHOLE_WORD "DropCapWholeWord"
#define UNO_NAME_DROP_CAP_CHAR_STYLE_NAME "DropCapCharStyleName"
#define UNO_NAME_FILE_LINK "FileLink"
#define UNO_NAME_GRAPHIC "Graphic"
#define UNO_NAME_TRANSFORMED_GRAPHIC "TransformedGraphic"
#define UNO_NAME_IS_PROTECTED "IsProtected"
#define UNO_NAME_PARA_KEEP_TOGETHER "ParaKeepTogether"
#define UNO_NAME_KEEP_TOGETHER "KeepTogether"
#define UNO_NAME_IS_LANDSCAPE "IsLandscape"
#define UNO_NAME_SEPARATOR_TEXT "SeparatorText"
#define UNO_NAME_NUMBER_POSITION "NumberPosition"
#define UNO_NAME_PAGE_STYLE_NAME "PageStyleName"
#define UNO_NAME_PAGE_STYLE_LAYOUT "PageStyleLayout"
#define UNO_NAME_PARA_ADJUST "ParaAdjust"
#define UNO_NAME_PARA_REGISTER_MODE_ACTIVE "ParaRegisterModeActive"
#define UNO_NAME_PARA_STYLE_NAME "ParaStyleName"
#define UNO_NAME_PARA_LAST_LINE_ADJUST "ParaLastLineAdjust"
#define UNO_NAME_PARA_LINE_NUMBER_COUNT "ParaLineNumberCount"
#define UNO_NAME_PARA_LINE_NUMBER_START_VALUE "ParaLineNumberStartValue"
#define UNO_NAME_BACK_COLOR "BackColor"
#define UNO_NAME_PARA_BACK_COLOR "ParaBackColor"
#define UNO_NAME_PARA_WIDOWS "ParaWidows"
#define UNO_NAME_PARA_ORPHANS "ParaOrphans"
#define UNO_NAME_PARA_BACK_TRANSPARENT "ParaBackTransparent"
#define UNO_NAME_POSITION_END_OF_DOC "PositionEndOfDoc"
#define UNO_NAME_POSITION_PROTECTED "PositionProtected"
#define UNO_NAME_ALTERNATIVE_TEXT "AlternativeText"
#define UNO_NAME_PRIMARY_KEY "PrimaryKey"
#define UNO_NAME_PRINTER_PAPER_TRAY "PrinterPaperTray"
#define UNO_NAME_REGISTER_MODE_ACTIVE "RegisterModeActive"
#define UNO_NAME_RELATIVE_WIDTH "RelativeWidth"
#define UNO_NAME_RELATIVE_WIDTH_RELATION "RelativeWidthRelation"
#define UNO_NAME_RELATIVE_HEIGHT "RelativeHeight"
#define UNO_NAME_RELATIVE_HEIGHT_RELATION "RelativeHeightRelation"
#define UNO_NAME_REPEAT_HEADLINE "RepeatHeadline"
#define UNO_NAME_SEARCH_STYLES "SearchStyles"
#define UNO_NAME_SEARCH_BACKWARDS "SearchBackwards"
#define UNO_NAME_SEARCH_SIMILARITY "SearchSimilarity"
#define UNO_NAME_SEARCH_CASE_SENSITIVE "SearchCaseSensitive"
#define UNO_NAME_SEARCH_SIMILARITY_ADD "SearchSimilarityAdd"
#define UNO_NAME_SEARCH_SIMILARITY_RELAX "SearchSimilarityRelax"
#define UNO_NAME_SEARCH_SIMILARITY_REMOVE "SearchSimilarityRemove"
#define UNO_NAME_SEARCH_REGULAR_EXPRESSION "SearchRegularExpression"
#define UNO_NAME_SEARCH_SIMILARITY_EXCHANGE "SearchSimilarityExchange"
#define UNO_NAME_SECONDARY_KEY "SecondaryKey"
#define UNO_NAME_SEPARATOR_INTERVAL "SeparatorInterval"
#define UNO_NAME_SHOW_BREAKS "ShowBreaks"
#define UNO_NAME_SHOW_SPACES "ShowSpaces"
#define UNO_NAME_SHOW_TABLES "ShowTables"
#define UNO_NAME_SHOW_GRAPHICS "ShowGraphics"

#define UNO_NAME_SHOW_DRAWINGS "ShowDrawings"
#define UNO_NAME_SHOW_TABSTOPS "ShowTabstops"
#define UNO_NAME_SHOW_VERT_RULER "ShowVertRuler"
#define UNO_NAME_SHOW_PARA_BREAKS "ShowParaBreaks"
#define UNO_NAME_SHOW_HIDDEN_TEXT "ShowHiddenText"
#define UNO_NAME_SHOW_SOFT_HYPHENS "ShowSoftHyphens"
#define UNO_NAME_SHOW_VERT_SCROLL_BAR "ShowVertScrollBar"
#define UNO_NAME_SHOW_HORI_SCROLL_BAR "ShowHoriScrollBar"
#define UNO_NAME_SHOW_FIELD_COMMANDS "ShowFieldCommands"
#define UNO_NAME_SHOW_PROTECTED_SPACES "ShowProtectedSpaces"
#define UNO_NAME_SHOW_HIDDEN_PARAGRAPHS "ShowHiddenParagraphs"
#define UNO_NAME_HIDE_WHITESPACE "HideWhitespace"
#define UNO_NAME_IS_SYNC_WIDTH_TO_HEIGHT "IsSyncWidthToHeight"
#define UNO_NAME_IS_SYNC_HEIGHT_TO_WIDTH "IsSyncHeightToWidth"
#define UNO_NAME_SIZE_PROTECTED "SizeProtected"
#define UNO_NAME_TEXT_COLUMNS "TextColumns"
#define UNO_NAME_BACK_TRANSPARENT "BackTransparent"
#define UNO_NAME_ANCHOR_TYPE "AnchorType"
#define UNO_NAME_ANCHOR_TYPES "AnchorTypes"
#define UNO_NAME_ANCHOR_PAGE_NO "AnchorPageNo"
#define UNO_NAME_ANCHOR_FRAME "AnchorFrame"
#define UNO_NAME_AUTHOR "Author"
#define UNO_NAME_BREAK_TYPE "BreakType"
#define UNO_NAME_CHAIN_NEXT_NAME "ChainNextName"
#define UNO_NAME_CHAIN_PREV_NAME "ChainPrevName"
#define UNO_NAME_CHAIN_NAME "ChainName"
#define UNO_NAME_CHAPTER_FORMAT "ChapterFormat"
#define UNO_NAME_CLIENT_MAP "ClientMap"
#define UNO_NAME_CONDITION "Condition"
#define UNO_NAME_CONTENT "Content"
#define UNO_NAME_CHAR_CONTOURED "CharContoured"
#define UNO_NAME_CONTOUR_OUTSIDE "ContourOutside"
#define UNO_NAME_CONTENT_PROTECTED "ContentProtected"
#define UNO_NAME_COUNT_EMPTY_LINES "CountEmptyLines"
#define UNO_NAME_RESTART_AT_EACH_PAGE "RestartAtEachPage"
#define UNO_NAME_DATA_BASE_NAME "DataBaseName"
#define UNO_NAME_DATA_TABLE_NAME "DataTableName"
#define UNO_NAME_DATA_COMMAND_TYPE "DataCommandType"
#define UNO_NAME_DATA_COLUMN_NAME "DataColumnName"
#define UNO_NAME_IS_DATA_BASE_FORMAT "DataBaseFormat"
#define UNO_NAME_DATE "Date"
#define UNO_NAME_IS_DATE "IsDate"
#define UNO_NAME_EDIT_IN_READONLY "EditInReadonly"
#define UNO_NAME_FALSE_CONTENT "FalseContent"
#define UNO_NAME_FILE_FORMAT "FileFormat"
#define UNO_NAME_IS_FIXED "IsFixed"
#define UNO_NAME_FOOTNOTE_COUNTING "FootnoteCounting"
#define UNO_NAME_FULL_NAME "FullName"
#define UNO_NAME_HEIGHT "Height"
#define UNO_NAME_IS_AUTO_HEIGHT "IsAutoHeight"
#define UNO_NAME_SIZE_TYPE "SizeType"
#define UNO_NAME_HINT "Hint"
#define UNO_NAME_HORI_ORIENT "HoriOrient"
#define UNO_NAME_HORI_MIRRORED_ON_EVEN_PAGES "HoriMirroredOnEvenPages"
#define UNO_NAME_HORI_MIRRORED_ON_ODD_PAGES "HoriMirroredOnOddPages"
#define UNO_NAME_HORI_ORIENT_RELATION "HoriOrientRelation"
#define UNO_NAME_HORI_ORIENT_POSITION "HoriOrientPosition"
#define UNO_NAME_HYPER_LINK_U_R_L "HyperLinkURL"
#define UNO_NAME_HYPER_LINK_TARGET "HyperLinkTarget"
#define UNO_NAME_HYPER_LINK_NAME "HyperLinkName"
#define UNO_NAME_HYPER_LINK_EVENTS "HyperLinkEvents"
#define UNO_NAME_INFO_TYPE "InfoType"
#define UNO_NAME_INFO_FORMAT "InfoFormat"
#define UNO_NAME_IS_INPUT "IsInput"
#define UNO_NAME_LEVEL "Level"
#define UNO_NAME_INTERVAL "Interval"
#define UNO_NAME_LINK_REGION "LinkRegion"
#define UNO_NAME_MACRO_NAME "MacroName"
#define UNO_NAME_SPLIT "Split"
#define UNO_NAME_PARA_SPLIT "ParaSplit"
#define UNO_NAME_NUMBER_FORMAT "NumberFormat"
#define UNO_NAME_NUMBERING_TYPE "NumberingType"
#define UNO_NAME_OFFSET "Offset"
#define UNO_NAME_ON "On"
#define UNO_NAME_OPAQUE "Opaque"
#define UNO_NAME_PAGE_TOGGLE "PageToggle"
#define UNO_NAME_PAGE_DESC_NAME "PageDescName"
#define UNO_NAME_PAGE_NUMBER_OFFSET "PageNumberOffset"
#define UNO_NAME_PLACEHOLDER "PlaceHolder"
#define UNO_NAME_PLACEHOLDER_TYPE "PlaceHolderType"
#define UNO_NAME_PRINT "Print"
#define UNO_NAME_REFERENCE_FIELD_PART "ReferenceFieldPart"
#define UNO_NAME_REFERENCE_FIELD_SOURCE "ReferenceFieldSource"
#define UNO_NAME_REFERENCE_FIELD_LANGUAGE "ReferenceFieldLanguage"
#define UNO_NAME_REGISTER_PARAGRAPH_STYLE "RegisterParagraphStyle"
#define UNO_NAME_SCRIPT_TYPE "ScriptType"
#define UNO_NAME_SEARCH_ALL "SearchAll"

#define UNO_NAME_SEARCH_WORDS "SearchWords"
#define UNO_NAME_SEQUENCE_VALUE "SequenceValue"
#define UNO_NAME_SERVER_MAP "ServerMap"
#define UNO_NAME_IMAGE_MAP "ImageMap"
#define UNO_NAME_SET_NUMBER "SetNumber"
#define UNO_NAME_SHADOW_FORMAT "ShadowFormat"
#define UNO_NAME_SHOW_HORI_RULER "ShowHoriRuler"
#define UNO_NAME_SIZE "Size"
#define UNO_NAME_ACTUAL_SIZE "ActualSize"
#define UNO_NAME_SOURCE_NAME "SourceName"
#define UNO_NAME_START_AT "StartAt"
#define UNO_NAME_START_WITH "StartWith"
#define UNO_NAME_STATISTIC_TYPE_ID "StatisticTypeId"
#define UNO_NAME_SUB_TYPE "SubType"
#define UNO_NAME_SURROUND "Surround"
#define UNO_NAME_IS_EXPRESSION "IsExpression"
#define UNO_NAME_IS_SHOW_FORMULA "IsShowFormula"
#define UNO_NAME_TEXT_WRAP "TextWrap"
#define UNO_NAME_SURROUND_CONTOUR "SurroundContour"
#define UNO_NAME_SURROUND_ANCHORONLY "SurroundAnchorOnly"
#define UNO_NAME_TABLE_NAME "TableName"
#define UNO_NAME_TABLE_TEMPLATE_NAME "TableTemplateName"
#define UNO_NAME_TABSTOPS "ParaTabStops"
#define UNO_NAME_TITLE "Title"
#define UNO_NAME_TOP_MARGIN "TopMargin"
#define UNO_NAME_BOTTOM_MARGIN "BottomMargin"
#define UNO_NAME_TRUE_CONTENT "TrueContent"
#define UNO_NAME_URL_CONTENT "URLContent"
#define UNO_NAME_USERTEXT "UserText"
#define UNO_NAME_USER_DATA_TYPE "UserDataType"
#define UNO_NAME_VALUE "Value"
#define UNO_NAME_VARIABLE_NAME "VariableName"
#define UNO_NAME_VARIABLE_SUBTYPE "VariableSubtype"
#define UNO_NAME_VERT_ORIENT "VertOrient"
#define UNO_NAME_VERT_MIRRORED "VertMirrored"
#define UNO_NAME_VERT_ORIENT_POSITION "VertOrientPosition"
#define UNO_NAME_VERT_ORIENT_RELATION "VertOrientRelation"
#define UNO_NAME_IS_VISIBLE "IsVisible"
#define UNO_NAME_WIDTH "Width"
#define UNO_NAME_CHAR_WORD_MODE "CharWordMode"
#define UNO_NAME_GRAPHIC_CROP "GraphicCrop"
#define UNO_NAME_CHARACTER_FORMAT_NONE "CharacterFormatNone"
#define UNO_NAME_DOCUMENT_INDEX_MARK "DocumentIndexMark"
#define UNO_NAME_DOCUMENT_INDEX "DocumentIndex"
#define UNO_NAME_IS_GLOBAL_DOCUMENT_SECTION "IsGlobalDocumentSection"
#define UNO_NAME_TEXT_FIELD "TextField"
#define UNO_NAME_BOOKMARK "Bookmark"
#define UNO_NAME_BOOKMARK_HIDDEN "BookmarkHidden"
#define UNO_NAME_BOOKMARK_CONDITION "BookmarkCondition"
#define UNO_NAME_TEXT_TABLE "TextTable"
#define UNO_NAME_CELL "Cell"
#define UNO_NAME_TEXT_FRAME "TextFrame"
#define UNO_NAME_REFERENCE_MARK "ReferenceMark"
#define UNO_NAME_TEXT_SECTION "TextSection"
#define UNO_NAME_FOOTNOTE "Footnote"
#define UNO_NAME_ENDNOTE "Endnote"
#define UNO_NAME_CHART_ROW_AS_LABEL "ChartRowAsLabel"
#define UNO_NAME_CHART_COLUMN_AS_LABEL "ChartColumnAsLabel"
#define UNO_NAME_LEFT_BORDER "LeftBorder"
#define UNO_NAME_RIGHT_BORDER "RightBorder"
#define UNO_NAME_TOP_BORDER "TopBorder"
#define UNO_NAME_BOTTOM_BORDER "BottomBorder"
#define UNO_NAME_BORDER_DISTANCE "BorderDistance"
#define UNO_NAME_LEFT_BORDER_DISTANCE "LeftBorderDistance"
#define UNO_NAME_RIGHT_BORDER_DISTANCE "RightBorderDistance"
#define UNO_NAME_TOP_BORDER_DISTANCE "TopBorderDistance"
#define UNO_NAME_BOTTOM_BORDER_DISTANCE "BottomBorderDistance"
#define UNO_NAME_TABLE_BORDER "TableBorder"
#define UNO_NAME_TABLE_COLUMN_SEPARATORS "TableColumnSeparators"
#define UNO_NAME_TABLE_COLUMN_RELATIVE_SUM "TableColumnRelativeSum"
#define UNO_NAME_HEADER_TEXT "HeaderText"
#define UNO_NAME_HEADER_TEXT_LEFT "HeaderTextLeft"
#define UNO_NAME_HEADER_TEXT_RIGHT "HeaderTextRight"
#define UNO_NAME_FOOTER_TEXT "FooterText"
#define UNO_NAME_FOOTER_TEXT_LEFT "FooterTextLeft"
#define UNO_NAME_FOOTER_TEXT_RIGHT "FooterTextRight"
#define UNO_NAME_HEADER_BACK_COLOR "HeaderBackColor"
#define UNO_NAME_HEADER_BACK_TRANSPARENT "HeaderBackTransparent"
#define UNO_NAME_HEADER_LEFT_BORDER "HeaderLeftBorder"
#define UNO_NAME_HEADER_RIGHT_BORDER "HeaderRightBorder"
#define UNO_NAME_HEADER_TOP_BORDER "HeaderTopBorder"
#define UNO_NAME_HEADER_BOTTOM_BORDER "HeaderBottomBorder"
#define UNO_NAME_HEADER_BORDER_DISTANCE "HeaderBorderDistance"
#define UNO_NAME_HEADER_SHADOW_FORMAT "HeaderShadowFormat"
#define UNO_NAME_HEADER_BODY_DISTANCE "HeaderBodyDistance"
#define UNO_NAME_HEADER_IS_DYNAMIC_HEIGHT "HeaderIsDynamicHeight"
#define UNO_NAME_HEADER_IS_SHARED "HeaderIsShared"
#define UNO_NAME_HEADER_HEIGHT "HeaderHeight"
#define UNO_NAME_HEADER_IS_ON "HeaderIsOn"
#define UNO_NAME_FOOTER_BACK_COLOR "FooterBackColor"
#define UNO_NAME_FOOTER_BACK_TRANSPARENT "FooterBackTransparent"
#define UNO_NAME_FOOTER_LEFT_BORDER "FooterLeftBorder"
#define UNO_NAME_FOOTER_RIGHT_BORDER "FooterRightBorder"
#define UNO_NAME_FOOTER_TOP_BORDER "FooterTopBorder"
#define UNO_NAME_FOOTER_BOTTOM_BORDER "FooterBottomBorder"
#define UNO_NAME_FOOTER_BORDER_DISTANCE "FooterBorderDistance"
#define UNO_NAME_FOOTER_SHADOW_FORMAT "FooterShadowFormat"
#define UNO_NAME_FOOTER_BODY_DISTANCE "FooterBodyDistance"
#define UNO_NAME_FOOTER_IS_DYNAMIC_HEIGHT "FooterIsDynamicHeight"
#define UNO_NAME_FOOTER_IS_SHARED "FooterIsShared"
#define UNO_NAME_TEXT_PARAGRAPH "TextParagraph"
#define UNO_NAME_PARENT_TEXT "ParentText"

#define UNO_NAME_FOOTER_HEIGHT "FooterHeight"
#define UNO_NAME_FOOTER_IS_ON "FooterIsOn"
#define UNO_NAME_OVERWRITE_STYLES "OverwriteStyles"
#define UNO_NAME_LOAD_NUMBERING_STYLES "LoadNumberingStyles"
#define UNO_NAME_LOAD_PAGE_STYLES "LoadPageStyles"
#define UNO_NAME_LOAD_FRAME_STYLES "LoadFrameStyles"
#define UNO_NAME_LOAD_TEXT_STYLES "LoadTextStyles"
#define UNO_NAME_FILE_NAME "FileName"
#define UNO_NAME_COPY_COUNT "CopyCount"
#define UNO_NAME_COLLATE "Collate"
#define UNO_NAME_SORT "Sort"
#define UNO_NAME_PAGES "Pages"
#define UNO_NAME_FIRST_LINE_OFFSET "FirstLineOffset"
#define UNO_NAME_SYMBOL_TEXT_DISTANCE "SymbolTextDistance"
#define UNO_NAME_USER_INDEX_NAME "UserIndexName"
#define UNO_NAME_REVISION "Revision"
#define UNO_NAME_UNVISITED_CHAR_STYLE_NAME "UnvisitedCharStyleName"
#define UNO_NAME_VISITED_CHAR_STYLE_NAME "VisitedCharStyleName"
#define UNO_NAME_PARAGRAPH_COUNT "ParagraphCount"
#define UNO_NAME_WORD_COUNT "WordCount"
#define UNO_NAME_WORD_SEPARATOR "WordSeparator"
#define UNO_NAME_CHARACTER_COUNT "CharacterCount"
#define UNO_NAME_ZOOM_VALUE "ZoomValue"
#define UNO_NAME_ZOOM_TYPE "ZoomType"
#define UNO_NAME_CREATE_FROM_MARKS "CreateFromMarks"
#define UNO_NAME_CREATE_FROM_OUTLINE "CreateFromOutline"
#define UNO_NAME_CREATE_FROM_CHAPTER "CreateFromChapter"
#define UNO_NAME_CREATE_FROM_LABELS "CreateFromLabels"
#define UNO_NAME_USE_ALPHABETICAL_SEPARATORS "UseAlphabeticalSeparators"
#define UNO_NAME_USE_KEY_AS_ENTRY "UseKeyAsEntry"
#define UNO_NAME_USE_COMBINED_ENTRIES "UseCombinedEntries"
#define UNO_NAME_IS_CASE_SENSITIVE "IsCaseSensitive"
#define UNO_NAME_USE_P_P "UsePP"
#define UNO_NAME_USE_DASH "UseDash"
#define UNO_NAME_USE_UPPER_CASE "UseUpperCase"
#define UNO_NAME_LABEL_CATEGORY "LabelCategory"
#define UNO_NAME_LABEL_DISPLAY_TYPE "LabelDisplayType"
#define UNO_NAME_USE_LEVEL_FROM_SOURCE "UseLevelFromSource"
#define UNO_NAME_LEVEL_FORMAT "LevelFormat"
#define UNO_NAME_LEVEL_PARAGRAPH_STYLES "LevelParagraphStyles"
#define UNO_NAME_MAIN_ENTRY_CHARACTER_STYLE_NAME "MainEntryCharacterStyleName"
#define UNO_NAME_CREATE_FROM_TABLES "CreateFromTables"
#define UNO_NAME_CREATE_FROM_TEXT_FRAMES "CreateFromTextFrames"
#define UNO_NAME_CREATE_FROM_GRAPHIC_OBJECTS "CreateFromGraphicObjects"
#define UNO_NAME_CREATE_FROM_EMBEDDED_OBJECTS "CreateFromEmbeddedObjects"
#define UNO_NAME_CREATE_FROM_STAR_MATH "CreateFromStarMath"
#define UNO_NAME_CREATE_FROM_STAR_CHART "CreateFromStarChart"
#define UNO_NAME_CREATE_FROM_STAR_CALC "CreateFromStarCalc"
#define UNO_NAME_CREATE_FROM_STAR_DRAW "CreateFromStarDraw"
#define UNO_NAME_CREATE_FROM_OTHER_EMBEDDED_OBJECTS "CreateFromOtherEmbeddedObjects"
#define UNO_NAME_INDEX_AUTO_MARK_FILE_U_R_L "IndexAutoMarkFileURL"
#define UNO_NAME_IS_COMMA_SEPARATED "IsCommaSeparated"
#define UNO_NAME_IS_RELATIVE_TABSTOPS "IsRelativeTabstops"
#define UNO_NAME_CREATE_FROM_LEVEL_PARAGRAPH_STYLES "CreateFromLevelParagraphStyles"
#define UNO_NAME_SHOW_CHANGES "ShowChanges"
#define UNO_NAME_RECORD_CHANGES "RecordChanges"
#define UNO_LINK_DISPLAY_NAME "LinkDisplayName"
#define UNO_LINK_DISPLAY_BITMAP "LinkDisplayBitmap"
#define UNO_NAME_HEADING_STYLE_NAME "HeadingStyleName"
#define UNO_NAME_SHOW_ONLINE_LAYOUT "ShowOnlineLayout"
#define UNO_NAME_USER_DEFINED_ATTRIBUTES "UserDefinedAttributes"
#define UNO_NAME_TEXT_USER_DEFINED_ATTRIBUTES "TextUserDefinedAttributes"
#define UNO_NAME_FILE_PATH "FilePath"
#define UNO_NAME_PARA_CHAPTER_NUMBERING_LEVEL "ParaChapterNumberingLevel"
#define UNO_NAME_PARA_CONDITIONAL_STYLE_NAME "ParaConditionalStyleName"
#define UNO_NAME_CHAPTER_NUMBERING_LEVEL "ChapterNumberingLevel"
#define UNO_NAME_NUMBERING_SEPARATOR "NumberingSeparator"
#define UNO_NAME_IS_CONTINUOUS_NUMBERING "IsContinuousNumbering"
#define UNO_NAME_IS_AUTOMATIC "IsAutomatic"
#define UNO_NAME_IS_ABSOLUTE_MARGINS "IsAbsoluteMargins"
#define UNO_NAME_CATEGORY "Category"
#define UNO_NAME_DEPENDENT_TEXT_FIELDS "DependentTextFields"
#define UNO_NAME_CURRENT_PRESENTATION "CurrentPresentation"
#define UNO_NAME_ADJUST "Adjust"
#define UNO_NAME_INSTANCE_NAME "InstanceName"
#define UNO_NAME_TEXT_PORTION_TYPE "TextPortionType"
#define UNO_NAME_CONTROL_CHARACTER "ControlCharacter"
#define UNO_NAME_IS_COLLAPSED "IsCollapsed"
#define UNO_NAME_IS_START "IsStart"
#define UNO_NAME_SEQUENCE_NUMBER "SequenceNumber"
#define UNO_NAME_REFERENCE_ID "ReferenceId"
#define UNO_NAME_HEADER_LEFT_BORDER_DISTANCE "HeaderLeftBorderDistance"
#define UNO_NAME_HEADER_RIGHT_BORDER_DISTANCE "HeaderRightBorderDistance"
#define UNO_NAME_HEADER_TOP_BORDER_DISTANCE "HeaderTopBorderDistance"
#define UNO_NAME_HEADER_BOTTOM_BORDER_DISTANCE "HeaderBottomBorderDistance"
#define UNO_NAME_FOOTER_LEFT_BORDER_DISTANCE "FooterLeftBorderDistance"
#define UNO_NAME_FOOTER_RIGHT_BORDER_DISTANCE "FooterRightBorderDistance"
#define UNO_NAME_FOOTER_TOP_BORDER_DISTANCE "FooterTopBorderDistance"
#define UNO_NAME_FOOTER_BOTTOM_BORDER_DISTANCE "FooterBottomBorderDistance"
#define UNO_NAME_PARA_IS_NUMBERING_RESTART "ParaIsNumberingRestart"
#define UNO_NAME_HIDE_FIELD_TIPS "HideFieldTips"
#define UNO_NAME_PARA_SHADOW_FORMAT "ParaShadowFormat"
#define UNO_NAME_CONTOUR_POLY_POLYGON "ContourPolyPolygon"

#define UNO_NAME_IS_PIXEL_CONTOUR "IsPixelContour"
#define UNO_NAME_IS_AUTOMATIC_CONTOUR "IsAutomaticContour"
#define UNO_NAME_SEPARATOR_LINE_WIDTH "SeparatorLineWidth"
#define UNO_NAME_SEPARATOR_LINE_COLOR "SeparatorLineColor"
#define UNO_NAME_SEPARATOR_LINE_RELATIVE_HEIGHT "SeparatorLineRelativeHeight"
#define UNO_NAME_SEPARATOR_LINE_VERTIVAL_ALIGNMENT "SeparatorLineVerticalAlignment"
#define UNO_NAME_SEPARATOR_LINE_IS_ON "SeparatorLineIsOn"
#define UNO_NAME_IS_SKIP_HIDDEN_TEXT "IsSkipHiddenText"
#define UNO_NAME_IS_SKIP_PROTECTED_TEXT "IsSkipProtectedText"
#define UNO_NAME_RESET_PARAGRAPH_LIST_ATTRIBUTES "ResetParagraphListAttributes"
#define UNO_NAME_DOCUMENT_INDEX_MARKS "DocumentIndexMarks"
#define UNO_NAME_FOOTNOTE_IS_COLLECT_AT_TEXT_END "FootnoteIsCollectAtTextEnd"
#define UNO_NAME_FOOTNOTE_IS_RESTART_NUMBERING "FootnoteIsRestartNumbering"
#define UNO_NAME_FOOTNOTE_RESTART_NUMBERING_AT "FootnoteRestartNumberingAt"
#define UNO_NAME_FOOTNOTE_IS_OWN_NUMBERING "FootnoteIsOwnNumbering"
#define UNO_NAME_FOOTNOTE_NUMBERING_TYPE "FootnoteNumberingType"
#define UNO_NAME_FOOTNOTE_NUMBERING_PREFIX "FootnoteNumberingPrefix"
#define UNO_NAME_FOOTNOTE_NUMBERING_SUFFIX "FootnoteNumberingSuffix"
#define UNO_NAME_ENDNOTE_IS_COLLECT_AT_TEXT_END "EndnoteIsCollectAtTextEnd"
#define UNO_NAME_ENDNOTE_IS_RESTART_NUMBERING "EndnoteIsRestartNumbering"
#define UNO_NAME_ENDNOTE_RESTART_NUMBERING_AT "EndnoteRestartNumberingAt"
#define UNO_NAME_ENDNOTE_IS_OWN_NUMBERING "EndnoteIsOwnNumbering"
#define UNO_NAME_ENDNOTE_NUMBERING_TYPE "EndnoteNumberingType"
#define UNO_NAME_ENDNOTE_NUMBERING_PREFIX "EndnoteNumberingPrefix"
#define UNO_NAME_ENDNOTE_NUMBERING_SUFFIX "EndnoteNumberingSuffix"
#define UNO_NAME_BRACKET_BEFORE "BracketBefore"
#define UNO_NAME_BRACKET_AFTER "BracketAfter"
#define UNO_NAME_IS_NUMBER_ENTRIES "IsNumberEntries"
#define UNO_NAME_IS_SORT_BY_POSITION "IsSortByPosition"
#define UNO_NAME_SORT_KEYS "SortKeys"
#define UNO_NAME_IS_SORT_ASCENDING "IsSortAscending"
#define UNO_NAME_SORT_KEY "SortKey"
#define UNO_NAME_FIELDS "Fields"
#define UNO_NAME_DATE_TIME_VALUE "DateTimeValue"
#define UNO_NAME_IS_ON "IsOn"
#define UNO_NAME_Z_ORDER "ZOrder"
#define UNO_NAME_CONTENT_SECTION "ContentSection"
#define UNO_NAME_HEADER_SECTION "HeaderSection"
#define UNO_NAME_PARA_IS_HANGING_PUNCTUATION "ParaIsHangingPunctuation"
#define UNO_NAME_PARA_IS_CHARACTER_DISTANCE "ParaIsCharacterDistance"
#define UNO_NAME_PARA_IS_FORBIDDEN_RULES "ParaIsForbiddenRules"
#define UNO_NAME_PARA_VERT_ALIGNMENT "ParaVertAlignment"
#define UNO_NAME_IS_MAIN_ENTRY "IsMainEntry"
#define UNO_NAME_GRAPHIC_ROTATION "GraphicRotation"
#define UNO_NAME_ADJUST_LUMINANCE "AdjustLuminance"
#define UNO_NAME_ADJUST_CONTRAST "AdjustContrast"
#define UNO_NAME_ADJUST_RED "AdjustRed"
#define UNO_NAME_ADJUST_GREEN "AdjustGreen"
#define UNO_NAME_ADJUST_BLUE "AdjustBlue"
#define UNO_NAME_GAMMA "Gamma"
#define UNO_NAME_GRAPHIC_IS_INVERTED "GraphicIsInverted"
#define UNO_NAME_TRANSPARENCY "Transparency"
#define UNO_NAME_REDLINE_AUTHOR "RedlineAuthor"
#define UNO_NAME_REDLINE_DATE_TIME "RedlineDateTime"
#define UNO_NAME_REDLINE_COMMENT "RedlineComment"
#define UNO_NAME_REDLINE_DESCRIPTION "RedlineDescription"
#define UNO_NAME_REDLINE_TYPE "RedlineType"
#define UNO_NAME_REDLINE_SUCCESSOR_DATA "RedlineSuccessorData"
#define UNO_NAME_REDLINE_IDENTIFIER "RedlineIdentifier"
#define UNO_NAME_IS_IN_HEADER_FOOTER "IsInHeaderFooter"
#define UNO_NAME_START_REDLINE "StartRedline"
#define UNO_NAME_END_REDLINE "EndRedline"
#define UNO_NAME_REDLINE_START "RedlineStart"
#define UNO_NAME_REDLINE_END "RedlineEnd"
#define UNO_NAME_REDLINE_TEXT "RedlineText"
#define UNO_NAME_REDLINE_DISPLAY_TYPE "RedlineDisplayType"
#define UNO_NAME_FORBIDDEN_CHARACTERS "ForbiddenCharacters"
#define UNO_NAME_RUBY_BASE_TEXT "RubyBaseText"
#define UNO_NAME_RUBY_TEXT "RubyText"
#define UNO_NAME_RUBY_ADJUST "RubyAdjust"
#define UNO_NAME_RUBY_CHAR_STYLE_NAME "RubyCharStyleName"
#define UNO_NAME_RUBY_IS_ABOVE "RubyIsAbove"
#define UNO_NAME_RUBY_POSITION "RubyPosition"
#define UNO_NAME_FOOTNOTE_HEIGHT "FootnoteHeight"
#define UNO_NAME_FOOTNOTE_LINE_WEIGHT "FootnoteLineWeight"
#define UNO_NAME_FOOTNOTE_LINE_COLOR "FootnoteLineColor"
#define UNO_NAME_FOOTNOTE_LINE_RELATIVE_WIDTH "FootnoteLineRelativeWidth"
#define UNO_NAME_FOOTNOTE_LINE_ADJUST "FootnoteLineAdjust"
#define UNO_NAME_FOOTNOTE_LINE_TEXT_DISTANCE "FootnoteLineTextDistance"
#define UNO_NAME_FOOTNOTE_LINE_DISTANCE "FootnoteLineDistance"
#define UNO_NAME_CHAR_ROTATION "CharRotation"
#define UNO_NAME_CHAR_ROTATION_IS_FIT_TO_LINE "CharRotationIsFitToLine"
#define UNO_NAME_CHAR_SCALE_WIDTH "CharScaleWidth"
#define UNO_NAME_TAB_STOP_DISTANCE "TabStopDistance"
#define UNO_NAME_IS_WIDTH_RELATIVE "IsWidthRelative"
#define UNO_NAME_CHAR_RELIEF "CharRelief"
#define UNO_NAME_IS_HIDDEN "IsHidden"
#define UNO_NAME_IS_CONDITION_TRUE "IsConditionTrue"
#define UNO_NAME_TWO_DIGIT_YEAR "TwoDigitYear"
#define UNO_NAME_PROTECTION_KEY "ProtectionKey"
#define UNO_NAME_REDLINE_PROTECTION_KEY "RedlineProtectionKey"
#define UNO_NAME_AUTOMATIC_DISTANCE "AutomaticDistance"
#define UNO_NAME_AUTOMATIC_CONTROL_FOCUS "AutomaticControlFocus"
#define UNO_NAME_APPLY_FORM_DESIGN_MODE "ApplyFormDesignMode"
#define UNO_NAME_LOCALE "Locale"
#define UNO_NAME_SORT_ALGORITHM "SortAlgorithm"
#define UNO_NAME_FRAME_HEIGHT_ABSOLUTE "FrameHeightAbsolute"
#define UNO_NAME_FRAME_HEIGHT_PERCENT "FrameHeightPercent"
#define UNO_NAME_FRAME_ISAUTOMATIC_HEIGHT "FrameIsAutomaticHeight"
#define UNO_NAME_FRAME_WIDTH_ABSOLUTE "FrameWidthAbsolute"
#define UNO_NAME_FRAME_WIDTH_PERCENT "FrameWidthPercent"

// names for FillAttributes from SVX
#define UNO_NAME_SW_FILLBMP_LOGICAL_SIZE UNO_NAME_FILLBMP_LOGICAL_SIZE
#define UNO_NAME_SW_FILLBMP_OFFSET_X UNO_NAME_FILLBMP_OFFSET_X
#define UNO_NAME_SW_FILLBMP_OFFSET_Y UNO_NAME_FILLBMP_OFFSET_Y
#define UNO_NAME_SW_FILLBMP_POSITION_OFFSET_X UNO_NAME_FILLBMP_POSITION_OFFSET_X
#define UNO_NAME_SW_FILLBMP_POSITION_OFFSET_Y UNO_NAME_FILLBMP_POSITION_OFFSET_Y
#define UNO_NAME_SW_FILLBMP_RECTANGLE_POINT UNO_NAME_FILLBMP_RECTANGLE_POINT
#define UNO_NAME_SW_FILLBMP_SIZE_X UNO_NAME_FILLBMP_SIZE_X
#define UNO_NAME_SW_FILLBMP_SIZE_Y UNO_NAME_FILLBMP_SIZE_Y
#define UNO_NAME_SW_FILLBMP_STRETCH UNO_NAME_FILLBMP_STRETCH
#define UNO_NAME_SW_FILLBMP_TILE UNO_NAME_FILLBMP_TILE
#define UNO_NAME_SW_FILLBMP_MODE UNO_NAME_FILLBMP_MODE
#define UNO_NAME_SW_FILLCOLOR UNO_NAME_FILLCOLOR
#define UNO_NAME_SW_FILLBACKGROUND UNO_NAME_FILLBACKGROUND
#define UNO_NAME_SW_FILLBITMAP UNO_NAME_FILLBITMAP
#define UNO_NAME_SW_FILLBITMAPURL UNO_NAME_FILLBITMAPURL
#define UNO_NAME_SW_FILLBITMAPNAME UNO_NAME_FILLBITMAPNAME
#define UNO_NAME_SW_FILLGRADIENTSTEPCOUNT UNO_NAME_FILLGRADIENTSTEPCOUNT
#define UNO_NAME_SW_FILLGRADIENT UNO_NAME_FILLGRADIENT
#define UNO_NAME_SW_FILLGRADIENTNAME UNO_NAME_FILLGRADIENTNAME
#define UNO_NAME_SW_FILLHATCH UNO_NAME_FILLHATCH
#define UNO_NAME_SW_FILLHATCHNAME UNO_NAME_FILLHATCHNAME
#define UNO_NAME_SW_FILLSTYLE UNO_NAME_FILLSTYLE
#define UNO_NAME_SW_FILL_TRANSPARENCE UNO_NAME_FILL_TRANSPARENCE
#define UNO_NAME_SW_FILLTRANSPARENCEGRADIENT UNO_NAME_FILLTRANSPARENCEGRADIENT
#define UNO_NAME_SW_FILLTRANSPARENCEGRADIENTNAME UNO_NAME_FILLTRANSPARENCEGRADIENTNAME
#define UNO_NAME_SW_FILLCOLOR_2 UNO_NAME_FILLCOLOR_2

#define UNO_NAME_HEADER_FILLBMP_LOGICAL_SIZE "HeaderFillBitmapLogicalSize"
#define UNO_NAME_HEADER_FILLBMP_OFFSET_X "HeaderFillBitmapOffsetX"
#define UNO_NAME_HEADER_FILLBMP_OFFSET_Y "HeaderFillBitmapOffsetY"
#define UNO_NAME_HEADER_FILLBMP_POSITION_OFFSET_X "HeaderFillBitmapPositionOffsetX"
#define UNO_NAME_HEADER_FILLBMP_POSITION_OFFSET_Y "HeaderFillBitmapPositionOffsetY"
#define UNO_NAME_HEADER_FILLBMP_RECTANGLE_POINT "HeaderFillBitmapRectanglePoint"
#define UNO_NAME_HEADER_FILLBMP_SIZE_X "HeaderFillBitmapSizeX"
#define UNO_NAME_HEADER_FILLBMP_SIZE_Y "HeaderFillBitmapSizeY"
#define UNO_NAME_HEADER_FILLBMP_STRETCH "HeaderFillBitmapStretch"
#define UNO_NAME_HEADER_FILLBMP_TILE "HeaderFillBitmapTile"
#define UNO_NAME_HEADER_FILLBMP_MODE "HeaderFillBitmapMode"
#define UNO_NAME_HEADER_FILLCOLOR "HeaderFillColor"
#define UNO_NAME_HEADER_FILLBACKGROUND "HeaderFillBackground"
#define UNO_NAME_HEADER_FILLBITMAP "HeaderFillBitmap"
#define UNO_NAME_HEADER_FILLBITMAPNAME "HeaderFillBitmapName"
#define UNO_NAME_HEADER_FILLGRADIENTSTEPCOUNT "HeaderFillGradientStepCount"
#define UNO_NAME_HEADER_FILLGRADIENT "HeaderFillGradient"
#define UNO_NAME_HEADER_FILLGRADIENTNAME "HeaderFillGradientName"
#define UNO_NAME_HEADER_FILLHATCH "HeaderFillHatch"
#define UNO_NAME_HEADER_FILLHATCHNAME "HeaderFillHatchName"
#define UNO_NAME_HEADER_FILLSTYLE "HeaderFillStyle"
#define UNO_NAME_HEADER_FILL_TRANSPARENCE "HeaderFillTransparence"
#define UNO_NAME_HEADER_FILLTRANSPARENCEGRADIENT "HeaderFillTransparenceGradient"
#define UNO_NAME_HEADER_FILLTRANSPARENCEGRADIENTNAME "HeaderFillTransparenceGradientName"
#define UNO_NAME_HEADER_FILLCOLOR_2 "HeaderFillColor2"

#define UNO_NAME_FOOTER_FILLBMP_LOGICAL_SIZE "FooterFillBitmapLogicalSize"
#define UNO_NAME_FOOTER_FILLBMP_OFFSET_X "FooterFillBitmapOffsetX"
#define UNO_NAME_FOOTER_FILLBMP_OFFSET_Y "FooterFillBitmapOffsetY"
#define UNO_NAME_FOOTER_FILLBMP_POSITION_OFFSET_X "FooterFillBitmapPositionOffsetX"
#define UNO_NAME_FOOTER_FILLBMP_POSITION_OFFSET_Y "FooterFillBitmapPositionOffsetY"
#define UNO_NAME_FOOTER_FILLBMP_RECTANGLE_POINT "FooterFillBitmapRectanglePoint"
#define UNO_NAME_FOOTER_FILLBMP_SIZE_X "FooterFillBitmapSizeX"
#define UNO_NAME_FOOTER_FILLBMP_SIZE_Y "FooterFillBitmapSizeY"
#define UNO_NAME_FOOTER_FILLBMP_STRETCH "FooterFillBitmapStretch"
#define UNO_NAME_FOOTER_FILLBMP_TILE "FooterFillBitmapTile"
#define UNO_NAME_FOOTER_FILLBMP_MODE "FooterFillBitmapMode"
#define UNO_NAME_FOOTER_FILLCOLOR "FooterFillColor"
#define UNO_NAME_FOOTER_FILLBACKGROUND "FooterFillBackground"
#define UNO_NAME_FOOTER_FILLBITMAP "FooterFillBitmap"
#define UNO_NAME_FOOTER_FILLBITMAPNAME "FooterFillBitmapName"
#define UNO_NAME_FOOTER_FILLGRADIENTSTEPCOUNT "FooterFillGradientStepCount"
#define UNO_NAME_FOOTER_FILLGRADIENT "FooterFillGradient"
#define UNO_NAME_FOOTER_FILLGRADIENTNAME "FooterFillGradientName"
#define UNO_NAME_FOOTER_FILLHATCH "FooterFillHatch"
#define UNO_NAME_FOOTER_FILLHATCHNAME "FooterFillHatchName"
#define UNO_NAME_FOOTER_FILLSTYLE "FooterFillStyle"
#define UNO_NAME_FOOTER_FILL_TRANSPARENCE "FooterFillTransparence"
#define UNO_NAME_FOOTER_FILLTRANSPARENCEGRADIENT "FooterFillTransparenceGradient"
#define UNO_NAME_FOOTER_FILLTRANSPARENCEGRADIENTNAME "FooterFillTransparenceGradientName"
#define UNO_NAME_FOOTER_FILLCOLOR_2 "FooterFillColor2"

#define UNO_NAME_PARA_STYLEHEADING "ParaStyleHeading"
#define UNO_NAME_PARA_STYLELEVEL1 "ParaStyleLevel1"
#define UNO_NAME_PARA_STYLELEVEL10 "ParaStyleLevel10"
#define UNO_NAME_PARA_STYLELEVEL2 "ParaStyleLevel2"
#define UNO_NAME_PARA_STYLELEVEL3 "ParaStyleLevel3"
#define UNO_NAME_PARA_STYLELEVEL4 "ParaStyleLevel4"
#define UNO_NAME_PARA_STYLELEVEL5 "ParaStyleLevel5"
#define UNO_NAME_PARA_STYLELEVEL6 "ParaStyleLevel6"
#define UNO_NAME_PARA_STYLELEVEL7 "ParaStyleLevel7"
#define UNO_NAME_PARA_STYLELEVEL8 "ParaStyleLevel8"
#define UNO_NAME_PARA_STYLELEVEL9 "ParaStyleLevel9"
#define UNO_NAME_PARA_STYLESEPARATOR "ParaStyleSeparator"
#define UNO_NAME_MACRO_LIBRARY "MacroLibrary"
#define UNO_NAME_CELL_NAME "CellName"
#define UNO_NAME_PARA_USER_DEFINED_ATTRIBUTES "ParaUserDefinedAttributes"
#define UNO_NAME_MERGE_LAST_PARA "MergeLastPara"
#define UNO_NAME_WRITING_MODE "WritingMode"
#define UNO_NAME_GRID_COLOR "GridColor"
#define UNO_NAME_GRID_LINES "GridLines"
#define UNO_NAME_GRID_BASE_HEIGHT "GridBaseHeight"
#define UNO_NAME_GRID_RUBY_HEIGHT "GridRubyHeight"
#define UNO_NAME_GRID_MODE "GridMode"
#define UNO_NAME_GRID_RUBY_BELOW "RubyBelow"
#define UNO_NAME_GRID_PRINT "GridPrint"
#define UNO_NAME_GRID_DISPLAY "GridDisplay"
#define UNO_NAME_SNAP_TO_GRID "SnapToGrid"
#define UNO_NAME_DONT_BALANCE_TEXT_COLUMNS "DontBalanceTextColumns"
#define UNO_NAME_IS_CURRENTLY_VISIBLE "IsCurrentlyVisible"
#define UNO_NAME_ANCHOR_POSITION "AnchorPosition"
#define UNO_NAME_TEXT_READING "TextReading"
#define UNO_NAME_PRIMARY_KEY_READING "PrimaryKeyReading"
#define UNO_NAME_SECONDARY_KEY_READING "SecondaryKeyReading"
#define UNO_NAME_BACK_GRAPHIC_TRANSPARENCY "BackGraphicTransparency"
#define UNO_NAME_BACK_COLOR_R_G_B "BackColorRGB"
#define UNO_NAME_BACK_COLOR_TRANSPARENCY "BackColorTransparency"
#define UNO_NAME_HEADER_DYNAMIC_SPACING "HeaderDynamicSpacing"
#define UNO_NAME_FOOTER_DYNAMIC_SPACING "FooterDynamicSpacing"
#define UNO_NAME_BASIC_LIBRARIES "BasicLibraries"
#define UNO_NAME_IS_FIXED_LANGUAGE "IsFixedLanguage"
#define UNO_NAME_SELECTION "Selection"
#define UNO_NAME_RESULT_SET "ResultSet"
#define UNO_NAME_CONNECTION "ActiveConnection"
#define UNO_NAME_MODEL "Model"
#define UNO_NAME_DATA_SOURCE_NAME "DataSourceName"
#define UNO_NAME_FILTER "Filter"
#define UNO_NAME_DOCUMENT_URL "DocumentURL"
#define UNO_NAME_OUTPUT_URL "OutputURL"
#define UNO_NAME_OUTPUT_TYPE "OutputType"
#define UNO_NAME_ESCAPE_PROCESSING "EscapeProcessing"
#define UNO_NAME_SINGLE_PRINT_JOBS "SinglePrintJobs"
#define UNO_NAME_FILE_NAME_FROM_COLUMN "FileNameFromColumn"
#define UNO_NAME_FILE_NAME_PREFIX "FileNamePrefix"
#define UNO_NAME_CHAR_STYLE_NAMES "CharStyleNames"
#define UNO_NAME_DAD_COMMAND                                                                       \
    "Command" /* DAD = DataAccessDescriptor (see com.sun.star.sdb.DataAccessDescriptor) */
#define UNO_NAME_DAD_COMMAND_TYPE "CommandType"
#define UNO_NAME_CLSID "CLSID"
#define UNO_NAME_COMPONENT "Component"
#define UNO_NAME_SECT_LEFT_MARGIN "SectionLeftMargin"
#define UNO_NAME_SECT_RIGHT_MARGIN "SectionRightMargin"
#define UNO_NAME_PARA_IS_CONNECT_BORDER "ParaIsConnectBorder"
#define UNO_NAME_ITEMS "Items"
#define UNO_NAME_SELITEM "SelectedItem"
#define UNO_NAME_IS_SPLIT_ALLOWED "IsSplitAllowed"
#define UNO_NAME_HAS_TEXT_CHANGES_ONLY "HasTextChangesOnly"
#define UNO_NAME_CHAR_HIDDEN "CharHidden"
#define UNO_NAME_IS_FOLLOWING_TEXT_FLOW "IsFollowingTextFlow"
#define UNO_NAME_WIDTH_TYPE "WidthType"
#define UNO_NAME_SCRIPT_URL "ScriptURL"
#define UNO_NAME_RUNTIME_UID "RuntimeUID"
#define UNO_NAME_COLLAPSING_BORDERS "CollapsingBorders"
#define UNO_NAME_WRAP_INFLUENCE_ON_POSITION "WrapInfluenceOnPosition"
#define UNO_NAME_DATA_BASE_URL "DataBaseURL"
#define UNO_NAME_TRANSFORMATION_IN_HORI_L2R "TransformationInHoriL2R"
#define UNO_NAME_POSITION_LAYOUT_DIR "PositionLayoutDir"
#define UNO_NAME_NUMBERING_IS_OUTLINE "NumberingIsOutline"
#define UNO_NAME_STARTPOSITION_IN_HORI_L2R "StartPositionInHoriL2R"
#define UNO_NAME_ENDPOSITION_IN_HORI_L2R "EndPositionInHoriL2R"
#define UNO_NAME_SUBJECT "Subject"
#define UNO_NAME_ADDRESS_FROM_COLUMN "AddressFromColumn"
#define UNO_NAME_SEND_AS_HTML "SendAsHTML"
#define UNO_NAME_SEND_AS_ATTACHMENT "SendAsAttachment"
#define UNO_NAME_MAIL_BODY "MailBody"
#define UNO_NAME_ATTACHMENT_NAME "AttachmentName"
#define UNO_NAME_ATTACHMENT_FILTER "AttachmentFilter"
#define UNO_NAME_PRINT_OPTIONS "PrintOptions"
#define UNO_NAME_SAVE_AS_SINGLE_FILE "SaveAsSingleFile"
#define UNO_NAME_SAVE_FILTER "SaveFilter"
#define UNO_NAME_COPIES_TO "CopiesTo"
#define UNO_NAME_BLIND_COPIES_TO "BlindCopiesTo"
#define UNO_NAME_IN_SERVER_PASSWORD "InServerPassword"
#define UNO_NAME_OUT_SERVER_PASSWORD "OutServerPassword"
#define UNO_NAME_SAVE_FILTER_OPTIONS "SaveFilterOptions"
#define UNO_NAME_SAVE_FILTER_DATA "SaveFilterData"
#define UNO_NAME_LOCK_UPDATES "LockUpdates"
#define UNO_NAME_PAGE_COUNT "PageCount"
#define UNO_NAME_LINE_COUNT "LineCount"
#define UNO_NAME_IS_CONSTANT_SPELLCHECK "IsConstantSpellcheck"
#define UNO_NAME_IS_HIDE_SPELL_MARKS "IsHideSpellMarks" /* deprecated #i91949 */

#define UNO_NAME_IS_FIELD_USED "IsFieldUsed"
#define UNO_NAME_IS_FIELD_DISPLAYED "IsFieldDisplayed"
#define UNO_NAME_BUILDID "BuildId"
#define UNO_NAME_PARA_STYLE_CONDITIONS "ParaStyleConditions"
#define UNO_NAME_ROLE "Role"
#define UNO_NAME_FIELD_CODE "FieldCode"
#define UNO_NAME_HAS_VALID_SIGNATURES "HasValidSignatures"
#define UNO_NAME_CHAR_AUTO_STYLE_NAME "CharAutoStyleName"
#define UNO_NAME_PARA_AUTO_STYLE_NAME "ParaAutoStyleName"
#define UNO_NAME_LAYOUT_SIZE "LayoutSize"
#define UNO_NAME_HELP "Help"
#define UNO_NAME_TOOLTIP "Tooltip"
#define UNO_NAME_DIALOG_LIBRARIES "DialogLibraries"
#define UNO_NAME_HEADER_ROW_COUNT "HeaderRowCount"
#define UNO_NAME_INPUT "Input"
#define UNO_NAME_ROW_SPAN "RowSpan"
#define UNO_NAME_POSITION_AND_SPACE_MODE "PositionAndSpaceMode"
#define UNO_NAME_LABEL_FOLLOWED_BY "LabelFollowedBy"
#define UNO_NAME_LISTTAB_STOP_POSITION "ListtabStopPosition"
#define UNO_NAME_FIRST_LINE_INDENT "FirstLineIndent"
#define UNO_NAME_INDENT_AT "IndentAt"
#define UNO_NAME_GRID_BASE_WIDTH "GridBaseWidth"
#define UNO_NAME_GRID_SNAP_TO_CHARS "GridSnapToChars"
#define UNO_NAME_GRID_STANDARD_PAGE_MODE "StandardPageMode"
#define UNO_NAME_TABLE_BORDER_DISTANCES "TableBorderDistances"
#define UNO_NAME_LIST_ID "ListId"
#define UNO_NAME_DEFAULT_LIST_ID "DefaultListId"
#define UNO_NAME_STREAM_NAME "StreamName"
#define UNO_NAME_PARA_CONTINUEING_PREVIOUS_SUB_TREE "ContinueingPreviousSubTree"
#define UNO_NAME_PARA_LIST_LABEL_STRING "ListLabelString"
#define UNO_NAME_PARA_LIST_AUTO_FORMAT "ListAutoFormat"
#define UNO_NAME_CHAR_OVERLINE "CharOverline"
#define UNO_NAME_CHAR_OVERLINE_COLOR "CharOverlineColor"
#define UNO_NAME_CHAR_OVERLINE_HAS_COLOR "CharOverlineHasColor"
#define UNO_NAME_OUTLINE_CONTENT_VISIBLE "OutlineContentVisible"
#define UNO_NAME_OUTLINE_LEVEL "OutlineLevel"
#define UNO_NAME_DESCRIPTION "Description"
#define UNO_NAME_META "InContentMetadata"
#define UNO_NAME_IS_TEMPLATE "IsTemplate"
#define UNO_NAME_VBA_DOCOBJ "VBAGlobalConstantName"
#define UNO_NAME_NESTED_TEXT_CONTENT "NestedTextContent"
#define UNO_NAME_SEPARATOR_LINE_STYLE "SeparatorLineStyle"
#define UNO_NAME_FOOTNOTE_LINE_STYLE "FootnoteLineStyle"
#define UNO_NAME_EMBEDDED_OBJECT "EmbeddedObject"
#define UNO_NAME_RSID "Rsid"
#define UNO_NAME_PARRSID "ParRsid"
#define UNO_NAME_DRAW_ASPECT "DrawAspect"
#define UNO_NAME_VISIBLE_AREA_WIDTH "VisibleAreaWidth"
#define UNO_NAME_VISIBLE_AREA_HEIGHT "VisibleAreaHeight"

#define UNO_NAME_LINE_STYLE "LineStyle"
#define UNO_NAME_LINE_WIDTH "LineWidth"

#define UNO_NAME_PARA_CONTEXT_MARGIN "ParaContextMargin"
#define UNO_NAME_PARAGRAPH_STYLE_NAME "ParagraphStyleName"
#define UNO_NAME_FIRST_IS_SHARED "FirstIsShared"
#define UNO_NAME_HEADER_TEXT_FIRST "HeaderTextFirst"
#define UNO_NAME_FOOTER_TEXT_FIRST "FooterTextFirst"
#define UNO_NAME_INITIALS "Initials"
#define UNO_NAME_TABLE_BORDER2 "TableBorder2"
#define UNO_NAME_REPLACEMENT_GRAPHIC "ReplacementGraphic"
#define UNO_NAME_HIDDEN "Hidden"
#define UNO_NAME_DEFAULT_PAGE_MODE "DefaultPageMode"
#define UNO_NAME_CHAR_SHADING_VALUE "CharShadingValue"
#define UNO_NAME_PARA_INTEROP_GRAB_BAG "ParaInteropGrabBag"
#define UNO_NAME_CHAR_LEFT_BORDER "CharLeftBorder"
#define UNO_NAME_CHAR_RIGHT_BORDER "CharRightBorder"
#define UNO_NAME_CHAR_TOP_BORDER "CharTopBorder"
#define UNO_NAME_CHAR_BOTTOM_BORDER "CharBottomBorder"
#define UNO_NAME_CHAR_BORDER_DISTANCE "CharBorderDistance"
#define UNO_NAME_CHAR_LEFT_BORDER_DISTANCE "CharLeftBorderDistance"
#define UNO_NAME_CHAR_RIGHT_BORDER_DISTANCE "CharRightBorderDistance"
#define UNO_NAME_CHAR_TOP_BORDER_DISTANCE "CharTopBorderDistance"
#define UNO_NAME_CHAR_BOTTOM_BORDER_DISTANCE "CharBottomBorderDistance"
#define UNO_NAME_CHAR_SHADOW_FORMAT "CharShadowFormat"
#define UNO_NAME_SHADOW_TRANSPARENCE "ShadowTransparence"
#define UNO_NAME_DOC_INTEROP_GRAB_BAG "InteropGrabBag"
#define UNO_NAME_FRAME_INTEROP_GRAB_BAG "FrameInteropGrabBag"
#define UNO_NAME_CHAR_HIGHLIGHT "CharHighlight"
#define UNO_NAME_STYLE_INTEROP_GRAB_BAG "StyleInteropGrabBag"
#define UNO_NAME_CHAR_INTEROP_GRAB_BAG "CharInteropGrabBag"
#define UNO_NAME_TEXT_VERT_ADJUST u"TextVerticalAdjust"
#define UNO_NAME_CELL_INTEROP_GRAB_BAG "CellInteropGrabBag"
#define UNO_NAME_ROW_INTEROP_GRAB_BAG "RowInteropGrabBag"
#define UNO_NAME_TABLE_INTEROP_GRAB_BAG "TableInteropGrabBag"

#define UNO_NAME_TABLE_FIRST_ROW_END_COLUMN "FirstRowEndColumn"
#define UNO_NAME_TABLE_FIRST_ROW_START_COLUMN "FirstRowStartColumn"
#define UNO_NAME_TABLE_LAST_ROW_END_COLUMN "LastRowEndColumn"
#define UNO_NAME_TABLE_LAST_ROW_START_COLUMN "LastRowStartColumn"

#define UNO_NAME_RESOLVED "Resolved"
#define UNO_NAME_ALLOW_OVERLAP "AllowOverlap"
#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
