/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#include <mathmlMo.hxx>

static moOperatorData moOperatorDataDictionaryData[starmathdatabase::MATHML_MO_COUNT]
    = { { u"\u2018", moOpDF::prefix, 10, 0, 0, moOpDP::fence | moOpDP::nonedp },
        { u"\u2019", moOpDF::postfix, 10, 0, 0, moOpDP::fence | moOpDP::nonedp },
        { u"\u201C", moOpDF::prefix, 10, 0, 0, moOpDP::fence | moOpDP::nonedp },
        { u"\u201D", moOpDF::postfix, 10, 0, 0, moOpDP::fence | moOpDP::nonedp },
        { u"(", moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u")", moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"[", moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"]", moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"{", moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"|", moOpDF::prepostfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"||", moOpDF::prepostfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"|||", moOpDF::prepostfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"}", moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2016", moOpDF::prepostfix, 20, 0, 0, moOpDP::stretchyfence },
        { u"\u2308", moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2309", moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u230A", moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u230B", moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2329", moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u232A", moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2772", moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2773", moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u27E6", moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u27E7", moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u27E8", moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u27E9", moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u27EA", moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u27EB", moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u27EC", moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u27ED", moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u27EE", moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u27EF", moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2980", moOpDF::prepostfix, 20, 0, 0, moOpDP::stretchyfence },
        { u"\u2983", moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2984", moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2985", moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2986", moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2987", moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2988", moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2989", moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u298A", moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u298B", moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u298C", moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u298D", moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u298E", moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u298F", moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2990", moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2991", moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2992", moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2993", moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2994", moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2995", moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2996", moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2997", moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2998", moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u29FC", moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u29FD", moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u";", moOpDF::infix, 30, 0, 3, moOpDP::separator | moOpDP::linebreakstyleAfter },
        { u",", moOpDF::infix, 40, 0, 3, moOpDP::separator | moOpDP::linebreakstyleAfter },
        { u"\u2063", moOpDF::infix, 40, 0, 0, moOpDP::separator | moOpDP::linebreakstyleAfter },
        { u"\u2234", moOpDF::infix, 70, 5, 5, moOpDP::nonedp },
        { u"\u2235", moOpDF::infix, 70, 5, 5, moOpDP::nonedp },
        { u"->", moOpDF::infix, 90, 5, 5, moOpDP::nonedp },
        { u"..", moOpDF::postfix, 100, 0, 0, moOpDP::nonedp },
        { u"...", moOpDF::postfix, 100, 0, 0, moOpDP::nonedp },
        { u":", moOpDF::infix, 100, 1, 2, moOpDP::nonedp },
        { u"\u03F6", moOpDF::infix, 110, 5, 5, moOpDP::nonedp },
        { u"\u2026", moOpDF::infix, 150, 0, 0, moOpDP::nonedp },
        { u"\u22EE", moOpDF::infix, 150, 5, 5, moOpDP::nonedp },
        { u"\u22EF", moOpDF::infix, 150, 0, 0, moOpDP::nonedp },
        { u"\u22F1", moOpDF::infix, 150, 5, 5, moOpDP::nonedp },
        { u"\u220B", moOpDF::infix, 160, 5, 5, moOpDP::nonedp },
        { u"\u22A2", moOpDF::infix, 170, 5, 5, moOpDP::nonedp },
        { u"\u22A3", moOpDF::infix, 170, 5, 5, moOpDP::nonedp },
        { u"\u22A4", moOpDF::infix, 170, 5, 5, moOpDP::nonedp },
        { u"\u22A8", moOpDF::infix, 170, 5, 5, moOpDP::nonedp },
        { u"\u22A9", moOpDF::infix, 170, 5, 5, moOpDP::nonedp },
        { u"\u22AC", moOpDF::infix, 170, 5, 5, moOpDP::nonedp },
        { u"\u22AD", moOpDF::infix, 170, 5, 5, moOpDP::nonedp },
        { u"\u22AE", moOpDF::infix, 170, 5, 5, moOpDP::nonedp },
        { u"\u22AF", moOpDF::infix, 170, 5, 5, moOpDP::nonedp },
        { u"\u2228", moOpDF::infix, 190, 4, 4, moOpDP::nonedp },
        { u"&&", moOpDF::infix, 200, 4, 4, moOpDP::nonedp },
        { u"\u2227", moOpDF::infix, 200, 4, 4, moOpDP::nonedp },
        { u"\u2200", moOpDF::prefix, 230, 2, 1, moOpDP::nonedp },
        { u"\u2203", moOpDF::prefix, 230, 2, 1, moOpDP::nonedp },
        { u"\u2204", moOpDF::prefix, 230, 2, 1, moOpDP::nonedp },
        { u"\u2201", moOpDF::infix, 240, 1, 2, moOpDP::nonedp },
        { u"\u2208", moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u2209", moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u220C", moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u2282", moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u2282\u20D2", moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u2283", moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u2283\u20D2", moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u2284", moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u2285", moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u2286", moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u2287", moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u2288", moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u2289", moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u228A", moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u228B", moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"<=", moOpDF::infix, 241, 5, 5, moOpDP::nonedp },
        { u"\u2264", moOpDF::infix, 241, 5, 5, moOpDP::nonedp },
        { u"\u2265", moOpDF::infix, 242, 5, 5, moOpDP::nonedp },
        { u">", moOpDF::infix, 243, 5, 5, moOpDP::nonedp },
        { u">=", moOpDF::infix, 243, 5, 5, moOpDP::nonedp },
        { u"\u226F", moOpDF::infix, 244, 5, 5, moOpDP::nonedp },
        { u"&lt", moOpDF::infix, 245, 5, 5, moOpDP::nonedp },
        { u"\u226E", moOpDF::infix, 246, 5, 5, moOpDP::nonedp },
        { u"\u2248", moOpDF::infix, 247, 5, 5, moOpDP::nonedp },
        { u"\u223C", moOpDF::infix, 250, 5, 5, moOpDP::nonedp },
        { u"\u2249", moOpDF::infix, 250, 5, 5, moOpDP::nonedp },
        { u"\u2262", moOpDF::infix, 252, 5, 5, moOpDP::nonedp },
        { u"\u2260", moOpDF::infix, 255, 5, 5, moOpDP::nonedp },
        { u"!=", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"*=", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"+=", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"-=", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"/=", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u":=", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"=", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"==", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u221D", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2224", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2225", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2226", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2241", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2243", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2244", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2245", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2246", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2247", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u224D", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2254", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2257", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2259", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u225A", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u225B", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u225C", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u225F", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2261", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2268", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2269", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u226A", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u226A\u0338", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u226B", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u226B\u0338", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u226D", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2270", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2271", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u227A", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u227B", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u227C", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u227D", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2280", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2281", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u22A5", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u22B4", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u22B5", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u22C9", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u22CA", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u22CB", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u22CC", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u22D4", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u22D6", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u22D7", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u22D8", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u22D9", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u22EA", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u22EB", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u22EC", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u22ED", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u25A0", moOpDF::infix, 260, 3, 3, moOpDP::nonedp },
        { u"\u25A1", moOpDF::infix, 260, 3, 3, moOpDP::nonedp },
        { u"\u25AA", moOpDF::infix, 260, 3, 3, moOpDP::nonedp },
        { u"\u25AB", moOpDF::infix, 260, 3, 3, moOpDP::nonedp },
        { u"\u25AD", moOpDF::infix, 260, 3, 3, moOpDP::nonedp },
        { u"\u25AE", moOpDF::infix, 260, 3, 3, moOpDP::nonedp },
        { u"\u25AF", moOpDF::infix, 260, 3, 3, moOpDP::nonedp },
        { u"\u25B0", moOpDF::infix, 260, 3, 3, moOpDP::nonedp },
        { u"\u25B1", moOpDF::infix, 260, 3, 3, moOpDP::nonedp },
        { u"\u25B3", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25B4", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25B5", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25B6", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25B7", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25B8", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25B9", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25BC", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25BD", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25BE", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25BF", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25C0", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25C1", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25C2", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25C3", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25C4", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25C5", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25C6", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25C7", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25C8", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25C9", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25CC", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25CD", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25CE", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25CF", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25D6", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25D7", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25E6", moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u29C0", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u29C1", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u29E3", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u29E4", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u29E5", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u29E6", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u29F3", moOpDF::infix, 260, 3, 3, moOpDP::nonedp },
        { u"\u2A87", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2A88", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2AAF", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2AAF\u0338", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2AB0", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2AB0\u0338", moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2044", moOpDF::infix, 265, 4, 4, moOpDP::stretchy },
        { u"\u2206", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u220A", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u220D", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u220E", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u2215", moOpDF::infix, 265, 4, 4, moOpDP::stretchy },
        { u"\u2217", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2218", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2219", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u221F", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2223", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2236", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2237", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2238", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2239", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u223A", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u223B", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u223D", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u223D\u0331", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u223E", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u223F", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u2242", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2242\u0338", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u224A", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u224B", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u224C", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u224E", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u224E\u0338", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u224F", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u224F\u0338", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2250", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2251", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2252", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2253", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2255", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2256", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2258", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u225D", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u225E", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2263", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2266", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2266\u0338", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2267", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u226C", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2272", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2273", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2274", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2275", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2276", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2277", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2278", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2279", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u227E", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u227F", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u227F\u0338", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u228C", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u228D", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u228E", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u228F", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u228F\u0338", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2290", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2290\u0338", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2291", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2292", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2293", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2294", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u229A", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u229B", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u229C", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u229D", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u22A6", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22A7", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22AA", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22AB", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22B0", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22B1", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22B2", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22B3", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22B6", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22B7", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22B9", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22BA", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u22BB", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u22BC", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u22BD", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u22BE", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u22BF", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u22C4", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u22C6", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u22C7", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u22C8", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22CD", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22CE", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u22CF", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u22D0", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22D1", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22D2", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u22D3", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u22D5", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22DA", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22DB", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22DC", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22DD", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22DE", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22DF", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22E0", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22E1", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22E2", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22E3", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22E4", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22E5", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22E6", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22E7", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22E8", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22E9", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22F0", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22F2", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22F3", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22F4", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22F5", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22F6", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22F7", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22F8", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22F9", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22FA", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22FB", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22FC", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22FD", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22FE", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22FF", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u25B2", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2758", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2981", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u2982", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29A0", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29A1", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29A2", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29A3", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29A4", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29A5", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29A6", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29A7", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29A8", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29A9", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29AA", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29AB", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29AC", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29AD", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29AE", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29AF", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29B0", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29B1", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29B2", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29B3", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29B4", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29B5", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29B6", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29B7", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29B8", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29B9", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29BA", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29BB", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29BC", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29BD", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29BE", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29BF", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29C2", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29C3", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29C4", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29C5", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29C6", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29C7", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29C8", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29C9", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29CA", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29CB", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29CC", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29CD", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29CE", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u29CF", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u29CF\u0338", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u29D0", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u29D0\u0338", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u29D1", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u29D2", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u29D3", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u29D4", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u29D5", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u29D6", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29D7", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29D8", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29D9", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29DB", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29DC", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29DD", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29DE", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u29E0", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29E1", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u29E2", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29E7", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29E8", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29E9", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29EA", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29EB", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29EC", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29ED", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29EE", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29F0", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29F1", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29F2", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29F5", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29F6", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29F7", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29F8", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29F9", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29FA", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29FB", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29FE", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29FF", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A1D", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u2A1E", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u2A1F", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u2A20", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u2A21", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u2A22", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A23", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A24", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A25", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A26", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A27", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A28", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A29", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A2A", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A2B", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A2C", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A2D", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A2E", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A30", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A31", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A32", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A33", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A34", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A35", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A36", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A37", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A38", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A39", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A3A", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A3B", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A3C", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A3D", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A3E", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A40", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A41", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A42", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A43", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A44", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A45", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A46", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A47", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A48", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A49", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A4A", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A4B", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A4C", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A4D", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A4E", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A4F", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A50", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A51", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A52", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A53", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A54", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A55", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A56", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A57", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A58", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A59", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A5A", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A5B", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A5C", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A5D", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A5E", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A5F", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A60", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A61", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A62", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A63", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A64", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A65", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A66", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A67", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A68", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A69", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A6A", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A6B", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A6C", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A6D", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A6E", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A6F", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A70", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A71", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A72", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A73", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A74", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A75", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A76", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A77", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A78", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A79", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A7A", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A7B", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A7C", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A7D", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A7D\u0338", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A7E", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A7E\u0338", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A7F", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A80", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A81", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A82", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A83", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A84", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A85", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A86", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A89", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A8A", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A8B", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A8C", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A8D", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A8E", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A8F", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A90", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A91", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A92", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A93", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A94", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A95", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A96", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A97", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A98", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A99", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A9A", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A9B", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A9C", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A9D", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A9E", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A9F", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AA0", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AA1", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AA1\u0338", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AA2", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AA2\u0338", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AA3", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AA4", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AA5", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AA6", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AA7", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AA8", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AA9", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AAA", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AAB", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AAC", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AAD", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AAE", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AB1", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AB2", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AB3", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AB4", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AB5", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AB6", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AB7", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AB8", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AB9", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ABA", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ABB", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ABC", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ABD", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ABE", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ABF", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AC0", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AC1", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AC2", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AC3", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AC4", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AC5", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AC6", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AC7", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AC8", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AC9", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ACA", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ACB", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ACC", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ACD", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ACE", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ACF", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AD0", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AD1", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AD2", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AD3", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AD4", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AD5", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AD6", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AD7", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AD8", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AD9", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ADA", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ADB", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ADD", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ADD\u0338", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ADE", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ADF", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AE0", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AE1", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AE2", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AE3", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AE4", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AE5", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AE6", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AE7", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AE8", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AE9", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AEA", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AEB", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AEC", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AED", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AEE", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AEF", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AF0", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AF1", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AF2", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AF3", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AF4", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2AF5", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2AF6", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2AF7", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AF8", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AF9", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AFA", moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AFB", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2AFD", moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2AFE", moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"|", moOpDF::infix, 270, 2, 2, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"||", moOpDF::infix, 270, 2, 2, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"|||", moOpDF::infix, 270, 2, 2, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2190", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u2191", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2192", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u2193", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2194", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u2195", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2196", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2197", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2198", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2199", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u219A", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u219B", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u219C", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u219D", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u219E", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u219F", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21A0", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21A1", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21A2", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21A3", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21A4", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21A5", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21A6", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21A7", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21A8", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21A9", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21AA", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21AB", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21AC", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21AD", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21AE", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21AF", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21B0", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21B1", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21B2", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21B3", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21B4", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21B5", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21B6", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21B7", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21B8", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u21B9", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21BA", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u21BB", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u21BC", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21BD", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21BE", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21BF", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21C0", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21C1", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21C2", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21C3", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21C4", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21C5", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21C6", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21C7", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21C8", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21C9", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21CA", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21CB", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21CC", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21CD", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21CE", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21CF", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21D0", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21D1", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21D2", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21D3", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21D4", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21D5", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21D6", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21D7", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21D8", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21D9", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21DA", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21DB", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21DC", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21DD", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21DE", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u21DF", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u21E0", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21E1", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21E2", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21E3", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21E4", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21E5", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21E6", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21E7", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21E8", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21E9", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21EA", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21EB", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21EC", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21ED", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21EE", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21EF", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21F0", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21F1", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u21F2", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u21F3", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21F4", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21F5", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21F6", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21F7", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21F8", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21F9", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21FA", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21FB", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21FC", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21FD", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21FE", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21FF", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u22B8", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u27F0", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u27F1", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u27F5", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u27F6", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u27F7", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u27F8", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u27F9", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u27FA", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u27FB", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u27FC", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u27FD", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u27FE", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u27FF", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u2900", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2901", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2902", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2903", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2904", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2905", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2906", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2907", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2908", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2909", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u290A", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u290B", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u290C", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u290D", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u290E", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u290F", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u2910", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u2911", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2912", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2913", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2914", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2915", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2916", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2917", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2918", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2919", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u291A", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u291B", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u291C", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u291D", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u291E", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u291F", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2920", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2921", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2922", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2923", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2924", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2925", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2926", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2927", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2928", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2929", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u292A", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u292B", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u292C", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u292D", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u292E", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u292F", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2930", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2931", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2932", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2933", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2934", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2935", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2936", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2937", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2938", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2939", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u293A", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u293B", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u293C", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u293D", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u293E", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u293F", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2940", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2941", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2942", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2943", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2944", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2945", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2946", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2947", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2948", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2949", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u294A", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u294B", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u294C", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u294D", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u294E", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u294F", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2950", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u2951", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2952", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u2953", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u2954", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2955", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2956", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2957", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2958", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2959", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u295A", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u295B", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u295C", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u295D", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u295E", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u295F", moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u2960", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2961", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2962", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2963", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2964", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2965", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2966", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2967", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2968", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2969", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u296A", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u296B", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u296C", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u296D", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u296E", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u296F", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2970", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2971", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2972", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2973", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2974", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2975", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2976", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2977", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2978", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2979", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u297A", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u297B", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u297C", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u297D", moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u297E", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u297F", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2999", moOpDF::infix, 270, 3, 3, moOpDP::nonedp },
        { u"\u299A", moOpDF::infix, 270, 3, 3, moOpDP::nonedp },
        { u"\u299B", moOpDF::infix, 270, 3, 3, moOpDP::nonedp },
        { u"\u299C", moOpDF::infix, 270, 3, 3, moOpDP::nonedp },
        { u"\u299D", moOpDF::infix, 270, 3, 3, moOpDP::nonedp },
        { u"\u299E", moOpDF::infix, 270, 3, 3, moOpDP::nonedp },
        { u"\u299F", moOpDF::infix, 270, 3, 3, moOpDP::nonedp },
        { u"\u29DF", moOpDF::infix, 270, 3, 3, moOpDP::nonedp },
        { u"\u29EF", moOpDF::infix, 270, 3, 3, moOpDP::nonedp },
        { u"\u29F4", moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2B45", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2B46", moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"+", moOpDF::infix, 275, 4, 4, moOpDP::nonedp },
        { u"+", moOpDF::prefix, 275, 0, 1, moOpDP::nonedp },
        { u"-", moOpDF::infix, 275, 4, 4, moOpDP::nonedp },
        { u"-", moOpDF::prefix, 275, 0, 1, moOpDP::nonedp },
        { u"\u00B1", moOpDF::infix, 275, 4, 4, moOpDP::nonedp },
        { u"\u00B1", moOpDF::prefix, 275, 0, 1, moOpDP::nonedp },
        { u"\u2212", moOpDF::infix, 275, 4, 4, moOpDP::nonedp },
        { u"\u2212", moOpDF::prefix, 275, 0, 1, moOpDP::nonedp },
        { u"\u2213", moOpDF::infix, 275, 4, 4, moOpDP::nonedp },
        { u"\u2213", moOpDF::prefix, 275, 0, 1, moOpDP::nonedp },
        { u"\u2214", moOpDF::infix, 275, 4, 4, moOpDP::nonedp },
        { u"\u229E", moOpDF::infix, 275, 4, 4, moOpDP::nonedp },
        { u"\u229F", moOpDF::infix, 275, 4, 4, moOpDP::nonedp },
        { u"\u2211", moOpDF::prefix, 290, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A0A", moOpDF::prefix, 290, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A0B", moOpDF::prefix, 290, 1, 2, moOpDP::largeop | moOpDP::symmetric },
        { u"\u222C", moOpDF::prefix, 300, 0, 1, moOpDP::largeop | moOpDP::symmetric },
        { u"\u222D", moOpDF::prefix, 300, 0, 1, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2295", moOpDF::infix, 300, 4, 4, moOpDP::nonedp },
        { u"\u2296", moOpDF::infix, 300, 4, 4, moOpDP::nonedp },
        { u"\u2298", moOpDF::infix, 300, 4, 4, moOpDP::nonedp },
        { u"\u2A01", moOpDF::prefix, 300, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u222B", moOpDF::prefix, 310, 0, 1, moOpDP::largeop | moOpDP::symmetric },
        { u"\u222E", moOpDF::prefix, 310, 0, 1, moOpDP::largeop | moOpDP::symmetric },
        { u"\u222F", moOpDF::prefix, 310, 0, 1, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2230", moOpDF::prefix, 310, 0, 1, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2231", moOpDF::prefix, 310, 0, 1, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2232", moOpDF::prefix, 310, 0, 1, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2233", moOpDF::prefix, 310, 0, 1, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2A0C", moOpDF::prefix, 310, 0, 1, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2A0D", moOpDF::prefix, 310, 1, 2, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2A0E", moOpDF::prefix, 310, 1, 2, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2A0F", moOpDF::prefix, 310, 1, 2, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2A10", moOpDF::prefix, 310, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A11", moOpDF::prefix, 310, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A12", moOpDF::prefix, 310, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A13", moOpDF::prefix, 310, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A14", moOpDF::prefix, 310, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A15", moOpDF::prefix, 310, 1, 2, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2A16", moOpDF::prefix, 310, 1, 2, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2A17", moOpDF::prefix, 310, 1, 2, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2A18", moOpDF::prefix, 310, 1, 2, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2A19", moOpDF::prefix, 310, 1, 2, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2A1A", moOpDF::prefix, 310, 1, 2, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2A1B", moOpDF::prefix, 310, 1, 2, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2A1C", moOpDF::prefix, 310, 1, 2, moOpDP::largeop | moOpDP::symmetric },
        { u"\u22C3", moOpDF::prefix, 320, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A03", moOpDF::prefix, 320, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A04", moOpDF::prefix, 320, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u22C0", moOpDF::prefix, 330, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u22C1", moOpDF::prefix, 330, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u22C2", moOpDF::prefix, 330, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A00", moOpDF::prefix, 330, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A02", moOpDF::prefix, 330, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A05", moOpDF::prefix, 330, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A06", moOpDF::prefix, 330, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A07", moOpDF::prefix, 330, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A08", moOpDF::prefix, 330, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A09", moOpDF::prefix, 330, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2AFC", moOpDF::prefix, 330, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2AFF", moOpDF::prefix, 330, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2240", moOpDF::infix, 340, 4, 4, moOpDP::nonedp },
        { u"\u220F", moOpDF::prefix, 350, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2210", moOpDF::prefix, 350, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2229", moOpDF::infix, 350, 4, 4, moOpDP::nonedp },
        { u"\u222A", moOpDF::infix, 350, 4, 4, moOpDP::nonedp },
        { u"*", moOpDF::infix, 390, 3, 3, moOpDP::nonedp },
        { u".", moOpDF::infix, 390, 3, 3, moOpDP::nonedp },
        { u"\u00D7", moOpDF::infix, 390, 4, 4, moOpDP::nonedp },
        { u"\u2022", moOpDF::infix, 390, 4, 4, moOpDP::nonedp },
        { u"\u2043", moOpDF::infix, 390, 4, 4, moOpDP::nonedp },
        { u"\u2062", moOpDF::infix, 390, 0, 0, moOpDP::nonedp },
        { u"\u22A0", moOpDF::infix, 390, 4, 4, moOpDP::nonedp },
        { u"\u22A1", moOpDF::infix, 390, 4, 4, moOpDP::nonedp },
        { u"\u22C5", moOpDF::infix, 390, 4, 4, moOpDP::nonedp },
        { u"\u2A2F", moOpDF::infix, 390, 4, 4, moOpDP::nonedp },
        { u"\u2A3F", moOpDF::infix, 390, 4, 4, moOpDP::nonedp },
        { u"\u00B7", moOpDF::infix, 400, 4, 4, moOpDP::nonedp },
        { u"\u2297", moOpDF::infix, 410, 4, 4, moOpDP::nonedp },
        { u"%", moOpDF::infix, 640, 3, 3, moOpDP::nonedp },
        { u"\\", moOpDF::infix, 650, 0, 0, moOpDP::nonedp },
        { u"\u2216", moOpDF::infix, 650, 4, 4, moOpDP::nonedp },
        { u"/", moOpDF::infix, 660, 1, 1, moOpDP::nonedp },
        { u"\u00F7", moOpDF::infix, 660, 4, 4, moOpDP::nonedp },
        { u"\u2220", moOpDF::prefix, 670, 0, 0, moOpDP::nonedp },
        { u"\u2221", moOpDF::prefix, 670, 0, 0, moOpDP::nonedp },
        { u"\u2222", moOpDF::prefix, 670, 0, 0, moOpDP::nonedp },
        { u"\u00AC", moOpDF::prefix, 680, 2, 1, moOpDP::nonedp },
        { u"\u2299", moOpDF::infix, 710, 4, 4, moOpDP::nonedp },
        { u"\u2202", moOpDF::prefix, 740, 2, 1, moOpDP::nonedp },
        { u"\u2207", moOpDF::prefix, 740, 2, 1, moOpDP::nonedp },
        { u"**", moOpDF::infix, 780, 1, 1, moOpDP::nonedp },
        { u"<>", moOpDF::infix, 780, 1, 1, moOpDP::nonedp },
        { u"^", moOpDF::infix, 780, 1, 1, moOpDP::nonedp },
        { u"\u2032", moOpDF::postfix, 800, 0, 0, moOpDP::nonedp },
        { u"\u266D", moOpDF::postfix, 800, 0, 2, moOpDP::nonedp },
        { u"\u266E", moOpDF::postfix, 800, 0, 2, moOpDP::nonedp },
        { u"\u266F", moOpDF::postfix, 800, 0, 2, moOpDP::nonedp },
        { u"!", moOpDF::postfix, 810, 1, 0, moOpDP::nonedp },
        { u"!!", moOpDF::postfix, 810, 1, 0, moOpDP::nonedp },
        { u"//", moOpDF::infix, 820, 1, 1, moOpDP::nonedp },
        { u"@", moOpDF::infix, 825, 1, 1, moOpDP::nonedp },
        { u"?", moOpDF::infix, 835, 1, 1, moOpDP::nonedp },
        { u"\u2145", moOpDF::prefix, 845, 2, 1, moOpDP::nonedp },
        { u"\u2146", moOpDF::prefix, 845, 2, 0, moOpDP::nonedp },
        { u"\u221A", moOpDF::prefix, 845, 1, 1, moOpDP::stretchy },
        { u"\u221B", moOpDF::prefix, 845, 1, 1, moOpDP::nonedp },
        { u"\u221C", moOpDF::prefix, 845, 1, 1, moOpDP::nonedp },
        { u"\u2061", moOpDF::infix, 850, 0, 0, moOpDP::nonedp },
        { u"\"", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"&", moOpDF::postfix, 880, 0, 0, moOpDP::nonedp },
        { u"\'", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"++", moOpDF::postfix, 880, 0, 0, moOpDP::nonedp },
        { u"--", moOpDF::postfix, 880, 0, 0, moOpDP::nonedp },
        { u"^", moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"_", moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"`", moOpDF::postfix, 880, 0, 00, moOpDP::accent },
        { u"~", moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u00A8", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u00AA", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u00AF", moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u00B0", moOpDF::postfix, 880, 0, 0, moOpDP::nonedp },
        { u"\u00B2", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u00B3", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u00B4", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u00B8", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u00B9", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u00BA", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u02C6", moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u02C7", moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u02C9", moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u02CA", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u02CB", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u02CD", moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u02D8", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u02D9", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u02DA", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u02DC", moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u02DD", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u02F7", moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u0302", moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u0311", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u201A", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u201B", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u201E", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u201F", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u2033", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u2034", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u2035", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u2036", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u2037", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u203E", moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u2057", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u2064", moOpDF::infix, 880, 0, 0, moOpDP::nonedp },
        { u"\u20DB", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u20DC", moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u23B4", moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u23B5", moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u23DC", moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u23DD", moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u23DE", moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u23DF", moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u23E0", moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u23E1", moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"_", moOpDF::infix, 900, 1, 1, moOpDP::nonedp } };

std::vector<moOperatorData> starmathdatabase::moOperatorDataDictionary(
    moOperatorDataDictionaryData, moOperatorDataDictionaryData + starmathdatabase::MATHML_MO_COUNT);

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
