/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libe-book project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef PMLPARSER_H_INCLUDED
#define PMLPARSER_H_INCLUDED

#include <string>
#include <vector>

#include <boost/scoped_ptr.hpp>
#include <boost/unordered_map.hpp>

#include "PDXParser.h"


namespace libebook
{

struct PMLHeader;

class PMLParser : public PDXParser
{
public:
  typedef boost::unordered_map<std::string, std::vector<unsigned char> > ImageMap_t;

public:
  explicit PMLParser(librevenge::RVNGInputStream *input, librevenge::RVNGTextInterface *document = 0);
  virtual ~PMLParser();

  static bool checkType(unsigned type, unsigned creator);

  virtual void readAppInfoRecord(librevenge::RVNGInputStream *record);
  virtual void readSortInfoRecord(librevenge::RVNGInputStream *record);
  virtual void readIndexRecord(librevenge::RVNGInputStream *record);
  virtual void readDataRecord(librevenge::RVNGInputStream *record, bool last = false);

  virtual void readDataRecords();

private:
  void readText();
  void readImages();
  void readImage(librevenge::RVNGInputStream *record, bool verified = false);

  void openDocument();
  void closeDocument();

private:
  boost::scoped_ptr<PMLHeader> m_header;
  ImageMap_t m_imageMap;
};

} // namespace libebook

#endif // PMLPARSER_H_INCLUDED
/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
