/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libe-book project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef FB2TEXTCONTEXT_H_INCLUDED
#define FB2TEXTCONTEXT_H_INCLUDED

#include <string>

#include "FB2ParserContext.h"

namespace libebook
{

class FB2ParaContextBase : public FB2StyleContextBase
{
public:
  FB2ParaContextBase(FB2ParserContext *parentContext, const FB2BlockFormat &format);

private:
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void attribute(const FB2TokenData &name, const FB2TokenData *ns, const char *value);
};

class FB2AContext : public FB2StyleContextBase
{
public:
  FB2AContext(FB2ParserContext *parentContext, const FB2Style &style);

private:
  virtual void startOfElement();
  virtual void endOfAttributes();
  virtual void attribute(const FB2TokenData &name, const FB2TokenData *ns, const char *value);
  virtual void text(const char *text);

private:
  std::string m_href;
  bool m_valid;
  bool m_note;
};

class FB2CodeContext : public FB2StyleContextBase
{
public:
  FB2CodeContext(FB2ParserContext *parentContext, FB2Style &style);

private:
  virtual void startOfElement();
};

class FB2EmphasisContext : public FB2StyleContextBase
{
public:
  FB2EmphasisContext(FB2ParserContext *parentContext, FB2Style &style);

private:
  virtual void startOfElement();
};

class FB2InlineImageContext : public FB2DataContextBase
{
public:
  FB2InlineImageContext(FB2ParserContext *parentContext, const FB2Style &style);

private:
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes();
  virtual void attribute(const FB2TokenData &name, const FB2TokenData *ns, const char *value);

private:
  const FB2Style &m_style;
  std::string m_href;
  std::string m_altText;
  bool m_valid;
};

class FB2PContext : public FB2ParaContextBase
{
public:
  FB2PContext(FB2ParserContext *parentContext, const FB2BlockFormat &format);

private:
  static FB2BlockFormat makeBlockFormat(const FB2BlockFormat &format);
};

class FB2StrikethroughContext : public FB2StyleContextBase
{
public:
  FB2StrikethroughContext(FB2ParserContext *parentContext, FB2Style &style);

private:
  virtual void startOfElement();
};

class FB2StrongContext : public FB2StyleContextBase
{
public:
  FB2StrongContext(FB2ParserContext *parentContext, FB2Style &style);

private:
  virtual void startOfElement();
};

class FB2StyleContext : public FB2StyleContextBase
{
public:
  FB2StyleContext(FB2ParserContext *parentContext, FB2Style &style);

private:
  virtual void startOfElement();
};

class FB2SubContext : public FB2StyleContextBase
{
public:
  FB2SubContext(FB2ParserContext *parentContext, FB2Style &style);

private:
  virtual void startOfElement();
};

class FB2SubtitleContext : public FB2ParaContextBase
{
public:
  explicit FB2SubtitleContext(FB2ParserContext *parentContext, const FB2BlockFormat &format);

private:
  static FB2BlockFormat makeBlockFormat(const FB2BlockFormat &format);
};

class FB2SupContext : public FB2StyleContextBase
{
public:
  FB2SupContext(FB2ParserContext *parentContext, FB2Style &style);

private:
  virtual void startOfElement();
};

class FB2TextAuthorContext : public FB2PContext
{
public:
  explicit FB2TextAuthorContext(FB2ParserContext *parentContext, const FB2BlockFormat &format);

private:
  static FB2BlockFormat makeBlockFormat(const FB2BlockFormat &format);
};

class FB2VContext : public FB2ParaContextBase
{
public:
  explicit FB2VContext(FB2ParserContext *parentContext, const FB2BlockFormat &format);

private:
  static FB2BlockFormat makeBlockFormat(const FB2BlockFormat &format);
};

}

#endif // FB2TEXTCONTEXT_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
