/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libe-book project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef EPUBTOKEN_H_INCLUDED
#define EPUBTOKEN_H_INCLUDED

#include <boost/static_assert.hpp>

#include "EBOOKToken.h"

namespace libebook
{

namespace EPUBToken
{

enum
{
  INVALID_TOKEN = 0,
  FIRST_TOKEN = EBOOKToken<EPUBParser>::FIRST_TOKEN,

  // namespace prefixes
  container,
  xml,
  xmlns,

  // elements
  rootfiles,
  rootfile,
  signatures,
  encryption,

  // attributes
  version,
  full_path,
  media_type,

  // attribute values
  _1_0,
  MIME_epub,
  MIME_opf,

  LAST_TOKEN
};

BOOST_STATIC_ASSERT(EBOOKToken<EPUBParser>::LAST_TOKEN >= LAST_TOKEN);

enum Namespace
{
  NS_container = container << 16,
  NS_xml = xml << 16,
  NS_xmlns = xmlns << 16
};

}

int getEPUBTokenId(const char *name, const char *ns = 0);
int getEPUBTokenId(const char *name, std::size_t nameLen, const char *ns, std::size_t nsLen);
int getEPUBTokenId(const char *name, std::size_t nameLen);

}

#endif // EPUBTOKEN_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
