/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef FB2METADATACOLLECTOR_H_INCLUDED
#define FB2METADATACOLLECTOR_H_INCLUDED

#include "FB2Collector.h"

class WPXPropertyList;

namespace libebook
{

class FB2MetadataCollector : public FB2Collector
{
public:
  FB2MetadataCollector(WPXPropertyList &metadata);

private:
  virtual void defineMetadataEntry(const char *name, const char *value);
  virtual void openMetadataEntry(const char *name);
  virtual void closeMetadataEntry();

  virtual void defineID(const char *id);

  virtual void openPageSpan();
  virtual void closePageSpan();

  virtual void openBlock();
  virtual void closeBlock();

  virtual void openParagraph(const FB2BlockFormat &format);
  virtual void closeParagraph();

  virtual void openSpan(const FB2Style &style);
  virtual void closeSpan();

  virtual void insertText(const char *text);

  virtual void openTable(const FB2BlockFormat &format);
  virtual void closeTable();

  virtual void openTableRow(const FB2BlockFormat &format);
  virtual void closeTableRow();

  virtual void openTableCell(int rowspan, int colspan);
  virtual void closeTableCell();
  virtual void insertCoveredTableCell();

  virtual void insertFootnote(const char *id);

  virtual void insertBitmap(const char *id);
  virtual void insertBitmapData(const char *contentType, const char *base64Data);

private:
  WPXPropertyList &m_metadata;
};

}

#endif // FB2METADATACOLLECTOR_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
