/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#include <boost/shared_ptr.hpp>

#include <libwpd-stream/libwpd-stream.h>

#include <libe-book/IMPDocument.h>

#include "IMPHeader.h"
#include "IMPParser.h"

namespace libebook
{

bool IMPDocument::isSupported(WPXInputStream *const input) try
{
  input->seek(0, WPX_SEEK_SET);
  boost::shared_ptr<IMPHeader> header(IMPHeader::create(input));
  return bool(header);
}
catch (...)
{
  return false;
}

bool IMPDocument::parse(WPXInputStream *const input, WPXDocumentInterface *const document) try
{
  input->seek(0, WPX_SEEK_SET);
  IMPParser parser(input, document);
  return parser.parse();
}
catch (...)
{
  return false;
}

} // namespace libebook

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
