/*
** Copyright (c) 2001-2009 Expat maintainers.
**
** Permission is hereby granted, free of charge, to any person obtaining
** a copy of this software and associated documentation files (the
** "Software"), to deal in the Software without restriction, including
** without limitation the rights to use, copy, modify, merge, publish,
** distribute, sublicense, and/or sell copies of the Software, and to
** permit persons to whom the Software is furnished to do so, subject to
** the following conditions:
**
** The above copyright notice and this permission notice shall be included
** in all copies or substantial portions of the Software.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
** EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
** MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
** IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
** CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
** TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
** SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

/*
** Note: This file was originally automatically generated by fdtrans.
*/

#ifdef __USE_INLINE__
#undef __USE_INLINE__
#endif

#include <exec/interfaces.h>
#include <exec/libraries.h>
#include <exec/emulation.h>
#include <proto/exec.h>
#include <interfaces/expat.h>
#include "expat_68k.h"
#include "expat_base.h"


STATIC ULONG stub_OpenPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct LibraryManagerInterface *Self = (struct LibraryManagerInterface *) ExtLib->ILibrary;

	return (ULONG) Self->Open(0);
}
struct EmuTrap stub_Open = { TRAPINST, TRAPTYPE, stub_OpenPPC };

STATIC ULONG stub_ClosePPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct LibraryManagerInterface *Self = (struct LibraryManagerInterface *) ExtLib->ILibrary;

	return (ULONG) Self->Close();
}
struct EmuTrap stub_Close = { TRAPINST, TRAPTYPE, stub_ClosePPC };

STATIC ULONG stub_ExpungePPC(ULONG *regarray)
{
	return 0UL;
}
struct EmuTrap stub_Expunge = { TRAPINST, TRAPTYPE, stub_ExpungePPC };

STATIC ULONG stub_ReservedPPC(ULONG *regarray)
{
	return 0UL;
}
struct EmuTrap stub_Reserved = { TRAPINST, TRAPTYPE, stub_ReservedPPC };

static M68kXML_Parser stub_XML_ParserCreatePPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;
	struct ExecIFace *IExec = ((struct ExpatBase *)Self->Data.LibBase)->IExec;

	M68kXML_Parser p;
	p = IExec->AllocVec(sizeof(*p), MEMF_SHARED|MEMF_CLEAR);
	if (p) {
		p->p = Self->XML_ParserCreate((const XML_Char *)regarray[8]);
		if (p->p) {
			p->IExec = IExec;
			Self->XML_SetUserData(p->p, p);
			return p;
		}
		IExec->FreeVec(p);
	}
	return NULL;
}
struct EmuTrap stub_XML_ParserCreate = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_ParserCreatePPC };

static M68kXML_Parser stub_XML_ParserCreateNSPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;
	struct ExecIFace *IExec = ((struct ExpatBase *)Self->Data.LibBase)->IExec;

	M68kXML_Parser p;
	p = IExec->AllocVec(sizeof(*p), MEMF_SHARED|MEMF_CLEAR);
	if (p) {
		p->p = Self->XML_ParserCreateNS((const XML_Char *)regarray[8], (XML_Char)regarray[0]);
		if (p->p) {
			p->IExec = IExec;
			Self->XML_SetUserData(p->p, p);
			return p;
		}
		IExec->FreeVec(p);
	}
	return NULL;
}
struct EmuTrap stub_XML_ParserCreateNS = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_ParserCreateNSPPC };

static M68kXML_Parser stub_XML_ParserCreate_MMPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;
	struct ExecIFace *IExec = ((struct ExpatBase *)Self->Data.LibBase)->IExec;

	M68kXML_Parser p;
	p = IExec->AllocVec(sizeof(*p), MEMF_SHARED|MEMF_CLEAR);
	if (p) {
		p->p = Self->XML_ParserCreate_MM((const XML_Char *)regarray[8],
			(const XML_Memory_Handling_Suite *)regarray[9],
			(const XML_Char *)regarray[10]);
		if (p->p) {
			p->IExec = IExec;
			Self->XML_SetUserData(p->p, p);
			return p;
		}
		IExec->FreeVec(p);
	}
	return NULL;
}
struct EmuTrap stub_XML_ParserCreate_MM = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_ParserCreate_MMPPC };

static M68kXML_Parser stub_XML_ExternalEntityParserCreatePPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;
	struct ExecIFace *IExec = ((struct ExpatBase *)Self->Data.LibBase)->IExec;

	M68kXML_Parser p;
	p = IExec->AllocVec(sizeof(*p), MEMF_SHARED|MEMF_CLEAR);
	if (p) {
		p->p = Self->XML_ExternalEntityParserCreate((XML_Parser)regarray[8],
			(const XML_Char *)regarray[9], (const XML_Char *)regarray[10]);
		if (p->p) {
			p->IExec = IExec;
			Self->XML_SetUserData(p->p, p);
			return p;
		}
		IExec->FreeVec(p);
	}
	return NULL;
}
struct EmuTrap stub_XML_ExternalEntityParserCreate = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_ExternalEntityParserCreatePPC };

static void stub_XML_ParserFreePPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;
	struct ExecIFace *IExec = ((struct ExpatBase *)Self->Data.LibBase)->IExec;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	if (p) {
		Self->XML_ParserFree(p->p);
		IExec->FreeVec(p);
	}
}
struct EmuTrap stub_XML_ParserFree = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_ParserFreePPC };

static int stub_XML_ParsePPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	Self->XML_SetUserData(p->p, p);
	return Self->XML_Parse(p->p, (const char *)regarray[9], (int)regarray[0], (int)regarray[1]);
}
struct EmuTrap stub_XML_Parse = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_ParsePPC };

static int stub_XML_ParseBufferPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	return Self->XML_ParseBuffer(p->p, (int)regarray[0], (int)regarray[1]);
}
struct EmuTrap stub_XML_ParseBuffer = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_ParseBufferPPC };

static void * stub_XML_GetBufferPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	return Self->XML_GetBuffer(p->p, (int)regarray[0]);
}
struct EmuTrap stub_XML_GetBuffer = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_GetBufferPPC };

static void stub_XML_SetStartElementHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->startelementhandler = (void *)regarray[9];
	Self->XML_SetStartElementHandler(p->p, _68k_startelementhandler);
}
struct EmuTrap stub_XML_SetStartElementHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetStartElementHandlerPPC };

static void stub_XML_SetEndElementHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->endelementhandler = (void *)regarray[9];
	Self->XML_SetEndElementHandler(p->p, _68k_endelementhandler);
}
struct EmuTrap stub_XML_SetEndElementHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetEndElementHandlerPPC };

static void stub_XML_SetElementHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->startelementhandler = (void *)regarray[9];
	p->endelementhandler = (void *)regarray[10];
	Self->XML_SetElementHandler(p->p, _68k_startelementhandler, _68k_endelementhandler);
}
struct EmuTrap stub_XML_SetElementHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetElementHandlerPPC };

static void stub_XML_SetCharacterDataHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->chardatahandler = (void *)regarray[9];
	Self->XML_SetCharacterDataHandler(p->p, _68k_chardatahandler);
}
struct EmuTrap stub_XML_SetCharacterDataHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetCharacterDataHandlerPPC };

static void stub_XML_SetProcessingInstructionHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->procinsthandler = (void *)regarray[9];
	Self->XML_SetProcessingInstructionHandler(p->p, _68k_procinsthandler);
}
struct EmuTrap stub_XML_SetProcessingInstructionHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetProcessingInstructionHandlerPPC };

static void stub_XML_SetCommentHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->commenthandler = (void *)regarray[9];
	Self->XML_SetCommentHandler(p->p, _68k_commenthandler);
}
struct EmuTrap stub_XML_SetCommentHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetCommentHandlerPPC };

static void stub_XML_SetStartCdataSectionHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->startcdatahandler = (void *)regarray[9];
	Self->XML_SetStartCdataSectionHandler(p->p, _68k_startcdatahandler);
}
struct EmuTrap stub_XML_SetStartCdataSectionHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetStartCdataSectionHandlerPPC };

static void stub_XML_SetEndCdataSectionHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->endcdatahandler = (void *)regarray[9];
	Self->XML_SetEndCdataSectionHandler(p->p, _68k_endcdatahandler);
}
struct EmuTrap stub_XML_SetEndCdataSectionHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetEndCdataSectionHandlerPPC };

static void stub_XML_SetCdataSectionHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->startcdatahandler = (void *)regarray[9];
	p->endcdatahandler = (void *)regarray[10];
	Self->XML_SetCdataSectionHandler(p->p, _68k_startcdatahandler, _68k_endcdatahandler);
}
struct EmuTrap stub_XML_SetCdataSectionHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetCdataSectionHandlerPPC };

static void stub_XML_SetDefaultHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->defaulthandler = (void *)regarray[9];
	Self->XML_SetDefaultHandler(p->p, _68k_defaulthandler);
}
struct EmuTrap stub_XML_SetDefaultHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetDefaultHandlerPPC };

static void stub_XML_SetDefaultHandlerExpandPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->defaulthandlerexp = (void *)regarray[9];
	Self->XML_SetDefaultHandlerExpand(p->p, _68k_defaulthandlerexp);
}
struct EmuTrap stub_XML_SetDefaultHandlerExpand = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetDefaultHandlerExpandPPC };

static void stub_XML_SetExternalEntityRefHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->extentrefhandler = (void *)regarray[9];
	Self->XML_SetExternalEntityRefHandler(p->p, _68k_extentrefhandler);
}
struct EmuTrap stub_XML_SetExternalEntityRefHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetExternalEntityRefHandlerPPC };

static void stub_XML_SetExternalEntityRefHandlerArgPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->extenthandlerarg = (void *)regarray[9];
}
struct EmuTrap stub_XML_SetExternalEntityRefHandlerArg = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetExternalEntityRefHandlerArgPPC };

static void stub_XML_SetUnknownEncodingHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->unknownenchandler = (void *)regarray[9];
	p->enchandlerarg = (void *)regarray[10];
	Self->XML_SetUnknownEncodingHandler(p->p, _68k_unknownenchandler, p);
}
struct EmuTrap stub_XML_SetUnknownEncodingHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetUnknownEncodingHandlerPPC };

static void stub_XML_SetStartNamespaceDeclHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->startnamespacehandler = (void *)regarray[9];
	Self->XML_SetStartNamespaceDeclHandler(p->p, _68k_startnamespacehandler);
}
struct EmuTrap stub_XML_SetStartNamespaceDeclHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetStartNamespaceDeclHandlerPPC };

static void stub_XML_SetEndNamespaceDeclHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->endnamespacehandler = (void *)regarray[9];
	Self->XML_SetEndNamespaceDeclHandler(p->p, _68k_endnamespacehandler);
}
struct EmuTrap stub_XML_SetEndNamespaceDeclHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetEndNamespaceDeclHandlerPPC };

static void stub_XML_SetNamespaceDeclHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->startnamespacehandler = (void *)regarray[9];
	p->endnamespacehandler = (void *)regarray[10];
	Self->XML_SetNamespaceDeclHandler(p->p, _68k_startnamespacehandler, _68k_endnamespacehandler);
}
struct EmuTrap stub_XML_SetNamespaceDeclHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetNamespaceDeclHandlerPPC };

static void stub_XML_SetXmlDeclHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->xmldeclhandler = (void *)regarray[9];
	Self->XML_SetXmlDeclHandler(p->p, _68k_xmldeclhandler);
}
struct EmuTrap stub_XML_SetXmlDeclHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetXmlDeclHandlerPPC };

static void stub_XML_SetStartDoctypeDeclHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->startdoctypehandler = (void *)regarray[9];
	Self->XML_SetStartDoctypeDeclHandler(p->p, _68k_startdoctypehandler);
}
struct EmuTrap stub_XML_SetStartDoctypeDeclHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetStartDoctypeDeclHandlerPPC };

static void stub_XML_SetEndDoctypeDeclHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->enddoctypehandler = (void *)regarray[9];
	Self->XML_SetEndDoctypeDeclHandler(p->p, _68k_enddoctypehandler);
}
struct EmuTrap stub_XML_SetEndDoctypeDeclHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetEndDoctypeDeclHandlerPPC };

static void stub_XML_SetDoctypeDeclHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->startdoctypehandler = (void *)regarray[9];
	p->enddoctypehandler = (void *)regarray[10];
	Self->XML_SetDoctypeDeclHandler(p->p, _68k_startdoctypehandler, _68k_enddoctypehandler);
}
struct EmuTrap stub_XML_SetDoctypeDeclHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetDoctypeDeclHandlerPPC };

static void stub_XML_SetElementDeclHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->elementdeclhandler = (void *)regarray[9];
	Self->XML_SetElementDeclHandler(p->p, _68k_elementdeclhandler);
}
struct EmuTrap stub_XML_SetElementDeclHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetElementDeclHandlerPPC };

static void stub_XML_SetAttlistDeclHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->attlistdeclhandler = (void *)regarray[9];
	Self->XML_SetAttlistDeclHandler(p->p, _68k_attlistdeclhandler);
}
struct EmuTrap stub_XML_SetAttlistDeclHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetAttlistDeclHandlerPPC };

static void stub_XML_SetEntityDeclHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->entitydeclhandler = (void *)regarray[9];
	Self->XML_SetEntityDeclHandler(p->p, _68k_entitydeclhandler);
}
struct EmuTrap stub_XML_SetEntityDeclHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetEntityDeclHandlerPPC };

static void stub_XML_SetUnparsedEntityDeclHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->unparseddeclhandler = (void *)regarray[9];
	Self->XML_SetUnparsedEntityDeclHandler(p->p, _68k_unparseddeclhandler);
}
struct EmuTrap stub_XML_SetUnparsedEntityDeclHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetUnparsedEntityDeclHandlerPPC };

static void stub_XML_SetNotationDeclHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->notationdeclhandler = (void *)regarray[9];
	Self->XML_SetNotationDeclHandler(p->p, _68k_notationdeclhandler);
}
struct EmuTrap stub_XML_SetNotationDeclHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetNotationDeclHandlerPPC };

static void stub_XML_SetNotStandaloneHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->notstandalonehandler = (void *)regarray[9];
	Self->XML_SetNotStandaloneHandler(p->p, _68k_notstandalonehandler);
}
struct EmuTrap stub_XML_SetNotStandaloneHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetNotStandaloneHandlerPPC };

static int stub_XML_GetErrorCodePPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	return Self->XML_GetErrorCode(p->p);
}
struct EmuTrap stub_XML_GetErrorCode = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_GetErrorCodePPC };

static const XML_LChar * stub_XML_ErrorStringPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	return Self->XML_ErrorString((int)regarray[0]);
}
struct EmuTrap stub_XML_ErrorString = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_ErrorStringPPC };

static long stub_XML_GetCurrentByteIndexPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	return Self->XML_GetCurrentByteIndex(p->p);
}
struct EmuTrap stub_XML_GetCurrentByteIndex = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_GetCurrentByteIndexPPC };

static int stub_XML_GetCurrentLineNumberPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	return Self->XML_GetCurrentLineNumber(p->p);
}
struct EmuTrap stub_XML_GetCurrentLineNumber = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_GetCurrentLineNumberPPC };

static int stub_XML_GetCurrentColumnNumberPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	return Self->XML_GetCurrentColumnNumber(p->p);
}
struct EmuTrap stub_XML_GetCurrentColumnNumber = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_GetCurrentColumnNumberPPC };

static int stub_XML_GetCurrentByteCountPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	return Self->XML_GetCurrentByteCount(p->p);
}
struct EmuTrap stub_XML_GetCurrentByteCount = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_GetCurrentByteCountPPC };

static const char * stub_XML_GetInputContextPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	return Self->XML_GetInputContext(p->p, (int *)regarray[9], (int *)regarray[10]);
}
struct EmuTrap stub_XML_GetInputContext = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_GetInputContextPPC };

static void stub_XML_SetUserDataPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->handlerarg = (void *)regarray[9];
}
struct EmuTrap stub_XML_SetUserData = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetUserDataPPC };

static void stub_XML_DefaultCurrentPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	Self->XML_DefaultCurrent(p->p);
}
struct EmuTrap stub_XML_DefaultCurrent = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_DefaultCurrentPPC };

static void stub_XML_UseParserAsHandlerArgPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->handlerarg = p;
}
struct EmuTrap stub_XML_UseParserAsHandlerArg = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_UseParserAsHandlerArgPPC };

static int stub_XML_SetBasePPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	return Self->XML_SetBase(p->p, (const XML_Char *)regarray[9]);
}
struct EmuTrap stub_XML_SetBase = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetBasePPC };

static const XML_Char * stub_XML_GetBasePPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	return Self->XML_GetBase(p->p);
}
struct EmuTrap stub_XML_GetBase = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_GetBasePPC };

static int stub_XML_GetSpecifiedAttributeCountPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	return Self->XML_GetSpecifiedAttributeCount(p->p);
}
struct EmuTrap stub_XML_GetSpecifiedAttributeCount = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_GetSpecifiedAttributeCountPPC };

static int stub_XML_GetIdAttributeIndexPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	return Self->XML_GetIdAttributeIndex(p->p);
}
struct EmuTrap stub_XML_GetIdAttributeIndex = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_GetIdAttributeIndexPPC };

static int stub_XML_SetEncodingPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	return Self->XML_SetEncoding(p->p, (const XML_Char *)regarray[9]);
}
struct EmuTrap stub_XML_SetEncoding = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetEncodingPPC };

static int stub_XML_SetParamEntityParsingPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	return Self->XML_SetParamEntityParsing(p->p, (enum XML_ParamEntityParsing)regarray[9]);
}
struct EmuTrap stub_XML_SetParamEntityParsing = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetParamEntityParsingPPC };

static void stub_XML_SetReturnNSTripletPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	Self->XML_SetReturnNSTriplet(p->p, (int)regarray[0]);
}
struct EmuTrap stub_XML_SetReturnNSTriplet = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetReturnNSTripletPPC };

static const XML_LChar * stub_XML_ExpatVersionPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	return Self->XML_ExpatVersion();
}
struct EmuTrap stub_XML_ExpatVersion = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_ExpatVersionPPC };

static XML_Expat_Version stub_XML_ExpatVersionInfoPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	return Self->XML_ExpatVersionInfo();
}
struct EmuTrap stub_XML_ExpatVersionInfo = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_ExpatVersionInfoPPC };

static int stub_XML_ParserResetPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	return Self->XML_ParserReset(p->p, (const XML_Char *)regarray[9]);
}
struct EmuTrap stub_XML_ParserReset = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_ParserResetPPC };

static void stub_XML_SetSkippedEntityHandlerPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	p->skippedentityhandler = (void *)regarray[9];
	Self->XML_SetSkippedEntityHandler(p->p, _68k_skippedentityhandler);
}
struct EmuTrap stub_XML_SetSkippedEntityHandler = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_SetSkippedEntityHandlerPPC };

static int stub_XML_UseForeignDTDPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	return Self->XML_UseForeignDTD(p->p, (XML_Bool)regarray[0]);
}
struct EmuTrap stub_XML_UseForeignDTD = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_UseForeignDTDPPC };

static const XML_Feature * stub_XML_GetFeatureListPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	return Self->XML_GetFeatureList();
}
struct EmuTrap stub_XML_GetFeatureList = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_GetFeatureListPPC };

static int stub_XML_StopParserPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	return Self->XML_StopParser(p->p, (XML_Bool)regarray[0]);
}
struct EmuTrap stub_XML_StopParser = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_StopParserPPC };

static int stub_XML_ResumeParserPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	return Self->XML_ResumeParser(p->p);
}
struct EmuTrap stub_XML_ResumeParser = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_ResumeParserPPC };

static void stub_XML_GetParsingStatusPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	Self->XML_GetParsingStatus(p->p, (XML_ParsingStatus *)regarray[9]);
}
struct EmuTrap stub_XML_GetParsingStatus = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_GetParsingStatusPPC };

static void stub_XML_FreeContentModelPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	Self->XML_FreeContentModel(p->p, (XML_Content *)regarray[9]);
}
struct EmuTrap stub_XML_FreeContentModel = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_FreeContentModelPPC };

static void *stub_XML_MemMallocPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	return Self->XML_MemMalloc(p->p, (size_t)regarray[0]);
}
struct EmuTrap stub_XML_MemMalloc = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_MemMallocPPC };

static void *stub_XML_MemReallocPPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	return Self->XML_MemRealloc(p->p, (void *)regarray[9], (size_t)regarray[0]);
}
struct EmuTrap stub_XML_MemRealloc = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_MemReallocPPC };

static void stub_XML_MemFreePPC(ULONG *regarray)
{
	struct Library *Base = (struct Library *) regarray[REG68K_A6/4];
	struct ExtendedLibrary *ExtLib = (struct ExtendedLibrary *) ((ULONG)Base + Base->lib_PosSize);
	struct ExpatIFace *Self = (struct ExpatIFace *) ExtLib->MainIFace;

	M68kXML_Parser p = (M68kXML_Parser)regarray[8];
	Self->XML_MemFree(p->p, (void *)regarray[9]);
}
struct EmuTrap stub_XML_MemFree = { TRAPINST, TRAPTYPE, (ULONG (*)(ULONG *))stub_XML_MemFreePPC };

ULONG VecTable68K[] = {
	(ULONG)&stub_Open,
	(ULONG)&stub_Close,
	(ULONG)&stub_Expunge,
	(ULONG)&stub_Reserved,
	(ULONG)&stub_XML_ParserCreate,
	(ULONG)&stub_XML_ParserCreateNS,
	(ULONG)&stub_XML_ParserCreate_MM,
	(ULONG)&stub_XML_ExternalEntityParserCreate,
	(ULONG)&stub_XML_ParserFree,
	(ULONG)&stub_XML_Parse,
	(ULONG)&stub_XML_ParseBuffer,
	(ULONG)&stub_XML_GetBuffer,
	(ULONG)&stub_XML_SetStartElementHandler,
	(ULONG)&stub_XML_SetEndElementHandler,
	(ULONG)&stub_XML_SetElementHandler,
	(ULONG)&stub_XML_SetCharacterDataHandler,
	(ULONG)&stub_XML_SetProcessingInstructionHandler,
	(ULONG)&stub_XML_SetCommentHandler,
	(ULONG)&stub_XML_SetStartCdataSectionHandler,
	(ULONG)&stub_XML_SetEndCdataSectionHandler,
	(ULONG)&stub_XML_SetCdataSectionHandler,
	(ULONG)&stub_XML_SetDefaultHandler,
	(ULONG)&stub_XML_SetDefaultHandlerExpand,
	(ULONG)&stub_XML_SetExternalEntityRefHandler,
	(ULONG)&stub_XML_SetExternalEntityRefHandlerArg,
	(ULONG)&stub_XML_SetUnknownEncodingHandler,
	(ULONG)&stub_XML_SetStartNamespaceDeclHandler,
	(ULONG)&stub_XML_SetEndNamespaceDeclHandler,
	(ULONG)&stub_XML_SetNamespaceDeclHandler,
	(ULONG)&stub_XML_SetXmlDeclHandler,
	(ULONG)&stub_XML_SetStartDoctypeDeclHandler,
	(ULONG)&stub_XML_SetEndDoctypeDeclHandler,
	(ULONG)&stub_XML_SetDoctypeDeclHandler,
	(ULONG)&stub_XML_SetElementDeclHandler,
	(ULONG)&stub_XML_SetAttlistDeclHandler,
	(ULONG)&stub_XML_SetEntityDeclHandler,
	(ULONG)&stub_XML_SetUnparsedEntityDeclHandler,
	(ULONG)&stub_XML_SetNotationDeclHandler,
	(ULONG)&stub_XML_SetNotStandaloneHandler,
	(ULONG)&stub_XML_GetErrorCode,
	(ULONG)&stub_XML_ErrorString,
	(ULONG)&stub_XML_GetCurrentByteIndex,
	(ULONG)&stub_XML_GetCurrentLineNumber,
	(ULONG)&stub_XML_GetCurrentColumnNumber,
	(ULONG)&stub_XML_GetCurrentByteCount,
	(ULONG)&stub_XML_GetInputContext,
	(ULONG)&stub_XML_SetUserData,
	(ULONG)&stub_XML_DefaultCurrent,
	(ULONG)&stub_XML_UseParserAsHandlerArg,
	(ULONG)&stub_XML_SetBase,
	(ULONG)&stub_XML_GetBase,
	(ULONG)&stub_XML_GetSpecifiedAttributeCount,
	(ULONG)&stub_XML_GetIdAttributeIndex,
	(ULONG)&stub_XML_SetEncoding,
	(ULONG)&stub_XML_SetParamEntityParsing,
	(ULONG)&stub_XML_SetReturnNSTriplet,
	(ULONG)&stub_XML_ExpatVersion,
	(ULONG)&stub_XML_ExpatVersionInfo,
	(ULONG)&stub_XML_ParserReset,
	(ULONG)&stub_XML_SetSkippedEntityHandler,
	(ULONG)&stub_XML_UseForeignDTD,
	(ULONG)&stub_XML_GetFeatureList,
	(ULONG)&stub_XML_StopParser,
	(ULONG)&stub_XML_ResumeParser,
	(ULONG)&stub_XML_GetParsingStatus,
	(ULONG)&stub_XML_FreeContentModel,
	(ULONG)&stub_XML_MemMalloc,
	(ULONG)&stub_XML_MemRealloc,
	(ULONG)&stub_XML_MemFree,
	(ULONG)-1
};
